

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchIsChangeDataPathToNASLibraryAllowed.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchIsChangeDataPathToNASLibraryAllowed.sp,v $ $Id: ArchIsChangeDataPathToNASLibraryAllowed.sp,v 1.1.2.2 2018/03/20 19:53:42 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "ArchIsChangeDataPathToNASLibraryAllowed"				|
--	|																		|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ArchIsChangeDataPathToNASLibraryAllowed <<<'

IF EXISTS (select * from sysobjects where name='ArchIsChangeDataPathToNASLibraryAllowed')
	drop procedure ArchIsChangeDataPathToNASLibraryAllowed
IF EXISTS (select * from GxQscripts where name='ArchIsChangeDataPathToNASLibraryAllowed')
	delete from GxQscripts where name = 'ArchIsChangeDataPathToNASLibraryAllowed'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchIsChangeDataPathToNASLibraryAllowed')
	delete from GXDBVersions where aliasname = 'ArchIsChangeDataPathToNASLibraryAllowed'
GO
print '... Creating Procedure: ArchIsChangeDataPathToNASLibraryAllowed'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure ArchIsChangeDataPathToNASLibraryAllowed
  @i_CopyId integer
AS
  DECLARE @o_allowChangeDataPathToNASLibrary integer
	DECLARE	@allowChangeDataPathToNASLibrary integer = 1
	DECLARE @archGroupId integer = 0
	DECLARE @nClassicCopyCount integer=0
	DECLARE @nSnapCopyCount integer=0
	DECLARE @nDataPathCount integer=0
	DECLARE @nArchFileCount integer=0
	select  @archGroupId = archGroupId from archGroupCopy where id=@i_CopyId
	select  @nClassicCopyCount = Count(archGroupId) from archGroupCopy where archGroupId=@archGroupId and isSnapCopy=0
	select  @nSnapCopyCount = Count(archGroupId) from archGroupCopy where archGroupId=@archGroupId and isSnapCopy=1
	----There should be only one classic copy and/or one snap copy for the storage policy.
	IF @nSnapCopyCount > 1 OR @nClassicCopyCount > 1
	BEGIN
		SET @allowChangeDataPathToNASLibrary = 0
		GOTO PROC_EXIT
	END
	----For a copy there should be only one datapath
	select @nDataPathCount = Count(CopyId) from MMDataPath WHERE CopyId = @i_CopyId
	IF @nDataPathCount > 1
	BEGIN
		SET @allowChangeDataPathToNASLibrary = 0
		GOTO PROC_EXIT
	END
	----There should be NO data present for the copy
	select @nArchFileCount = Count(archCopyId) from archFileCopy where archCopyId=@i_CopyId
	IF @nArchFileCount > 0
	BEGIN
		SET @allowChangeDataPathToNASLibrary = 0
		GOTO PROC_EXIT
	END
PROC_EXIT:
	select @allowChangeDataPathToNASLibrary
GO

IF EXISTS (select * from GxQscripts where name = 'ArchIsChangeDataPathToNASLibraryAllowed')
	delete from GxQscripts where name = 'ArchIsChangeDataPathToNASLibraryAllowed'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchIsChangeDataPathToNASLibraryAllowed')
	delete from GXDBVersions where aliasname = 'ArchIsChangeDataPathToNASLibraryAllowed'
GO

insert into GXDBVersions values(2, 'ArchIsChangeDataPathToNASLibraryAllowed',  '00010001000200020000', 'ArchIsChangeDataPathToNASLibraryAllowed', '00010001000200020000')
GO

