

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchIsAuxiliaryCopySupportedForSubclient.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  ArchIsAuxiliaryCopySupportedForSubclient.sp                */
/*                                                                            */
/*  Description :  Stored procedure to check if subclient is eligible		  */
/*				   for selective copy						      			  */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchIsAuxiliaryCopySupportedForSubclient.sp,v $ $Id: ArchIsAuxiliaryCopySupportedForSubclient.sp,v 1.1.2.7 2020/01/10 21:59:15 kjaiswal Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ArchIsAuxiliaryCopySupportedForSubclient')
BEGIN
	print '>>> Drop Stored Procedure: ArchIsAuxiliaryCopySupportedForSubclient <<<'
	drop procedure ArchIsAuxiliaryCopySupportedForSubclient
END
IF EXISTS (select * from GxQscripts where name='ArchIsAuxiliaryCopySupportedForSubclient')
	delete from GxQscripts where name = 'ArchIsAuxiliaryCopySupportedForSubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchIsAuxiliaryCopySupportedForSubclient')
	delete from GXDBVersions where aliasname = 'ArchIsAuxiliaryCopySupportedForSubclient'
GO
print '... Creating Procedure: ArchIsAuxiliaryCopySupportedForSubclient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ArchIsAuxiliaryCopySupportedForSubclient
  @i_flags INTEGER
AS
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	/*
	Table has to be created before calling this stored procedure
	unSupported1 is for reasons to ignore always for selective copy
	unSupported2 is specific for oracle/sap agents to be checked only in certain conditions. Check caller code for details
	CREATE TABLE #tmpAppIdList(appId int, unSupportedAlways int, unSupportedOnSelAlways int, unSupportedDB int, isCWEjobValid int, Primary Key(appId))
	*/
	/*
	Reasons -
	EdgeDriveSubClient
	DDB SubClient
	Index SubClient
	Log Cmdline SubClient
	Cmd Line SubClient
	Oracle OnDemand SubClient
	Live Sync SubClient, subclient created for CVFailOver feature transaction log shipping
	VSA V2 parent jobs selected only based on VM jobs
	*/
	BEGIN TRY
		DECLARE @l_checkSumDDBSubclient INT = CHECKSUM(N'DDB Backup')
		DECLARE @l_checkSumMSSQLSubclient INT = CHECKSUM(N'mssql subclient type')
		DECLARE @l_SelectDDBBackupJobForAuxCopy INTEGER = 0
		IF EXISTS (SELECT * from MMConfigs  WITH (READUNCOMMITTED) WHERE name = 'MMS2_CONFIG_SELECT_DDB_BACKUP_JOB_FOR_AUXCOPY' AND value > 0)
			SET @l_SelectDDBBackupJobForAuxCopy = 1
		DECLARE @l_SelectCvFailoverLogShippingJobForAuxCopy INTEGER = 0
		IF EXISTS (SELECT * from MMConfigs  WITH (READUNCOMMITTED) WHERE name = 'MMS2_CONFIG_SELECT_CV_FAILOVER_LOG_SHIPPING_JOB_FOR_AUXCOPY' AND value > 0)
			SET @l_SelectCvFailoverLogShippingJobForAuxCopy = 1
		UPDATE T
		SET unSupportedAlways = (CASE WHEN (@l_SelectDDBBackupJobForAuxCopy = 0 AND PROP1.id IS NOT NULL)
OR (@l_SelectCvFailoverLogShippingJobForAuxCopy = 0 AND App.appTypeId = 81 AND App.SubClientName = 'CvFailoverLogShipping')
										 THEN 1
									  ELSE 0
								END)
		FROM #tmpAppIdList T
				INNER JOIN App_Application App WITH(READUNCOMMITTED) ON T.appId = App.id
				LEFT OUTER JOIN APP_SubClientProp PROP1 WITH (READUNCOMMITTED) ON App.id = PROP1.componentNameId AND PROP1.cs_attrName = @l_checkSumDDBSubclient AND PROP1.attrName = 'DDB Backup' AND PROP1.attrVal = N'1' AND PROP1.modified = 0
		--Do not process VSA V2 parent jobs for selective copy based on rules
		--It will be picked based on VM job selection
		UPDATE T
		SET unSupportedAlways = 1
		FROM #tmpAppIdList T, JMJobDataLink JDL WITH (NOLOCK)
		WHERE T.appId = JDL.parentAppId
AND		JDL.linkType IN (7, 8)
		UPDATE T SET unSupportedOnSelAlways = CASE WHEN T.unSupportedAlways = 1 THEN 1
WHEN (App.subclientStatus & (CONVERT(INT, 0x20000) | CONVERT(INT, 0x1000)) > 0)
									OR PROP1.id IS NOT NULL
									OR PROP3.id IS NOT NULL
									-- Take jobs only from the default subclient for SQL iDAs
OR ( (App.subclientStatus & 0x00008 = 0) AND App.AppTypeId IN (4, 16, 70) )
									THEN 1 ELSE unSupportedOnSelAlways END,
unSupportedDB = CASE WHEN (Ins.Status & 0x0800 = 0x0800)
OR (App.subclientStatus & 0x0040 = 0x0040)
				 							THEN 1 ELSE 0 END,
					 isCWEjobValid = IDAT.isCWEjobValid
		FROM #tmpAppIdList T INNER JOIN App_Application App WITH(READUNCOMMITTED) ON T.appId = App.id
	 		INNER JOIN App_InstanceName Ins WITH(READUNCOMMITTED) ON App.instance = Ins.id
	 		INNER JOIN App_iDAType IDAT WITH(READUNCOMMITTED) ON App.appTypeId = IDAT.type
			LEFT OUTER JOIN APP_SubClientProp PROP1 WITH (READUNCOMMITTED) ON App.id = PROP1.componentNameId AND PROP1.cs_attrName = @l_checkSumDDBSubclient AND PROP1.attrName = 'DDB Backup' AND PROP1.attrVal = N'1' AND PROP1.modified = 0
			-- Exclude FFG subclients for SQL iDAs from selective copies since 6.1
LEFT OUTER JOIN APP_SubClientProp PROP3 WITH (READUNCOMMITTED) ON App.appTypeId = 81 AND App.id = PROP3.componentNameId AND PROP3.cs_attrName = @l_checkSumMSSQLSubclient AND PROP3.attrName = 'mssql subclient type' AND PROP3.attrVal = N'2' AND PROP3.modified = 0
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		;THROW
	END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'ArchIsAuxiliaryCopySupportedForSubclient')
	delete from GxQscripts where name = 'ArchIsAuxiliaryCopySupportedForSubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchIsAuxiliaryCopySupportedForSubclient')
	delete from GXDBVersions where aliasname = 'ArchIsAuxiliaryCopySupportedForSubclient'
GO

insert into GXDBVersions values(2, 'ArchIsAuxiliaryCopySupportedForSubclient',  '00010001000200070000', 'ArchIsAuxiliaryCopySupportedForSubclient', '00010001000200070000')
GO

