

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchIncrementPeriod.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  ArchIncrementPeriod.sp		                              */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchIncrementPeriod.sp,v $ $Id: ArchIncrementPeriod.sp,v 1.3.36.4 2019/06/21 13:27:07 pkrishnan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ArchIncrementPeriod')
BEGIN
	print '>>> Drop Stored Procedure: ArchIncrementPeriod <<<'
	drop procedure ArchIncrementPeriod
END
IF EXISTS (select * from GxQscripts where name='ArchIncrementPeriod')
	delete from GxQscripts where name = 'ArchIncrementPeriod'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchIncrementPeriod')
	delete from GXDBVersions where aliasname = 'ArchIncrementPeriod'
GO
print '... Creating Procedure: ArchIncrementPeriod'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ArchIncrementPeriod
  @i_period BIGINT,
  @i_selectionType INTEGER,
  @i_dayNumber INTEGER,
  @i_numPeriod INTEGER
AS
  DECLARE @r_period BIGINT;
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	DECLARE @errorString varchar(512)
	--We got a UTC time. Convert it to local time
	DECLARE @localDateTime datetime
	SELECT @localDateTime = dbo.UTCToCellLocalTime(dbo.getdatetime(@i_period), 2)
IF(@i_selectionType = 10) --Hourly
	BEGIN
		DECLARE @tempDateTimeBaseLine datetime = CONVERT(DATE,@localDateTime) --Get the date without hours and minutes
		SET @tempDateTimeBaseLine = DATEADD(minute, @i_dayNumber, @tempDateTimeBaseLine) --Move to the minutes day starts from. This is our baseline
		IF(@localDateTime < @tempDateTimeBaseLine) --Baseline is ahead of input time. Let us go to previous baseline. Move it a day behind so it is definitely behind input time
			SET @tempDateTimeBaseLine = DATEADD(day, -1, @tempDateTimeBaseLine)
		WHILE(@localDateTime >= @tempDateTimeBaseLine) --Now keep incrementing from the baseline until we get the next period
			SET @tempDateTimeBaseLine = DATEADD(hour, @i_numPeriod, @tempDateTimeBaseLine)
		SET @localDateTime = @tempDateTimeBaseLine
	END
ELSE IF(@i_selectionType = 3) --Daily
	BEGIN
		DECLARE @tempDateTimeBaseLine1 datetime = CONVERT(DATE,@localDateTime) --Get the date without hours and minutes
		SET @tempDateTimeBaseLine1 = DATEADD(minute, @i_dayNumber, @tempDateTimeBaseLine1) --Move to the minutes day starts from. This is our baseline
		SET @localDateTime = DATEADD(day, @i_numPeriod, @tempDateTimeBaseLine1)
	END
ELSE IF(@i_selectionType = 2) --Weekly
	BEGIN
		SET @localDateTime = CONVERT(date, @localDateTime) --Get rid of hours and minutes
		DECLARE @currDayNum int
		SET @currDayNum = DATEPART (dw , @localDateTime) - 1 --Subtract 1 to get to the format of daynumber which is in the range 0-6
		--If input time is not on the day number return closest previous date which is in dayNumber so the caller will call incrementPeriod again which is when we will return the correct incrementPeriod
		IF(@currDayNum < @i_dayNumber)
		BEGIN
			SET @localDateTime = DATEADD(day, (@i_dayNumber - @currDayNum), @localDateTime) --Readjust to the dayStart of the week which is going ahead
			SET @localDateTime = DATEADD(week, -1, @localDateTime) --Return the closest previous period
		END
		ELSE IF(@currDayNum > @i_dayNumber)
		BEGIN
			SET @localDateTime = DATEADD(day, (@i_dayNumber - @currDayNum), @localDateTime) --Readjust to the dayStart of the week which is basically going back here
		END
		ELSE --Equal
			SET @localDateTime = DATEADD(week, @i_numPeriod, @localDateTime) --Increment
	END
ELSE IF(@i_selectionType = 4) --monthly
	BEGIN
		IF @i_dayNumber <= 0 --For month based selection this cannot be 0.
			SET @i_dayNumber = 1
		SET @localDateTime = CONVERT(date, @localDateTime) --Get rid of hours and minutes
		SET @localDateTime = DATEADD(month, @i_numPeriod, @localDateTime)
		DECLARE @tempDate datetime = CAST(datepart(yy,@localDateTime) as varchar(10)) + '-' + cast(datepart(mm,@localDateTime) as varchar(10)) + '-' + '1' --Get the datetime for 1st day of the month/year
		--DECLARE @daysInMonth int = DAY(EOMONTH(@localDateTime))
		DECLARE @daysInMonth int = DATEDIFF(day,@tempDate,DATEADD(month, 1, @tempDate))
		DECLARE @daysToAdd int
		SELECT @daysToAdd = CASE WHEN @i_dayNumber > @daysInMonth THEN @daysInMonth ELSE @i_dayNumber END
		SET @daysToAdd = @daysToAdd - DATEPART(d, @localDateTime)
		SET @localDateTime = DATEADD(day, @daysToAdd, @localDateTime)
	END
	DECLARE @loopCounter int = 0
	WHILE(dbo.IsInvalidTimeManaged(@localDateTime, dbo.GetClientTimeZone(2)) = 1)
	BEGIN
		IF(@loopCounter >= 12) --That is just an arbitrary count of hours, a safety net to avoid infinite loop in any unforeseen case. Fail rather than stuck here
		BEGIN
			SET @errorString = 'Datetime could not be incremented from InvalidTime [' + @localDateTime + ']' + ' for the Timezone [' + dbo.GetClientTimeZone(2) + ']'
			RAISERROR(@errorString, 16, 1)
			BREAK
		END
		ELSE
		BEGIN
			SET @loopCounter = @loopCounter + 1
			SET @localDateTime = DATEADD(hour, 1, @localDateTime)
		END
	END
	SELECT dbo.GetUnixTime(dbo.CellLocalToUTCTime(@localDateTime,2))
GO

IF EXISTS (select * from GxQscripts where name = 'ArchIncrementPeriod')
	delete from GxQscripts where name = 'ArchIncrementPeriod'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchIncrementPeriod')
	delete from GXDBVersions where aliasname = 'ArchIncrementPeriod'
GO

insert into GXDBVersions values(2, 'ArchIncrementPeriod',  '00010003003600040000', 'ArchIncrementPeriod', '00010003003600040000')
GO

