

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchGroupsGetDataToBeCopied.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchGroupsGetDataToBeCopied.sp,v $ $Id: ArchGroupsGetDataToBeCopied.sp,v 1.7.12.3 2018/07/28 03:57:26 kjaiswal Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ArchGroupsGetDataToBeCopied <<<'

IF EXISTS (select * from sysobjects where name='ArchGroupsGetDataToBeCopied')
	drop procedure ArchGroupsGetDataToBeCopied
IF EXISTS (select * from GxQscripts where name='ArchGroupsGetDataToBeCopied')
	delete from GxQscripts where name = 'ArchGroupsGetDataToBeCopied'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGroupsGetDataToBeCopied')
	delete from GXDBVersions where aliasname = 'ArchGroupsGetDataToBeCopied'
GO
print '... Creating Procedure: ArchGroupsGetDataToBeCopied'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ArchGroupsGetDataToBeCopied
  @i_xmlTextInput XML,
  @i_userId INT
AS
SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
  DECLARE @o_outputXML xml
DECLARE @ShowDetails INTEGER = 0
DECLARE @FilterType INTEGER = 0
DECLARE @ViewType INTEGER = 0
DECLARE @CopyId INTEGER = 0
DECLARE @PolicyIdPresent INTEGER = 0
DECLARE @CopyIdPresent INTEGER = 0
DECLARE @SaveResults INTEGER = 0
DECLARE @MinorVal INTEGER
DECLARE @MajorVal INTEGER
DECLARE @CriticalVal INTEGER
DECLARE @CommcellId INTEGER = 2
DECLARE @CurrentTime INTEGER = dbo.GetUnixTime(GetUTCDate())
IF OBJECT_ID('tempdb.dbo.#TobeCopiedJobs') IS NOT NULL DROP TABLE #TobeCopiedJobs
IF OBJECT_ID('tempdb.dbo.#InputPolicyIds') IS NOT NULL DROP TABLE #InputPolicyIds
IF OBJECT_ID('tempdb.dbo.#TobeCopiedSummaryTable') IS NOT NULL DROP TABLE #TobeCopiedSummaryTable
IF OBJECT_ID('tempdb.dbo.#TobeCopiedClientSummaryTable') IS NOT NULL DROP TABLE #TobeCopiedClientSummaryTable
IF OBJECT_ID('tempdb.dbo.#TempTotalDataCopied') IS NOT NULL DROP TABLE #TempTotalDataCopied
CREATE TABLE #TobeCopiedJobs
(
	jobid INTEGER,
	archGrpName VARCHAR(256),
	archGrpcOPYName VARCHAR(256),
	archGrpId INTEGER,
	archGrpCopyId INTEGER,
	[status] INTEGER,
	appid INTEGER,
	commcellId INTEGER,
	totalUnCompBytes BIGINT,
	elapsedTime INTEGER
)
CREATE TABLE #InputPolicyIds
(
	archGrpId INTEGER,
	archGrpCopyId INTEGER
)
CREATE TABLE #TempTotalDataCopied
(
	archGrpId INTEGER,
	archGrpCopyId INTEGER,
	TotalDataCopied BIGINT
)
CREATE TABLE #TobeCopiedSummaryTable
(
	commcellId INTEGER,
	archGrpId INTEGER,
	archGrpCopyId INTEGER,
	archGrpName VARCHAR(256),
	archGrpCopyName VARCHAR(256),
	TotalDataCopied BIGINT,
	TotalDataTobeCopied BIGINT,
	AmountOfCriticalData BIGINT,
	AmountOfMajorData BIGINT,
	AmountOfMinorData BIGINT,
	TotalJobs BIGINT,
	TotalCriticalJobs INTEGER,
	TotalMajorJobs INTEGER,
	TotalMinorJobs INTEGER
)
CREATE TABLE #TobeCopiedClientSummaryTable
(
	appid INTEGER,
	SubclientName NVARCHAR(1024),
	ClientId INTEGER,
	ClientName NVARCHAR(1024),
	TotalDataTobeCopied BIGINT,
	AmountOfCriticalData BIGINT,
	AmountOfMajorData BIGINT,
	AmountOfMinorData BIGINT,
	TotalJobs BIGINT,
	TotalCriticalJobs INTEGER,
	TotalMajorJobs INTEGER,
	TotalMinorJobs INTEGER
)
-- STORAGE_POLICY_ENTITY 17
--<EVGui_DataToBeCopied_Req aggregationLevel="StoragePolicyView">
--    <entities _type_="17" storagePolicyId="9" storagePolicyName="test_DDB"/>
--    <entities _type_="17" storagePolicyId="18" storagePolicyName="test_AUX"/>
--</EVGui_DataToBeCopied_Req>
SELECT	@ViewType = case WHEN ISNULL(Details.value('@aggregationLevel', 'varchar(max)'), 'StoragePolicyView') = 'ClientView' THEN 1 ELSE 0 END
FROM	@i_xmlTextInput.nodes('EVGui_DataToBeCopied_Req') EVGui_DataToBeCopied_Req(Details)
SELECT	@SaveResults= ISNULL(Details.value('@SaveResults', 'int'), 0)
FROM	@i_xmlTextInput.nodes('EVGui_DataToBeCopied_Req') EVGui_DataToBeCopied_Req(Details)
SELECT	@PolicyIdPresent = COUNT(ISNULL(Details.value('@storagePolicyId', 'int'), '0'))
FROM	@i_xmlTextInput.nodes('EVGui_DataToBeCopied_Req/entities') EVGui_DataToBeCopied_Req(Details)
WHERE	Details.value('@_type_', 'int') = 17 --  STORAGE_POLICY_ENTITY
SELECT	@CopyIdPresent = COUNT(ISNULL(Details.value('@copyId', 'int'), '0'))
FROM	@i_xmlTextInput.nodes('EVGui_DataToBeCopied_Req/entities') EVGui_DataToBeCopied_Req(Details)
WHERE	Details.value('@_type_', 'int') = 18 --STORAGE_POLICY_COPY_ENTITY
-- restrict showing of archive UMGroups that are visible to user, first do general stuff
IF @CopyIdPresent > 0
BEGIN
	INSERT INTO #InputPolicyIds (archGrpId, archGrpCopyId)
		SELECT 0, ISNULL(Details.value('@copyId', 'int'), '0')
		FROM @i_xmlTextInput.nodes('EVGui_DataToBeCopied_Req/entities') EVGui_DataToBeCopied_Req(Details)
		WHERE Details.value('@_type_', 'int') = 18 --STORAGE_POLICY_COPY_ENTITY
	UPDATE	#InputPolicyIds
	SET		archGrpId = archGroupId
	FROM	archGroupCopy WITH (NOLOCK)
	WHERE	#InputPolicyIds.archGrpCopyId = id
END
ELSE IF @PolicyIdPresent > 0
BEGIN
	INSERT INTO #InputPolicyIds (archGrpId, archGrpCopyId)
		SELECT archgroupId, ID FROM ARCHGROUPCOPY  WITH (NOLOCK)
		WHERE
		archgroupId IN (
			SELECT ISNULL(Details.value('@storagePolicyId', 'int'), '0')
			FROM @i_xmlTextInput.nodes('EVGui_DataToBeCopied_Req/entities') EVGui_DataToBeCopied_Req(Details)
			WHERE
			Details.value('@_type_', 'int') = 17 --  STORAGE_POLICY_ENTITY
		)
END
ELSE
BEGIN
	INSERT INTO #InputPolicyIds (archGrpId, archGrpCopyId)
		SELECT archgroupId, ID
		FROM ARCHGROUPCOPY  WITH (NOLOCK)
	IF (@i_userId > 0)
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#ArchGroupsGetDataToBeCopied_UserObjects') IS NOT NULL DROP TABLE #ArchGroupsGetDataToBeCopied_UserObjects
create table  #ArchGroupsGetDataToBeCopied_UserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
		EXEC sec_getUserObjects @i_userId, 2231, 0, '#ArchGroupsGetDataToBeCopied_UserObjects'
		IF NOT EXISTS(
				SELECT 1 FROM #ArchGroupsGetDataToBeCopied_UserObjects sec
WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0)
				)
			DELETE  IPI
			FROM #InputPolicyIds  IPI
			LEFT OUTER JOIN
				 (SELECT IPI.archGrpId FROM #InputPolicyIds as IPI INNER JOIN #ArchGroupsGetDataToBeCopied_UserObjects Sec
				ON IPI.archGrpId = Sec.archGroupId ) VAG
			ON IPI.archGrpId =  VAG.archGrpId
			WHERE VAG.archGrpId IS NULL
	END
END
SELECT	@MinorVal = (value * 3600)
FROM	MMConfigs WITH (NOLOCK)
WHERE NAME = 'HOURS_TO_CONSIDER_TO_BE_COPIED_DATA_HAS_MET_MINOR_CRITERIA'
		AND	nConfigSubSystemId = 3
SELECT	@MajorVal = (value * 3600)
FROM	MMConfigs WITH (NOLOCK)
WHERE NAME = 'HOURS_TO_CONSIDER_TO_BE_COPIED_DATA_HAS_MET_MAJOR_CRITERIA'
		AND nConfigSubSystemId = 3
SELECT	@CriticalVal = (value * 3600)
FROM	MMConfigs WITH (NOLOCK)
WHERE	NAME = 'HOURS_TO_CONSIDER_TO_BE_COPIED_DATA_HAS_MET_CRITICAL_CRITERIA'
		AND	nConfigSubSystemId = 3
BEGIN
	-- Remove transitive and primary SILO copies
	DELETE #InputPolicyIds
	FROM	archGroupCopy AGC WITH (NOLOCK), #InputPolicyIds P
	WHERE	AGC.id = P.archGrpCopyId
			AND (type = 5 -- CVA_AGCOPYTYPE_TRANSITIVE = 5
OR (flags & 524288) <> 0
				 )
	-- Remove Primary Copies
	DELETE #InputPolicyIds
	FROM	archGroup AG WITH (NOLOCK), #InputPolicyIds P
	WHERE	AG.id = P.archGrpId AND (AG.defaultCopy = P.archGrpCopyId) or (AG.defaultSnapCopy = P.archGrpCopyId)
	IF NOT EXISTS (SELECT 1 FROM MMConfigs WHERE name = 'MMCONFIG_SHOW_HIDDEN_STORAGE_POLICIES' AND value = 1)
		DELETE #InputPolicyIds
		FROM	 #InputPolicyIds t, archGroup AG WITH (NOLOCK)
WHERE AG.id = t.archGrpId AND ag.flags & 64 > 0
	INSERT INTO #TobeCopiedJobs (jobid, archGrpId, archGrpCopyId, appid, commcellId, totalUnCompBytes, elapsedTime)
		SELECT DISTINCT JMJobDataStats.jobid, JMJobDataStats.archGrpId, JMJobDataStats.archGrpCopyId,
				JMJobDataStats.appid, JMJobDataStats.commcellid,
				 case when JMBkpStats.dataArchGrpId > 1 and JMBkpStats.logArchGrpId > 1 and JMBkpStats.dataArchGrpId <> JMBkpStats.logArchGrpId
                then ISNULL((select sum(unCompBytes) from JMBkpAtmptStats WITH (NOLOCK)
                            where jobId = JMBkpStats.jobId and commCellId = JMBkpStats.commCellId and archGrpId = JMJobDataStats.archGrpId and status in (1,3,14,16)), 0)
               else JMBkpStats.totalUncompBytes end,
				 @CurrentTime - JMBkpStats.servStartDate AS elapsedTime
		FROM	JMJobDataStats WITH (NOLOCK)
				INNER JOIN JMBkpStats WITH (NOLOCK)
				ON	JMJobDataStats.jobid = JMBkpStats.jobid
					AND JMJobDataStats.commcellid = JMBkpStats.commcellid
				INNER JOIN #InputPolicyIds InputPlcIds
				ON	InputPlcIds.archGrpId = JMJobDataStats.archGrpId
					AND InputPlcIds.archGrpCopyId = JMJobDataStats.archGrpCopyId
		WHERE	JMJobDataStats.status in (101, 102, 103) AND
((JMJobDataStats.disabled = 0) OR  ((JMJobDataStats.disabled & (1 | 256)) = 0))
	INSERT INTO #TobeCopiedJobs (jobid, archGrpId, archGrpCopyId, appid, commcellId, totalUnCompBytes, elapsedTime)
		SELECT DISTINCT JMJobDataStats.jobid, JMJobDataStats.archGrpId, JMJobDataStats.archGrpCopyId,
				JMJobDataStats.appid, JMJobDataStats.commcellid, JMAdminJobStatsTable.totalBackupSize, @CurrentTime - JMAdminJobStatsTable.servStart AS elapsedTime
		FROM	JMJobDataStats WITH (NOLOCK)
				INNER JOIN JMAdminJobStatsTable WITH (NOLOCK)
				ON	JMJobDataStats.jobid = JMAdminJobStatsTable.jobid AND
					JMJobDataStats.commcellid = JMAdminJobStatsTable.commcellid
				INNER JOIN #InputPolicyIds InputPlcIds
				ON	InputPlcIds.archGrpId = JMJobDataStats.archGrpId
					AND InputPlcIds.archGrpCopyId = JMJobDataStats.archGrpCopyId
		WHERE	JMJobDataStats.status in (101, 102, 103) AND
				((JMJobDataStats.disabled = 0) OR  ((JMJobDataStats.disabled & (1 | 256)) = 0))
				AND JMAdminJobStatsTable.opType = 11
		INSERT INTO #TempTotalDataCopied
		SELECT	T.archgrpId, T.archgrpCopyId, ISNULL(SUM(T.totalUncompBytes), 0) AS TotalDataCopied
		FROM
			((SELECT DISTINCT JDS.archGrpId, JDS.archGrpCopyId, JDS.JobId, JDS.CommCellId, JBS.totalUnCompBytes
			FROM JMJobDataStats JDS WITH (NOLOCK)
				INNER JOIN JMBkpStats JBS WITH (NOLOCK)
					ON 	JBS.jobid = JDS.jobid and
						JBS.commcellid = JDS.commcellid
				INNER JOIN #InputPolicyIds InputPlcIds
					ON	InputPlcIds.archGrpId = JDS.archGrpId
						AND InputPlcIds.archGrpCopyId = JDS.archGrpCopyId
			WHERE	JDS.status = 100
AND ((JDS.disabled = 0) OR  ((JDS.disabled & (1 | 256)) = 0))
			EXCEPT
			SELECT DISTINCT JDS.archGrpId, JDS.archGrpCopyId, JDS.JobId, JDS.CommCellId, JBS.totalUnCompBytes
			FROM JMJobDataStats JDS WITH (NOLOCK)
				INNER JOIN JMBkpStats JBS WITH (NOLOCK)
					ON 	JBS.jobid = JDS.jobid and
						JBS.commcellid = JDS.commcellid
				INNER JOIN #InputPolicyIds InputPlcIds
					ON	InputPlcIds.archGrpId = JDS.archGrpId
						AND InputPlcIds.archGrpCopyId = JDS.archGrpCopyId
			WHERE	JDS.status IN (101, 102, 103)
AND ((JDS.disabled = 0) OR  ((JDS.disabled & (1 | 256)) = 0)))
			UNION
						(SELECT DISTINCT JDS.archGrpId, JDS.archGrpCopyId, JDS.JobId, JDS.CommCellId, JBS.totalBackupSize
			FROM JMJobDataStats JDS WITH (NOLOCK)
				INNER JOIN JMAdminJobStatsTable JBS WITH (NOLOCK)
					ON 	JBS.jobid = JDS.jobid and
						JBS.commcellid = JDS.commcellid
				INNER JOIN #InputPolicyIds InputPlcIds
					ON	InputPlcIds.archGrpId = JDS.archGrpId
						AND InputPlcIds.archGrpCopyId = JDS.archGrpCopyId
			WHERE	JDS.status = 100
			AND ((JDS.disabled = 0) OR  ((JDS.disabled & (1 | 256)) = 0))
			EXCEPT
			SELECT DISTINCT JDS.archGrpId, JDS.archGrpCopyId, JDS.JobId, JDS.CommCellId, JBS.totalBackupSize
			FROM JMJobDataStats JDS WITH (NOLOCK)
				INNER JOIN JMAdminJobStatsTable JBS WITH (NOLOCK)
					ON 	JBS.jobid = JDS.jobid and
						JBS.commcellid = JDS.commcellid
				INNER JOIN #InputPolicyIds InputPlcIds
					ON	InputPlcIds.archGrpId = JDS.archGrpId
						AND InputPlcIds.archGrpCopyId = JDS.archGrpCopyId
			WHERE	JDS.status IN (101, 102, 103)
			AND ((JDS.disabled = 0) OR  ((JDS.disabled & (1 | 256)) = 0)))) T
		GROUP BY T.archgrpId, T.archgrpCopyId
END
IF @ShowDetails = 0
BEGIN
	IF @ViewType = 0 --Storage Policy View
	BEGIN
		INSERT INTO #TobeCopiedSummaryTable (archGrpId, archGrpCopyId, TotalDataTobeCopied, TotalJobs, AmountOfCriticalData, AmountOfMajorData, AmountOfMinorData, TotalCriticalJobs, TotalMajorJobs, TotalMinorJobs)
		SELECT TobeCopied.archGrpId AS [StoragePolicyID], TobeCopied.archGrpCopyId AS [StoragePolicyCopyID], SUM(TobeCopied.totalUnCompBytes) as [TotalTobecopied], COUNT(*) As [TotalJobs],
			ISNULL(SUM (CASE WHEN TobeCopied.elapsedTime >= (@CriticalVal) THEN TobeCopied.totalUnCompBytes END), 0) AS [AmountofDatainCritical],
			ISNULL(SUM(CASE WHEN TobeCopied.elapsedTime BETWEEN (@MajorVal)  AND (@CriticalVal) THEN TobeCopied.totalUnCompBytes END), 0) AS [AmountofDatainMajor],
			ISNULL(SUM(CASE WHEN TobeCopied.elapsedTime BETWEEN (@MinorVal) AND (@MajorVal) THEN TobeCopied.totalUnCompBytes END), 0) AS [AmountofDatainMinor],
			ISNULL(Count (CASE WHEN TobeCopied.elapsedTime > (@CriticalVal) THEN TobeCopied.jobid END), 0) AS [TotalNumberofCriticalJobs],
			ISNULL(Count(CASE WHEN TobeCopied.elapsedTime BETWEEN (@MajorVal)  AND (@CriticalVal) THEN TobeCopied.jobid END), 0) AS [TotalNumberofMajorJobs],
			ISNULL(Count(CASE WHEN TobeCopied.elapsedTime BETWEEN (@MinorVal) AND (@MajorVal) THEN TobeCopied.jobid END), 0) AS [TotalNumberofMinorJobs]
		FROM #TobeCopiedJobs TobeCopied
		GROUP BY TobeCopied.archGrpId, TobeCopied.archGrpCopyId
		ORDER BY TobeCopied.archGrpId, TobeCopied.archGrpCopyId
		INSERT INTO #TobeCopiedSummaryTable (archGrpId, archGrpCopyId, TotalDataCopied, TotalDataTobeCopied, TotalJobs, AmountOfCriticalData, AmountOfMajorData, AmountOfMinorData, TotalCriticalJobs, TotalMajorJobs, TotalMinorJobs)
		SELECT	P.archGrpId, P.archGrpCopyId, P.TotalDataCopied, 0, 0, 0, 0, 0, 0, 0, 0
		FROM	#TempTotalDataCopied P LEFT OUTER JOIN #TobeCopiedSummaryTable T ON P.archGrpId = T.archGrpId AND P.archGrpCopyId = T.archGrpCopyId
		WHERE	T.archGrpCopyId IS NULL
		UPDATE	#TobeCopiedSummaryTable
		SET		TotalDataCopied = P.TotalDataCopied
		FROM	#TempTotalDataCopied P
		WHERE	P.archGrpId = #TobeCopiedSummaryTable.archGrpId
				AND P.archGrpCopyId = #TobeCopiedSummaryTable.archGrpCopyId
		UPDATE	#TobeCopiedSummaryTable
		SET		TotalDataCopied = 0
		WHERE	TotalDataCopied IS NULL
		INSERT INTO #TobeCopiedSummaryTable (archGrpId, archGrpCopyId, TotalDataCopied, TotalDataTobeCopied, TotalJobs, AmountOfCriticalData, AmountOfMajorData, AmountOfMinorData, TotalCriticalJobs, TotalMajorJobs, TotalMinorJobs)
		SELECT	P.archGrpId, P.archGrpCopyId, 0, 0, 0, 0, 0, 0, 0, 0, 0
		FROM	#InputPolicyIds P LEFT OUTER JOIN #TobeCopiedSummaryTable T ON P.archGrpId = T.archGrpId AND P.archGrpCopyId = T.archGrpCopyId
		WHERE	T.archGrpCopyId IS NULL
		INSERT INTO #TobeCopiedSummaryTable (archGrpId, archGrpCopyId, TotalDataCopied, TotalDataTobeCopied, TotalJobs, AmountOfCriticalData, AmountOfMajorData, AmountOfMinorData, TotalCriticalJobs, TotalMajorJobs, TotalMinorJobs)
		SELECT	archGrpId, NULL, SUM(TotalDataCopied), SUM(TotalDataTobeCopied), SUM(TotalJobs), SUM(AmountOfCriticalData), SUM(AmountOfMajorData), SUM(AmountOfMinorData), SUM(TotalCriticalJobs), SUM(TotalMajorJobs), SUM(TotalMinorJobs)
		FROM	#TobeCopiedSummaryTable
		WHERE	@CopyIdPresent = 0
		GROUP BY archGrpId
		INSERT INTO #TobeCopiedSummaryTable (archGrpId, archGrpCopyId, TotalDataCopied, TotalDataTobeCopied, TotalJobs, AmountOfCriticalData, AmountOfMajorData, AmountOfMinorData, TotalCriticalJobs, TotalMajorJobs, TotalMinorJobs)
		SELECT	NULL, NULL, SUM(TotalDataCopied), SUM(TotalDataTobeCopied), SUM(TotalJobs), SUM(AmountOfCriticalData), SUM(AmountOfMajorData), SUM(AmountOfMinorData), SUM(TotalCriticalJobs), SUM(TotalMajorJobs), SUM(TotalMinorJobs)
		FROM	#TobeCopiedSummaryTable
		WHERE	(archGrpCopyId = 0 OR archGrpCopyId IS NULL)
				AND @PolicyIdPresent = 0
				AND @CopyIdPresent = 0
		UPDATE #TobeCopiedSummaryTable SET archGrpName = ArchGroup.Name
		FROM #TobeCopiedSummaryTable SummTable
		INNER JOIN ARCHGROUP WITH (NOLOCK)
		ON ARCHGROUP.ID = SummTable.archGrpId
		UPDATE #TobeCopiedSummaryTable SET archGrpCopyName = ArchGroupCopy.Name
		FROM #TobeCopiedSummaryTable SummTable
		INNER JOIN ARCHGROUPCOPY WITH (NOLOCK)
		ON ARCHGROUPCOPY.ID = SummTable.archGrpCopyId
		-- Policy id present then do not send the storage policies level aggregation
		-- Copy id present then do not send the storage policies and storage policy level aggregation
		DELETE FROM #TobeCopiedSummaryTable
		WHERE	(@PolicyIdPresent > 0 AND (archGrpId = 0 OR archGrpId IS NULL))
				OR (@CopyIdPresent > 0 AND (archGrpCopyId = 0 OR archGrpCopyId IS NULL))
		SET @o_outputXML =
			(
				SELECT ISNULL(archGrpId, 0) AS [@archGrpId], ISNULL(archGrpCopyId, 0) AS [@archGrpCopyId], ISNULL(archGrpName, 'All Storage Policies') AS [@archGrpName], ISNULL(archGrpCopyName, 'All Copies') AS [@archGrpCopyName], ISNULL(TotalDataCopied, 0) AS [@totalDataCopied], ISNULL(TotalDataTobeCopied, 0) AS [@totalDataTobeCopied], ISNULL(amountOfCriticalData, 0) AS [@amountOfCriticalData], ISNULL(AmountOfMajorData, 0) AS [@amountOfMajorData], ISNULL(AmountOfMinorData, 0) AS [@amountOfMinorData], TotalJobs AS [@totalJobs], TotalCriticalJobs AS [@totalCriticalJobs], TotalMajorJobs AS [@totalMajorJobs], TotalMinorJobs AS [@totalMinorJobs]
				FROM #TobeCopiedSummaryTable
				ORDER BY archGrpId, archGrpCopyId
				FOR XML PATH ('StoragePolicyLevelDetails'), Root('EVGui_StoragePolicyAggregationViewDetails')
			)
		IF (@o_outputXML IS NULL)
			SET @o_outputXML = '<EVGui_StoragePolicyAggregationViewDetails></EVGui_StoragePolicyAggregationViewDetails>'
		IF @SaveResults <> 0
		Begin
			DECLARE @reportGenerationTime INTEGER = dbo.GetUnixTime(GetUTCDate())
			INSERT INTO ArchCopyDataSummary (generateTime, archGrpId, archGrpCopyId, TotalDataCopied, TotalDataTobeCopied, AmountOfCriticalData, AmountOfMajorData, AmountOfMinorData, TotalJobs, TotalCriticalJobs, TotalMajorJobs, TotalMinorJobs)
				SELECT @reportGenerationTime, ISNULL(archGrpId, 0) AS archGrpId, ISNULL(archGrpCopyId, 0) AS archGrpCopyId, ISNULL(TotalDataCopied, 0), ISNULL(TotalDataTobeCopied, 0) AS TotalDataTobeCopied, ISNULL(AmountOfCriticalData, 0) AS AmountOfCriticalData, ISNULL(AmountOfMajorData, 0) AS AmountOfMajorData, ISNULL(AmountOfMinorData, 0) AS AmountOfMinorData,
						ISNULL(TotalJobs, 0), ISNULL(TotalCriticalJobs, 0), ISNULL(TotalMajorJobs, 0), ISNULL(TotalMinorJobs, 0)
					FROM #TobeCopiedSummaryTable
					WHERE archGrpCopyId <> 0
					ORDER BY archGrpId, archGrpCopyId
		END
	END
	ELSE ---Client View
	BEGIN
		INSERT INTO #TobeCopiedClientSummaryTable (ClientId, appid, TotalDataTobeCopied, TotalJobs, AmountOfCriticalData, AmountOfMajorData, AmountOfMinorData, TotalCriticalJobs, TotalMajorJobs, TotalMinorJobs)
			SELECT APP_APPLICATION.CLIENTID, TobeCopied.appid, SUM(TobeCopied.totalUnCompBytes) as [TotalTobecopied], COUNT(*) As [TotalJobs],
			SUM (CASE WHEN TobeCopied.elapsedTime >= (@CriticalVal) THEN TobeCopied.totalUnCompBytes END) AS [AmountofDatainCritical],
			SUM(CASE WHEN TobeCopied.elapsedTime BETWEEN (@MajorVal)  AND (@CriticalVal) THEN TobeCopied.totalUnCompBytes END) AS [AmountofDatainMajor],
			SUM(CASE WHEN TobeCopied.elapsedTime BETWEEN (@MinorVal) AND (@MajorVal) THEN TobeCopied.totalUnCompBytes END) AS [AmountofDatainMinor],
			Count (CASE WHEN TobeCopied.elapsedTime >= (@CriticalVal) THEN TobeCopied.jobid END) AS [TotalNumberofCriticalJobs],
			Count(CASE WHEN TobeCopied.elapsedTime BETWEEN (@MajorVal)  AND (@CriticalVal) THEN TobeCopied.jobid END) AS [TotalNumberofMajorJobs],
			Count(CASE WHEN TobeCopied.elapsedTime BETWEEN (@MinorVal) AND (@MajorVal) THEN TobeCopied.jobid END) AS [TotalNumberofMinorJobs]
			FROM #TobeCopiedJobs TobeCopied
			INNER JOIN APP_APPLICATION WITH (NOLOCK)
			ON APP_APPLICATION.ID = TobeCopied.appid
			GROUP BY ROLLUP(APP_APPLICATION.CLIENTID, TobeCopied.appid)
		UPDATE #TobeCopiedClientSummaryTable SET SubClientName = APP_APPLICATION.subclientName
		FROM #TobeCopiedClientSummaryTable ClientSummTable
		INNER JOIN APP_APPLICATION
		ON APP_APPLICATION.ID = ClientSummTable.appid
		UPDATE #TobeCopiedClientSummaryTable SET ClientName = APP_CLIENT.name
		FROM #TobeCopiedClientSummaryTable ClientSummTable
		INNER JOIN APP_CLIENT
		ON APP_CLIENT.ID = ClientSummTable.ClientId
		SET @o_outputXML =
			(
				SELECT ISNULL(ClientId, 0) AS [@ClientId], ISNULL(AppId, 0) AS [@SubclientId], ISNULL(ClientName, '') AS [@ClientName], ISNULL(SubClientName, '') AS [@SubclientName] , ISNULL(TotalDataTobeCopied, 0) AS [@totalDataTobeCopied], ISNULL(AmountOfCriticalData, 0) AS [@amountOfCriticalData], ISNULL(AmountOfMajorData, 0) AS [@amountOfMajorData], ISNULL(AmountOfMinorData, 0) AS [@amountOfMinorData], TotalJobs AS [@totalJobs], TotalCriticalJobs AS [@totalCriticalJobs], TotalMajorJobs AS [@totalMajorJobs], TotalMinorJobs AS [@totalMinorJobs]
				FROM #TobeCopiedClientSummaryTable
				ORDER BY ClientId, AppId
				FOR XML PATH ('ClientLevelDetails'), Root('EVGui_ClientAggregationViewDetails')
			)
		IF (@o_outputXML IS NULL)
			SET @o_outputXML = '<EVGui_ClientAggregationViewDetails></EVGui_ClientAggregationViewDetails>'
	END
END
SELECT @o_outputXML
IF OBJECT_ID('tempdb.dbo.#TobeCopiedJobs') IS NOT NULL DROP TABLE #TobeCopiedJobs
IF OBJECT_ID('tempdb.dbo.#InputPolicyIds') IS NOT NULL DROP TABLE #InputPolicyIds
IF OBJECT_ID('tempdb.dbo.#TobeCopiedSummaryTable') IS NOT NULL DROP TABLE #TobeCopiedSummaryTable
IF OBJECT_ID('tempdb.dbo.#TobeCopiedClientSummaryTable') IS NOT NULL DROP TABLE #TobeCopiedClientSummaryTable
IF OBJECT_ID('tempdb.dbo.#TempTotalDataCopied') IS NOT NULL DROP TABLE #TempTotalDataCopied
GO

IF EXISTS (select * from GxQscripts where name = 'ArchGroupsGetDataToBeCopied')
	delete from GxQscripts where name = 'ArchGroupsGetDataToBeCopied'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGroupsGetDataToBeCopied')
	delete from GXDBVersions where aliasname = 'ArchGroupsGetDataToBeCopied'
GO

insert into GXDBVersions values(2, 'ArchGroupsGetDataToBeCopied',  '00010007001200030000', 'ArchGroupsGetDataToBeCopied', '00010007001200030000')
GO

