

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchGroupIsStoragePolicyNeedUpdateForSubclient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchGroupIsStoragePolicyNeedUpdateForSubclient.sp,v $ $Id: ArchGroupIsStoragePolicyNeedUpdateForSubclient.sp,v 1.1.2.5 2020/10/21 12:51:04 cliu Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ArchGroupIsStoragePolicyNeedUpdateForSubclient')
BEGIN
	print '>>> Drop Stored Procedure: ArchGroupIsStoragePolicyNeedUpdateForSubclient <<<'
	drop procedure ArchGroupIsStoragePolicyNeedUpdateForSubclient
END
IF EXISTS (select * from GxQscripts where name='ArchGroupIsStoragePolicyNeedUpdateForSubclient')
	delete from GxQscripts where name = 'ArchGroupIsStoragePolicyNeedUpdateForSubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGroupIsStoragePolicyNeedUpdateForSubclient')
	delete from GXDBVersions where aliasname = 'ArchGroupIsStoragePolicyNeedUpdateForSubclient'
GO
print '... Creating Procedure: ArchGroupIsStoragePolicyNeedUpdateForSubclient'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure ArchGroupIsStoragePolicyNeedUpdateForSubclient
  @i_subclientId int,
  @i_clientId int = 0,
  @i_dataType int = 0
AS
  DECLARE @retVal integer;
  DECLARE @newStoragePolicyId integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET @retVal = 0
SET @newStoragePolicyId = 0
DECLARE @clientId 						int = 0
DECLARE @currentStoragePolicyGroupId	int = 0
DECLARE @currentStoragePolicyId			int = 0
/*
-- Assume this is for data storage policy only
IF @i_dataType != 0
BEGIN
	SET @i_dataType = 0
	-- Future support for different data type
	--@dataType = CVA_DATATYPE_LOGS
	--@dataType = CVA_DATATYPE_SNAPMETADATA
END
*/
SELECT @clientId = clientId,
@currentStoragePolicyId = CASE WHEN @i_dataType != 4
										THEN dataArchGrpID ELSE logArchGrpID END
FROM APP_Application WITH(READUNCOMMITTED)
WHERE id = @i_subclientId
IF @@ROWCOUNT = 0
BEGIN
	SET @retVal = 0
	GOTO FINISH
END
--
-- JM may passes a different client, we should use storage policy associated to that client's client group.
-- Only adjust the client Id based on client property of enabling the feature.
IF @i_clientId > 0
AND	EXISTS
	(
		SELECT  1
		FROM    APP_AdvanceSettings WITH(READUNCOMMITTED)
		WHERE   keyname = 'EnableRegionBasedBackups'
		AND     entityId = @i_clientId
AND     entityType = 3
		AND     relativePath = 'iDataAgent'
		AND     CONVERT(NVARCHAR(10), value) = N'true'
		AND     enabled = 1
		AND     deleted = 0
	)
BEGIN
	SET @clientId = @i_clientId
END
SELECT TOP 1 @newStoragePolicyId = c.archGroupId
FROM	APP_ClientGroupAssoc b WITH (NOLOCK), ArchGroupClientGroupAssociation c WITH (NOLOCK)
WHERE	b.clientId = @clientId
		AND		b.clientGroupId = c.clientGroupId
		AND		c.archGroupId > 0
		AND		attributes & 1 = 1 /*Region based client group backup*/
		--AND		(@i_dataType = 0 OR
--		 @i_dataType = 4 AND attributes & 2 = 2 /* log archgroup id */ )
		AND		enabled = 1
ORDER BY (CASE WHEN c.archGroupId = @currentStoragePolicyId THEN 0 ELSE 1 END)
IF @@ROWCOUNT = 0
BEGIN
	SET @retVal = 0
	GOTO FINISH
END
IF @i_dataType = 4
BEGIN
	-- Double-check the log storag policy set on new SP. If it is set, use that value
	SELECT @newStoragePolicyId = logSP
	FROM	ArchGroup WITH (NOLOCK)
	WHERE	Id = @newStoragePolicyId
	AND		logSP != 0
END
-- Create a default storage policy group. Right now, it doesn't show up in GUI
--SELECT @currentStoragePolicyGroupId = storagePolicyGroupId
--FROM ArchStoragePolicyGroup WITH (NOLOCK)
--WHERE flags & 1 = 1 /*storage policy group type for region based client group backup feature*/
IF @newStoragePolicyId = 0 OR @currentStoragePolicyId = @newStoragePolicyId
BEGIN
	SET @retVal = 0
END
ELSE
BEGIN
	SET @retVal = 1
END
FINISH:
SELECT @retVal, @newStoragePolicyId
RETURN @retVal
GO

IF EXISTS (select * from GxQscripts where name = 'ArchGroupIsStoragePolicyNeedUpdateForSubclient')
	delete from GxQscripts where name = 'ArchGroupIsStoragePolicyNeedUpdateForSubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGroupIsStoragePolicyNeedUpdateForSubclient')
	delete from GXDBVersions where aliasname = 'ArchGroupIsStoragePolicyNeedUpdateForSubclient'
GO

insert into GXDBVersions values(2, 'ArchGroupIsStoragePolicyNeedUpdateForSubclient',  '00010001000200050000', 'ArchGroupIsStoragePolicyNeedUpdateForSubclient', '00010001000200050000')
GO

