

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchGetVMsForBrowse.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
--  | Stored Proc:  ArchGetVMsForBrowse()
--  |
--  | Description:  Return VMs for browse from parent VSA job level
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchGetVMsForBrowse.sp,v $ $Id: ArchGetVMsForBrowse.sp,v 1.1.4.9.4.1 2021/06/02 20:07:15 pkrishnan Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ArchGetVMsForBrowse')
BEGIN
	print '>>> Drop Stored Procedure: ArchGetVMsForBrowse <<<'
	drop procedure ArchGetVMsForBrowse
END
IF EXISTS (select * from GxQscripts where name='ArchGetVMsForBrowse')
	delete from GxQscripts where name = 'ArchGetVMsForBrowse'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGetVMsForBrowse')
	delete from GXDBVersions where aliasname = 'ArchGetVMsForBrowse'
GO
print '... Creating Procedure: ArchGetVMsForBrowse'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ArchGetVMsForBrowse
  @i_backupSetId INTEGER,
  @i_appId INTEGER,
  @i_fromTime BIGINT,
  @i_toTime BIGINT,
  @i_copyPrecedence INTEGER,
  @i_user INTEGER = 0
AS
  DECLARE @r_errorCode INT;
  DECLARE @r_VMClientId INT;
  DECLARE @r_VMGUID NVARCHAR(1024);
  DECLARE @r_VMClientName NVARCHAR(255);
  DECLARE @r_VMSize BIGINT;
  DECLARE @r_VMInstanceId INT;
  DECLARE @r_VMInstanceGUID NVARCHAR(1024);
  DECLARE @r_VMBackupSetId INT;
  DECLARE @r_VMBackupSetGUID NVARCHAR(1024);
  DECLARE @r_VMAppId INT;
  DECLARE @r_VMAppGUID NVARCHAR(1024);
  DECLARE @r_VMJobId INT;
  DECLARE @r_VMJobCommcellId INT;
  DECLARE @r_VMJobEndTime BIGINT;
  DECLARE @r_VMClientOSId INT;
/*These are enum CVJobStatus in cvjob.h*/
/*These are enum CVOpType in cvconstdef.h*/
BEGIN TRY
	IF OBJECT_ID('tempdb..#VSAAppIdList') IS NOT NULL DROP TABLE #VSAAppIdList
	CREATE TABLE #VSAAppIdList (appId int, primary key(appId) with(ignore_dup_key = ON))
	IF OBJECT_ID('tempdb..#VSAJobListForBrowse') IS NOT NULL DROP TABLE #VSAJobListForBrowse
	CREATE TABLE #VSAJobListForBrowse (jobId INT, commcellId INT, appId INT, servStartDate BIGINT, primary key(jobId, commcellId, appId) with(ignore_dup_key = ON))
	IF OBJECT_ID('tempdb..#VMAppListForBrowse') IS NOT NULL DROP TABLE #VMAppListForBrowse
	CREATE TABLE #VMAppListForBrowse (jobId INT, commcellId INT,
	VMClientId int, VMGUID nvarchar(1024), VMClientName nvarchar(255), VMSize BIGINT,
	VMInstanceId INT, VMInstanceGUID nvarchar(1024),
	VMBackupSetId INT, VMBackupSetGUID nvarchar(1024),
	VMAppId INT, VMAppGUID nvarchar(1024), VMJobId INT, VMJobCommcellId INT, VMJobEndTime BIGINT, VMClientOSId INT,
	primary key(VMAppId) with(ignore_dup_key = ON))
	IF OBJECT_ID('tempdb..#VMAppList') IS NOT NULL DROP TABLE #VMAppList
		CREATE TABLE #VMAppList(VMappId INT, primary key(VMappId) with(ignore_dup_key = ON))
	IF(@i_appId > 0)
		INSERT INTO #VSAAppIdList
		SELECT @i_appId
	ELSE IF(@i_backupSetId > 1)
		INSERT INTO #VSAAppIdList
		SELECT id FROM App_Application WITH(NOLOCK)
		WHERE backupSet = @i_backupSetId
	ELSE
		RAISERROR('Inputs AppId - [%d] BackupSetId - [%d] are not valid for the request', 16, 1, @i_appId, @i_backupSetId)
	DECLARE @includeAgedData int = 0
	SELECT @includeAgedData = value FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'ShowAgedDataForBrowseAndRecovery' AND modified = 0
	IF(@i_fromTime <= 0) --Latest data browse
	BEGIN
		IF(@i_toTime = 0) --Current Time
			SET @i_toTime = dbo.GetUnixTime(GETUTCDATE())
		/*Pick latest valid job that isn't a failed VM job for each appId if at least one of the child of that job is available in the copy being browsed*/
		INSERT INTO #VSAJobListForBrowse
		SELECT jobId, commcellId, appId, servStartDate FROM
		(
			SELECT JBKP.jobId, JBKP.commcellId, JBKP.appId, JBKP.servStartDate, dense_rank() over(partition by JBKP.appId order by JBKP.servStartDate desc) as rn
			FROM JMBkpStats JBKP WITH(NOLOCK) INNER JOIN #VSAAppIdList App ON JBKP.appId = App.appId
			LEFT OUTER JOIN	JMJobStats JS WITH(NOLOCK) ON JBKP.jobId = JS.jobId AND JBKP.commcellId = JS.commcellId
			INNER JOIN JMJobDataLink JDL WITH(NOLOCK) ON JBKP.jobId = JDL.parentJobId AND JBKP.commcellId = JDL.commcellId
AND JDL.linkType IN (7, 8)
			INNER JOIN JMJobDataStats JDS WITH(NOLOCK) ON JDL.childJobId = JDS.jobId AND JDL.commcellId = JDS.commcellId
AND JDS.dataType = 1 AND JDS.status = 100 AND (JDS.disabled & 256 = 0 OR @includeAgedData > 0)
			INNER JOIN ArchGroupCopy AGC WITH(NOLOCK) ON JDS.archGrpCopyId = AGC.id
			INNER JOIN ArchGroup AG WITH(NOLOCK) ON AGC.archGroupId = AG.id
WHERE JBKP.bkpAttributesEx & (0x200000 | CAST(0x800000000 AS BIGINT)) = 0 AND JBKP.status IN (1, 3, 14) AND JBKP.servStartDate <= @i_toTime
			/*
			JMBKP_EX_VSA_FAILED_VM_JOB   0x200000
			JMBKP_EX_SELECTIVE_VM_BACKUP 0x800000000LL
			*/
AND JBKP.opType NOT IN (60, 61)	AND NOT (JBKP.opType = 59 AND ISNULL(JS.subOpType, 0) = 96)
			AND JBKP.bkpLevel NOT IN (64, 128, 16384)
			/*
			We will ignore synthetic full and start from last non-synthetic full and in the next query we will include synthetic fulls if parent has synthetic full. For VM level
			synthetic fulls that do not have a parent synthetic full they will be included through their links with last parent incremental jobs.
			 SYNTHETIC_FULL = 0x40
			 SYNTHETIC_FULL_AND_INCR = 0x80
			 SYNTHETIC_FULL_AND_INCR_BEFORE = 0x4000
			*/
			AND (
				(@i_copyPrecedence > 0 AND AGC.copy = @i_copyPrecedence)
				OR
(@i_copyPrecedence = 0)
				OR
(@i_copyPrecedence = -1 AND AGC.id = AG.defaultCopy)
				OR
(@i_copyPrecedence = -5 AND AGC.id = AG.defaultSnapCopy)
				OR
(@i_copyPrecedence = -4 AND AGC.isSnapCopy = 0)
			)
		) T
		WHERE rn = 1
		/*Inserting a dummy row for parent subclients for which we do not find any complete backup in above query. Below query will pick up all partial VM backups available for such parents*/
		INSERT INTO #VSAJobListForBrowse
		SELECT 0, 0, App.appId, 0
		FROM #VSAAppIdList App LEFT OUTER JOIN #VSAJobListForBrowse J ON App.appId = J.appId
		WHERE J.appId IS NULL
		/*Pick failed VM jobs or selective VM jobs, if at least one of the child of that job is available in the copy being browsed*/
		INSERT INTO #VSAJobListForBrowse
		SELECT DISTINCT JBKP.jobId, JBKP.commcellId, 0, 0
		FROM #VSAJobListForBrowse J
		INNER JOIN JMBkpStats JBKP WITH(NOLOCK) ON J.appId = JBKP.appId
		LEFT OUTER JOIN	JMJobStats JS WITH(NOLOCK) ON JBKP.jobId = JS.jobId AND JBKP.commcellId = JS.commcellId
		INNER JOIN JMJobDataLink JDL WITH(NOLOCK) ON JBKP.jobId = JDL.parentJobId AND JBKP.commcellId = JDL.commcellId
AND JDL.linkType IN (7, 8)
		INNER JOIN JMJobDataStats JDS WITH(NOLOCK) ON JDL.childJobId = JDS.jobId AND JDL.commcellId = JDS.commcellId
AND JDS.dataType = 1 AND JDS.status = 100 AND (JDS.disabled & 256 = 0 OR @includeAgedData > 0)
		INNER JOIN ArchGroupCopy AGC WITH(NOLOCK) ON JDS.archGrpCopyId = AGC.id
		INNER JOIN ArchGroup AG WITH(NOLOCK) ON AGC.archGroupId = AG.id
WHERE J.servStartDate < JBKP.servStartDate AND JBKP.status IN (1, 3, 14) AND JBKP.servStartDate <= @i_toTime
AND JBKP.opType NOT IN (60, 61)	AND NOT (JBKP.opType = 59 AND ISNULL(JS.subOpType, 0) = 96)
		AND (
			(@i_copyPrecedence > 0 AND AGC.copy = @i_copyPrecedence)
			OR
(@i_copyPrecedence = 0)
			OR
(@i_copyPrecedence = -1 AND AGC.id = AG.defaultCopy)
			OR
(@i_copyPrecedence = -5 AND AGC.id = AG.defaultSnapCopy)
			OR
(@i_copyPrecedence = -4 AND AGC.isSnapCopy = 0)
		)
		/*Get rid of the dummy rows inserted earlier. We don't need them any more*/
		DELETE #VSAJobListForBrowse	WHERE jobId = 0
		/*Now that we have the parent jobs, let's find the VMs associcated with these parent jobs*/
		INSERT INTO #VMAppList
		SELECT DISTINCT JDL.childAppId
FROM #VSAJobListForBrowse TJ INNER JOIN JMJobDataLink JDL WITH(NOLOCK) ON TJ.jobId = JDL.parentJobId AND TJ.commcellId = JDL.commcellId AND JDL.linkType IN (7, 8)
AND JDL.childJobStatus IN (1, 3, 14)
		/*
		CREATE TABLE #VMAppListForBrowse (jobId INT, commcellId INT,
		VMClientId int, VMGUID nvarchar(1024), VMClientName nvarchar(255), VMSize BIGINT,
		VMInstanceId INT, VMInstanceGUID nvarchar(1024),
		VMBackupSetId INT, VMBackupSetGUID nvarchar(1024),
		VMAppId INT, VMAppGUID nvarchar(1024), VMJobId INT, VMJobCommcellId INT, VMJobEndTime BIGINT, VMClientOSId INT,
		primary key(VMAppId) with(ignore_dup_key = ON))
		*/
		/*With the VM list find the availability of these VMs in the copy being browsed*/
		INSERT INTO #VMAppListForBrowse
		SELECT parentJobId, ParentCommcellId, 0, '', '', 0, 0, '' ,0, '' ,childAppId, '', VMJobId, VMJobCommcellId, VMJobEndTime, 0
		FROM
		(
			SELECT JDL.parentJobId, JDL.commcellId "ParentCommcellId", JDL.childAppId, JBKP.jobId "VMJobId", JBKP.commcellId "VMJobCommcellId", JBKP.servEndDate "VMJobEndTime", dense_rank() over(partition by JDL.childAppId order by JDL.parentJobId desc) as rn
			FROM #VMAppList VMS INNER JOIN JMJobDataStats JDS WITH(NOLOCK) ON VMS.VMappId = JDS.appId
AND JDS.dataType = 1 AND JDS.status = 100 AND (JDS.disabled & 256 = 0 OR @includeAgedData > 0)
INNER JOIN JMJobDataLink JDL WITH(NOLOCK) ON JDS.jobId = JDL.childJobId AND JDS.commcellId = JDL.commcellId AND JDL.linkType IN (7, 8)
			INNER JOIN JMBkpStats JBKP WITH(NOLOCK) ON JDL.childJobId = JBKP.jobId AND JDL.commcellId = JBKP.commcellId AND JBKP.servStartDate <= @i_toTime
			INNER JOIN ArchGroupCopy AGC WITH(NOLOCK) ON JDS.archGrpCopyId = AGC.id
			INNER JOIN ArchGroup AG WITH(NOLOCK) ON AGC.archGroupId = AG.id
			WHERE
			(
				(@i_copyPrecedence > 0 AND AGC.copy = @i_copyPrecedence)
				OR
(@i_copyPrecedence = 0)
				OR
(@i_copyPrecedence = -1 AND AGC.id = AG.defaultCopy)
				OR
(@i_copyPrecedence = -5 AND AGC.id = AG.defaultSnapCopy)
				OR
(@i_copyPrecedence = -4 AND AGC.isSnapCopy = 0)
			)
		) T
		WHERE rn = 1
		IF OBJECT_ID('tempdb..#VMAppList') IS NOT NULL DROP TABLE #VMAppList
	END
	ELSE IF(@i_fromTime > 0 AND (@i_toTime = 0 OR @i_fromTime <= @i_toTime))
	BEGIN
		IF(@i_toTime = 0) --Current Time
			SET @i_toTime = dbo.GetUnixTime(GETUTCDATE())
		INSERT INTO #VSAJobListForBrowse
		SELECT JBKP.jobId, JBKP.commcellId, 0, 0
		FROM JMBkpStats JBKP WITH(NOLOCK) INNER JOIN #VSAAppIdList App ON JBKP.appId = App.appId
		LEFT OUTER JOIN	JMJobStats JS WITH(NOLOCK) ON JBKP.jobId = JS.jobId AND JBKP.commcellId = JS.commcellId
		WHERE (JBKP.servStartDate BETWEEN @i_fromTime AND @i_toTime OR JBKP.servEndDate BETWEEN @i_fromTime AND @i_toTime)
AND JBKP.status IN (1, 3, 14)
AND JBKP.opType NOT IN (60, 61)	AND NOT (JBKP.opType = 59 AND ISNULL(JS.subOpType, 0) = 96)
		/*
		CREATE TABLE #VMAppListForBrowse (jobId INT, commcellId INT,
		VMClientId int, VMGUID nvarchar(1024), VMClientName nvarchar(255), VMSize BIGINT,
		VMInstanceId INT, VMInstanceGUID nvarchar(1024),
		VMBackupSetId INT, VMBackupSetGUID nvarchar(1024),
		VMAppId INT, VMAppGUID nvarchar(1024), VMJobId INT, VMJobCommcellId INT, VMJobEndTime BIGINT, VMClientOSId INT,
		primary key(VMAppId) with(ignore_dup_key = ON))
		*/
		INSERT INTO #VMAppListForBrowse
		SELECT parentJobId, ParentCommcellId, 0, '', '', 0, 0, '' ,0, '' ,childAppId, '', VMJobId, VMJobCommcellId, VMJobEndTime, 0
		FROM
		(
			SELECT TJ.jobId "ParentJobId", TJ.commcellId "ParentCommcellId", JDL.childAppId, JBKP.jobId "VMJobId", JBKP.commcellId "VMJobCommcellId", JBKP.servEndDate "VMJobEndTime", dense_rank() over(partition by JDL.childAppId order by TJ.jobId desc) as rn
FROM #VSAJobListForBrowse TJ INNER JOIN JMJobDataLink JDL WITH(NOLOCK)	ON TJ.jobId = JDL.parentJobId AND TJ.commcellId = JDL.commcellId AND JDL.linkType IN (7, 8)
INNER JOIN JMJobDataStats JDS WITH(NOLOCK) ON JDL.childJobId = JDS.jobId AND JDL.commcellId = JDS.commcellId AND JDS.dataType = 1 AND JDS.status = 100 AND (JDS.disabled & 256 = 0 OR @includeAgedData > 0)
			INNER JOIN JMBkPStats JBKP WITH(NOLOCK) ON JDL.childJobId = JBKP.jobId AND JDL.commcellId = JBKP.commcellId
			INNER JOIN ArchGroupCopy AGC WITH(NOLOCK) ON JDS.archGrpCopyId = AGC.id
			INNER JOIN ArchGroup AG WITH(NOLOCK) ON AGC.archGroupId = AG.id
			WHERE
			(
				(@i_copyPrecedence > 0 AND AGC.copy = @i_copyPrecedence)
				OR
(@i_copyPrecedence = 0)
				OR
(@i_copyPrecedence = -1 AND AGC.id = AG.defaultCopy)
				OR
(@i_copyPrecedence = -5 AND AGC.id = AG.defaultSnapCopy)
				OR
(@i_copyPrecedence = -4 AND AGC.isSnapCopy = 0)
			)
		) T
		WHERE rn = 1
	END
	ELSE
		RAISERROR('Inputs FromTime - [%I64d] ToTime - [%I64d] are not valid for the request', 16, 1, @i_fromTime, @i_toTime)
	UPDATE T SET VMClientId = CL.id, VMClientName = CASE WHEN LEN(CL.displayName) > 0 THEN CL.displayName ELSE CL.name END, VMClientOSId = CL.simOperatingSystemId
	FROM #VMAppListForBrowse T
	INNER JOIN App_Application APP WITH(NOLOCK) ON T.VMAppId = APP.id
	INNER JOIN App_Client CL WITH(NOLOCK) ON APP.clientId = CL.id
	IF(@i_user > 0)
	BEGIN
		--Temporary table that will hold objects available for curent user.
		IF OBJECT_ID('tempdb..#ClientsWithPermission') IS NOT NULL DROP TABLE #ClientsWithPermission
		CREATE TABLE #ClientsWithPermission
		(
		    t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
		)
		-- Check for BROWSE capability for all clients
EXEC sec_getIdaObjectsForUser @i_user, 3 /*CLIENT_ENTITY*/ , 13, 1, '#ClientsWithPermission'
		DELETE #VMAppListForBrowse WHERE VMClientId NOT IN (SELECT t_clientId FROM #ClientsWithPermission)
		IF OBJECT_ID('tempdb..#ClientsWithPermission') IS NOT NULL DROP TABLE #ClientsWithPermission
	END
	--First try to find GUID from App_VMProp
	UPDATE T
	SET VMGUID = VMP.attrVal
	FROM #VMAppListForBrowse T INNER JOIN APP_VMProp VMP WITH (NOLOCK)
	ON T.jobId = VMP.jobId AND T.CommcellId = VMP.commcellId AND T.VMClientId = VMP.VMClientId
	WHERE 	VMP.attrName = N'vmGUID'
	IF EXISTS (SELECT 1 FROM #VMAppListForBrowse WHERE VMGUID IS NULL OR LEN(VMGUID) = 0)
	BEGIN
		--GUID gets updated for a VM client and so modified timestamp is set on previous GUID. Pick GUID based on the job time we have for a VM.
		UPDATE T SET VMGUID = CP.attrVal
		FROM #VMAppListForBrowse T INNER JOIN App_ClientProp CP WITH(NOLOCK) ON T.VMClientId = CP.componentNameId AND CP.attrName = N'Virtual Machine Instance UUID'
		AND T.VMJobEndTime >= CP.created AND (T.VMJobEndTime < CP.modified OR CP.modified = 0)
		AND (VMGUID IS NULL OR LEN(VMGUID) = 0)
	END
	UPDATE T SET VMSize = VMPROP.attrVal
	FROM #VMAppListForBrowse T INNER JOIN APP_VMProp VMPROP WITH(NOLOCK) ON T.jobId = VMPROP.jobId AND T.commcellId = VMPROP.commcellId AND T.VMClientId = VMPROP.VMClientId AND VMPROP.attrName = N'vmSize'
	/* For synthfull jobs, property is at VM job level */
	IF EXISTS(SELECT 1 FROM #VMAppListForBrowse WHERE VMSize = 0)
	BEGIN
		UPDATE T SET VMSize = VMPROP.attrVal
		FROM #VMAppListForBrowse T INNER JOIN APP_VMProp VMPROP WITH(NOLOCK) ON T.VMJobId = VMPROP.jobId AND T.commcellId = VMPROP.commcellId AND T.VMClientId = VMPROP.VMClientId AND VMPROP.attrName = N'vmSize'
		WHERE T.VMSize = 0
	END
	UPDATE T SET
	VMInstanceId = INS.id, VMInstanceGUID = INS.GUID,
	VMBackupSetId = BKP.id, VMBackupSetGUID = BKP.GUID,
	VMAppId = APP.id, VMAppGUID = APP.GUID
	FROM #VMAppListForBrowse T INNER JOIN
	App_Application APP WITH(NOLOCK) ON T.VMAppId = APP.id
	INNER JOIN App_BackupsetName BKP WITH(NOLOCK) ON APP.backupSet = BKP.id
	INNER JOIN App_InstanceName INS WITH(NOLOCK) ON APP.instance = INS.id
	SELECT 0 "ErrorCode", VMClientId, VMGUID, VMClientName, VMSize, VMInstanceId, VMInstanceGUID, VMBackupSetId, VMBackupSetGUID, VMAppId, VMAppGUID, VMJobId, VMJobCommcellId, VMJobEndTime, VMClientOSId
	FROM #VMAppListForBrowse ORDER BY VMClientName, VMAppId
	IF OBJECT_ID('tempdb..#VSAAppIdList') IS NOT NULL DROP TABLE #VSAAppIdList
	IF OBJECT_ID('tempdb..#VSAJobListForBrowse') IS NOT NULL DROP TABLE #VSAJobListForBrowse
	IF OBJECT_ID('tempdb..#VMAppListForBrowse') IS NOT NULL DROP TABLE #VMAppListForBrowse
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
IF OBJECT_ID('tempdb..#VSAAppIdList') IS NOT NULL DROP TABLE #VSAAppIdList
IF OBJECT_ID('tempdb..#VSAJobListForBrowse') IS NOT NULL DROP TABLE #VSAJobListForBrowse
IF OBJECT_ID('tempdb..#VMAppListForBrowse') IS NOT NULL DROP TABLE #VMAppListForBrowse
IF OBJECT_ID('tempdb..#VMAppList') IS NOT NULL DROP TABLE #VMAppList
IF OBJECT_ID('tempdb..#ClientsWithPermission') IS NOT NULL DROP TABLE #ClientsWithPermission
;THROW
SELECT -1, -1, -1, -1, -1
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'ArchGetVMsForBrowse')
	delete from GxQscripts where name = 'ArchGetVMsForBrowse'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGetVMsForBrowse')
	delete from GXDBVersions where aliasname = 'ArchGetVMsForBrowse'
GO

insert into GXDBVersions values(2, 'ArchGetVMsForBrowse',  'v1.1.4.9.4.1', 'ArchGetVMsForBrowse', 'v1.1.4.9.4.1')
GO

