

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchGetSnapShotNamesForAF.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  ArchGetSnapShotNamesForAF.sp                */
/*                                                                            */
/*  Description :  Stored procedure to snapshot names for archvie files		  */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchGetSnapShotNamesForAF.sp,v $ $Id: ArchGetSnapShotNamesForAF.sp,v 1.1.2.1 2020/09/20 00:45:17 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ArchGetSnapShotNamesForAF')
BEGIN
	print '>>> Drop Stored Procedure: ArchGetSnapShotNamesForAF <<<'
	drop procedure ArchGetSnapShotNamesForAF
END
IF EXISTS (select * from GxQscripts where name='ArchGetSnapShotNamesForAF')
	delete from GxQscripts where name = 'ArchGetSnapShotNamesForAF'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGetSnapShotNamesForAF')
	delete from GXDBVersions where aliasname = 'ArchGetSnapShotNamesForAF'
GO
print '... Creating Procedure: ArchGetSnapShotNamesForAF'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ArchGetSnapShotNamesForAF
  @i_archFileId INTEGER,
  @i_commCellId INTEGER,
  @i_archCopyId INTEGER
AS
  DECLARE @o_snapShotNames NVARCHAR(256); 
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	DECLARE @snapShotNamesMax	NVARCHAR(MAX) = ''
	DECLARE @snapShotNames		NVARCHAR(255) = ''
	BEGIN TRY
		SELECT  @snapShotNamesMax = SUBSTRING((	SELECT DISTINCT ( ', ' + H.SMArrayId + ':' + SN.UniqueIdentifier)
												FROM	SMVolume SMV WITH (READUNCOMMITTED)
														INNER JOIN SMVolSnapMap Map WITH (READUNCOMMITTED) ON SMV.SMVolumeId = Map.SMVolumeId
														INNER JOIN SMSnap SN WITH (READUNCOMMITTED) ON Map.SMSnapId = SN.SMSnapId
														INNER JOIN SMControlHost H WITH (READUNCOMMITTED) ON SN.ControlHostId = H.ControlHostId
												WHERE	SMV.archFileId = @i_archFileId
														AND SMV.CommCellId = @i_commCellId
														AND SMV.CopyId = @i_archCopyId
												FOR XML PATH('') ), 2, 255)
		IF (LEN(@snapShotNamesMax) = 255)
		BEGIN
			SET	@snapShotNamesMax = REVERSE(@snapShotNamesMax)
			SET	@snapShotNames = REVERSE(SUBSTRING(@snapShotNamesMax, CHARINDEX(',', @snapShotNamesMax) +1, 255))
		END
		ELSE
		BEGIN
			SET @snapShotNames = @snapShotNamesMax
		END
		SELECT	@snapShotNames
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		;THROW
	END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'ArchGetSnapShotNamesForAF')
	delete from GxQscripts where name = 'ArchGetSnapShotNamesForAF'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGetSnapShotNamesForAF')
	delete from GXDBVersions where aliasname = 'ArchGetSnapShotNamesForAF'
GO

insert into GXDBVersions values(2, 'ArchGetSnapShotNamesForAF',  '00010001000200010000', 'ArchGetSnapShotNamesForAF', '00010001000200010000')
GO

