

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchGetMySQLLogArchFilesByTime.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchGetMySQLLogArchFilesByTime.sp,v $ $Id: ArchGetMySQLLogArchFilesByTime.sp,v 1.1.2.5 2018/03/27 08:45:53 jiechen Exp $";
-- Stored Proc Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ArchGetMySQLLogArchFilesByTime <<<'

IF EXISTS (select * from sysobjects where name='ArchGetMySQLLogArchFilesByTime')
	drop procedure ArchGetMySQLLogArchFilesByTime
IF EXISTS (select * from GxQscripts where name='ArchGetMySQLLogArchFilesByTime')
	delete from GxQscripts where name = 'ArchGetMySQLLogArchFilesByTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGetMySQLLogArchFilesByTime')
	delete from GXDBVersions where aliasname = 'ArchGetMySQLLogArchFilesByTime'
GO
print '... Creating Procedure: ArchGetMySQLLogArchFilesByTime'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ArchGetMySQLLogArchFilesByTime
-- Input Arguments
  @beforeTime integer,
  @includeAged integer,
  @appIds XML
AS
-- Output Arguments
-- negative errors can be ignored
  DECLARE @errorCode integer
  DECLARE @whereReturned integer
  DECLARE @archFileId integer
  DECLARE @name NVARCHAR(2048)
  DECLARE @commCellId integer
  DECLARE @archGroupId integer
  DECLARE @fileType integer
  DECLARE @createTime integer
  DECLARE @jobId integer
  DECLARE @appId integer
  DECLARE @backupLevel integer
-- input variables
declare @i_beforetime int
declare @lt_DataAppids table (appId Int, instance Int)
set @i_beforetime  = @beforeTime
declare @i_includeAged int
set @i_includeAged = @includeAged
DECLARE @AppIdList TABLE (id int)
INSERT INTO @AppIdList
SELECT t.value('.', 'int')
FROM @appIds.nodes('/APPID') AS appIds(t)
insert into @lt_DataAppids
select id, instance
FROM app_application
where id in (select id from @AppIdList)
--- local variables
declare @l_Error int
declare @l_whereReturned int
declare @l_instance int
set @l_Error  = 0
set @l_whereReturned = 0
-- first do some sanity checking
-- are all the appids of the same instance?
if (1 <>
(select count (distinct instance) from @lt_DataAppids) )
begin
	set @l_Error  = 1
	set @l_whereReturned = 1
	goto error_exit
end
SELECT TOP 1 @l_instance = instance
FROM @lt_DataAppids
-- now we need to get the time of the last data backup of all
-- the appids listed before the specified before time
DECLARE @l_aftertime int
DECLARE @TempLatestJobsPerSubClient TABLE(appId INTEGER, servStartDate INTEGER)
-- Backup level macro define INCR - 2, INCR_NOTRUNC - 256,   SNAPBACKUP - 59
INSERT INTO @TempLatestJobsPerSubClient
select JB.appId, max(JB.servStartDate) as begindate
from @lt_DataAppids Apps
	INNER JOIN jmbkpstats JB WITH(NOLOCK) ON JB.AppId = Apps.AppId AND (JB.bkpLevel NOT IN (2,256) OR JB.opType = 59) AND JB.servStartDate <= @i_beforetime
inner join jmjobdatastats JS WITH(NOLOCK) ON JS.commcellId = JB.commcellId AND JS.jobId = JB.jobId AND DataType = 1
	inner join archgroupcopy AGC WITH(NOLOCK) ON AGC.id = JS.archGrpCopyId
where JS.Status = 100	AND
(@i_includeAged = 1 OR (JS.Disabled  & 256) = 0 )
GROUP BY JB.appId
DECLARE @latestJobId INTEGER
DECLARE @CommcellIdOfLastJob INTEGER
SELECT @latestJobId = JB.jobId, @CommcellIdOfLastJob = JB.commcellId, @l_aftertime = LJob.servStartDate FROM jmbkpstats JB WITH(NOLOCK), (SELECT top 1 appId, servStartDate FROM @TempLatestJobsPerSubClient order by servStartDate ASC) AS LJob
WHERE JB.appId = LJob.appId
AND JB.servStartDate = LJob.servStartDate
if (@l_aftertime is null)
BEGIN
	set @l_Error  = -2
	set @l_whereReturned = 2
	goto error_exit
END
-- get all the instance APPids, I don't know which one the logs are for
DECLARE @lt_InstanceAppIds TABLE (AppId Integer)
INSERT INTO @lt_InstanceAppIds
SELECT id
FROM APP_Application
WHERE Instance = @l_Instance
-- now get all the log archive files for the instance in the time range
declare @lt_LOgAFS TABLE (commcellId int, AFId int)
-- logs before or at the before time
INSERT INTO @lt_LOgAFS
SELECT DISTINCT commcellId, id FROM (
SELECT AF.commcellId, AF.id
FROM  Archfile AF WITH(NOLOCK) INNER JOIN @lt_InstanceAppIds APPs ON APPS.appId = AF.AppId
WHERE AF.ctime >= @l_aftertime AND AF.ctime <= @i_beforetime
AND AF.isValid = 1 AND AF.FileType = 4
UNION ALL
SELECT AF.commcellId, AF.id
FROM
(
	SELECT MIN(AF1.ctime) as MinCTime
	FROM @lt_InstanceAppIds APPS1 INNER JOIN ArchFile AF1 WITH(NOLOCK) ON AF1.AppId = APPS1.AppID
	WHERE AF1.FileType = 4 AND AF1.isValid = 1 AND AF1.ctime > @i_beforetime
	--GROUP BY AF1.AppId /*We want only 1 log aFile across the instance for +1 logic*/
) AFTimes INNER JOIN ArchFile AF WITH(NOLOCK)
		ON AF.ctime = AFTimes.MinCTime
		INNER JOIN @lt_InstanceAppIds APPS ON APPS.AppId = AF.AppId
AND AF.IsValid = 1 AND AF.Filetype = 4
UNION ALL
SELECT AF.commcellId, AF.id FROM JMJobDataLink JML WITH(NOLOCK), archFile AF WITH(NOLOCK)
WHERE JML.parentJobId = @latestJobId
AND JML.commCellId = @CommcellIdOfLastJob
AND AF.jobId = JML.childJobId
AND AF.commCellId = JML.commCellId
AND AF.isValid = 1
AND AF.FileType = 4
) AS TMP
--ignore zero-sized AFs
DELETE @lt_LOgAFS
FROM @lt_LOgAFS LAFS inner join ArchFile AF WITH(NOLOCK) ON LAFS.AFId = AF.id AND LAFS.commcellId = AF.commCellId
inner join ArchFileCopy AFC WITH(NOLOCK) ON LAFS.AFId = AFC.archFileId AND LAFS.commcellId = AFC.commCellId AND AFC.physicalSize = 0 AND AFC.logicalSize = 0
inner join JMJobDataStats JDS WITH(NOLOCK) ON JDS.status = 100 AND JDS.jobId = AF.jobId AND JDS.dataType = AF.fileType AND JDS.archGrpCopyId = AFC.archCopyId
AND JDS.commcellId = AFC.commCellId
SELECT 0, 0, AF.id, AF.name, AF.commcellId, AF.archgroupId, AF.filetype,
			AF.ctime, AF.jobId, AF.appId, AF.backuplevel
FROM @lt_LOgAFS LAFS
INNER JOIN ArchFile AF ON AF.commcellId = LAFS.commcellId
AND AF.id = LAFS.AFId
GOTO NORMAL_EXIT
ERROR_EXIT:
SELECT @l_Error, @l_whereReturned, 0,'',0,0,0,0,0,0,0
NORMAL_EXIT:
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'ArchGetMySQLLogArchFilesByTime')
	delete from GxQscripts where name = 'ArchGetMySQLLogArchFilesByTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGetMySQLLogArchFilesByTime')
	delete from GXDBVersions where aliasname = 'ArchGetMySQLLogArchFilesByTime'
GO

insert into GXDBVersions values(2, 'ArchGetMySQLLogArchFilesByTime',  '00010001000200050000', 'ArchGetMySQLLogArchFilesByTime', '00010001000200050000')
GO

