

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchGetMountPathListForSubclients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ArchGetMountPathListForSubclients')
BEGIN
	print '>>> Drop Stored Procedure: ArchGetMountPathListForSubclients <<<'
	drop procedure ArchGetMountPathListForSubclients
END
IF EXISTS (select * from GxQscripts where name='ArchGetMountPathListForSubclients')
	delete from GxQscripts where name = 'ArchGetMountPathListForSubclients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGetMountPathListForSubclients')
	delete from GXDBVersions where aliasname = 'ArchGetMountPathListForSubclients'
GO
print '... Creating Procedure: ArchGetMountPathListForSubclients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ArchGetMountPathListForSubclients
  @i_subclientIdList XML
AS
  DECLARE @response XML;
--This will turn off message: "xxx rows affected".
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
DECLARE @outputXML  XML
DECLARE @dataServerBits INT = (16|32|128)
--Example XML : '<App_GetMountPathForSubclientsReq><subClient subclientId = "1" /><subClient subclientId = "2"/><mediaAgent mediaAgentId="2" /> </App_GetMountPathForSubclientsReq>'
IF (OBJECT_ID('tempdb..#lt_sc') IS NOT NULL)      DROP TABLE #lt_sc
CREATE TABLE #lt_sc (scId INT)
DECLARE @mediaAgentId INT = 0
SET @mediaAgentId = ( SELECT ISNULL ((PARAM1.value('@mediaAgentId','INTEGER')),0) FROM @i_subclientIdList.nodes('/App_GetMountPathForSubclientsReq/mediaAgent') AS messageXML(param1))
INSERT INTO #lt_sc
SELECT ISNULL ((PARAM.value('@subclientId','INTEGER')),0)
FROM @i_subclientIdList.nodes('/App_GetMountPathForSubclientsReq/subClient') AS messageXML(param)
DECLARE @MP TABLE
(
   mpid          INT,
   scid 		 INT,
   dp            VARCHAR(2048),
   mpName        NVARCHAR(2048),
   Cname         VARCHAR(2048),
   MAid			 INT,
   mangledMA	VARCHAR(MAX),
   fullTimeStamp INT,
   pathFormat	 VARCHAR(2)
)
INSERT INTO @MP
SELECT DISTINCT SM.mountPathId, SM.subClientId,DC.folder, MP.MountPathName,CN.NAME,CN.id,dbo.GetClientMangledHostName(C.id,NULL), fullTimeStamp ,(CASE SO.Name  WHEN 'Linux' THEN '/' ELSE '\\' END)
FROM   #lt_sc M
	INNER JOIN APP_SubclientToMountpathMapping SM WITH (READUNCOMMITTED) ON SM.subClientId = M.scId
	INNER JOIN MMMountPathToStorageDevice MSD WITH (READUNCOMMITTED) ON MSD.MountPathId = SM.mountPathId
	INNER JOIN MMMountPath MP WITH (READUNCOMMITTED) ON MP.MountPathId = SM.mountPathId
	INNER JOIN MMDeviceController DC WITH (READUNCOMMITTED) ON DC.DeviceId = MSD.DeviceId
	INNER JOIN App_Client CN WITH (READUNCOMMITTED) ON CN.id = DC.clientId
	LEFT OUTER JOIN APP_VMToPMMap VC WITH(READUNCOMMITTED) ON CN.Id = VC.VMClientId
	INNER JOIN App_Client C WITH (READUNCOMMITTED) ON C.id = ISNULL(VC.PMClientId, CN.Id)
	INNER JOIN simOperatingSystem SO WITH (READUNCOMMITTED) ON C.simOperatingSystemId = SO.id
	INNER JOIN simInstalledPackages SI WITH (READUNCOMMITTED) ON C.id = SI.ClientId
	WHERE (SO.Name  LIKE 'Linux' OR SO.Name LIKE 'Windows%')
		AND (C.ReleaseId > 16 OR (C.ReleaseId = 16 AND SI.HighestSP >= 17))
AND DC.deviceAccessType & ( @dataServerBits|4 ) = 4
		AND (@mediaAgentId = 0 OR DC.ClientId = @mediaAgentId)
SET @outputXML = (SELECT
						--Subclient Entity
						(SELECT scid as '@subclientId',
								subclientName as '@subclientName',
								GUID as '@subclientGUID'
						FROM APP_Application
						WHERE id = L.scId
						FOR XML PATH('subClient'), TYPE),
						--List of MountPaths
						(SELECT
								--MediaAgent Entity
								(SELECT MAid   as '@mediaAgentId',
										Cname as '@mediaAgentName'
								FOR XML PATH('mediaAgent'), TYPE ),
								mpid as 'mountPathId',
								'IP | ' + dp + pathFormat + mpName + pathFormat + 'CV_MAGNETIC'+ ' | ' + Cname as 'path' ,
								fullTimeStamp as 'fullTimestamp' ,
								mangledMA as 'mangledMediaAgentName'
						FROM @MP
						WHERE scid = L.scid
						AND  dp IS NOT NULL
						FOR XML RAW('mountPaths'), TYPE)
				FROM #lt_sc L
				FOR XML PATH('subclientMountPaths'), ROOT('App_GetMountPathListForSubclientsResp'))
SELECT @outputXML;
IF (OBJECT_ID('tempdb..#lt_sc') IS NOT NULL)      DROP TABLE #lt_sc
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'ArchGetMountPathListForSubclients')
	delete from GxQscripts where name = 'ArchGetMountPathListForSubclients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGetMountPathListForSubclients')
	delete from GXDBVersions where aliasname = 'ArchGetMountPathListForSubclients'
GO

insert into GXDBVersions values(2, 'ArchGetMountPathListForSubclients',  '00000000000000000000', 'ArchGetMountPathListForSubclients', '00000000000000000000')
GO

