

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchGetMAListFromSubclientList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ArchGetMAListFromSubclientList')
BEGIN
	print '>>> Drop Stored Procedure: ArchGetMAListFromSubclientList <<<'
	drop procedure ArchGetMAListFromSubclientList
END
IF EXISTS (select * from GxQscripts where name='ArchGetMAListFromSubclientList')
	delete from GxQscripts where name = 'ArchGetMAListFromSubclientList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGetMAListFromSubclientList')
	delete from GXDBVersions where aliasname = 'ArchGetMAListFromSubclientList'
GO
print '... Creating Procedure: ArchGetMAListFromSubclientList'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ArchGetMAListFromSubclientList
  @i_assocList XML
AS
  DECLARE @mediaAgentId integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
IF object_id('tempdb.dbo.#includeEntity') IS NOT NULL
        DROP TABLE #includeEntity
    CREATE TABLE #includeEntity
    (
        entityType integer,
        commcellId integer ,
        clientId integer ,
        appType integer ,
        instanceId integer ,
        backupsetId integer ,
        subclientId integer ,
        clientgroupId integer,
        planId	integer,
        exclude integer
    )
	INSERT INTO #includeEntity
        SELECT
            ISNULL(Tbl.Col.value('@_type_', 'int'),0) ,
            ISNULL(Tbl.Col.value('@commCellId', 'int'),2) ,
            ISNULL(Tbl.Col.value('@clientId', 'int'),0),
            ISNULL(Tbl.Col.value('@applicationId', 'int'),0) ,
            ISNULL(Tbl.Col.value('@instanceId', 'int'),0),
            ISNULL(Tbl.Col.value('@backupsetId', 'int'),0),
            ISNULL(Tbl.Col.value('@subclientId', 'int'),0),
            ISNULL(Tbl.Col.value('@clientGroupId', 'int'),0),
            ISNULL(Tbl.Col.value('@planId', 'int'),0),
            ISNULL(Tbl.Col.value('(flags/@exclude)[1]', 'int'),0)
        FROM @i_assocList.nodes('/App_GetMediaAgentsForSubclientsReq/associations') as Tbl(Col)
	IF object_id('tempdb.dbo.#appIdTbl') IS NOT NULL
		DROP TABLE #appIdTbl
    CREATE TABLE #appIdTbl ( appId INT PRIMARY KEY, appTypeId INT )
	 INSERT INTO #appIdTbl
    --All clients
    SELECT A.id, A.appTypeId FROM APP_Application A WITH(NOLOCK), #includeEntity B
WHERE B.entityType in(1 , 2)
    -- Include all CLIENTGROUPS
    UNION
    SELECT A.id, A.appTypeId FROM APP_Application A WITH(NOLOCK), #includeEntity B, APP_ClientGroupAssoc C
WHERE B.entityType = 27 AND A.clientId = C.clientId
    --CLIENT GROUP
    UNION
    SELECT A.id, A.appTypeId FROM APP_Application A WITH(NOLOCK)
	INNER JOIN APP_ClientGroupAssoc CGA WITH(NOLOCK)
		ON A.clientId = CGA.clientId
	INNER JOIN #includeEntity B
		ON B.clientgroupId = CGA.clientGroupId
WHERE B.entityType = 28
    --CLIENT
    UNION
    SELECT A.id, A.appTypeId FROM APP_Application A WITH(NOLOCK), #includeEntity B
WHERE B.entityType = 3
    AND A.clientId = B.clientId
    --APPTYPE
    UNION
    SELECT A.id, A.appTypeId FROM APP_Application A WITH(NOLOCK), #includeEntity B
WHERE B.entityType = 4
    AND A.clientId = B.clientId
    AND A.appTypeId = B.appType
    --INSTANCE
    UNION
    SELECT A.id, A.appTypeId FROM APP_Application A WITH(NOLOCK), #includeEntity B
WHERE B.entityType = 5
    AND A.clientId = B.clientId
    AND A.appTypeId = B.appType
    AND A.instance = B.instanceId
    --BACKUPSET
    UNION
    SELECT A.id, A.appTypeId FROM APP_Application A WITH(NOLOCK), #includeEntity B
WHERE B.entityType = 6
    AND A.clientId = B.clientId
    AND A.appTypeId = B.appType
    AND A.instance = B.instanceId
    AND A.backupset = B.backupsetId
	--Subclient Entity
	UNION
    SELECT A.id, A.appTypeId FROM APP_Application A WITH(NOLOCK), #includeEntity B
WHERE B.entityType = 7
    AND A.id = B.subclientId
	-- expand plan associations
	UNION
	SELECT A.id, A.appTypeId FROM APP_Application A WITH(NOLOCK)
	INNER JOIN #includeEntity B
ON B.entityType = 158
	AND B.planID > 0
	INNER JOIN App_SubclientProp (NOLOCK) ON A.id = App_SubclientProp.componentNameId
	AND App_SubclientProp.attrName = 'Associated Plan' AND App_SubclientProp.cs_attrName = CHECKSUM(N'Associated Plan')
	AND App_SubclientProp.attrVal = CAST(B.planId as nvarchar(10))
	AND App_SubclientProp.modified = 0
	--Filter appids that are not supported for Database Log dump/sweep feature
DELETE FROM #appIdTbl WHERE appTypeId NOT IN (81, 22, 80, 135, 3)
	;WITH ClientSPLevel AS (
	    SELECT DISTINCT
	        CLIENT.id AS ClientId,
	        CLIENT.releaseId AS ReleaseId,
	        MAX(PKG.HighestSP) AS SPMajor
	    FROM MMMountPathToStorageDevice SD WITH(READUNCOMMITTED)
			INNER JOIN MMDeviceController DC WITH(READUNCOMMITTED)
				ON SD.DeviceId = DC.DeviceId
			LEFT OUTER JOIN APP_VMToPMMap MAP WITH(READUNCOMMITTED)
				ON MAP.VMClientId = DC.ClientId
			INNER JOIN APP_Client CLIENT WITH(READUNCOMMITTED)
				ON CLIENT.id = ISNULL(MAP.PMClientId, DC.ClientId)
			INNER JOIN APP_SubclientToMountpathMapping MPM WITH(READUNCOMMITTED)
				ON SD.MountPathId = MPM.mountPathId
			INNER JOIN #appIdTbl Assoc
				ON MPM.subClientId = Assoc.appId
	        INNER JOIN SimInstalledPackages PKG WITH(READUNCOMMITTED)
				ON PKG.ClientId = CLIENT.id
	    WHERE
PKG.simPackageID in (51, 1301)
		GROUP BY CLIENT.id, CLIENT.releaseId)
	-- Consider clients from V12 or  V11 SP17 onwards
	-- Release id 15 == V10, 16 == V11
	SELECT C.clientId as mediaAgentId
		FROM ClientSPLevel C
	WHERE C.ReleaseId > 16 OR (C.ReleaseId = 16 AND C.SPMajor >= 17)
	IF object_id('tempdb.dbo.#includeEntity') IS NOT NULL
        DROP TABLE #includeEntity
	IF object_id('tempdb.dbo.#appIdTbl') IS NOT NULL
		DROP TABLE #appIdTbl
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'ArchGetMAListFromSubclientList')
	delete from GxQscripts where name = 'ArchGetMAListFromSubclientList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGetMAListFromSubclientList')
	delete from GXDBVersions where aliasname = 'ArchGetMAListFromSubclientList'
GO

insert into GXDBVersions values(2, 'ArchGetMAListFromSubclientList',  '00000000000000000000', 'ArchGetMAListFromSubclientList', '00000000000000000000')
GO

