

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchGetLatestBackupsetForClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchGetLatestBackupsetForClient.sp,v $ $Id: ArchGetLatestBackupsetForClient.sp,v 1.1.2.1 2020/02/14 00:59:14 pkrishnan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ArchGetLatestBackupsetForClient')
BEGIN
	print '>>> Drop Stored Procedure: ArchGetLatestBackupsetForClient <<<'
	drop procedure ArchGetLatestBackupsetForClient
END
IF EXISTS (select * from GxQscripts where name='ArchGetLatestBackupsetForClient')
	delete from GxQscripts where name = 'ArchGetLatestBackupsetForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGetLatestBackupsetForClient')
	delete from GXDBVersions where aliasname = 'ArchGetLatestBackupsetForClient'
GO
print '... Creating Procedure: ArchGetLatestBackupsetForClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ArchGetLatestBackupsetForClient
  @i_xml XML
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_outXml XML 
	SET NOCOUNT ON
	BEGIN TRY
		DECLARE @i_clientId INT
		DECLARE @i_appType INT
		SET @i_clientId = ISNULL (( SELECT R.ref.value('@clientId', 'integer') FROM @i_xml.nodes ( '/EVGui_GetLatestBackupSetForClient' ) R ( ref )), 0)
		SET @i_appType = ISNULL (( SELECT R.ref.value('@appType', 'integer') FROM @i_xml.nodes ( '/EVGui_GetLatestBackupSetForClient' ) R ( ref )), 0)
		IF(@i_clientId = 0 OR @i_appType = 0)
			RAISERROR('Invalid inputs', 16, 1)
		/*Find the AppId that has the latest archive file for this client and agent*/
		DECLARE @l_latestAppId INT
		SELECT TOP 1 @l_latestAppId = AppId
		FROM
		(
			SELECT App.id "AppId", MAX(AF.cTime) "cTime"
			FROM App_Application App WITH(NOLOCK) INNER JOIN ArchFile AF WITH(NOLOCK) ON App.id = AF.appId AND AF.isValid = 1
			WHERE App.clientId = @i_clientId AND App.appTypeId = @i_appType
			GROUP BY App.id
		) T
		ORDER BY cTime DESC
		/*Get backupset of the latest appid that we got. If appid is null (if there is no data), return the latest backupset by backupset id*/
		SET @o_outXml = (SELECT TOP 1 BKPS.id as 'backupSet/@backupsetId', BKPS.name as 'backupSet/@backupsetName', BKPS.GUID as 'backupSet/@backupsetGUID'
		FROM App_Application App WITH(NOLOCK) INNER JOIN App_BackupSetName BKPS WITH(NOLOCK) ON App.backupSet = BKPS.id
		WHERE App.id = @l_latestAppId OR (@l_latestAppId IS NULL AND App.clientId = @i_clientId AND App.appTypeId = @i_appType)
		ORDER BY BKPS.id DESC
		FOR XML PATH ('EVGui_BackupSetIdForClient'))
		SELECT @o_outXml
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		;THROW
	END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'ArchGetLatestBackupsetForClient')
	delete from GxQscripts where name = 'ArchGetLatestBackupsetForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGetLatestBackupsetForClient')
	delete from GXDBVersions where aliasname = 'ArchGetLatestBackupsetForClient'
GO

insert into GXDBVersions values(2, 'ArchGetLatestBackupsetForClient',  '00010001000200010000', 'ArchGetLatestBackupsetForClient', '00010001000200010000')
GO

