

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchGetLastAfileOfCycle.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchGetLastAfileOfCycle.sp,v $ $Id: ArchGetLastAfileOfCycle.sp,v 1.1.2.3 2018/03/20 19:58:36 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ArchGetLastAfileOfCycle <<<'

IF EXISTS (select * from sysobjects where name='ArchGetLastAfileOfCycle')
	drop procedure ArchGetLastAfileOfCycle
IF EXISTS (select * from GxQscripts where name='ArchGetLastAfileOfCycle')
	delete from GxQscripts where name = 'ArchGetLastAfileOfCycle'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGetLastAfileOfCycle')
	delete from GXDBVersions where aliasname = 'ArchGetLastAfileOfCycle'
GO
print '... Creating Procedure: ArchGetLastAfileOfCycle'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure ArchGetLastAfileOfCycle
  @i_archFileId integer,
  @i_commcellId integer,
  @i_retFileType integer
AS
  DECLARE @r_retCode integer
  DECLARE @r_archFileId integer
  DECLARE @r_commcellId integer
  DECLARE @r_fileType integer
  DECLARE @r_jobId integer
  DECLARE @r_archFileName NVARCHAR(2048)
  DECLARE @r_archGroupId integer
  DECLARE @r_appId integer
  DECLARE @r_cTime integer
  DECLARE @r_bkpLevel integer
/*
The logic below was taken from int ArchiveManagerCS::getLastAfileOfCycle(CVA_GetLastAfileOfCycleReq_t *args) with a fix being to look for the correct cycle number
and pick the last archive file instead of the old logic of looping through all archive files until we hit a full backup archive file.
*/
DECLARE @l_archGroupId int = 0
DECLARE @l_appId int = 0
DECLARE @l_cTime int = 0
DECLARE @l_fullCycleNum int = 0
DECLARE @l_isAdminJob int = 0
SELECT @l_fullCycleNum = ISNULL(JBKP.fullCycleNum, 0), @l_archGroupId = ISNULL(AF.archGroupId, 0), @l_appId = ISNULL(AF.appId, 0), @l_cTime = ISNULL(AF.cTime, 0)
FROM JMBkpStats JBKP WITH(NOLOCK) INNER JOIN ArchFile AF WITH(NOLOCK) ON JBKP.jobId = AF.jobId AND JBKP.commcellId = AF.commcellId
WHERE AF.id = @i_archFileId AND AF.commcellId = @i_commcellId
IF(@l_fullCycleNum = 0)
BEGIN
	SET @l_isAdminJob = 1
	SELECT @l_fullCycleNum = ISNULL(JBKP.fullCycleNum, 0), @l_archGroupId = ISNULL(AF.archGroupId, 0), @l_appId = ISNULL(AF.appId, 0), @l_cTime = ISNULL(AF.cTime, 0)
	FROM JMAdminJobStatsTable JBKP WITH(NOLOCK) INNER JOIN ArchFile AF WITH(NOLOCK) ON JBKP.jobId = AF.jobId AND JBKP.commcellId = AF.commcellId
	WHERE AF.id = @i_archFileId AND AF.commcellId = @i_commcellId
END
IF (@l_fullCycleNum = 0 OR @l_archGroupId = 0 OR @l_appId = 0 OR @l_cTime = 0)
	SELECT -1, 0, 0, 0, 0, 0, 0, 0, 0, 0
ELSE IF(@i_retFileType = 6)
BEGIN
	IF(@l_isAdminJob = 0)
		SELECT TOP 1 0, AF.id, AF.commcellId, AF.fileType, AF.jobid, AF.name, AF.archGroupId, @l_appId, AF.cTime, AF.backupLevel
		FROM ArchFile AF WITH(NOLOCK) INNER JOIN JMBkpStats JBKP WITH(NOLOCK) ON AF.jobId = JBKP.jobId AND AF.commcellId = JBKP.commcellId
WHERE AF.appId = @l_appId AND AF.fileType = 6 AND JBKP.fullCycleNum = @l_fullCycleNum AND AF.isValid = 1
		AND AF.cTime >= @l_cTime
		ORDER BY AF.cTime DESC
	ELSE
		SELECT TOP 1 0, AF.id, AF.commcellId, AF.fileType, AF.jobid, AF.name, AF.archGroupId, @l_appId, AF.cTime, AF.backupLevel
		FROM ArchFile AF WITH(NOLOCK) INNER JOIN JMAdminJobStatsTable JBKP WITH(NOLOCK) ON AF.jobId = JBKP.jobId AND AF.commcellId = JBKP.commcellId
WHERE AF.appId = @l_appId AND AF.fileType = 6 AND JBKP.fullCycleNum = @l_fullCycleNum AND AF.isValid = 1
		AND AF.cTime >= @l_cTime
		ORDER BY AF.cTime DESC
END
ELSE
BEGIN
	IF(@l_isAdminJob = 0)
		SELECT TOP 1 0, AF.id, AF.commcellId, AF.fileType, AF.jobid, AF.name, AF.archGroupId, @l_appId, AF.cTime, AF.backupLevel
		FROM ArchFile AF WITH(NOLOCK) INNER JOIN JMBkpStats JBKP WITH(NOLOCK) ON AF.jobId = JBKP.jobId AND AF.commcellId = JBKP.commcellId
		WHERE AF.appId = @l_appId AND AF.archGroupId = @l_archGroupId AND JBKP.fullCycleNum = @l_fullCycleNum AND AF.isValid = 1
		AND (@i_retFileType = 0 OR AF.fileType = @i_retFileType) AND AF.cTime >= @l_cTime
		ORDER BY AF.cTime DESC
	ELSE
		SELECT TOP 1 0, AF.id, AF.commcellId, AF.fileType, AF.jobid, AF.name, AF.archGroupId, @l_appId, AF.cTime, AF.backupLevel
		FROM ArchFile AF WITH(NOLOCK) INNER JOIN JMAdminJobStatsTable JBKP WITH(NOLOCK) ON AF.jobId = JBKP.jobId AND AF.commcellId = JBKP.commcellId
		WHERE AF.appId = @l_appId AND AF.archGroupId = @l_archGroupId AND JBKP.fullCycleNum = @l_fullCycleNum AND AF.isValid = 1
		AND (@i_retFileType = 0 OR AF.fileType = @i_retFileType) AND AF.cTime >= @l_cTime
		ORDER BY AF.cTime DESC
END
GO

IF EXISTS (select * from GxQscripts where name = 'ArchGetLastAfileOfCycle')
	delete from GxQscripts where name = 'ArchGetLastAfileOfCycle'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGetLastAfileOfCycle')
	delete from GXDBVersions where aliasname = 'ArchGetLastAfileOfCycle'
GO

insert into GXDBVersions values(2, 'ArchGetLastAfileOfCycle',  '00010001000200030000', 'ArchGetLastAfileOfCycle', '00010001000200030000')
GO

