

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchGetEncKeyByClientAndCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchGetEncKeyByClientAndCopy.sp,v $ $Id: ArchGetEncKeyByClientAndCopy.sp,v 1.1.2.3 2019/06/28 04:12:58 cliu Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ArchGetEncKeyByClientAndCopy')
BEGIN
	print '>>> Drop Stored Procedure: ArchGetEncKeyByClientAndCopy <<<'
	drop procedure ArchGetEncKeyByClientAndCopy
END
IF EXISTS (select * from GxQscripts where name='ArchGetEncKeyByClientAndCopy')
	delete from GxQscripts where name = 'ArchGetEncKeyByClientAndCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGetEncKeyByClientAndCopy')
	delete from GXDBVersions where aliasname = 'ArchGetEncKeyByClientAndCopy'
GO
print '... Creating Procedure: ArchGetEncKeyByClientAndCopy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ArchGetEncKeyByClientAndCopy
  @archFileId integer = 0,
  @commCellId integer = 2,
  @archCopyId integer = 0,
  @SIDBStoreId integer = 0,
  @clientId integer = 0,
  @encKeyType integer = 0,
  @encRSA integer = 0
AS
  DECLARE @o_encRSA integer = 0;
  DECLARE @o_encKeyType integer = 0;
  DECLARE @o_encKey varchar(1024) = '';
  DECLARE @o_encKeyId integer = 0;
  DECLARE @o_errorCode integer = 0;
DECLARE @DedupeFlags	integer = 0
DECLARE @RowCount		integer = 0
DECLARE @l_encRSA		tinyint = 0
DECLARE @l_encKeyType   integer = 0
DECLARE @l_encKey		varchar(1024)
DECLARE @l_encKeyId		int = 0
DECLARE @errorCode 		int = 0
SET @commCellId = CASE WHEN @commCellId = 0 THEN 2 ELSE @commCellId END
-- Encryption Key selected based on client and SIDBStore Ids
IF (@clientId = 0 AND @archFileId = 0)
OR (@archCopyId = 0)
BEGIN
	SET	@errorCode = -1
	GOTO ERR_EXIT
END
DECLARE @dependentCopyId integer = 0
EXEC ArchEncKeyGetDependentCopy @archCopyId, @dependentCopyId OUTPUT, @errorCode OUTPUT
IF @dependentCopyId > 0 AND @archCopyId != @dependentCopyId
	SET @archCopyId = @dependentCopyId
IF @clientId = 0
BEGIN
	SELECT	@clientId = app.ClientId
	FROM	App_application app WITH (NOLOCK), ArchFile archfile WITH (NOLOCK)
	WHERE	archfile.Id = @archFileId
	AND		archfile.commCellId = @commCellId
	AND		archFile.appId = app.Id
	SELECT	@errorCode = @@ERROR, @RowCount = @@ROWCOUNT
	IF	(@errorCode <> 0)
	BEGIN
		GOTO ERR_EXIT
	END
	IF (@RowCount = 0)
	BEGIN
		SET	@errorCode = -1
		GOTO ERR_EXIT
	END
END
SELECT	@SIDBStoreID = SIDBStoreId, @DedupeFlags = DedupeFlags
FROM	archGroupCopy WITH (NOLOCK)
WHERE	id = @archCopyId
SELECT	@errorCode = @@ERROR, @RowCount = @@ROWCOUNT
IF	(@errorCode <> 0)
BEGIN
	GOTO ERR_EXIT
END
IF (@RowCount = 0)
BEGIN
	SET	@errorCode = -1
	GOTO ERR_EXIT
END
IF (@DedupeFlags & 262144 = 0)
OR NOT EXISTS (SELECT 1 FROM MMConfigs WITH (NOLOCK) WHERE name = 'MMCONFIG_ENABLE_ENCRYPTION_SHARING_BASED_ON_CLIENT' and value > 0)
BEGIN
	SET	@errorCode = -1
	GOTO ERR_EXIT
END
DECLARE @userDefinedExpiredPeriod INT = 0
SELECT @userDefinedExpiredPeriod = value FROM MMConfigs WITH (NOLOCK) WHERE name = 'MMCONFIG_ENCRYPTION_SHARING_BASED_ON_CLIENT_REFRESH_TIME' and value > 0
IF @userDefinedExpiredPeriod = 0
BEGIN
	SELECT	TOP 1 @l_encKeyId = encKeyId,
	            @l_encKeyType = encKeyType,
				@l_encKey = encKey,
				@l_encRSA = encRSA
	FROM	ArchEncKeys WITH (NOLOCK)
	WHERE	clientId = @clientId
	AND		archCopyId = @archCopyId
	AND		encKeyType = @encKeyType
	AND		encRSA = @encRSA
	AND		isActive = 1
	--AND		ExpiredTime = 0
	SELECT	@errorCode = @@ERROR, @RowCount = @@ROWCOUNT
END
ELSE
BEGIN
	DECLARE @encKeyLife INT = 0
	SELECT @encKeyLife = dbo.GETUNIXTIME(DATEADD(dd, -1*@userDefinedExpiredPeriod, GETUTCDATE()))
	SELECT	TOP 1 @l_encKeyId = encKeyId,
	            @l_encKeyType = encKeyType,
				@l_encKey = encKey,
				@l_encRSA = encRSA
	FROM	ArchEncKeys WITH (NOLOCK)
	WHERE	clientId = @clientId
	AND		archCopyId = @archCopyId
	AND		encKeyType = @encKeyType
	AND		encRSA = @encRSA
	AND		isActive = 1
	--AND		ExpiredTime = 0
	AND		createTime > @encKeyLife
	SELECT	@errorCode = @@ERROR, @RowCount = @@ROWCOUNT
END
IF	(@errorCode <> 0)
BEGIN
	GOTO ERR_EXIT
END
IF (@RowCount = 0)
BEGIN
	SET	@errorCode = -1
	GOTO ERR_EXIT
END
ERR_EXIT:
SELECT @l_encRSA, @l_encKeyType, @l_encKey, @l_encKeyId, @errorCode
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'ArchGetEncKeyByClientAndCopy')
	delete from GxQscripts where name = 'ArchGetEncKeyByClientAndCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGetEncKeyByClientAndCopy')
	delete from GXDBVersions where aliasname = 'ArchGetEncKeyByClientAndCopy'
GO

insert into GXDBVersions values(2, 'ArchGetEncKeyByClientAndCopy',  '00010001000200030000', 'ArchGetEncKeyByClientAndCopy', '00010001000200030000')
GO

