

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchGetDependentCopyListByEntity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchGetDependentCopyListByEntity.sp,v $ $Id: ArchGetDependentCopyListByEntity.sp,v 1.1.2.1  2020/10/25 01:16:23 pveeravalli
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "ArchGetDependentCopyListByEntity"		|
-- 	+-----------------------------------------------------------------------+
---------------------------------------------------------------------------------
-- Currently this store procedure is supported for following entities
-- 1.LIBRARY_ENTITY(9)
-- 2.STORAGE_POOL_ENTITY(160)
---------------------------------------------------------------------------------
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ArchGetDependentCopyListByEntity')
BEGIN
	print '>>> Drop Stored Procedure: ArchGetDependentCopyListByEntity <<<'
	drop procedure ArchGetDependentCopyListByEntity
END
IF EXISTS (select * from GxQscripts where name='ArchGetDependentCopyListByEntity')
	delete from GxQscripts where name = 'ArchGetDependentCopyListByEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGetDependentCopyListByEntity')
	delete from GXDBVersions where aliasname = 'ArchGetDependentCopyListByEntity'
GO
print '... Creating Procedure: ArchGetDependentCopyListByEntity'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure ArchGetDependentCopyListByEntity
  @id INTEGER,
  @entityType INTEGER
AS
  DECLARE @spId INTEGER
  DECLARE @spName NVARCHAR(144)
  DECLARE @copyId INTEGER
  DECLARE @copyName NVARCHAR(64)
  DECLARE @copyType INTEGER
  DECLARE @dedupeFlags INTEGER
  DECLARE @storagePoolId INTEGER
  DECLARE @storagePoolName NVARCHAR(144)
  DECLARE @retentionDays INTEGER
  DECLARE @retentionCycles INTEGER
 IF (OBJECT_ID('tempdb.dbo.#TempCopyList') IS NOT NULL) DROP TABLE #TempCopyList
 CREATE TABLE #TempCopyList
 (
   spId			INT,
   spName		NVARCHAR(144),
   copyId		INT,
copyName		NVARCHAR(64),
   copyType             INT,
   dedupeFlags		INT Default 0,
   storagePoolId        INT,
   storagePoolName	NVARCHAR(144),
   retentionDays        INT Default 0,
   retentionCycles      INT Default 0
 )
IF @entityType = 9
 BEGIN
 	INSERT INTO #TempCopyList
 	SELECT DISTINCT AG.id , AG.name , AGC.id , AGC.name, AGC.type, AGC.dedupeFlags, 0, '' ,  0, 0
 	FROM archgroup AS AG WITH (READUNCOMMITTED)
      	    INNER JOIN archgroupcopy AS AGC WITH (READUNCOMMITTED) ON AG.id = AGC.archgroupid
      	    INNER JOIN MMDataPath AS MD WITH (READUNCOMMITTED) ON AGC.id = MD.CopyId
      	    INNER JOIN MMDrivePool AS MDP WITH (READUNCOMMITTED) ON MDP.DrivePoolId = MD.DrivePoolId
      	    INNER JOIN MMMasterPool AS mp WITH (READUNCOMMITTED) ON mp.masterpoolid = MDP.masterpoolid
 	WHERE mp.LibraryId = @id  AND
agc.type <> 5
 END
ELSE IF  @entityType = 160
 BEGIN
        INSERT INTO #TempCopyList
 	SELECT	AG.id, AG.name, AGC.id, AGC.name, AGC.type, AGC.dedupeFlags, 0, '' ,  0, 0
 	FROM archGroup AG WITH (READUNCOMMITTED)
      	    INNER JOIN archGroupCopy AGC WITH (READUNCOMMITTED) ON AG.id = AGC.archGroupId
            INNER JOIN archCopyToGlobalPolicy GP WITH (READUNCOMMITTED) ON GP.CopyId = AGC.id
        WHERE  GP.GlobalPolicyId = @id
        ORDER BY AG.name, AGC.name
 END
UPDATE TC
 SET  storagePoolName = GDSP.name , storagePoolId = GDSP.id
 FROM #TempCopyList TC, archCopyToGlobalPolicy GP WITH (READUNCOMMITTED), archGroup GDSP WITH (READUNCOMMITTED)
 WHERE TC.copyId = GP.copyId AND
 GDSP.id = GP.globalPolicyId
UPDATE TC
 SET retentionDays = AAG.retentionDays  , retentionCycles = AAG.fullCycles
 FROM #TempCopyList TC INNER JOIN archAgingRule AAG WITH (READUNCOMMITTED) ON TC.copyId = AAG.copyId
 SELECT spId	,   spName	,   copyId	,   copyName,
        copyType,   dedupeFlags ,   storagePoolId,  storagePoolName,
        retentionDays ,   retentionCycles
 	FROM #TempCopyList
 	ORDER BY spName, copyName
DROP TABLE #TempCopyList
GO

IF EXISTS (select * from GxQscripts where name = 'ArchGetDependentCopyListByEntity')
	delete from GxQscripts where name = 'ArchGetDependentCopyListByEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGetDependentCopyListByEntity')
	delete from GXDBVersions where aliasname = 'ArchGetDependentCopyListByEntity'
GO

insert into GXDBVersions values(2, 'ArchGetDependentCopyListByEntity',  '00000000000000000000', 'ArchGetDependentCopyListByEntity', '00000000000000000000')
GO

