

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchGetDDBRestoreInfoWithoutJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchGetDDBRestoreInfoWithoutJob.sp,v $ $Id: ArchGetDDBRestoreInfoWithoutJob.sp,v 1.1.48.2 2018/03/27 08:47:35 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ArchGetDDBRestoreInfoWithoutJob <<<'

IF EXISTS (select * from sysobjects where name='ArchGetDDBRestoreInfoWithoutJob')
	drop procedure ArchGetDDBRestoreInfoWithoutJob
IF EXISTS (select * from GxQscripts where name='ArchGetDDBRestoreInfoWithoutJob')
	delete from GxQscripts where name = 'ArchGetDDBRestoreInfoWithoutJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGetDDBRestoreInfoWithoutJob')
	delete from GXDBVersions where aliasname = 'ArchGetDDBRestoreInfoWithoutJob'
GO
print '... Creating Procedure: ArchGetDDBRestoreInfoWithoutJob'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ArchGetDDBRestoreInfoWithoutJob
  @i_SidbStoreID INTEGER, 
  @i_commCellId INTEGER
AS
  DECLARE @o_errorCode INTEGER
  DECLARE @o_SubStoreId INTEGER
  DECLARE @o_Version INTEGER
  DECLARE @o_DestClientId INTEGER
  DECLARE @o_DestClientName VARCHAR(255)
  DECLARE @o_DestIdxAccessPath VARCHAR(1024)
  DECLARE @o_DestIdxAccessPathUserName VARCHAR(255)
  DECLARE @o_DestIdxAccessPathUserPassword VARCHAR(255)
  DECLARE @o_clientId INTEGER
  DECLARE @o_clientName VARCHAR(255)
  DECLARE @o_appTypeId INTEGER
  DECLARE @o_appTypeName VARCHAR(255)
  DECLARE @o_instanceId INTEGER
  DECLARE @o_instanceName VARCHAR(255)
  DECLARE @o_backupSetId INTEGER
  DECLARE @o_backupSetName VARCHAR(255)
  DECLARE @o_subClientId INTEGER
  DECLARE @o_subClientName VARCHAR(255)
  DECLARE @o_IdxAccessPath VARCHAR(1024)
  DECLARE @o_lastJobIndexArchFileTime INTEGER
  DECLARE @o_lastJobId INTEGER
  DECLARE @o_lastJobCommCellId INTEGER
  DECLARE @o_lastSnapTime INTEGER
  DECLARE @o_isUnixOS INTEGER
  DECLARE @o_galaxyUserName VARCHAR(255)
  DECLARE @o_galaxyUserPassword VARCHAR(255)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET	@o_errorCode		= 0
SET	@o_IdxAccessPath	= ''
SET	@o_DestIdxAccessPathUserName	= ''
SET	@o_DestIdxAccessPathUserPassword	= ''
DECLARE	@l_IdxAccessPathId	INT
DECLARE	@l_lastSnapTime	INT
DECLARE	@l_ddbAppId		INT
DECLARE	@l_clientId		INT
DECLARE	@l_lastJobId	INT
DECLARE	@l_lastJobCommCellId	INT
DECLARE	@l_lastJobIndexArchFileTime	INT
DECLARE	@l_lastJobIndexArchFileId	INT
DECLARE	@s_SrcAccessPath	varchar(1024)
SET	@l_IdxAccessPathId	= -1
SET	@l_lastSnapTime		= -1
SET	@l_ddbAppId			= -1
SET	@l_clientId			= -1
SET	@l_lastJobId		= -1
SET	@l_lastJobCommCellId	= -1
SET	@l_lastJobIndexArchFileTime = -1
SET	@l_lastJobIndexArchFileId = -1
SET	@s_SrcAccessPath = ''
IF (NOT EXISTS (
			SELECT	*
			FROM	IdxSIDBStore I WITH (NOLOCK)
			WHERE	I.SIDBStoreId = @i_SidbStoreID
					AND I.CommCellId = @i_commCellId))
BEGIN
	--SET @o_errorCode = E_ARCH_SIDB_STORE_NOT_FOUND
	SELECT	1,
	0, 0,
	0 AS DestClientId,
	'' AS DestClientName,
	'', '', '', 0, '', 0, '', 0, '', 0, '', 0, '', '', 0, 0, 0, 0, 0, '', ''
	goto FINISH
END
DECLARE	 @tmpSIDBSubStore TABLE (
	errorCode			INTEGER,
	SubStoreId			INTEGER,
	CommCellId			INTEGER,
	Version				INTEGER,
	DestClientId		INTEGER,
DestClientName		VARCHAR(255),
	DestIdxAccessId		INTEGER,
DestIdxAccessPath	VARCHAR(1024),
DestIdxAccessPathUserName     VARCHAR(255),
DestIdxAccessPathUserPassword VARCHAR(255),
	clientId			INTEGER,
clientName			VARCHAR(255),
	appTypeId			INTEGER,
appTypeName			VARCHAR(255),
	instanceId			INTEGER,
instanceName		VARCHAR(255),
	backupSetId			INTEGER,
backupSetName		VARCHAR(255),
	ddbAppId			INTEGER,
subClientName		VARCHAR(255),
IdxAccessPath		VARCHAR(1024),
	lastJobIndexArchFileId		INTEGER,
	lastJobIndexArchFileTime	  INTEGER,
	lastJobId			INTEGER,
	lastJobCommCellId	INTEGER,
	lastSnapTime		INTEGER,
	isUnixOS			INTEGER,
galaxyUserName		VARCHAR(255),
galaxyUserPassword	VARCHAR(255)
	)
INSERT INTO @tmpSIDBSubStore
SELECT	0, SubStoreId, CommCellId, Version,
		I.ClientId,
		NULL,
		IdxAccessPathId,
		NULL, NULL, NULL,
		-1, NULL,
		-1, NULL,
		-1, NULL,
		-1, NULL,
		-1, NULL,
		SIDBSnapPath,
		-1,
		-1,
		(case when CC.id > 1 then LastSnapJobId else 0 end),
		(case when CC.id > 1 then CC.id else 0 end),
		LastSnapTime,
		(SELECT	(CASE WHEN Type = 'Unix' THEN 1 ELSE 0 END) FROM simOperatingSystem WHERE id = (SELECT TOP 1 simOperatingSystemId FROM App_Client WHERE id = I.ClientId)),
		NULL,
		NULL
FROM	IdxSIDBSubStore I
		LEFT OUTER JOIN APP_CommCell CC ON I.DDBBackupCSGUID = CC.csGUID
WHERE	I.SIDBStoreId = @i_SidbStoreID
UPDATE		@tmpSIDBSubStore
SET			DestClientName = name
FROM		@tmpSIDBSubStore SS, APP_Client C
WHERE		C.id = SS.DestClientId
UPDATE		@tmpSIDBSubStore
SET			DestIdxAccessPath = IAP.Path,
			DestIdxAccessPathUserName = IAP.Username,
			DestIdxAccessPathUserPassword = IAP.Password
FROM		@tmpSIDBSubStore SS, IdxAccessPath IAP
WHERE		IAP.IdxAccessPathId = SS.DestIdxAccessId
UPDATE		@tmpSIDBSubStore
SET			lastJobIndexArchFileId = JInfo.MaxArchIndexFileId,
			lastJobIndexArchFileTime = JInfo.MaxCTime,
			ddbAppId = appId
FROM		@tmpSIDBSubStore SS,
			(SELECT	SS.SubStoreId, max(SS.lastJobId) as lastJobId, max(SS.lastJobCommCellId) as lastJobCommCellId, MAX(id) AS MaxArchIndexFileId, MAX(appId) AS appId, MAX(cTime) MaxCTime
			FROM	archFile AF, @tmpSIDBSubStore SS
			WHERE	AF.jobId = SS.lastJobId
					AND AF.commCellId = SS.lastJobCommCellId
					AND fileType = 2
					AND isValid = 1
					AND (flags & 256) = 0
			GROUP BY SS.SubStoreId) JInfo
WHERE		JInfo.lastJobId = SS.lastJobId
			AND JInfo.lastJobCommCellId = SS.lastJobCommCellId
			AND JInfo.SubStoreId = SS.SubStoreId
UPDATE		@tmpSIDBSubStore
SET			clientId = A.ClientId,
			appTypeId = A.appTypeId,
			instanceId = A.instance,
			backupSetId = A.backupSet,
			subClientName = A.subclientName
FROM		@tmpSIDBSubStore SS, APP_Application A
WHERE		SS.ddbAppId = A.id
UPDATE		@tmpSIDBSubStore
SET			clientName = C.name
FROM		@tmpSIDBSubStore SS, APP_Client C
WHERE		SS.clientId = C.id
UPDATE		@tmpSIDBSubStore
SET			appTypeName = I.name
FROM		@tmpSIDBSubStore SS, APP_iDAType I
WHERE		SS.appTypeId = I.type
UPDATE		@tmpSIDBSubStore
SET			instanceName = I.name
FROM		@tmpSIDBSubStore SS, APP_InstanceName I
WHERE		SS.instanceId = I.id
UPDATE		@tmpSIDBSubStore
SET			backupSetName = B.name
FROM		@tmpSIDBSubStore SS, APP_BackupSetName B
WHERE		SS.backupSetId = B.id
UPDATE		@tmpSIDBSubStore
SET			galaxyUserName = U.login,
			galaxyUserPassword = U.password
FROM		(SELECT TOP 1 login, password FROM UMUsers WITH (NOLOCK) WHERE id > 0) U
UPDATE		@tmpSIDBSubStore
SET			errorCode = 2 --E_ARCH_DDB_LAST_JOB_NOT_FOUND
WHERE		ddbAppId IS NULL OR ddbAppId = -1 OR
			lastJobId IS NULL OR lastJobId = -1 OR
			lastJobIndexArchFileTime IS NULL OR lastJobIndexArchFileTime = -1 OR
			IdxAccessPath IS NULL OR IdxAccessPath = '' OR
			NOT EXISTS (SELECT * FROM ArchFileCopy WHERE archFileId = lastJobIndexArchFileId AND commCellId = lastJobCommCellId AND (flags & 256) = 0)
IF EXISTS (	SELECT	*
			FROM	@tmpSIDBSubStore)
BEGIN
	SELECT	errorCode,
			SubStoreId,
			Version,
			DestClientId,
			DestClientName,
			DestIdxAccessPath,
			DestIdxAccessPathUserName,
			DestIdxAccessPathUserPassword,
			clientId,
			clientName,
			appTypeId,
			appTypeName,
			instanceId,
			instanceName,
			backupSetId,
			backupSetName,
			ddbAppId,
			subClientName,
			IdxAccessPath,
			lastJobIndexArchFileTime,
			lastJobId,
			lastJobCommCellId,
			lastSnapTime,
			isUnixOS,
			galaxyUserName,
			galaxyUserPassword
	FROM	@tmpSIDBSubStore
END
ELSE
BEGIN
	--SET @o_errorCode = E_ARCH_CORRUPTED_SIDB_SUB_STORE_NOT_FOUND
	SELECT	3,
	0, 0,
	0 AS DestClientId,
	'' AS DestClientName,
	'', '', '', 0, '', 0, '', 0, '', 0, '', 0, '', '', 0, 0, 0, 0, 0, '', ''
END
FINISH:
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'ArchGetDDBRestoreInfoWithoutJob')
	delete from GxQscripts where name = 'ArchGetDDBRestoreInfoWithoutJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGetDDBRestoreInfoWithoutJob')
	delete from GXDBVersions where aliasname = 'ArchGetDDBRestoreInfoWithoutJob'
GO

insert into GXDBVersions values(2, 'ArchGetDDBRestoreInfoWithoutJob',  '00010001004800020000', 'ArchGetDDBRestoreInfoWithoutJob', '00010001004800020000')
GO

