

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchGetCustomCalPeriodStart.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  ArchGetCustomCalPeriodStart.sp		                      */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchGetCustomCalPeriodStart.sp,v $ $Id: ArchGetCustomCalPeriodStart.sp,v 1.1.6.2 2018/05/10 20:52:07 pkrishnan Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ArchGetCustomCalPeriodStart <<<'

IF EXISTS (select * from sysobjects where name='ArchGetCustomCalPeriodStart')
	drop procedure ArchGetCustomCalPeriodStart
IF EXISTS (select * from GxQscripts where name='ArchGetCustomCalPeriodStart')
	delete from GxQscripts where name = 'ArchGetCustomCalPeriodStart'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGetCustomCalPeriodStart')
	delete from GXDBVersions where aliasname = 'ArchGetCustomCalPeriodStart'
GO
print '... Creating Procedure: ArchGetCustomCalPeriodStart'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ArchGetCustomCalPeriodStart
  @i_inputTime BIGINT,
  @i_monthIncr INTEGER,
  @i_monthStartsFrom INTEGER,
  @i_calendarId INTEGER
AS
  DECLARE @r_startDate BIGINT;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
BEGIN TRY
--We got a UTC time. Convert it to local time and get rid of hours and minutes
DECLARE @i_inputDate datetime =  CONVERT(date, dbo.UTCToClientLocalTime(dbo.GetDateTime(@i_inputTime), 2))
DECLARE @startDate datetime
DECLARE @daysCount int
DECLARE @endDate dateTime
IF (@i_monthIncr/12 <> 0 AND @i_monthIncr%12 = 0) --For yearly periods
BEGIN
	DECLARE @yearStart datetime = dbo.GetDateTime((SELECT dbo.DAGetYearStart(@i_inputTime, @i_calendarId)))
	--If copy config is set to start a month from particular date we need to adjust the start date
	IF(@i_monthStartsFrom <> 1)
	BEGIN
		SELECT @daysCount = daysCount, @endDate = endDate from APP_CustomCalendarMonths WITH(NOLOCK) where startDate = @yearStart and calendarId = @i_calendarId
		--If custom days count of the month is less than the month start day
		IF((@daysCount IS NOT NULL) AND (@i_monthStartsFrom > @daysCount))
			SET @startDate = @endDate
		ELSE
			SET @startDate = DATEADD(day, @i_monthStartsFrom - 1, @yearStart)
		--If start date turns out to be after the input date go to previous period start
		IF @startDate > @i_inputDate
		BEGIN
			DECLARE @prevYearDate int = dbo.Getunixtime(DATEADD(day, -1, @yearStart))
			DECLARE @prevYearStartDate dateTime = dbo.GetDateTime((SELECT dbo.DAGetYearStart(@prevYearDate, @i_calendarId)))
			SELECT @daysCount = daysCount, @endDate = endDate from APP_CustomCalendarMonths WITH(NOLOCK) where startDate = @prevYearStartDate and calendarId = @i_calendarId
			--If custom days count of the month is less than the month start day
			IF((@daysCount IS NOT NULL) AND (@i_monthStartsFrom > @daysCount))
				SET @startDate = @endDate
			ELSE
				SET @startDate = DATEADD(day, @i_monthStartsFrom - 1, @prevYearStartDate)
		END
	END
	ELSE
		SET @startDate = @yearStart
END
ELSE IF (@i_monthIncr/6 <> 0 AND @i_monthIncr%6 = 0) --For half yearly
BEGIN
	DECLARE @halfYearStart datetime = dbo.GetDateTime((SELECT dbo.DAGetHalfYearStart(@i_inputTime, @i_calendarId)))
	--If copy config is set to start a month from particular date we need to adjust the start date
	IF(@i_monthStartsFrom <> 1)
	BEGIN
		SELECT @daysCount = daysCount, @endDate = endDate from APP_CustomCalendarMonths WITH(NOLOCK) where startDate = @halfYearStart and calendarId = @i_calendarId
		--If custom days count of the month is less than the month start day
		IF((@daysCount IS NOT NULL) AND (@i_monthStartsFrom > @daysCount))
			SET @startDate = @endDate
		ELSE
			SET @startDate = DATEADD(day, @i_monthStartsFrom - 1, @halfYearStart)
		--If start date turns out to be after the input date go to previous period start
		IF @startDate > @i_inputDate
		BEGIN
			DECLARE @prevHalfYearDate int = dbo.GetUnixTime(DATEADD(day, -1, @halfYearStart))
			DECLARE @prevHalfYearStartDate dateTime = dbo.GetDateTime((SELECT dbo.DAGetHalfYearStart(@prevHalfYearDate, @i_calendarId)))
			SELECT @daysCount = daysCount, @endDate = endDate from APP_CustomCalendarMonths WITH(NOLOCK) where startDate = @prevHalfYearStartDate and calendarId = @i_calendarId
			--If custom days count of the month is less than the month start day
			IF((@daysCount IS NOT NULL) AND (@i_monthStartsFrom > @daysCount))
				SET @startDate = @endDate
			ELSE
				SET @startDate = DATEADD(day, @i_monthStartsFrom - 1, @prevHalfYearStartDate)
		END
	END
	ELSE
		SET @startDate = @halfYearStart
END
ELSE IF (@i_monthIncr/3 <> 0 AND @i_monthIncr%3 = 0) --For quarter year
BEGIN
	DECLARE @quarterStart datetime = dbo.GetDateTime((SELECT dbo.DAGetQuarterStart(@i_inputTime, @i_calendarId)))
	--If copy config is set to start a month from particular date we need to adjust the start date
	IF(@i_monthStartsFrom <> 1)
	BEGIN
		SELECT @daysCount = daysCount, @endDate = endDate from APP_CustomCalendarMonths WITH(NOLOCK) where startDate = @quarterStart and calendarId = @i_calendarId
		--If custom days count of the month is less than the month start day
		IF((@daysCount IS NOT NULL) AND (@i_monthStartsFrom > @daysCount))
			SET @startDate = @endDate
		ELSE
			SET @startDate = DATEADD(day, @i_monthStartsFrom - 1, @quarterStart)
		--If start date turns out to be after the input date go to previous period start
		IF @startDate > @i_inputDate
		BEGIN
			DECLARE @prevQuarterDate int = dbo.GetUnixTime(DATEADD(day, -1, @quarterStart))
			DECLARE @prevQuarterStartDate dateTime = dbo.GetDateTime((SELECT dbo.DAGetQuarterStart(@prevQuarterDate, @i_calendarId)))
			SELECT @daysCount = daysCount, @endDate = endDate from APP_CustomCalendarMonths WITH(NOLOCK) where startDate = @prevQuarterStartDate and calendarId = @i_calendarId
			--If custom days count of the month is less than the month start day
			IF((@daysCount IS NOT NULL) AND (@i_monthStartsFrom > @daysCount))
				SET @startDate = @endDate
			ELSE
				SET @startDate = DATEADD(day, @i_monthStartsFrom - 1, @prevQuarterStartDate)
		END
	END
	ELSE
		SET @startDate = @quarterStart
END
ELSE --Monthly
BEGIN
	SET @startDate = dbo.GetDateTime(dbo.DAGetMonthStart(@i_inputTime, @i_calendarId, @i_monthStartsFrom))
END
--Return UTC time of period start in local time
SELECT dbo.GetUnixTime(dbo.ClientLocalToUTCTime(@startDate,2))
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SELECT -1
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'ArchGetCustomCalPeriodStart')
	delete from GxQscripts where name = 'ArchGetCustomCalPeriodStart'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGetCustomCalPeriodStart')
	delete from GXDBVersions where aliasname = 'ArchGetCustomCalPeriodStart'
GO

insert into GXDBVersions values(2, 'ArchGetCustomCalPeriodStart',  '00010001000600020000', 'ArchGetCustomCalPeriodStart', '00010001000600020000')
GO

