

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchGetCatalogedStatusForVsaCycle.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2019  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Paul Mazur
--	Date:   10/18/2019
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchGetCatalogedStatusForVsaCycle.sp,v $ $Id: ArchGetCatalogedStatusForVsaCycle.sp,v 1.1.4.6 2020/12/07 20:27:29 chandru Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ArchGetCatalogedStatusForVsaCycle')
BEGIN
	print '>>> Drop Stored Procedure: ArchGetCatalogedStatusForVsaCycle <<<'
	drop procedure ArchGetCatalogedStatusForVsaCycle
END
IF EXISTS (select * from GxQscripts where name='ArchGetCatalogedStatusForVsaCycle')
	delete from GxQscripts where name = 'ArchGetCatalogedStatusForVsaCycle'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGetCatalogedStatusForVsaCycle')
	delete from GXDBVersions where aliasname = 'ArchGetCatalogedStatusForVsaCycle'
GO
print '... Creating Procedure: ArchGetCatalogedStatusForVsaCycle'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ArchGetCatalogedStatusForVsaCycle
  @xmlText XML
AS
DECLARE @jobId INT = ISNULL(@xmlText.value('(/Indexing_ArchGetCatalogedStatusForVsaCycleReq/@jobId)[1]', 'int'), 0)
DECLARE @commcellId INT = ISNULL(@xmlText.value('(/Indexing_ArchGetCatalogedStatusForVsaCycleReq/@commcellId)[1]', 'int'), 0)
DECLARE @copyPrecedence INT = ISNULL(@xmlText.value('(/Indexing_ArchGetCatalogedStatusForVsaCycleReq/@copyPrecedence)[1]', 'int'), 0)
DECLARE @snapJob integer = ISNULL(@xmlText.value('(/Indexing_ArchGetCatalogedStatusForVsaCycleReq/@snapJob)[1]', 'INT'), 0)
--TODO: honor copyPrecedence - as of now check is across all copies
DECLARE @status INT = 0
--  0 - success
--  1 - no job found matching the criteria
-- -1 - incorrect parameters received
if @jobId=0 or @commcellId=0
BEGIN
	set @status=-1
END
ELSE
BEGIN
	DECLARE @appId INT
	DECLARE @cycleNum INT
	select @cycleNum=fullcyclenum, @appId=appId from JMBkpStats WITH(NOLOCK) where jobId=@jobId and commcellId=@commcellId
	if @appId is NULL
	BEGIN
		--could happen if currently running jobId is received
		select @appId= applicationId from jmbkpjobinfo WITH(NOLOCK) where jobId=@jobId and commcellId=@commcellId
		if @appId is NULL
		BEGIN
			set @status=1
		END
		ELSE
		BEGIN
			-- snap and tape could have different last cycle
			select @cycleNum=MAX(js.fullcyclenum) from JMBkpStats js WITH(NOLOCK)
			join archFile af WITH(NOLOCK) on af.jobid=js.jobid
					and af.commCellId = js.commCellId
					and (@snapJob=1 AND af.fileType=6 or @snapJob=0 and af.fileType=2)
					and af.isValid=1
			where js.appId=@appId and js.commcellId=@commcellId
		END
	END
END
DECLARE @outxmlText XML
--Output XML generation
SET @outxmlText = (
	SELECT @status as '@status',
	(
			select js.jobId as '@jobId', js.commcellId as '@commcellId', ISNULL(af1.id, 0) as '@cataloged',
IIF(((JDS.disabled & 256 = 256) AND AR.retentionDays != 0 AND AR.fullCycles != 0), 1, 0) AS '@agedOnNonSpoolCopy'
			 from JMBkpStats js WITH(NOLOCK)
				JOIN JMJobDataStats JDS WITH (READUNCOMMITTED) ON JS.JobId = JDS.JobId AND JS.CommCellId = JDS.CommCellId AND JDS.DataType = 1
				JOIN archGroup AG WITH (READUNCOMMITTED) ON JDS.ArchGrpId = AG.id AND JDS.archGrpCopyId = AG.defaultCopy
				JOIN archAgingRule AR WITH (READUNCOMMITTED) ON AG.defaultCopy = AR.copyId
				join archFile af WITH(NOLOCK) on af.jobid=js.jobid
						and af.commCellId = js.commCellId
						and (@snapJob=1 AND af.fileType=6 or @snapJob=0 and af.fileType=2)
						and af.isValid=1
				-- CVA_DATATYPE_FILE_INDEX == 9
				left outer join archFile af1 WITH(NOLOCK) on af1.jobId=js.jobId and af1.commcellid=js.commcellid and af1.fileType=9 and af1.isValid=1
				where @status=0 and js.appid=@appId and js.fullcyclenum=@cycleNum and js.status in (1,3,14)
			FOR XML PATH('jobList'), TYPE
	)
	FOR XML PATH('Indexing_ArchGetCatalogedStatusForVsaCycleResp'), TYPE)
SELECT  @outxmlText
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'ArchGetCatalogedStatusForVsaCycle')
	delete from GxQscripts where name = 'ArchGetCatalogedStatusForVsaCycle'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGetCatalogedStatusForVsaCycle')
	delete from GXDBVersions where aliasname = 'ArchGetCatalogedStatusForVsaCycle'
GO

insert into GXDBVersions values(2, 'ArchGetCatalogedStatusForVsaCycle',  '00010001000400060000', 'ArchGetCatalogedStatusForVsaCycle', '00010001000400060000')
GO

