

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchGetBCDVolumeForSnapJob.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  ArchGetBCDVolumeForSnapJob.sp                              */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchGetBCDVolumeForSnapJob.sp,v $ $Id: ArchGetBCDVolumeForSnapJob.sp,v 1.1.4.7 2020/07/21 21:59:06 chandru Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ArchGetBCDVolumeForSnapJob')
BEGIN
	print '>>> Drop Stored Procedure: ArchGetBCDVolumeForSnapJob <<<'
	drop procedure ArchGetBCDVolumeForSnapJob
END
IF EXISTS (select * from GxQscripts where name='ArchGetBCDVolumeForSnapJob')
	delete from GxQscripts where name = 'ArchGetBCDVolumeForSnapJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGetBCDVolumeForSnapJob')
	delete from GXDBVersions where aliasname = 'ArchGetBCDVolumeForSnapJob'
GO
print '... Creating Procedure: ArchGetBCDVolumeForSnapJob'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure ArchGetBCDVolumeForSnapJob
-- The following two lines indicate, in order, parameters that will be
--  expected in the "setValues()" method, as well as the order in which
--  they will be provided as arguments to the SQLSTRING command
  @i_commCellId integer,
  @i_jobId integer,
  @i_copyPrecedence integer,
  @i_includeAgedData integer
AS
--	The next two lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
  DECLARE @name NVARCHAR(2048);
  DECLARE @archFileId INTEGER;
  DECLARE @archGroupId INTEGER;
  DECLARE @appId INTEGER;
  DECLARE @fileType INTEGER;
  DECLARE @createTime INTEGER;
  DECLARE @backupLevel INTEGER;
  DECLARE @archFileFlags INTEGER;
-- Output values - do not initialize!!
DECLARE @l_ArchGroupId Integer
DECLARE @l_CopyId Integer
DECLARE @l_IsSnapCopy Integer
DECLARE @l_VolumeId Integer
DECLARE @l_ArchFileId Integer
DECLARE @l_SnapToMediaEnabled Integer
DECLARE @l_SnapToMediaSrcCopyId Integer
DECLARE @l_Error Integer
SET @l_Error = 0
-- first, figure out the storage policy copy
SELECT	TOP 1 @l_ArchGroupId = J.archGrpId, @l_CopyId = J.archGrpCopyId, @l_IsSnapCopy = C.isSnapCopy
FROM	JMJobDataStats J WITH (READUNCOMMITTED), archGroupCopy C WITH (READUNCOMMITTED)
WHERE	J.jobId = @i_jobId AND J.commCellId = @i_commCellId
		AND C.id = J.archGrpCopyId
		AND (@i_copyPrecedence = 0 OR C.copy = @i_copyPrecedence)
AND (@i_includeAgedData = 1 OR (J.disabled & 256) = 0)
GROUP BY J.archGrpId, J.archGrpCopyId, C.isSnapCopy, C.copy
HAVING MIN(Status) = 100 AND MAX(Status) = 100
ORDER BY C.copy
IF (@l_CopyId IS NULL) AND (@i_commCellId  = 2)
begin
	DECLARE @l_opType INT
	SELECT @l_opType = opType FROM JMJobInfo WITH(READUNCOMMITTED) WHERE jobId = @i_jobId AND commcellId = 2
	IF @l_opType IS NOT NULL
	BEGIN
		-- job is still running, JMJobDatastats entries will not exist,
		-- so set everything so that we can get the copy automatically later
		SET @l_CopyId = 0
		IF @l_opType = 59 -- SNAPBACKUP = 59, -- Snap Backup
			SET @l_IsSnapCopy = 1
		ELSE
			SET @l_IsSnapCopy = 0
	END
end
IF (@l_CopyId IS NULL)
BEGIN
	SET @l_Error = 1
	GOTO proc_exit
END
IF	@l_IsSnapCopy = 0
BEGIN
	IF EXISTS (SELECT 1 FROM JMVSAAppJobLink WITH (READUNCOMMITTED) WHERE childJobId = @i_jobId AND commCellId = @i_commCellId)
	BEGIN
		IF(@l_CopyId > 0) --Get the BCD index archfile for the copy we already have
			SELECT	@l_ArchFileId = AF.id
			FROM	archFile AF WITH (READUNCOMMITTED) INNER JOIN archFileCopy AFC WITH (READUNCOMMITTED) ON AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId AND AFC.archCopyId = @l_CopyId
			WHERE	AF.jobId = @i_jobId AND AF.commCellId = @i_commCellId AND AF.isValid = 1 AND AFC.isValid = 1
AND AF.fileType = 2
		/*
		Possible cases here -
		@l_ArchFileId > 0 AND @l_CopyId > 0 	- We don't have to go inside this block
		@l_ArchFileId IS NULL AND @l_CopyId > 0 - This can happen if the job exists in the copy but somehow BCD index doesn't exist or not valid,
												  so in the following block we will pick up any available copy based on given copy precedence for the job's valid BCD index AF
		@l_ArchFileId > 0 AND @l_CopyId = 0 	- This can never happen as we would not have picked an archive file id without copyId at this point of code
		*/
		IF(@l_ArchFileId IS NULL OR @l_CopyId = 0)
		BEGIN
			SELECT	@l_ArchFileId = MAX(id)
			FROM	archFile WITH (READUNCOMMITTED)
			WHERE	jobId = @i_jobId AND commCellId = @i_commCellId AND isValid = 1
AND fileType = 2
		END
	END
	ELSE
	BEGIN
		IF @l_CopyId > 0
		BEGIN
			-- get the first valid non-snap data AF
			SELECT	@l_ArchFileId = MIN(id)
			FROM	archFile  AF WITH (READUNCOMMITTED) INNER JOIN archFileCopy AFC WITH (READUNCOMMITTED) ON AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId AND AFC.archCopyId = @l_CopyId
			WHERE	AF.jobId = @i_jobId AND AF.commCellId = @i_commCellId AND AF.isValid = 1 AND AFC.isValid = 1  AND (AFC.physicalSize > 0 OR AFC.logicalSize > 0)
AND AF.fileType IN (1, 4) AND (AF.flags & 2) = 0
		END
		ELSE
		BEGIN
			SELECT	@l_ArchFileId = MAX(AF.id)
			FROM	archFile AF WITH (READUNCOMMITTED)
			WHERE	AF.jobId = @i_jobId AND AF.commCellId = @i_commCellId AND AF.isValid = 1
AND AF.fileType IN (1, 4) AND (AF.flags & 2) = 0
		END
	END
END
ELSE
BEGIN
	IF(@l_CopyId > 0) --Get the BCD index archfile for the copy we already have
		SELECT	@l_ArchFileId = AF.id
		FROM	archFile AF WITH (READUNCOMMITTED) INNER JOIN archFileCopy AFC WITH (READUNCOMMITTED) ON AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId AND AFC.archCopyId = @l_CopyId
		WHERE	AF.jobId = @i_jobId AND AF.commCellId = @i_commCellId AND AF.isValid = 1 AND AFC.isValid = 1
AND AF.fileType = 6
	/*
	Possible cases here -
	@l_ArchFileId > 0 AND @l_CopyId > 0 	- We don't have to go inside this block
	@l_ArchFileId IS NULL AND @l_CopyId > 0 - This can happen if the job exists in the copy but somehow BCD index doesn't exist or not valid,
											  so in the following block we will pick up any available copy based on given copy precedence for the job's valid BCD index AF
	@l_ArchFileId > 0 AND @l_CopyId = 0 	- This can never happen as we would not have picked an archive file id without copyId at this point of code
	*/
	IF(@l_ArchFileId IS NULL OR @l_CopyId = 0)
	BEGIN
		SELECT	@l_ArchFileId = MAX(id)
		FROM	archFile WITH (READUNCOMMITTED)
		WHERE	jobId = @i_jobId AND commCellId = @i_commCellId AND isValid = 1
AND fileType = 6
		--If we fetched archive file id here reset the copy id so we will fetch new copy id based on this archive file id
		IF @l_ArchFileId > 0
			SET @l_CopyId = 0
	END
END
IF(@l_CopyId = 0 AND @l_ArchFileId > 0)
	SELECT	TOP 1 @l_CopyId = AGC.id, @l_ArchGroupId = AGC.archGroupId
				FROM	archFileCopy AFC WITH (READUNCOMMITTED), archGroupCopy AGC WITH (READUNCOMMITTED)
				WHERE	AFC.archFileId = @l_ArchFileId AND AFC.commCellId = @i_commCellId AND AFC.isValid = 1
				AND AGC.id = AFC.archCopyId
				AND (@i_copyPrecedence = 0 OR AGC.copy = @i_copyPrecedence)
				ORDER BY AGC.copy
IF (@l_CopyId = 0)
BEGIN
	SET @l_Error = 5
	goto proc_exit
END
if (@l_ArchFileId is null)
begin
	set @l_Error = 2
	goto proc_exit
end
IF	@l_IsSnapCopy <> 0
BEGIN
	SELECT	@l_SnapToMediaEnabled = enabled,
			@l_SnapToMediaSrcCopyId = sourceCopyId
	FROM	archMaterializeSnapshotProp WITH (READUNCOMMITTED)
	WHERE	archGroupId = @l_ArchGroupId
	IF	@l_SnapToMediaEnabled = 0
		SET @l_SnapToMediaSrcCopyId = 0
	ELSE
	IF	@l_SnapToMediaSrcCopyId = 0
		SELECT @l_SnapToMediaSrcCopyId = defaultSnapCopy FROM archGroup WITH (READUNCOMMITTED)  WHERE id = @l_ArchGroupId
END
-- now we are ready to get the volume. For this just get the top 1 chunk for the archfileid and copy
-- we don't care if there are multiple. We are just interested in one to later determine the mediaagent.
DECLARE @l_ChunkId bigint
DECLARE @l_ChunkCommcellId int
SELECT TOP 1 @l_chunkId = archChunkId, @l_ChunkCommcellId = chunkCommcellId
FROM	ArchChunkMapping WITH (READUNCOMMITTED)
WHERE	archFileId = @l_ArchFileId AND commCellId = @i_commCellId AND archCopyId = @l_CopyId
IF (@l_ChunkId is NULL)
BEGIN
	SET @l_Error = 3
	goto proc_exit
END
SELECT	@l_VolumeId = volumeId
FROM	ArchChunk WITH (READUNCOMMITTED)
WHERE	id = @l_ChunkId AND commCellId = @l_ChunkCommcellId
IF (@l_VolumeId is NULL)
BEGIN
	set @l_Error = 4
	goto proc_exit
END
proc_exit:
SELECT	'',
		0,
		@l_Error,
		ISNULL(@l_CopyId,0),
		ISNULL(@l_IsSnapCopy,0),
		ISNULL(@l_VolumeId,0),
		ISNULL(@l_SnapToMediaEnabled,0),
		ISNULL(@l_SnapToMediaSrcCopyId,0)
UNION
SELECT	AF.name,
		AF.id,
		AF.archGroupId,
		AF.appId,
		AF.fileType,
		AF.cTime,
		AF.backupLevel,
		AF.flags
FROM	archFile AF WITH (READUNCOMMITTED), archFileCopy AFC WITH (READUNCOMMITTED)
WHERE	@l_CopyId IS NOT NULL
	AND AF.jobId = @i_jobId AND AF.commCellId = @i_commCellId AND AF.isValid = 1
	AND AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId
	AND AFC.archCopyId = @l_CopyId AND AFC.isValid = 1
GO

IF EXISTS (select * from GxQscripts where name = 'ArchGetBCDVolumeForSnapJob')
	delete from GxQscripts where name = 'ArchGetBCDVolumeForSnapJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGetBCDVolumeForSnapJob')
	delete from GXDBVersions where aliasname = 'ArchGetBCDVolumeForSnapJob'
GO

insert into GXDBVersions values(2, 'ArchGetBCDVolumeForSnapJob',  '00010001000400070000', 'ArchGetBCDVolumeForSnapJob', '00010001000400070000')
GO

