

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchGetAssociatedSubclientsWithSP.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--  Author: PavanKumar Veeravalli
--  Date:   6/15/2016
-- ----------------------------------------------------------------------*/
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ArchGetAssociatedSubclientsWithSP <<<'

IF EXISTS (select * from sysobjects where name='ArchGetAssociatedSubclientsWithSP')
	drop procedure ArchGetAssociatedSubclientsWithSP
IF EXISTS (select * from GxQscripts where name='ArchGetAssociatedSubclientsWithSP')
	delete from GxQscripts where name = 'ArchGetAssociatedSubclientsWithSP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGetAssociatedSubclientsWithSP')
	delete from GXDBVersions where aliasname = 'ArchGetAssociatedSubclientsWithSP'
GO
print '... Creating Procedure: ArchGetAssociatedSubclientsWithSP'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ArchGetAssociatedSubclientsWithSP
  @i_xml XML
AS
  DECLARE @clientId INTEGER;
  DECLARE @clientName NVARCHAR(255);
  DECLARE @ApptypeId INTEGER;
  DECLARE @AppTypeName NVARCHAR(255);
  DECLARE @instanceId INTEGER;
  DECLARE @instanceName NVARCHAR(255);
  DECLARE @backupsetId INTEGER;
  DECLARE @backupsetName NVARCHAR(255);
  DECLARE @subclientId INTEGER;
  DECLARE @subclientName NVARCHAR(MAX);
if (OBJECT_ID('tempdb.dbo.#SubclientAssocTbl') IS NOT NULL) DROP TABLE #SubclientAssocTbl
if (OBJECT_ID('tempdb.dbo.#assocTable') IS NOT NULL) DROP TABLE #assocTable
 --set @i_xml = N'<SubclientAssociation archGrpId = "22">  <SubClientInfo  subclientId = "4" policyType="" />  <SubClientInfo  subclientId = "10" policyType= "LOG" /></SubclientAssociation>'
 --set @i_xml = N'<SubclientAssociation archGrpId = "12"> </SubclientAssociation>'
   SELECT  DISTINCT T.item.value('@subclientId ', 'INTEGER') AS SubclientId ,
 					T.item.value('@SubclientName', 'VARCHAR(256)') AS SName,
					T.item.value('@policyType', 'VARCHAR(256)') AS AssociatedPolicyType
    INTO    #SubclientAssocTbl
    FROM    @i_xml.nodes('/SubclientAssociation/SubClientInfo') T(item)
DECLARE	@spId  INTEGER
DECLARE	@subclientsCount  INTEGER
SET @spId =  @i_xml.value('(/SubclientAssociation/@archGrpId)[1]', 'int' )
SET @subclientsCount = (Select count(*) FROM #SubclientAssocTbl)
 CREATE TABLE #assocTable (
    	ClientID					INTEGER,
ClientName					NVARCHAR(255),
	ApptypeId					INTEGER,
ApptypeName					NVARCHAR(255),
	InstanceId					INTEGER,
InstanceName					NVARCHAR(255),
	BackupsetId					INTEGER,
BackupsetName					NVARCHAR(255),
	SubclientId					INTEGER,
	SubclientName					NVARCHAR(MAX),
	PolicyType					VARCHAR(100)
  )
IF @subclientsCount>0
	BEGIN
		INSERT INTO #assocTable
		SELECT a.clientId,'',a.appTypeId,'',a.instance,'',a.backupSet,'',s.SubclientId,a.subclientName,s.AssociatedPolicyType  FROM APP_Application AS a WITH (NOLOCK), #SubclientAssocTbl AS s
		WHERE s.SubclientId = a.id
	END
ELSE
	 BEGIN
	   INSERT INTO #assocTable
	   SELECT a.clientId,'',a.appTypeId,'',a.instance,'',a.backupSet,'',a.id,a.subclientName,''  FROM APP_Application  AS a WITH (NOLOCK)
	   WHERE (dataArchGrpID = @spId)
	   INSERT INTO #assocTable
	   SELECT a.clientId,'',a.appTypeId,'',a.instance,'',a.backupSet,'',a.id,a.subclientName,'(LOG)'  FROM APP_Application  AS a WITH (NOLOCK)
	   WHERE (logArchGrpID = @spId) AND ( a.appTypeId IN (SELECT appTypeId FROM dbo.AppGetLogSpSupportedApptypes()))
	 END
UPDATE #assocTable
SET ClientName = a.name
FROM APP_Client a WITH (NOLOCK) WHERE ClientID = a.id
UPDATE #assocTable
SET ApptypeName = a.name
FROM APP_iDAType a WITH (NOLOCK) WHERE ApptypeId = a.type
UPDATE #assocTable
SET BackupsetName = a.name
FROM APP_BackupSetName a WITH (NOLOCK) WHERE BackupsetId = a.id
UPDATE #assocTable
SET InstanceName = a.name
FROM APP_InstanceName a WITH (NOLOCK) WHERE InstanceId = a.id
/*
 If a subclients log SP is re-associated then subclient name is appended with "(LOG)"
*/
SELECT ClientID	,ClientName	,ApptypeId,ApptypeName,InstanceId,InstanceName,BackupsetId,BackupsetName,SubclientId,SubclientName+PolicyType FROM #assocTable
ORDER BY ClientID,ApptypeId,InstanceId,BackupsetId,SubclientName
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ArchGetAssociatedSubclientsWithSP')
	delete from GxQscripts where name = 'ArchGetAssociatedSubclientsWithSP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGetAssociatedSubclientsWithSP')
	delete from GXDBVersions where aliasname = 'ArchGetAssociatedSubclientsWithSP'
GO

insert into GXDBVersions values(2, 'ArchGetAssociatedSubclientsWithSP',  '00000000000000000000', 'ArchGetAssociatedSubclientsWithSP', '00000000000000000000')
GO

