

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchGetApplicationInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchGetApplicationInfo.sp,v $ $Id: ArchGetApplicationInfo.sp,v 1.1.2.1 2019/08/22 19:47:12 anarulkar Exp $";
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE	:	"MMGetMountpathListForStore"               				|
--  |       Author	    :	prasanthm                            			|
--  | Execute the System stored procedure to fetch the physical files   	|
--  | .. for the (current) database.                    					|
--  +-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ArchGetApplicationInfo')
BEGIN
	print '>>> Drop Stored Procedure: ArchGetApplicationInfo <<<'
	drop procedure ArchGetApplicationInfo
END
IF EXISTS (select * from GxQscripts where name='ArchGetApplicationInfo')
	delete from GxQscripts where name = 'ArchGetApplicationInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGetApplicationInfo')
	delete from GXDBVersions where aliasname = 'ArchGetApplicationInfo'
GO
print '... Creating Procedure: ArchGetApplicationInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure ArchGetApplicationInfo
  @i_appId integer
AS
  DECLARE @o_clientId INTEGER
  DECLARE @o_appType INTEGER
  DECLARE @o_instanceId INTEGER
  DECLARE @o_backupSetId INTEGER
  DECLARE @o_clientName NVARCHAR(255)
  DECLARE @o_agentName VARCHAR(255)
  DECLARE @o_instanceName NVARCHAR(255)
  DECLARE @o_backupSetName NVARCHAR(255)
  DECLARE @o_subClientName NVARCHAR(255)
 SELECT CL.id, APP.appTypeId, INS.id, BKP.id, CL.displayName, IDA.displayName, INS.name, BKP.name, APP.subclientName
 FROM APP_Application APP WITH (READUNCOMMITTED)
 INNER JOIN APP_iDAType IDA WITH (READUNCOMMITTED) on APP.appTypeId = IDA.type
 INNER JOIN APP_InstanceName INS WITH (READUNCOMMITTED) on APP.instance = INS.id
 INNER JOIN APP_BackupSetName BKP WITH (READUNCOMMITTED) on APP.backupSet = BKP.id
 INNER JOIN APP_Client CL WITH (READUNCOMMITTED) on APP.clientId = CL.id
 WHERE APP.id = @i_appId
GO

IF EXISTS (select * from GxQscripts where name = 'ArchGetApplicationInfo')
	delete from GxQscripts where name = 'ArchGetApplicationInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchGetApplicationInfo')
	delete from GXDBVersions where aliasname = 'ArchGetApplicationInfo'
GO

insert into GXDBVersions values(2, 'ArchGetApplicationInfo',  '00010001000200010000', 'ArchGetApplicationInfo', '00010001000200010000')
GO

