

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchFileValidateForStubbing.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  ArchFileValidateForStubbing.sp                             */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchFileValidateForStubbing.sp,v $ $Id: ArchFileValidateForStubbing.sp,v 1.1.2.10 2020/12/01 12:58:30 srajani Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ArchFileValidateForStubbing')
BEGIN
	print '>>> Drop Stored Procedure: ArchFileValidateForStubbing <<<'
	drop procedure ArchFileValidateForStubbing
END
IF EXISTS (select * from GxQscripts where name='ArchFileValidateForStubbing')
	delete from GxQscripts where name = 'ArchFileValidateForStubbing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchFileValidateForStubbing')
	delete from GXDBVersions where aliasname = 'ArchFileValidateForStubbing'
GO
print '... Creating Procedure: ArchFileValidateForStubbing'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ArchFileValidateForStubbing
  @i_inputXml xml = ''
AS
DECLARE @o_xmlText XML
  DECLARE @o_outXml xml;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET @o_xmlText = '<Indexing_ArchFileValidateForStubbing/>'
IF OBJECT_ID('tempdb..#tmpArchFileList') IS NOT NULL
	DROP TABLE #tmpArchFileList
CREATE TABLE #tmpArchFileList (archFileId int, commcellId int, commcellNumber int, appId int, cTime int, synthFullJobId int, synthFullJobCCId int, flags int)
INSERT INTO #tmpArchFileList
SELECT afs.t.value('@archFileId', 'int'), 0, afs.t.value('@commcellNumber', 'int'), 0, 0, 0, 0, afs.t.value('@flags', 'int') flags
FROM @i_inputXml.nodes('//Indexing_ArchFileValidateForStubbing/archFiles') as afs(t)
UPDATE T
SET commcellId = ACC.id
FROM APP_CommCell ACC WITH(NOLOCK) INNER JOIN #tmpArchFileList T ON ACC.number = T.commcellNumber
UPDATE T SET appId = AF.appId, cTime = AF.cTime, T.flags = CASE WHEN AF.isValid <> 1 OR NOT EXISTS(SELECT 1 FROM archFileCopy AFC WITH(NOLOCK) WHERE AFC.archFileId = T.archFileId AND AFC.isValid = 1 AND AFC.flags & 256 = 0 AND AFC.commcellId = T.commcellId) THEN T.flags | 8 ELSE T.flags END
FROM #tmpArchFileList T INNER JOIN ArchFile AF WITH(NOLOCK) ON T.archFileId = AF.id AND T.commcellId = AF.commcellId
DECLARE @appId int
DECLARE AppIdCursor CURSOR FOR
SELECT DISTINCT appId FROM #tmpArchFileList
OPEN AppIdCursor
FETCH NEXT FROM AppIdCursor INTO @appId
WHILE(@@FETCH_STATUS = 0)
BEGIN
	DECLARE @i_GetDRTimeReq xml
	DECLARE @o_GetDRTimeResp xml
	DECLARE @l_DRStartTime int
	SET @l_DRStartTime = 0
	DECLARE @l_eventMessageId int
	SET @l_eventMessageId = 0
	IF OBJECT_ID('tempdb..#AppGetLastSuccessfulDRBackupResp') IS NOT NULL
		DROP TABLE #AppGetLastSuccessfulDRBackupResp
	CREATE TABLE #AppGetLastSuccessfulDRBackupResp(o_GetDRTimeResp xml)
	SET @i_GetDRTimeReq = '<App_GetLastSuccessfulDRBackupReq isIndexing = "1">' + '<subclient subclientId = "' + CAST(@appId AS VARCHAR(10)) + '"/></App_GetLastSuccessfulDRBackupReq>'
	EXEC AppGetLastSuccessfulDRBackup @i_GetDRTimeReq
	SELECT @o_GetDRTimeResp = o_GetDRTimeResp FROM #AppGetLastSuccessfulDRBackupResp
	IF OBJECT_ID('tempdb..#AppGetLastSuccessfulDRBackupResp') IS NOT NULL
		DROP TABLE #AppGetLastSuccessfulDRBackupResp
	--Do not delay stub during first week
	SELECT @l_eventMessageId = t.value('@eventMessageId', 'INT')
	FROM @o_GetDRTimeResp.nodes('/App_GetLastSuccessfulDRBackupResp/delayedStubInfo') resp(t)
	SELECT @l_DRStartTime = t.value('@jobStartTime', 'INT')
	FROM @o_GetDRTimeResp.nodes('/App_GetLastSuccessfulDRBackupResp') resp(t)
UPDATE #tmpArchFileList SET flags = flags | 1
	WHERE appId = @appId AND cTime > @l_DRStartTime AND @l_DRStartTime > 0
	FETCH NEXT FROM AppIdCursor INTO @appId
END
CLOSE AppIdCursor
DEALLOCATE AppIdCursor
IF OBJECT_ID('tempdb..#appIdCycleNumMap') IS NOT NULL
	DROP TABLE #appIdCycleNumMap
CREATE TABLE #appIdCycleNumMap(appId int, latestCycleNum int, primary key(appId))
INSERT INTO #appIdCycleNumMap
SELECT DISTINCT appId, 0
FROM #tmpArchFileList
UPDATE T SET latestCycleNum = CAST(AppProp.attrVal AS INT)
FROM #appIdCycleNumMap T INNER JOIN App_SubClientProp AppProp WITH(NOLOCK) ON T.appId = AppProp.componentNameId
WHERE AppProp.attrName = N'sys:full cycle num' AND AppProp.modified = 0
UPDATE T1 SET flags = T1.flags | 4
FROM #tmpArchFileList T1 INNER JOIN ArchFile AF WITH(NOLOCK) ON T1.archFileId = AF.id AND T1.commcellId = AF.commcellId
INNER JOIN JMBkpStats JBKP WITH(NOLOCK) ON AF.jobId = JBKP.jobId AND AF.commcellId = JBKP.commcellId
INNER JOIN #appIdCycleNumMap T2 ON T1.appId = T2.appId
WHERE JBKP.fullCycleNum < T2.latestCycleNum
IF OBJECT_ID('tempdb..#appIdCycleNumMap') IS NOT NULL
	DROP TABLE #appIdCycleNumMap
UPDATE TAF
SET synthFullJobId = AFSR.SpaceReclamationJobId, synthFullJobCCId = AFSR.SpaceReclamationJobCCId
FROM #tmpArchFileList TAF INNER JOIN ArchFileSpaceReclamation AFSR WITH(NOLOCK) ON TAF.archFileId = AFSR.archFileId AND TAF.commcellId = AFSR.ArchFileCCId
UPDATE TAF
SET synthFullJobId = JBKP2.jobId, synthFullJobCCId = JBKP2.commcellId
FROM #tmpArchFileList TAF INNER JOIN ArchFile AF WITH(NOLOCK) ON TAF.archFileId = AF.id AND TAF.commcellId = AF.commcellId
INNER JOIN JMBkpStats JBKP1 WITH(NOLOCK) ON AF.jobId = JBKP1.jobId AND AF.commcellId = JBKP1.commcellId
INNER JOIN JMBkpStats JBKP2 WITH(NOLOCK) ON JBKP1.appId = JBKP2.appId AND JBKP2.fullCycleNum = (JBKP1.fullCycleNum + 1) AND JBKP2.bkpLevel = 64 --SYNTHETIC_FULL = 0x40
WHERE TAF.synthFullJobId = 0 /* TODO - Check if subclient is in regular synth full mode*/
IF OBJECT_ID('tempdb..#tmpArchFileCopyMap') IS NOT NULL
	DROP TABLE #tmpArchFileCopyMap
CREATE TABLE #tmpArchFileCopyMap (archFileId int, commcellId int, archCopyId int, primary key(archFileId, commcellId, archCopyId) with(ignore_dup_key = ON))
--Find distinct copies for this archive file
INSERT INTO #tmpArchFileCopyMap
SELECT TAF.archFileId, TAF.commcellId, AFC.archCopyId
FROM #tmpArchFileList TAF
INNER JOIN ArchFileCopy AFC WITH(NOLOCK) ON TAF.archFileId = AFC.archFileId AND TAF.commcellId = AFC.commcellId
WHERE AFC.flags & 256 = 0 AND AFC.isValid = 1 AND TAF.flags = 0
--Find distinct copies of synth full job that synthesized this archive file
INSERT INTO #tmpArchFileCopyMap
SELECT TAF1.archFileId, TAF1.commcellId, T.archGrpCopyId
FROM #tmpArchFileList TAF1 INNER JOIN
(
SELECT JDS.jobId, JDS.commcellId, JDS.archGrpCopyId
FROM #tmpArchFileList TAF
INNER JOIN JMJobDataStats JDS WITH(NOLOCK) ON TAF.synthFullJobId = JDS.jobId AND TAF.synthFullJobCCId = JDS.commcellId
WHERE JDS.disabled & 256 = 0 AND TAF.flags = 0
GROUP BY JDS.jobId, JDS.commcellId, JDS.archGrpCopyId
HAVING MAX(status) = 100 AND MIN(status) = 100
) T ON TAF1.synthFullJobId = T.jobId AND TAF1.synthFullJobCCId = T.commcellId
--If we have multiple copies of the archive file be it for the same archive file or the synthesized one redundancy is achieved
DELETE TAF1
FROM #tmpArchFileList TAF1 INNER JOIN
(
SELECT T1.archFileId, T1.commcellId
FROM #tmpArchFileList T1 INNER JOIN #tmpArchFileCopyMap T2 ON T1.archFileId = T2.archFileId AND T1.commcellId = T2.commcellId
GROUP BY T1.archFileId, T1.commcellId
HAVING COUNT(distinct T2.archCopyId) > 1
) TAF2
ON TAF1.archFileId = TAF2.archFileId AND TAF1.commcellId = TAF2.commcellId
--AFs in glusterFS mount path or cloud mount path can be stubbed
IF EXISTS(SELECT 1 FROM #tmpArchFileList WHERE flags = 0) AND EXISTS(SELECT 1 FROM MMMountPath WITH(NOLOCK) WHERE Attribute & 64 /*MNTPTH_ATTRIB_GFS_VOL_CONFIGURED*/ > 0 OR mountPathTypeId = 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/)
	DELETE T
	FROM #tmpArchFileList T INNER JOIN ArchFileCopy AFC WITH(NOLOCK) ON T.ArchFileId = AFC.archFileId AND T.commcellId = AFC.commcellId
	INNER JOIN ArchChunkMapping ACM WITH(NOLOCK) ON T.ArchFileId = ACM.archFileId AND T.commcellId = ACM.commcellId AND AFC.archCopyId = ACM.archCopyId
	INNER JOIN ArchChunk AC WITH(NOLOCK) ON ACM.archChunkId = AC.id AND ACM.chunkCommcellId = AC.commcellId
	INNER JOIN MMVolume Vol WITH(NOLOCK) ON AC.VolumeId = Vol.VolumeId
	INNER JOIN MMMountPath MP WITH(NOLOCK) ON Vol.MediaSideId = MP.MediaSideId
WHERE AFC.flags & 256 = 0
AND (MP.Attribute & 64 /*MNTPTH_ATTRIB_GFS_VOL_CONFIGURED*/ > 0 OR MP.mountPathTypeId = 7/*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/)
	AND T.flags = 0
UPDATE #tmpArchFileList SET flags = flags | 2
WHERE flags = 0
SET @o_xmlText = ISNULL((SELECT archFileId as '@archFileId', commcellNumber as '@commcellNumber', flags as '@flags'
FROM #tmpArchFileList
FOR XML PATH('archFiles'), ROOT('Indexing_ArchFileValidateForStubbing')), '<Indexing_ArchFileValidateForStubbing/>')
IF OBJECT_ID('tempdb..#ArchFileValidateForStubbingResp') IS NOT NULL
BEGIN
	INSERT #ArchFileValidateForStubbingResp
	SELECT @o_xmlText
END
ELSE
	SELECT @o_xmlText
GO

IF EXISTS (select * from GxQscripts where name = 'ArchFileValidateForStubbing')
	delete from GxQscripts where name = 'ArchFileValidateForStubbing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchFileValidateForStubbing')
	delete from GXDBVersions where aliasname = 'ArchFileValidateForStubbing'
GO

insert into GXDBVersions values(2, 'ArchFileValidateForStubbing',  '00010001000200100000', 'ArchFileValidateForStubbing', '00010001000200100000')
GO

