

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchFileValidate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- 	+-----------------------------------------------------------------------+
--	| 	Cursor: "archFileValidate"										|
--	|																		|
--  	|	Initial Version: 	9/25/2013										|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archFileValidate')
BEGIN
	print '>>> Drop Stored Procedure: archFileValidate <<<'
	drop procedure archFileValidate
END
IF EXISTS (select * from GxQscripts where name='archFileValidate')
	delete from GxQscripts where name = 'archFileValidate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileValidate')
	delete from GXDBVersions where aliasname = 'archFileValidate'
GO
print '... Creating Procedure: archFileValidate'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archFileValidate
  @i_SIDBStoreId integer,
  @i_reserve integer,
  @archFileStr varchar(max)
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @AFId integer
  DECLARE @isValid integer
  DECLARE @reserve integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
IF object_id('tempdb.dbo.#ArchFileIdList') IS NOT NULL DROP TABLE #ArchFileIdList
CREATE TABLE #ArchFileIdList (aFileId int, isAFValid int)
exec('INSERT INTO #ArchFileIdList ' + @archFileStr)
DECLARE @SIDBStoreId INT
SET @SIDBStoreId = @i_SIDBStoreId
DECLARE @jobStartTime INT
SET @jobStartTime = 0
--If this is for reconstruction then find the jobStartTime of the store from JM table.
 SELECT  @jobStartTime = ISNULL(jobStartTime, 0)
 FROM    JMJobInfo
 WHERE   commCellId = 2 /* Local Commcell ID*/ AND opType = 80  /* DEDUPDBSYNC */
 AND dbo.GetJobOption(jobId, 1777365717/* DEDUPDBSYNCOPTION__SIDBSTORE_ID */) = @SIDBStoreId
 /*
UPDATE #ArchFileIdList
SET isAFValid = (CASE WHEN EXISTS (SELECT * FROM archFileCopyDedup WHERE SIDBStoreId = @SIDBStoreId AND archFileId = #ArchFileIdList.aFileId)
				THEN 1
				/*This is the condition where some AFs are pruned after recon job started. So they do no exists in AFCD table and DDB still has them*/
				WHEN EXISTS (SELECT * FROM MMDeletedAF WHERE SIDBStoreId = @SIDBStoreId and archFileId = #ArchFileIdList.aFileId and DeletedTime >= @jobStartTime)
				THEN 1
				ELSE 0
				END)
*/
UPDATE #ArchFileIdList
SET isAFValid = 1
FROM #ArchFileIdList T
	LEFT OUTER JOIN archFileCopyDedup AFCD WITH (NOLOCK) ON T.aFileId = AFCD.archFileId
WHERE AFCD.SIDBStoreId = @SIDBStoreId
AND AFCD.archFileId IS NOT NULL
UPDATE #ArchFileIdList
SET isAFValid = 1
FROM #ArchFileIdList T
	LEFT OUTER JOIN archFileCopy AFC WITH (NOLOCK) ON T.aFileId = AFC.archFileId AND AFC.archCopyId IN (SELECT copyId FROM archCopySIDBStore WITH (NOLOCK) WHERE SIDBStoreId = @SIDBStoreId)
WHERE AFC.archFileId IS NOT NULL
AND T.isAFValid = 0
UPDATE #ArchFileIdList
SET isAFValid = 1
FROM #ArchFileIdList T
	LEFT OUTER JOIN MMDeletedAF DAF WITH (NOLOCK) ON DAF.SIDBStoreId = @SIDBStoreId AND T.aFileId = DAF.archFileId
WHERE T.isAFValid = 0
-- Those which are not yet marked picked are still considered valid.
-- Those marked picked should have got replayed during prune Phase of recon. So they shouldn't be existing on DDB.
-- When this becomes a periodic check validity based on picked flag is not sufficient. Since in multiple partitions
-- 1 partition may be performing regular pruning and hence records may be getting marked in DAF while other has not replayed yet.
AND ((((DAF.Status & 2 = 0)
/* The below check: if not exists in MMTempDeletedAF is not true any more since we rely on validation pruning and do not populate MMTDAF.
			OR NOT EXISTS (SELECT * FROM MMTempDeletedAF TDAF WITH (NOLOCK)
							WHERE TDAF.archFileid = DAF.archFileId
							AND TDAF.SIDBStoreId = DAF.SIDBStoreId
							AND TDAF.commCellId = DAF.commCellId
							AND TDAF.volumeId = DAF.volumeId
							AND TDAF.archChunkId = DAF.archChunkId
							AND TDAF.chunkCommCellId = DAF.chunkCommCellId
							AND TDAF.CreatedTime > @jobStartTime) */ ) AND (@jobStartTime > 0))
		OR (@jobStartTime = 0))
AND DAF.archFileId IS NOT NULL
SELECT aFileId, isAFValid, 0 FROM #ArchFileIdList
IF object_id('tempdb.dbo.#ArchFileIdList') IS NOT NULL DROP TABLE #ArchFileIdList

IF EXISTS (select * from GxQscripts where name = 'ArchFileValidate')
	delete from GxQscripts where name = 'ArchFileValidate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchFileValidate')
	delete from GXDBVersions where aliasname = 'ArchFileValidate'
GO

insert into GXDBVersions values(2, 'ArchFileValidate',  '00000000000000000000', 'ArchFileValidate', '00000000000000000000')
GO

