

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchFileOpenEventConfig.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchFileOpenEventConfig.sp,v $ $Id: ArchFileOpenEventConfig.sp,v 1.2.88.4 2020/04/21 18:45:06 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archFileOpenEventConfig')
BEGIN
	print '>>> Drop Stored Procedure: archFileOpenEventConfig <<<'
	drop procedure archFileOpenEventConfig
END
IF EXISTS (select * from GxQscripts where name='archFileOpenEventConfig')
	delete from GxQscripts where name = 'archFileOpenEventConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archFileOpenEventConfig')
	delete from GXDBVersions where aliasname = 'archFileOpenEventConfig'
GO
print '... Creating Procedure: archFileOpenEventConfig'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archFileOpenEventConfig
  @i_aFileId integer,
  @i_commCellId integer,
  @i_copyId integer,
  @i_jobId integer,
  @i_eventId integer
AS
  DECLARE @o_addEvent INTEGER
  DECLARE @o_backupJobId INTEGER
  DECLARE @o_backupStartTime INTEGER
  DECLARE @o_archGroupName NVARCHAR(144)
  DECLARE @o_archGroupCopyName NVARCHAR(64)
  DECLARE @o_asciiTime VARCHAR(128)
  DECLARE @o_subclientName NVARCHAR(255)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET @o_addEvent = 0
SET @o_backupJobId = 0
SET @o_backupStartTime = 0
SET @o_archGroupName = N''
SET @o_archGroupCopyName = N''
SET @o_asciiTime = ''
SET @o_subclientName = N''
DECLARE @enabled NVARCHAR(MAX)
DECLARE @archGrpId INTEGER = 0
DECLARE @appId INTEGER = 0
DECLARE @inserted INTEGER = 0
SELECT @o_backupJobId = jobId, @archGrpId = archGroupId, @appId = AppId FROM ARCHFILE WITH (READUNCOMMITTED) WHERE id = @i_aFileId AND commcellid = @i_commCellId
SELECT @enabled = value FROM GXGlobalParam WITH (READUNCOMMITTED) WHERE NAME = 'EnableRestoreDataAgeTracking'
INSERT INTO JMJobRestoreHistoryInfo
SELECT	@i_jobId, 2, JBS.JobId, JBS.CommCellId, @i_copyId, JBS.servStartDate, @appId, dbo.GetUnixTime(GetUTCDate())
FROM	JMBkpStats JBS WITH (READUNCOMMITTED)
WHERE	JBS.JobId = @o_backupJobId
		AND JBS.commCellId = @i_commCellId
		AND NOT EXISTS (SELECT	TOP 1 JobId
						FROM	JMJobRestoreHistoryInfo H
						WHERE	H.JobId = @i_jobId
								AND H.commCellId = 2
								AND H.BackupjobId = @o_backupJobId
								AND H.BackupCommCellId = @i_commCellId
								AND H.ArchCopyId = @i_copyId)
SET @inserted = @@ROWCOUNT
IF (@enabled IS NULL OR @enabled <= 0)
	GOTO FINISH
IF (@inserted = 0)
	GOTO FINISH
SET @o_addEvent = 1
SELECT @o_backupStartTime = servStartDate from JMBkpStats WITH (READUNCOMMITTED) WHERE JobId = @o_backupJobId and commCellId = @i_commCellId
SELECT @o_archGroupName = name FROM archGroup WITH (READUNCOMMITTED) WHERE ID = @archGrpId
SELECT @o_archGroupCopyName = name FROM archGroupCopy WITH (READUNCOMMITTED) WHERE ID = @i_copyId
SELECT @o_subclientName = subclientName FROM APP_Application WITH (READUNCOMMITTED) WHERE ID = @appId
SET @o_asciiTime = dbo.UTCToClientLocalTime(dbo.GetDateTime(@o_backupStartTime), 2)
FINISH:
SELECT @o_addEvent, @o_backupJobId, @o_backupStartTime, @o_archGroupName, @o_archGroupCopyName, @o_asciiTime, @o_subclientName
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'ArchFileOpenEventConfig')
	delete from GxQscripts where name = 'ArchFileOpenEventConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchFileOpenEventConfig')
	delete from GXDBVersions where aliasname = 'ArchFileOpenEventConfig'
GO

insert into GXDBVersions values(2, 'ArchFileOpenEventConfig',  '00010002008800040000', 'ArchFileOpenEventConfig', '00010002008800040000')
GO

