

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchFileByTimeWrapper.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  ArchFileByTimeWrapper.sp                                   */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchFileByTimeWrapper.sp,v $ $Id: ArchFileByTimeWrapper.sp,v 1.1.2.1 2018/03/08 18:01:24 aduraisamy Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ArchFileByTimeWrapper <<<'

IF EXISTS (select * from sysobjects where name='ArchFileByTimeWrapper')
	drop procedure ArchFileByTimeWrapper
IF EXISTS (select * from GxQscripts where name='ArchFileByTimeWrapper')
	delete from GxQscripts where name = 'ArchFileByTimeWrapper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchFileByTimeWrapper')
	delete from GXDBVersions where aliasname = 'ArchFileByTimeWrapper'
GO
print '... Creating Procedure: ArchFileByTimeWrapper'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ArchFileByTimeWrapper
  @i_inputXml xml OUTPUT
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @l_appId INT = 0
DECLARE @l_backupSetId INT = 0
DECLARE @l_fileType INT = 0
DECLARE @l_cutTime BIGINT = 0
DECLARE	@l_afterOrBefore INT = 0
DECLARE @l_copyPrecedence INT = 0
DECLARE @l_flags BIGINT = 0
SELECT @l_appId = ISNULL(ref.value('@appId', 'int'), 0), @l_backupSetId = ISNULL(ref.value('@backupSetId', 'int'),0), @l_fileType = ISNULL(ref.value('@fileType', 'int'),0),
					@l_cutTime = ISNULL(ref.value('@cutTime', 'int'),0), @l_afterOrBefore = ISNULL(ref.value('@afterOrBefore', 'int'), 0),
					@l_copyPrecedence = ISNULL(ref.value('@copyPrecedence', 'int'), 0), @l_flags = ISNULL(ref.value('@flags', 'int'),0)
                                    FROM   @i_inputXml.nodes('MediaManager_ArchFileByTimeReq') R ( ref )
DECLARE @l_completedJobOnly INT = 0
DECLARE @l_includeAgedData INT = 0
DECLARE @l_includeReplacedIndex INT = 0
DECLARE @l_countBCDForIndex INT = 0
SELECT @l_completedJobOnly = CASE WHEN @l_flags & 1 /*CVA_COMPLETED_JOB_ONLY_FLAG*/ > 0 THEN 1 ELSE 0 END
IF (@l_flags & 8 /*CVA_SET_INCLUDE_AGED_DATA_FLAG*/ > 0)
BEGIN
	SELECT @l_includeAgedData = CASE WHEN @l_flags & 16 /*CVA_INCLUDE_AGED_DATA_FLAG*/ > 0 THEN 1 ELSE 0 END
END
ELSE
BEGIN
	SELECT @l_includeAgedData = ISNULL(CAST(value AS INT), 0) FROM GxGlobalParam WITH(NOLOCK) WHERE name = 'ShowAgedDataForBrowseAndRecovery'
END
SELECT @l_includeReplacedIndex = CASE WHEN @l_flags & 32 /*CVA_INCLUDE_REPLACED_INDEX_FLAG*/ > 0 THEN 1 ELSE 0 END
SELECT @l_countBCDForIndex = CASE WHEN @l_flags & 256 /*CVA_COUNT_BCD_FOR_INDEX_FLAG*/ > 0 THEN 1 ELSE 0 END
DECLARE @resultSet table(archFileId int, commcellId int, archGroupId int, copyId int, fileType int, cTime bigint, jobId int, backupLevel int, physicalSize bigint, logicalSize bigint)
INSERT INTO @resultSet
EXEC archFileByTime @l_backupSetId, @l_appId, @l_fileType, @l_cutTime, @l_afterOrBefore, @l_completedJobOnly, @l_copyPrecedence, @l_includeAgedData, @l_includeReplacedIndex, @l_countBCDForIndex
SET @i_inputXml = (SELECT 0 AS 'retStatus',
(
	SELECT *, 0 AS 'reserved' FROM @resultSet
	FOR XML PATH('archFileList'), TYPE
)
FOR XML PATH('MediaManager_ArchFileByTimeResp'), TYPE)
GO

IF EXISTS (select * from GxQscripts where name = 'ArchFileByTimeWrapper')
	delete from GxQscripts where name = 'ArchFileByTimeWrapper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchFileByTimeWrapper')
	delete from GXDBVersions where aliasname = 'ArchFileByTimeWrapper'
GO

insert into GXDBVersions values(2, 'ArchFileByTimeWrapper',  '00010001000200010000', 'ArchFileByTimeWrapper', '00010001000200010000')
GO

