

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchDoesSPHaveAnyValidJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2010  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchDoesSPHaveAnyValidJobs.sp,v $ $Id: ArchDoesSPHaveAnyValidJobs.sp,v 1.1.280.1 2018/03/22 00:55:59 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "ArchDoesSPHaveAnyValidJobs"				|
--	|									|
--	| Stored procedure to check if the given SP has any valid data.|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ArchDoesSPHaveAnyValidJobs <<<'

IF EXISTS (select * from sysobjects where name='ArchDoesSPHaveAnyValidJobs')
	drop procedure ArchDoesSPHaveAnyValidJobs
IF EXISTS (select * from GxQscripts where name='ArchDoesSPHaveAnyValidJobs')
	delete from GxQscripts where name = 'ArchDoesSPHaveAnyValidJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchDoesSPHaveAnyValidJobs')
	delete from GXDBVersions where aliasname = 'ArchDoesSPHaveAnyValidJobs'
GO
print '... Creating Procedure: ArchDoesSPHaveAnyValidJobs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure ArchDoesSPHaveAnyValidJobs
  @i_archGroupId integer,
  @i_copyId integer,
  @i_reserveParam integer
AS
  DECLARE @o_hasAnyJobs integer
  DECLARE @o_reserveOutput integer
	IF EXISTS
	(
		SELECT jobId
		FROM JMJobDataStats WITH (READUNCOMMITTED)
		WHERE archGrpId = @i_archGroupId and status = 100 and (disabled & 256) = 0
		AND ( (@i_copyId > 0 AND archGrpCopyId = @i_copyId) OR (@i_copyId <= 0) )
	)
	BEGIN
		GOTO HAS_DATA
	END
	-- Fingers crossed
	GOTO HAS_NO_DATA
	HAS_DATA:
		SELECT 1, 0
		GOTO PROC_EXIT
	HAS_NO_DATA:
		SELECT 0, 0
		GOTO PROC_EXIT
PROC_EXIT:
GO

IF EXISTS (select * from GxQscripts where name = 'ArchDoesSPHaveAnyValidJobs')
	delete from GxQscripts where name = 'ArchDoesSPHaveAnyValidJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchDoesSPHaveAnyValidJobs')
	delete from GXDBVersions where aliasname = 'ArchDoesSPHaveAnyValidJobs'
GO

insert into GXDBVersions values(2, 'ArchDoesSPHaveAnyValidJobs',  '00010001028000010000', 'ArchDoesSPHaveAnyValidJobs', '00010001028000010000')
GO

