

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchDestinationCopyList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchDestinationCopyList.sp,v $ $Id: ArchDestinationCopyList.sp,v 1.8.210.4 2020/07/15 21:08:28 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ArchDestinationCopyList')
BEGIN
	print '>>> Drop Stored Procedure: ArchDestinationCopyList <<<'
	drop procedure ArchDestinationCopyList
END
IF EXISTS (select * from GxQscripts where name='ArchDestinationCopyList')
	delete from GxQscripts where name = 'ArchDestinationCopyList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchDestinationCopyList')
	delete from GXDBVersions where aliasname = 'ArchDestinationCopyList'
GO
print '... Creating Procedure: ArchDestinationCopyList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure ArchDestinationCopyList
  @i_copyId integer
AS
  DECLARE @o_copyId integer;
  DECLARE @o_sourceCopyId integer;
  DECLARE @o_defaultCopyId integer;
  DECLARE @o_archGroupId integer;
  DECLARE @o_copyFlags integer;
  DECLARE @o_dedupeFlags integer;
  DECLARE @o_maxMultiplex integer;
  DECLARE @o_isSnapCopy integer;
  DECLARE @o_isMirrorCopy integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @l_archGroupId INT
DECLARE @l_defaultCopyId INT
DECLARE @l_isSnapCopy INT
DECLARE @tblDestCopyForSource TABLE (copyId INT, sourceCopyId INT, defaultCopyId INT, archGroupId INT, flags INT, dedupeFlags INT, maxMultiplex INT, isSnapCopy INT, isMirrorCopy INT)
SELECT	@l_archGroupId = a.id, @l_isSnapCopy = isSnapCopy,
		@l_defaultCopyId = CASE b.isSnapCopy WHEN 0 THEN a.defaultCopy ELSE a.defaultSnapCopy END
FROM	archGroup a WITH (NOLOCK), archGroupCopy b WITH (NOLOCK)
WHERE	a.id = b.archGroupId
AND		b.id = @i_copyId;
IF	@i_copyId = @l_defaultCopyId
	INSERT INTO @tblDestCopyForSource
	SELECT	id, case when id <> @i_copyId AND sourceCopyId = 0 then @l_defaultCopyId else sourceCopyId end,
			@l_defaultCopyId, @l_archGroupId, flags, dedupeFlags, maxMultiplex, isSnapCopy, isMirrorCopy
	FROM	archGroupCopy WITH (NOLOCK)
WHERE	archGroupId = @l_archGroupId AND type <> 5 AND isSnapCopy = @l_isSnapCopy
ELSE
BEGIN
	WITH SourceCopy_CTE AS
	(
		SELECT	id, sourceCopyId, flags, dedupeFlags, maxMultiplex, isSnapCopy, isMirrorCopy
		FROM	archGroupCopy WITH (NOLOCK)
		WHERE	id = @i_copyId
		UNION ALL
		SELECT	C.id, C.sourceCopyId, C.flags, C.dedupeFlags, C.maxMultiplex, C.isSnapCopy, C.isMirrorCopy
		FROM	archGroupCopy C WITH (NOLOCK) INNER JOIN SourceCopy_CTE S
ON	S.id = C.sourceCopyId AND C.type <> 5 AND C.isSnapCopy = @l_isSnapCopy
	)
	INSERT INTO @tblDestCopyForSource
	SELECT	id, CASE sourceCopyId WHEN 0 THEN @l_defaultCopyId ELSE sourceCopyId END,
			@l_defaultCopyId, @l_archGroupId, flags, dedupeFlags, maxMultiplex, isSnapCopy, isMirrorCopy
	FROM	SourceCopy_CTE
END
IF OBJECT_ID('tempdb..#archDestinationCopyListResultTable') IS NOT NULL
BEGIN
	INSERT INTO #archDestinationCopyListResultTable
	SELECT	*
	FROM	@tblDestCopyForSource
END
ELSE
BEGIN
	SELECT	*
	FROM	@tblDestCopyForSource
END
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'ArchDestinationCopyList')
	delete from GxQscripts where name = 'ArchDestinationCopyList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchDestinationCopyList')
	delete from GXDBVersions where aliasname = 'ArchDestinationCopyList'
GO

insert into GXDBVersions values(2, 'ArchDestinationCopyList',  '00010008021000040000', 'ArchDestinationCopyList', '00010008021000040000')
GO

