

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchDeleteDDBBackupJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchDeleteDDBBackupJobs.sp,v $ $Id: ArchDeleteDDBBackupJobs.sp,v 1.3.50.5 2020/12/04 01:36:38 gharidas Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ArchDeleteDDBBackupJobs')
BEGIN
	print '>>> Drop Stored Procedure: ArchDeleteDDBBackupJobs <<<'
	drop procedure ArchDeleteDDBBackupJobs
END
IF EXISTS (select * from GxQscripts where name='ArchDeleteDDBBackupJobs')
	delete from GxQscripts where name = 'ArchDeleteDDBBackupJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchDeleteDDBBackupJobs')
	delete from GXDBVersions where aliasname = 'ArchDeleteDDBBackupJobs'
GO
print '... Creating Procedure: ArchDeleteDDBBackupJobs'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ArchDeleteDDBBackupJobs
  @ExemptDDBOnCS INTEGER,
  @MarkDDBBackupsBad INTEGER
AS
  DECLARE @retVal INTEGER;
  DECLARE @numJobAged INTEGER;
BEGIN TRANSACTION
IF @MarkDDBBackupsBad = 1
BEGIN
	UPDATE IdxSIDBSubStore
SET ExtendedFlags = ExtendedFlags | 8
	WHERE LastSnapJobId > 0
	UPDATE IdxSIDBSubStoreBackupInfo
SET Flags = Flags | 1
	WHERE LastSnapJobId > 0
END
ELSE
BEGIN
	--	Just disassociating the DDB Backup jobs to the store should be enough. DA will pick these jobs for ageging automatically in next iteration.
	UPDATE IdxSIDBSubStore
	SET LastSnapJobId = 0,
	LastSnapTime = 0,
	SIDBSnapPath = '',
	DDBBackupCSGUID = '',
	StartLogSequence = '',
	EndLogSequence = '',
	SnapLogSequence = ''
	WHERE SIDBStoreId > 0
		-- For DDBs hosted on the CS instance, along with the most recent DDB backup, we maintain one more DDB backup -
		-- The DDB backup just before the most recent DR backup (ie the LastSnapJobId value as this proc is executing).
		-- This is to allow regular recon when the most recent DR backup is restored.
		-- When ArchDeleteDDBBackupJobs gets called post DR restore, skip
		-- reseting last snap jobid info so that regular recon can happen.
		AND (ClientId > 2 OR (ClientId = 2 AND @ExemptDDBOnCS = 0))
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	DELETE FROM IdxSIDBSubStoreBackupInfo
END
IF @@ERROR > 0 GOTO CX_ERROR_EXIT
CX_EXIT:
COMMIT TRANSACTION
SELECT 0, 0
RETURN;
CX_ERROR_EXIT:
ROLLBACK TRANSACTION
SELECT -1, 0
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'ArchDeleteDDBBackupJobs')
	delete from GxQscripts where name = 'ArchDeleteDDBBackupJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchDeleteDDBBackupJobs')
	delete from GXDBVersions where aliasname = 'ArchDeleteDDBBackupJobs'
GO

insert into GXDBVersions values(2, 'ArchDeleteDDBBackupJobs',  '00010003005000050000', 'ArchDeleteDDBBackupJobs', '00010003005000050000')
GO

