

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchDeleteBackupByMedia.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchDeleteBackupByMedia.sp,v $ $Id: ArchDeleteBackupByMedia.sp,v 1.76.34.8 2019/12/30 17:36:35 prasanthm Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ArchDeleteBackupByMedia')
BEGIN
	print '>>> Drop Stored Procedure: ArchDeleteBackupByMedia <<<'
	drop procedure ArchDeleteBackupByMedia
END
IF EXISTS (select * from GxQscripts where name='ArchDeleteBackupByMedia')
	delete from GxQscripts where name = 'ArchDeleteBackupByMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchDeleteBackupByMedia')
	delete from GXDBVersions where aliasname = 'ArchDeleteBackupByMedia'
GO
print '... Creating Procedure: ArchDeleteBackupByMedia'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure ArchDeleteBackupByMedia
  @i_mediaId integer,
  @i_seconds integer,
  @i_cleanDB integer
AS
  DECLARE @o_jobId integer
  DECLARE @o_appId integer
  DECLARE @o_appTypeId integer
  DECLARE @o_backupSetId integer
  DECLARE @o_forceNextBkpFull integer
DECLARE @l_agedByFlag integer
DECLARE @cleanDB integer
DECLARE @retVal integer
DECLARE @l_copyId integer
DECLARE @l_notAged integer
DECLARE @l_isMagnetic integer
DECLARE @l_now integer
DECLARE @l_datetime datetime
DECLARE	@magneticBytes bigint
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
IF @i_seconds > 0
SET @l_agedByFlag = 8192
ELSE
SET @l_agedByFlag = 4096
SET	@cleanDB = @i_cleanDB
SET @l_copyId = 0
SET @l_notAged = 0
SET @l_isMagnetic = 0
SET @l_datetime = GetUTCDate()
SET @l_now = dbo.GetUnixTime(@l_datetime)
SET @retVal = 0
CREATE TABLE #ToBeAgedAFC (
	archFileId INT, commCellId INT, archCopyId INT,
	PRIMARY KEY (archFileId, commCellId, archCopyId))
BEGIN TRY
	--********************** Create table variables **********************************/
	DECLARE @tblVol	TABLE (volumeId INT, recordingFormatId INT)
	DECLARE @tblAC	TABLE (
		id bigint, commCellId INT, createTime INT, flags INT,
		PRIMARY KEY (id, commCellId))
	DECLARE @tblBCDIndexAF TABLE(
			jobId int, commCellId int, fileType int, copyId int, flags int
			primary key (jobId, commCellId, fileType, copyId) )
	DECLARE @tblJobsWithBCDIndex TABLE(
			jobId int, commCellId int, fileType int, copyId int, flags int
			primary key (jobId, commCellId, fileType, copyId) )
	INSERT	INTO @tblVol
	SELECT	VolumeId, RecordingFormatId FROM MMVolume WITH (NOLOCK)
	WHERE	MediaId = @i_mediaId
IF EXISTS (SELECT * FROM @tblVol WHERE recordingFormatId = 10001)
	   SET @l_isMagnetic = 1
	INSERT	INTO @tblAC
	SELECT	A.id, A.commCellId, A.createTime, A.flags
	FROM	archChunk A WITH (NOLOCK), @tblVol B
	WHERE	A.volumeId = B.volumeId
	IF NOT EXISTS (SELECT * FROM @tblAC)
		GOTO CX_EXIT
	ELSE
	IF @i_seconds > 0
	BEGIN
		-- for overwriting a media if all chunks are older than @i_seconds
IF EXISTS (SELECT * FROM @tblAC WHERE createTime > @i_seconds AND (flags & 256) = 0)
		BEGIN
			SET @l_notAged = 1
			GOTO CX_EXIT
		END
	END
	-- No tombstoning for magnetic media, always deleting aged data.
	-- Used only for deleting content of a mount path!
	IF @l_isMagnetic = 1
	   SET @cleanDB = 1
	--********************** Create table variables **********************************/
	DECLARE @tblJobCopy TABLE (
		jobId INT, commCellId INT, fileType INT, appId INT,
		archGroupId INT, archCopyId INT, sourceCopyId INT,
		flags INT, isValidAF INT,
		PRIMARY KEY (jobId, commCellId, fileType, archCopyId))
	DECLARE @tblJob TABLE (
		jobId INT, commCellId INT, appId INT, deleted INT, forceNextBkpFull INT)
	--********************** Populate table variables ********************************/
	INSERT	INTO #ToBeAgedAFC
	SELECT	A.archFileId, A.commCellId, A.archCopyId
	FROM	archChunkMapping A WITH (NOLOCK), @tblAC B
	WHERE	A.archChunkId = B.id AND A.chunkCommCellId = B.commCellId
	GROUP BY A.archFileId, A.commCellId, A.archCopyId
	INSERT	INTO @tblJobCopy
	SELECT	A.jobId, A.commCellId, A.fileType, A.appId, A.archGroupId, B.archCopyId, 0, 0, MAX(A.isValid)
	FROM	archFile A WITH (NOLOCK), #ToBeAgedAFC B
	WHERE	A.id = B.archFileId AND A.commCellId = B.commCellId
	GROUP BY A.jobId, A.commCellId, A.fileType, A.appId, A.archGroupId, B.archCopyId
	IF EXISTS(SELECT 1 FROM @tblJobCopy TJ INNER JOIN ArchGroupCopy AGC WITH (NOLOCK) ON TJ.archCopyId = AGC.id AND AGC.isSnapCopy > 0)
	BEGIN
		DECLARE @tblCopy TABLE (
		    archGroupId     INT,
		    archCopyId      INT,
		    primaryCopyId INT,
		    sourceCopyId    INT,
		    isMirrorCopy    INT
		)
		INSERT INTO @tblCopy
		SELECT AG.id, AGC.id, AG.defaultSnapCopy, AGC.sourceCopyId, AGC.isMirrorCopy
		FROM    archGroup AG WITH (NOLOCK) INNER JOIN (SELECT distinct archGroupId FROM @tblJobCopy) TAG ON AG.id = TAG.archGroupId
		INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON AGC.archGroupId = AG.id AND AGC.isSnapCopy > 0
		-- The source copy will be source of Mirror copy if source copy is Mirror Copy
		WHILE EXISTS(SELECT T.sourceCopyId FROM @tblCopy T INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON T.sourceCopyId = AGC.id WHERE AGC.isMirrorCopy > 0)
		BEGIN
		    UPDATE  @tblCopy
		    SET     sourceCopyId = AGC.sourceCopyId
		    FROM    @tblCopy T INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON T.sourceCopyId = AGC.id
		    WHERE   AGC.isMirrorCopy > 0
		END
		-- The source copy will be primary copy if source copy is not defined
		UPDATE  @tblCopy
		SET     sourceCopyId = primaryCopyId
		WHERE   sourceCopyId = 0
		--Check if we have mirror copy jobs to be prunable in this media and the source snap of this job is not in the prunable job list
		IF EXISTS(SELECT 1 FROM @tblJobCopy TJ INNER JOIN @tblCopy TC ON TJ.archCopyId = TC.archCopyId AND TC.isMirrorCopy > 0
					LEFT OUTER JOIN @tblJobCopy TJ1 ON TJ.jobId = TJ1.jobId AND TJ.commcellId = TJ1.commcellId AND TJ.fileType = TJ1.fileType AND TJ1.archCopyId = TC.sourceCopyId
					WHERE TJ1.jobId is null)
		BEGIN
			SET @l_notAged = 6
			GOTO CX_EXIT
		END
		--Populate rows for pruning the jobs on mirror copy if the jobs are being deleted from snap copy which is source for mirror copy
		INSERT INTO @tblJobCopy
		SELECT AF.jobId, AF.commCellId, AF.fileType, AF.appId, AF.archGroupId, JDS.archGrpCopyId, 0, 0, MAX(AF.isValid)
		FROM JMJobDataStats JDS WITH(NOLOCK) INNER JOIN @tblJobCopy TJ ON JDS.jobId = TJ.jobId AND JDS.commcellId = TJ.commcellId
		INNER JOIN @tblCopy TC ON TC.archCopyId = JDS.archGrpCopyId AND TC.sourceCopyId = TJ.archCopyId AND TC.isMirrorCopy > 0
		INNER JOIN archFile AF WITH(NOLOCK) ON AF.jobId = JDS.jobId AND AF.commcellId = JDS.commcellId AND AF.fileType = JDS.dataType
		LEFT OUTER JOIN @tblJobCopy TJ1 ON AF.jobId = TJ1.jobId AND AF.commcellId = TJ1.commcellId AND AF.fileType = TJ1.fileType AND JDS.archGrpCopyId = TJ1.archCopyId
		WHERE TJ1.jobId IS NULL
		GROUP BY AF.jobId, AF.commCellId, AF.fileType, AF.appId, AF.archGroupId, JDS.archGrpCopyId
	END
	-- Exit if this media contains valid data of a worm storage policy
	IF EXISTS (
		SELECT	*
		FROM	archGroupCopy A WITH (NOLOCK), (SELECT DISTINCT TMP.archCopyId FROM @tblJobCopy TMP
												INNER JOIN JMJobDataStats JM WITH(NOLOCK) ON JM.jobId = TMP.jobId AND JM.commCellId = TMP.commCellId AND JM.archGrpCopyId = TMP.archCopyId
AND JM.dataType = TMP.fileType AND (JM.disabled & 256) = 0) B
WHERE	A.id =  B.archCopyId AND (A.flags & 16777216) <> 0
	) AND OBJECT_ID('tempdb..#GRC_IMPORT_IS_RUNNING') IS NULL
	BEGIN
		SET @l_notAged = 4
		GOTO CX_EXIT
	END
	-- Exit if this media contains valid data of a running/active job
	IF EXISTS (
		SELECT	*
		FROM	JMJobInfo A WITH (NOLOCK), @tblJobCopy B
		WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId
			AND B.isValidAF <> -1
	)
	BEGIN
		SET @l_notAged = 2
		GOTO CX_EXIT
	END
	-- Exit if this media contains jobs of SILO AppId
	IF EXISTS (
		SELECT	T.*
		FROM	@tblJobCopy T, JMJobDataStats JDS WITH (NOLOCK)
		WHERE	T.jobId = JDS.jobId
		AND 	T.commCellId = JDS.commCellId
		AND		T.archGroupId = JDS.archGrpId
		AND		T.archCopyId = JDS.archGrpCopyId
		AND		JDS.appId IN (SELECT DISTINCT siloAppId FROM archGroupCopy WITH (NOLOCK) WHERE siloAppId > 0)
		AND		JDS.status <> 1000
	) AND OBJECT_ID('tempdb..#GRC_IMPORT_IS_RUNNING') IS NULL
	BEGIN
		SET @l_notAged = 3
		GOTO CX_EXIT
	END
	TRUNCATE TABLE #ToBeAgedAFC
	INSERT	INTO #ToBeAgedAFC
	SELECT	A.id, A.commCellId, B.archCopyId
	FROM	archFile A WITH (NOLOCK), @tblJobCopy B
	WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId AND A.archGroupId = B.archGroupId
		-- If a valid data or index archive file is aged, the entire job is aged
		-- except for log and replaced index archive files.
AND (B.fileType NOT IN (4, 34) OR A.fileType = B.fileType)
		-- If the media has only isValidAF=-1 archive file of a job, don't touch other archive files of this job.
		AND (B.isValidAF <> -1 OR A.isValid = -1)
	GROUP BY A.id, A.commCellId, B.archCopyId
	-- Exit if this media contains jobs which are currently being auxcopied
	IF EXISTS(
		SELECT	T.*
		FROM	#ToBeAgedAFC T, archChunkToCopy AX, JMJobInfo J
		WHERE	T.archFileID = AX.archFileId
				AND T.CommCellID = AX.CommCellId
				AND T.archCopyId = AX.archCopyId
				AND AX.adminJobId = J.JobId)
	BEGIN
		SET @l_notAged = 5
		GOTO CX_EXIT
	END
	DELETE	@tblJobCopy WHERE isValidAF = -1
	-- Regular Index Archive Files after movement to media
	INSERT INTO @tblBCDIndexAF
	SELECT 	DISTINCT JDS.jobId, JDS.commCellId, JDS.dataType, JDS.archGrpCopyId, 0
	FROM 		JMJobDataStats JDS WITH (NOLOCK), @tblJobCopy b, archFile AF WITH (NOLOCK)
	WHERE		JDS.jobId = b.jobId
	AND			JDS.commCellId = b.commCellId
	AND			JDS.archGrpCopyId = b.archCopyId
	AND			JDS.jobId = AF.jobId
	AND			JDS.commCellId = AF.commCellId
	AND			JDS.dataType = AF.fileType
AND 		JDS.dataType IN (2)
AND			(AF.flags & (4 | 4096)) > 0
AND			b.fileType IN (1, 4, 2)
	INSERT INTO @tblJobsWithBCDIndex
SELECT 	DISTINCT JDS.jobId, JDS.commCellId, JDS.dataType, JDS.archGrpCopyId, JDS.disabled & 256
	FROM 		JMJobDataStats JDS WITH (NOLOCK), @tblBCDIndexAF TT
	WHERE		JDS.jobId = TT.jobId
	AND			JDS.commCellId = TT.commCellId
AND 		JDS.dataType IN (1, 4)
	AND			JDS.archGrpCopyId = TT.copyId
	UPDATE  @tblJobsWithBCDIndex
SET 		flags = 256
	FROM 		@tblJobsWithBCDIndex TT, @tblJobCopy b
	WHERE		TT.jobId = b.jobId
	AND			TT.commCellId = b.commCellId
AND 		((TT.fileType = b.fileType) OR b.fileType IN (2))
	AND			TT.copyId = b.archCopyId
	UPDATE  @tblBCDIndexAF
	SET 		flags = ISNULL(b.flags, 256)
	FROM 		@tblBCDIndexAF TT LEFT OUTER JOIN (SELECT jobId, commCellId, copyId, MIN(flags & 256) AS flags
															FROM @tblJobsWithBCDIndex
															GROUP BY jobId, commCellId, copyId) b
	ON			TT.jobId = b.jobId
	AND			TT.commCellId = b.commCellId
	AND			TT.copyId = b.copyId
	--Do not prune BCD/Regular Index Archive File created after Snap movement to media if Data or Log is NOT AGED
	DELETE #ToBeAgedAFC
	FROM #ToBeAgedAFC T, @tblBCDIndexAF TT, archFile A WITH (NOLOCK)
	WHERE	A.jobId = TT.jobId
	AND 	A.commCellId = TT.commCellId
	AND		A.fileType = TT.fileType
AND		TT.flags & 256 = 0
	AND		T.archCopyId = TT.copyId
	AND		T.archFileId = A.id
	AND		T.commCellId = A.commCellId
	--Prune BCD/Regular Index Archive File created after Snap movement to media if Data and Log are AGED
	INSERT	INTO #ToBeAgedAFC
	SELECT	A.id, A.commCellId, TT.copyId
	FROM	archFile A WITH (NOLOCK), archFileCopy B WITH (NOLOCK), @tblBCDIndexAF TT
	WHERE	A.jobId = TT.jobId
	AND 	A.commCellId = TT.commCellId
	AND		A.fileType = TT.fileType
AND		TT.flags & 256 = 256
	AND 	A.id = B.archFileId
	AND		A.commCellId = B.commCellId
	AND		B.archCopyId = TT.copyId
AND		B.flags & 256 = 0
	AND		NOT EXISTS (SELECT * FROM #ToBeAgedAFC as T
							WHERE	T.archFileId = A.id
							AND		T.commCellId = A.commCellId
							AND		T.archCopyId = TT.copyId)
	--Get all jobs that will be AGED
	INSERT	INTO @tblJobCopy
	SELECT	A.jobId, A.commCellId, A.fileType, A.appId, A.archGroupId, C.archCopyId, 0, 0, MAX(A.isValid)
	FROM	archFile A WITH (NOLOCK), archFileCopy B WITH (NOLOCK), #ToBeAgedAFC C
	WHERE	A.id = B.archFileId
	AND 	A.commCellId = B.commCellId
	AND		A.id = C.archFileId
	AND 	A.commCellId = C.commCellId
	AND		B.archCopyId = C.archCopyId
	AND		NOT EXISTS (SELECT * FROM @tblJobCopy as T
							WHERE T.jobId = A.jobId
							AND 	T.commCellId = A.commCellId
							AND		T.fileType = A.fileType
							AND		T.archCopyId = C.archCopyId)
	GROUP BY A.jobId, A.commCellId, A.fileType, A.appId, A.archGroupId, C.archCopyId
	/*
	INSERT	INTO @tblJob
	SELECT	DISTINCT jobId, commCellId, appId, 1, 0
	FROM	@tblJobCopy
	*/
	IF @cleanDB = 0
	BEGIN
EXEC @retVal = archFileSetAgedViaTable 4096, @l_now
		IF @retVal <> 0 GOTO CX_EXIT
		--Delete those jobs which still have unaged archive files for the filetype in the copy
		DELETE @tblJobCopy
		FROM @tblJobCopy b INNER JOIN ArchFile AF WITH(NOLOCK) ON b.jobId = AF.jobId AND b.commcellId = AF.commcellId AND b.fileType = AF.fileType
		INNER JOIN ArchFileCopy AFC WITH(NOLOCK) ON AF.id = AFC.archFileId AND AF.commcellId = AFC.commcellId AND AFC.archCopyId = b.archCopyId
WHERE AFC.flags & 256 = 0
		INSERT	INTO @tblJob
		SELECT	DISTINCT jobId, commCellId, appId, 1, 0
		FROM	@tblJobCopy
		-- Tombstone chunks which have no archive file.
UPDATE	archChunk WITH(PAGLOCK) SET flags = (a.flags | 256), modifiedTime = @l_now, agedBy = (agedBy | @l_agedByFlag)
		FROM	archChunk a, @tblAC b
WHERE	a.id = b.id AND a.commCellId = b.commCellId AND (a.flags & 256) = 0
		UPDATE	JMJobDataStats WITH(PAGLOCK)
SET		disabled = (a.disabled | 256), agedTime = @l_now, modifiedTime = @l_now, agedBy = (agedBy | @l_agedByFlag)
		FROM	JMJobDataStats a, @tblJobCopy b
		WHERE	a.jobId = b.jobId AND a.commCellId = b.commCellId
			AND a.archGrpCopyId = b.archCopyId
			AND a.dataType = b.fileType
AND a.disabled & 256 = 0
		-- If the chunks are on transitive copy then delete both archChunkMapping and archFileCopy entries immediately
		DELETE	#ToBeAgedAFC
		FROM	archGroupCopy C
		WHERE	#ToBeAgedAFC.archCopyId = C.id
				AND C.type <> 5 --CVA_AGCOPYTYPE_TRANSITIVE
		IF EXISTS (SELECT COUNT(*) FROM #ToBeAgedAFC)
		BEGIN
			EXEC @retVal = archFileDeleteViaTable 0, @magneticBytes OUTPUT
			IF @retVal <> 0 GOTO CX_EXIT
		END
	END
	ELSE
	BEGIN
		EXEC @retVal = archFileDeleteViaTable 0, @magneticBytes OUTPUT
		IF @retVal <> 0 GOTO CX_EXIT
		--Delete those jobs which still have archive files for the filetype in the copy
		DELETE @tblJobCopy
		FROM @tblJobCopy b INNER JOIN ArchFile AF WITH(NOLOCK) ON b.jobId = AF.jobId AND b.commcellId = AF.commcellId AND b.fileType = AF.fileType
		INNER JOIN ArchFileCopy AFC WITH(NOLOCK) ON AF.id = AFC.archFileId AND AF.commcellId = AFC.commcellId AND AFC.archCopyId = b.archCopyId
		INSERT	INTO @tblJob
		SELECT	DISTINCT jobId, commCellId, appId, 1, 0
		FROM	@tblJobCopy
		-- Delete chunks which have no archive file.
		DELETE	archChunk WITH(PAGLOCK)
		FROM	archChunk a, @tblAC b
		WHERE	a.id = b.id AND a.commCellId = b.commCellId
		UPDATE	JMJobDataStats WITH(PAGLOCK)
SET		status = 1000, disabled = (a.disabled | 256),
				agedTime = @l_now, mediaDeletedTime = @l_now, modifiedTime = @l_now, agedBy = (agedBy | @l_agedByFlag)
		FROM	JMJobDataStats a, @tblJobCopy b
		WHERE	a.jobId = b.jobId AND a.commCellId = b.commCellId
			AND a.archGrpCopyId = b.archCopyId
			AND a.dataType = b.fileType
			AND a.status <> 1000
		-- Set dataStatus = 2 when a job has been deleted from media from all copies
		UPDATE	@tblJob
		SET		deleted = 0
		FROM	JMJobDataStats A WITH (NOLOCK), @tblJob B
		WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId
 			AND A.status NOT IN (101, 1000)
		UPDATE	JMBkpStats WITH (PAGLOCK)
		SET		dataStatus = 2, agedTime = (case when J.agedTime = 0 then @l_now else J.agedTime end),
				mediaDeletedTime = @l_now, modifiedTime = @l_now
		FROM	JMBkpStats J, @tblJob T
		WHERE	J.JobId = T.jobId AND J.CommCellID = T.commCellId
 			AND J.dataStatus <> 2 AND T.deleted = 1
		UPDATE	JMAdminJobStatsTable WITH (PAGLOCK)
		SET		dataStatus = 2
		FROM	JMAdminJobStatsTable J, @tblJob T
		WHERE	J.JobId = T.jobId AND J.CommCellID = T.commCellId
 			AND J.dataStatus <> 2 AND T.deleted = 1
	END
	SELECT TOP 1 @l_copyId = archCopyId FROM @tblJobCopy
		--Media could be associated to miltiple copies. Disabled jobs on destination copies for all the associated copies.
	--IF @i_seconds > 0
	--BEGIN
		-- for overwriting a media
		-- Disable not fully copied jobs on destination copies.
		CREATE TABLE #ToBeDisabledJob (
			jobId INT, archGrpId INT, archGrpCopyId INT, dataType INT, commCellId INT,
			PRIMARY KEY (jobId, archGrpCopyId, dataType, commCellId))
		INSERT	INTO #ToBeDisabledJob
		SELECT	jobId, archGroupId, archCopyId, fileType, commCellId
		FROM	@tblJobCopy
		EXEC archDisallowMultipleJobForCopy @l_now
		DROP TABLE #ToBeDisabledJob
	--END
	-- Set copy aging rule flags dirty bit to AM_AGING_FLAGS_EXT_DIRTY
	-- This is to indicate the need to calculate retentionFlags in JMJobDataStats table
	UPDATE	ArchAgingRule WITH(PAGLOCK) SET flags = flags | 2
	WHERE	copyId = @l_copyId AND flags & 2 = 0
	IF @@ERROR <> 0 GOTO CX_EXIT
	-- For "Delete Contents"
	IF @i_cleanDB = 0
	BEGIN
       IF EXISTS (SELECT * FROM archGroup WITH (NOLOCK) WHERE defaultCopy = @l_copyId)
        BEGIN
				--Check if deleted job is in last cycle. If yes - convert next job to full or diff
				DECLARE @tblAppIdListToConvert table(appId int, fullCycleNum int, maxServStartDate int)
				INSERT INTO @tblAppIdListToConvert
				SELECT A.appId , MAX(JBS.fullCycleNum), MAX(JBS.servStartDate)
                FROM   @tblJob A
				INNER JOIN JMBkpStats JBS WITH (NOLOCK) ON A.jobId = JBS.jobId AND A.commCellId = JBS.commCellId
                AND A.appId = JBS.appId AND JBS.status IN (1,3,14)
				GROUP BY A.appId
				SET @retVal = @@ERROR
				IF  @retVal != 0 GOTO CX_EXIT
				--Filter out and get only subclients whose latest cycle jobs were deleted
				DELETE @tblAppIdListToConvert
				FROM @tblAppIdListToConvert APP INNER JOIN App_SubclientProp SCProp WITH(NOLOCK) ON App.appId = SCProp.componentNameId
				WHERE SCProp.attrName = 'sys:full cycle num' AND APP.fullCycleNum < CAST(SCProp.attrVal AS BIGINT)
				SET @retVal = @@ERROR
				IF  @retVal != 0 GOTO CX_EXIT
				DECLARE @configForceDiff INT = 0
				SELECT @configForceDiff = ISNULL(value, 0) FROM MMConfigs WITH(NOLOCK) WHERE name = 'MMCONFIGS_DEL_INCR_DIFF_NOT_FORCE_FULL_ON_NEXT_BACKUP'
				SET @retVal = @@ERROR
				IF  @retVal != 0 GOTO CX_EXIT
				--Subclients that I am left with must need job conversion
				DECLARE @tblAppIdsToForceFull table(appId int)
				IF(@configForceDiff > 0)
					INSERT INTO @tblAppIdsToForceFull
					SELECT distinct APP.appId
					FROM @tblAppIdListToConvert APP INNER JOIN JMBkpStats JBKP WITH(NOLOCK) ON APP.appId = JBKP.appId AND APP.fullCycleNum = JBKP.fullCycleNum
					INNER JOIN @tblJob J ON JBKP.jobId = J.jobId AND JBKP.commcellId = J.commcellId
					WHERE JBKP.bkpLevel NOT IN(2, 4) AND JBKP.status IN (1, 3, 14)
				ELSE
					INSERT INTO @tblAppIdsToForceFull
					SELECt appId FROM @tblAppIdListToConvert
				SET @retVal = @@ERROR
				IF  @retVal != 0 GOTO CX_EXIT
				/*
				typedef enum CVBkpLevel
				{
					UNKNOWN_BKP_LEVEL = 0x0,
					FULL = 0x1,
					INCR = 0x2,
					DIFFERENTIAL = 0x4,
				*/
				IF EXISTS(SELECT 1 FROM @tblAppIdsToForceFull)
				BEGIN
					DECLARE @appIdListXmlFull xml
					SET @appIdListXmlFull = (SELECT appId FROM @tblAppIdsToForceFull FOR XML RAW, ROOT('AppIdList'))
					SET @retVal = @@ERROR
					IF  @retVal != 0 GOTO CX_EXIT
					DECLARE @tblTempResultFull table (retVal int)
					INSERT @tblTempResultFull
					EXEC AppForceNextBackpAsFullOrDiff 1, @appIdListXmlFull, '8' --CV_CLEAR_ARCHIVE_AUXCOPY_JOBCOPY
					SET @retVal = @@ERROR
					IF @retVal = 0
						SELECT @retVal = retVal FROM @tblTempResultFull
					IF @retVal != 0 GOTO CX_EXIT
					UPDATE @tblJob
                    SET           forceNextBkpFull = 1
                    FROM @tblJob TJ INNER JOIN @tblAppIdsToForceFull TMP ON TJ.appId = TMP.appId
				END
				DELETE @tblAppIdListToConvert WHERE appId IN (SELECT appId FROM @tblAppIdsToForceFull)
				IF EXISTS(SELECT 1 FROM @tblAppIdListToConvert)
				BEGIN
					-- At this point all appIds in @tblAppIdListToConvert will have only appids whose incr and differential jobs are deleted. If these deleted jobs before last diff conversion is not required
					DELETE @tblAppIdListToConvert
					FROM @tblAppIdListToConvert APP INNER JOIN JMBkpStats JBKP WITH(NOLOCK)
					ON APP.appId = JBKP.appId AND APP.fullCycleNum = JBKP.fullCycleNum AND JBKP.bkpLevel = 4
					AND JBKP.servStartDate > APP.maxServStartDate AND JBKP.status IN (1, 3, 14)
					IF EXISTS(SELECT 1 FROM @tblAppIdListToConvert)
					BEGIN
						DECLARE @appIdListXmlDiff xml
						SET @appIdListXmlDiff = (SELECT appId FROM @tblAppIdListToConvert FOR XML RAW, ROOT('AppIdList'))
						SET @retVal = @@ERROR
						IF  @retVal != 0 GOTO CX_EXIT
						DECLARE @tblTempResultDiff table(retVal int)
						INSERT @tblTempResultDiff
						EXEC AppForceNextBackpAsFullOrDiff 2, @appIdListXmlDiff, '8' --CV_CLEAR_ARCHIVE_AUXCOPY_JOBCOPY
						SET @retVal = @@ERROR
						IF @retVal = 0
							SELECT @retVal = retVal FROM @tblTempResultDiff
						IF @retVal != 0 GOTO CX_EXIT
					END
				END
        END
		-- Disallow pruned jobs for copy
		DECLARE @tblCopyToSet TABLE (copyId INT, sourceCopyId INT, defaultCopyId INT, archGroupId INT, flags INT, dedupeFlags INT, maxMultiplex INT, isSnapCopy INT, isMirrorCopy INT)
		INSERT INTO @tblCopyToSet
		EXEC ArchDestinationCopyList @l_copyId
		DELETE FROM @tblCopyToSet WHERE copyId = @l_copyId
		IF EXISTS (SELECT * FROM @tblCopyToSet)
		BEGIN
			INSERT	INTO @tblJobCopy
			SELECT	DISTINCT J.jobId, J.commCellId, J.dataType, B.appId, J.archGrpId, J.archGrpCopyId,
					C.sourceCopyId, 1, 0
			FROM	JMJobDataStats J WITH (NOLOCK), @tblJobCopy B, @tblCopyToSet C
			WHERE	J.jobId = B.jobId AND J.archGrpCopyId = C.copyId
				AND J.dataType = B.fileType
				AND J.commCellId = B.commCellId
AND J.status IN (101, 102, 103) AND (J.disabled & (1 + 256)) = 0
			IF @@ROWCOUNT > 0
			BEGIN
				DELETE	FROM @tblJobCopy
				WHERE	jobId NOT IN (SELECT DISTINCT jobId FROM @tblJobCopy WHERE flags = 0)
				SELECT	@retVal = 0
				WHILE @@ROWCOUNT > 0
					UPDATE	@tblJobCopy SET flags = 1
					WHERE	flags = 0 AND sourceCopyId IN (SELECT archCopyId FROM @tblJobCopy WHERE flags = 1)
				UPDATE 	JMJobDataStats
SET		disabled = (J.disabled | 1), modifiedTime = @l_now
				FROM	JMJobDataStats J, @tblJobCopy T
				WHERE	J.jobId = T.jobId AND J.archGrpCopyId = T.archCopyId AND J.commCellId = T.commCellId
					AND J.dataType = T.fileType
AND T.flags = 1 AND J.archGrpCopyId <> @l_copyId
AND J.disabled & 1 = 0
			END
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET	@retVal = (SELECT ERROR_NUMBER())
END CATCH
--*********************************** Going to exit **********************************/
CX_EXIT:
DROP TABLE #ToBeAgedAFC
IF @retVal <> 0 OR @l_notAged <> 0
BEGIN
	IF OBJECT_ID('tempdb..#tmpResutSetForArchDeleteBackupByMedia') IS NOT NULL
	BEGIN
		INSERT INTO #tmpResutSetForArchDeleteBackupByMedia
		SELECT	-1, @retVal, @l_notAged, 0, 0
	END
	ELSE
	BEGIN
		SELECT	-1, @retVal, @l_notAged, 0, 0
	END
END
ELSE
BEGIN
	IF OBJECT_ID('tempdb..#tmpResutSetForArchDeleteBackupByMedia') IS NOT NULL
	BEGIN
		INSERT INTO #tmpResutSetForArchDeleteBackupByMedia
		SELECT	T.jobId, T.appId, A.appTypeId, A.backupSet, T.forceNextBkpFull
		FROM	@tblJob T, APP_Application A WITH (NOLOCK)
		WHERE	A.id = T.appId
		ORDER BY T.appId, T.forceNextBkpFull DESC
	END
	ELSE
	BEGIN
		SELECT	T.jobId, T.appId, A.appTypeId, A.backupSet, T.forceNextBkpFull
		FROM	@tblJob T, APP_Application A WITH (NOLOCK)
		WHERE	A.id = T.appId
		ORDER BY T.appId, T.forceNextBkpFull DESC
	END
END
SET NOCOUNT OFF
RETURN @retVal
GO

IF EXISTS (select * from GxQscripts where name = 'ArchDeleteBackupByMedia')
	delete from GxQscripts where name = 'ArchDeleteBackupByMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchDeleteBackupByMedia')
	delete from GXDBVersions where aliasname = 'ArchDeleteBackupByMedia'
GO

insert into GXDBVersions values(2, 'ArchDeleteBackupByMedia',  '00010076003400080000', 'ArchDeleteBackupByMedia', '00010076003400080000')
GO

