

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchCopyStreamDataCalculation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchCopyStreamDataCalculation.sp,v $ $Id: ArchCopyStreamDataCalculation.sp,v 1.6.274.2 2018/03/22 00:57:37 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ArchCopyStreamDataCalculation <<<'

IF EXISTS (select * from sysobjects where name='ArchCopyStreamDataCalculation')
	drop procedure ArchCopyStreamDataCalculation
IF EXISTS (select * from GxQscripts where name='ArchCopyStreamDataCalculation')
	delete from GxQscripts where name = 'ArchCopyStreamDataCalculation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchCopyStreamDataCalculation')
	delete from GXDBVersions where aliasname = 'ArchCopyStreamDataCalculation'
GO
print '... Creating Procedure: ArchCopyStreamDataCalculation'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure ArchCopyStreamDataCalculation
  @i_dummy integer
AS
-- Following are the "columns" returned, in the order in which they are returned
	DECLARE @thresholdInGB INT
	SET		@thresholdInGB = 0
	SELECT	@thresholdInGB = isnull(value, 0)
	FROM	MMConfigs
	WHERE	name = 'MMS2_CONFIG_STREAM_DATA_DISTRIBUTION_THRESHOLD'
	IF @thresholdInGB <= 0
		GOTO FINISH
	DECLARE @ByteToGB	int
	SET @ByteToGB = 1024 * 1024 * 1024
	CREATE TABLE #ArchCopy
	(
		CopyId				integer,
		ArchGroupId			integer,
		DefaultCopy			integer
	)
	CREATE TABLE #FirstJob
	(
		ArchGroupId			integer,
		DefaultCopy			integer,
		FirstJobId			integer,
		FirstArchFileId		integer
	)
	CREATE TABLE #ArchStreamDataSize
	(
		CopyId				integer,
		StreamId			integer,
		TotalDataSize		bigint
	)
	INSERT	INTO #ArchCopy
	SELECT	AGC.id, AG.id, AG.defaultCopy
	FROM	archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK)
	WHERE	AGC.archGroupId = AG.id AND AGC.id <> AG.defaultCopy AND AGC.isSnapCopy = 0 AND AGC.isActive = 1
AND AG.maxStreams > 1 AND (AG.flags & 4) <> 0
	INSERT	INTO #FirstJob
	SELECT	J.archGrpId, T.DefaultCopy, MIN(J.jobId), 0
	FROM	JMJobDataStats J WITH (NOLOCK), #ArchCopy T
	WHERE	J.archGrpCopyId = T.CopyId
		AND J.status IN (101, 102, 103) AND (J.disabled & (1+256))= 0
		AND J.commCellId = 2
	GROUP BY J.archGrpId, T.DefaultCopy
	UPDATE	#FirstJob
	SET		FirstArchFileId = A.archFileId
	FROM	(SELECT	T.ArchGroupId, MIN(AF.id) AS archFileId
			FROM	archFile AF WITH (NOLOCK), #FirstJob T
			WHERE	AF.jobId = T.FirstJobId AND AF.commCellId = 2 AND AF.archGroupId = T.ArchGroupId
			GROUP BY T.ArchGroupId) A
	WHERE	#FirstJob.ArchGroupId = A.ArchGroupId
	INSERT INTO #ArchStreamDataSize
	SELECT	AFC.archCopyId, AFC.streamNum, SUM(AFC.physicalSize)
	FROM	ArchFileCopy AFC WITH (NOLOCK), #FirstJob T
	WHERE	AFC.archCopyId = T.DefaultCopy
		AND	AFC.archFileId >= T.FirstArchFileId AND AFC.commCellId = 2
		AND	AFC.isValid = 1
	GROUP BY AFC.archCopyId, AFC.streamNum
	UPDATE	ArchStream
	SET		PhysicalDataSizeInGB = (b.TotalDataSize / @ByteToGB)
	FROM	ArchStream a, #ArchStreamDataSize b
	WHERE	a.ArchGroupCopyId = b.CopyId AND a.Stream = b.StreamId
		AND a.PhysicalDataSizeInGB <> (b.TotalDataSize / @ByteToGB)
FINISH:
DROP TABLE #ArchCopy
DROP TABLE #FirstJob
DROP TABLE #ArchStreamDataSize
GO

IF EXISTS (select * from GxQscripts where name = 'ArchCopyStreamDataCalculation')
	delete from GxQscripts where name = 'ArchCopyStreamDataCalculation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchCopyStreamDataCalculation')
	delete from GXDBVersions where aliasname = 'ArchCopyStreamDataCalculation'
GO

insert into GXDBVersions values(2, 'ArchCopyStreamDataCalculation',  '00010006027400020000', 'ArchCopyStreamDataCalculation', '00010006027400020000')
GO

