

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchCopyGetActiveStreamOnDataSize.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchCopyGetActiveStreamOnDataSize.sp,v $ $Id: ArchCopyGetActiveStreamOnDataSize.sp,v 1.4 2009/08/07 02:32:06 cliu Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ArchCopyGetActiveStreamOnDataSize <<<'

IF EXISTS (select * from sysobjects where name='ArchCopyGetActiveStreamOnDataSize')
	drop procedure ArchCopyGetActiveStreamOnDataSize
IF EXISTS (select * from GxQscripts where name='ArchCopyGetActiveStreamOnDataSize')
	delete from GxQscripts where name = 'ArchCopyGetActiveStreamOnDataSize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchCopyGetActiveStreamOnDataSize')
	delete from GXDBVersions where aliasname = 'ArchCopyGetActiveStreamOnDataSize'
GO
print '... Creating Procedure: ArchCopyGetActiveStreamOnDataSize'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure ArchCopyGetActiveStreamOnDataSize
  @i_CopyId integer,
  @i_IsReserved integer
AS
  DECLARE @o_ArchGroupId integer;
  DECLARE @o_ArchGroupCopyId integer;
  DECLARE @o_StreamId integer;
  DECLARE @o_MediaGroupId integer;
  DECLARE @o_IsActive integer;
  DECLARE @o_LastUsedTime integer;
-- Following are the "columns" returned, in the order in which they are returned
	DECLARE @thresholdInGB INT
	SET @thresholdInGB = 0
	SELECT	@thresholdInGB = isnull(value, 0)
	FROM		MMConfigs
	WHERE		name = 'MMS2_CONFIG_STREAM_DATA_DISTRIBUTION_THRESHOLD'
	IF @thresholdInGB <= 0
	BEGIN
		IF @i_IsReserved = 0
			SELECT  ArchGroupId, ArchGroupCopyId, Stream, MediaGroupId, IsActive, LastUsedTime
			FROM		ArchStream
			WHERE		ArchGroupCopyId = @i_CopyId AND IsActive = 1
			AND			Stream NOT IN (SELECT StreamId FROM MMResource WHERE CopyId = @i_CopyId)
			ORDER BY NEWID()
		ELSE
			SELECT  ArchGroupId, ArchGroupCopyId, Stream, MediaGroupId, IsActive, LastUsedTime
			FROM		ArchStream
			WHERE		ArchGroupCopyId = @i_CopyId AND IsActive = 1
			AND			Stream IN (SELECT StreamId FROM MMResource WHERE CopyId = @i_CopyId)
			ORDER BY NEWID()
	END
	ELSE
	BEGIN
		IF @i_IsReserved = 0
			SELECT  ArchGroupId, ArchGroupCopyId, Stream, MediaGroupId, IsActive, LastUsedTime
			FROM		ArchStream
			WHERE		ArchGroupCopyId = @i_CopyId AND IsActive = 1
			AND			Stream NOT IN (SELECT StreamId FROM MMResource WHERE CopyId = @i_CopyId)
			ORDER BY PhysicalDataSizeInGB / @thresholdInGB, NEWID()
		ELSE
			SELECT  ArchGroupId, ArchGroupCopyId, Stream, MediaGroupId, IsActive, LastUsedTime
			FROM		ArchStream
			WHERE		ArchGroupCopyId = @i_CopyId AND IsActive = 1
			AND			Stream IN (SELECT StreamId FROM MMResource WHERE CopyId = @i_CopyId)
			ORDER BY PhysicalDataSizeInGB / @thresholdInGB, NEWID()
	END
	return
GO

IF EXISTS (select * from GxQscripts where name = 'ArchCopyGetActiveStreamOnDataSize')
	delete from GxQscripts where name = 'ArchCopyGetActiveStreamOnDataSize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchCopyGetActiveStreamOnDataSize')
	delete from GXDBVersions where aliasname = 'ArchCopyGetActiveStreamOnDataSize'
GO

insert into GXDBVersions values(2, 'ArchCopyGetActiveStreamOnDataSize',  '00010004000000000000', 'ArchCopyGetActiveStreamOnDataSize', '00010004000000000000')
GO

