

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchChunkAgedStatusInfo.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  ArchChunkAgedStatusInfo.sp                                   */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchChunkAgedStatusInfo.sp,v $ $Id: ArchChunkAgedStatusInfo.sp,v 1.1.2.1 2020/06/16 17:03:23 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ArchChunkAgedStatusInfo')
BEGIN
	print '>>> Drop Stored Procedure: ArchChunkAgedStatusInfo <<<'
	drop procedure ArchChunkAgedStatusInfo
END
IF EXISTS (select * from GxQscripts where name='ArchChunkAgedStatusInfo')
	delete from GxQscripts where name = 'ArchChunkAgedStatusInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchChunkAgedStatusInfo')
	delete from GXDBVersions where aliasname = 'ArchChunkAgedStatusInfo'
GO
print '... Creating Procedure: ArchChunkAgedStatusInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ArchChunkAgedStatusInfo
  @i_Xml xml OUTPUT
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
IF object_id('tempdb.dbo.#tempChunk') IS NOT NULL DROP TABLE #tempChunk
CREATE TABLE #tempChunk (archChunkId BIGINT, chunkCommcellId INT, volumeId INT, isAged INT, isValid INT)
BEGIN TRY
	INSERT INTO #tempChunk
	SELECT ISNULL(ref.value('@chunkId', 'BIGINT'), 0), ISNULL(ref.value('@commcellId', 'INT'),0),  ISNULL(ref.value('@volumeId', 'INT'),0),
	ISNULL(ref.value('@isAged', 'INT'), 0),  ISNULL(ref.value('@isValid', 'INT'),0)
	FROM   @i_Xml.nodes('MediaManager_ArchChunkAgedStatusInfoReq/chunkList') R ( ref )
	UPDATE	TC
SET		isAged = (CASE WHEN (AC.flags & 256 > 0 ) THEN 1 ELSE 0 END),
isValid = (CASE WHEN (AC.flags & 256 = 0 ) THEN 1 ELSE 0 END)
	FROM	archChunk AC WITH (READUNCOMMITTED), #tempChunk TC
	WHERE	AC.id = TC.archChunkId
			AND AC.volumeId = TC.volumeId
	UPDATE	TC
	SET		isAged = 1,
			isValid = 0
	FROM	archChunkPruningLogs AC WITH (READUNCOMMITTED), #tempChunk TC
	WHERE	AC.chunkId = TC.archChunkId
			AND AC.volumeId = TC.volumeId
			AND TC.isAged = 0
			AND TC.isValid = 0
	UPDATE	TC
	SET		isAged = 1,
			isValid = 0
	FROM	MMDeletedAF MD WITH (READUNCOMMITTED), #tempChunk TC
	WHERE	MD.ArchChunkId = TC.archChunkId
			AND MD.volumeId = TC.volumeId
			AND TC.isAged = 0
			AND TC.isValid = 0
	SET @i_Xml = (	SELECT	0 AS '@errorCode',
							'' AS '@errorString',
							(SELECT archChunkId AS '@chunkId',
									chunkCommcellId AS '@commcellId',
									volumeId AS '@volumeId',
									isAged AS '@isAged',
									isValid AS '@isValid'
							FROM	#tempChunk
							FOR XML PATH('chunkList'), TYPE)
					FOR XML PATH('MediaManager_ArchChunkAgedStatusInfoResp'), TYPE)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @i_Xml = (	SELECT	ERROR_NUMBER() AS '@errorCode',
								ERROR_MESSAGE() AS '@errorString'
						FOR XML PATH('MediaManager_ArchChunkAgedStatusInfoResp'), TYPE)
	;THROW;
END CATCH
END_OF_PROC:
IF object_id('tempdb.dbo.#tempChunk') IS NOT NULL DROP TABLE #tempChunk
GO

IF EXISTS (select * from GxQscripts where name = 'ArchChunkAgedStatusInfo')
	delete from GxQscripts where name = 'ArchChunkAgedStatusInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchChunkAgedStatusInfo')
	delete from GXDBVersions where aliasname = 'ArchChunkAgedStatusInfo'
GO

insert into GXDBVersions values(2, 'ArchChunkAgedStatusInfo',  '00010001000200010000', 'ArchChunkAgedStatusInfo', '00010001000200010000')
GO

