

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchCheckJobContentIndexed.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchCheckJobContentIndexed.sp,v $ $Id: ArchCheckJobContentIndexed.sp,v 1.1.2.1 2020/06/29 18:47:25 prasanthm Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "ArchCheckJobContentIndexed"								|
--	|																		|
--	| Execute the System stored procedure to fcheck the job and later job 	|
--	| indexed																|
-- 	+-----------------------------------------------------------------------+
/*
XML format
<MediaManager_GetContentIndexInfoForJob><jobList appId="9" commcellId="2" isJobIndexed="0" isLaterJobIndexed="0" jobId="1"/>
<jobList appId="21" commcellId="2" isJobIndexed="0" isLaterJobIndexed="0" jobId="4846"/>
<jobList appId="296" commcellId="2" isJobIndexed="0" isLaterJobIndexed="0" jobId="11212"/>
</MediaManager_GetContentIndexInfoForJob>
*/
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ArchCheckJobContentIndexed')
BEGIN
	print '>>> Drop Stored Procedure: ArchCheckJobContentIndexed <<<'
	drop procedure ArchCheckJobContentIndexed
END
IF EXISTS (select * from GxQscripts where name='ArchCheckJobContentIndexed')
	delete from GxQscripts where name = 'ArchCheckJobContentIndexed'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchCheckJobContentIndexed')
	delete from GXDBVersions where aliasname = 'ArchCheckJobContentIndexed'
GO
print '... Creating Procedure: ArchCheckJobContentIndexed'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ArchCheckJobContentIndexed
  @i_jobListXML XML OUTPUT
AS
IF OBJECT_ID('tempdb..#CheckJobContentIndexed') IS NOT NULL DROP TABLE #CheckJobContentIndexed
CREATE TABLE #CheckJobContentIndexed(appId int, jobId int, commcellId int, isJobIndexed int, isLaterJobIndexed int, jobStartDate int)
CREATE CLUSTERED INDEX CheckJobContentIndexed_JobId_CommcellId ON #CheckJobContentIndexed(jobId,commcellId)
CREATE NONCLUSTERED INDEX CheckJobContentIndexed_AppId ON #CheckJobContentIndexed(appId)
IF @i_jobListXML.exist('/MediaManager_GetContentIndexInfoForJob') = 1
BEGIN
	INSERT INTO #CheckJobContentIndexed
	SELECT T.item.value('@appId','INT'), T.item.value('@jobId','INT'), T.item.value('@commcellId','INT'), 0, 0, 0
	        FROM @i_jobListXML.nodes('/MediaManager_GetContentIndexInfoForJob/jobList') T(item)
END
UPDATE TMP
SET isJobIndexed = 1
FROM #CheckJobContentIndexed TMP
INNER JOIN archFile AF WITH (NOLOCK)
ON TMP.jobId = AF.jobId AND TMP.commcellId = AF.commCellId AND TMP.appId = AF.appId
AND AF.fileType = 1 AND (AF.flags & 64) > 0 AND AF.isValid = 1
UPDATE TMP
SET jobStartDate = Jm.servStartDate
FROM #CheckJobContentIndexed TMP
INNER JOIN JMBkpStats JM WITH (NOLOCK) ON JM.appId = TMP.appId AND JM.jobId = TMP.jobId AND JM.commCellId = TMP.commcellId
UPDATE TMP
SET isLaterJobIndexed = 1
FROM #CheckJobContentIndexed TMP
INNER JOIN archFile AF WITH (NOLOCK) ON (TMP.jobId <> AF.jobId OR TMP.commcellId <> AF.commCellId) AND TMP.appId = AF.appId AND TMP.jobStartDate > 0 AND AF.cTime > TMP.jobStartDate
AND AF.fileType = 1 AND (AF.flags & 64) > 0 AND AF.isValid = 1
SET @i_jobListXML =
    (
        SELECT  appId AS '@appId',
                jobId AS '@jobId',
                commcellId AS '@comcellId',
                isJobIndexed AS '@isJobIndexed',
                isLaterJobIndexed AS '@isLaterJobIndexed'
        FROM    #CheckJobContentIndexed
        FOR XML PATH ('jobList'), ROOT('MediaManager_GetContentIndexInfoForJob'), TYPE
    )
IF OBJECT_ID('tempdb..#CheckJobContentIndexed') IS NOT NULL DROP TABLE #CheckJobContentIndexed
GO

IF EXISTS (select * from GxQscripts where name = 'ArchCheckJobContentIndexed')
	delete from GxQscripts where name = 'ArchCheckJobContentIndexed'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchCheckJobContentIndexed')
	delete from GXDBVersions where aliasname = 'ArchCheckJobContentIndexed'
GO

insert into GXDBVersions values(2, 'ArchCheckJobContentIndexed',  '00010001000200010000', 'ArchCheckJobContentIndexed', '00010001000200010000')
GO

