

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchCheckExpired.sp] ---------- 

--#include "DBaccess.h"
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Jun Lu
--	Date:   04/26/2003
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/archCheckExpired.sp,v $ $Id: archCheckExpired.sp,v 1.12.304.1 2018/03/22 01:06:49 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='archCheckExpired')
BEGIN
	print '>>> Drop Stored Procedure: archCheckExpired <<<'
	drop procedure archCheckExpired
END
IF EXISTS (select * from GxQscripts where name='archCheckExpired')
	delete from GxQscripts where name = 'archCheckExpired'
GO

IF EXISTS (select * from GXDBVersions where aliasname='archCheckExpired')
	delete from GXDBVersions where aliasname = 'archCheckExpired'
GO
print '... Creating Procedure: archCheckExpired'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure archCheckExpired
  @i_copyId integer,
  @i_expiredDate integer
AS
  DECLARE @retVal integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @l_now integer
SET @l_now = dbo.GetUnixTime(GETUTCDATE())
BEGIN TRANSACTION
SELECT jobId, commCellId
INTO   #tempJobCopy
FROM   JMJobDataStats WITH (READUNCOMMITTED)
WHERE  archGrpCopyId = @i_copyId AND archCheckStatus <> 1 AND archCheckEndTime > 0 AND archCheckEndTime < @i_expiredDate AND status = 100
GROUP BY jobId, commCellId
IF @@ERROR <> 0
   GOTO RETURN_PROC
SELECT A.id, A.commCellId
INTO   #tempAFile
FROM   archFile A WITH (READUNCOMMITTED), #tempJobCopy B
WHERE  A.jobId = B.jobId AND A.commCellId = B.commCellId
	AND A.isValid = 1
IF @@ERROR <> 0
   GOTO RETURN_PROC
UPDATE JMJobDataStats SET archCheckStatus = 1, modifiedTime = @l_now
FROM   JMJobDataStats A, #tempJobCopy B
WHERE  A.jobId = B.jobId
AND A.archGrpCopyId = @i_copyId
AND A.commCellId = B.commCellId
IF @@ERROR <> 0
   GOTO RETURN_PROC
UPDATE archChunkMapping SET flags = ((A.flags & ~255) | 8)
FROM   archChunkMapping A, #tempAFile B
WHERE  A.archFileId = B.id AND A.commCellId = B.commCellId AND A.archCopyId = @i_copyId
	AND (A.flags & 256) = 0
RETURN_PROC:
SET @retVal = @@ERROR
DROP TABLE #tempJobCopy
DROP TABLE #tempAFile
IF @retVal = 0
   COMMIT   TRANSACTION
ELSE
   ROLLBACK TRANSACTION
SELECT   @retVal
RETURN   @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'ArchCheckExpired')
	delete from GxQscripts where name = 'ArchCheckExpired'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchCheckExpired')
	delete from GXDBVersions where aliasname = 'ArchCheckExpired'
GO

insert into GXDBVersions values(2, 'ArchCheckExpired',  '00010012030400010000', 'ArchCheckExpired', '00010012030400010000')
GO

