

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchCheckCloudRecallRequired.sp] ---------- 

SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ArchCheckCloudRecallRequired')
BEGIN
	print '>>> Drop Stored Procedure: ArchCheckCloudRecallRequired <<<'
	drop procedure ArchCheckCloudRecallRequired
END
IF EXISTS (select * from GxQscripts where name='ArchCheckCloudRecallRequired')
	delete from GxQscripts where name = 'ArchCheckCloudRecallRequired'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchCheckCloudRecallRequired')
	delete from GXDBVersions where aliasname = 'ArchCheckCloudRecallRequired'
GO
print '... Creating Procedure: ArchCheckCloudRecallRequired'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ArchCheckCloudRecallRequired
  @i_jobId INT,
  @i_archFileId INT,
  @i_appId INT,
  @i_copyId INT,
  @i_commCellId INT,
  @i_volumeId INT
AS
  DECLARE @o_workflowId INT = 0
  DECLARE @o_workflowUser INT = 0
  DECLARE @o_isIndexRecall INT = 0
  DECLARE @o_errorCode INT = 0
  DECLARE @o_errorMessage NVARCHAR(1024) = ''
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
BEGIN TRY
DECLARE @bkpJobId	INT = 0
DECLARE @appType	INT = 0
DECLARE @opType		INT = 0
-----------------------------------------------------------
--Check if feature is disabled through additional settings
-----------------------------------------------------------
	IF EXISTS(SELECT 1
				FROM GxGlobalParam
WHERE name = 'EnableAutoCloudIndexRecall'
				AND modified = 0
				AND value = 'false')
	BEGIN
		SET @o_errorCode = -1
		GOTO CX_EXIT
	END
-----------------------------------------------------------
--Check if cloud storage archive recall workflow is installed
-----------------------------------------------------------
	SELECT TOP 1 @o_workflowId = workflowId, @o_workflowUser = userId
	FROM WF_Definition
WHERE Name = 'Cloud Storage Archive Recall'
	AND (flags & 1) = 0
	IF @o_workflowId = 0
	BEGIN
		SET @o_errorCode = -5
		GOTO CX_EXIT
	END
-----------------------------------------------------------
--Check if supported job types
-----------------------------------------------------------
	IF @i_appId = 0
	OR NOT EXISTS(
		SELECT 1
		FROM APP_Application
		WHERE id = @i_appId
	)
	BEGIN
		SELECT @i_appId = appId
		, @bkpJobId = jobId
		FROM archFile
		WHERE id = @i_archFileId
		AND commCellId = @i_commCellId
	END
	IF @i_copyId = 0
	OR NOT EXISTS(
		SELECT 1
		FROM archGroupCopy
		WHERE id = @i_copyId
	)
	BEGIN
		DECLARE @l_outAFC_isValid INT
		DECLARE @l_outAFC_flag INT
		EXEC archFileCopyPreferred @i_archFileId,@i_commCellId,0,1,1,@i_copyId output,@l_outAFC_isValid output,@l_outAFC_flag output
	END
	SELECT @appType = appTypeId
	FROM APP_Application
	WHERE id = @i_appId AND id > 0
	SELECT @opType = opType
	FROM JMJobInfo
	WHERE jobId = @i_jobId
	IF (@opType = 12 /*INDEXRESTORE*/)
	BEGIN
		SET @o_isIndexRecall = 1
	END
	ElSE
	BEGIN
		DECLARE @operType INT = 0
		SELECT @operType = ISNULL(TRY_CAST(value AS INT), 0)
		FROM TM_JobOptions
		WHERE jobId = @i_jobId
		AND optionId = 140018
		AND modified = 0
		IF (@opType NOT IN (
				5 /*RESTORE*/
				, 40 /*INDEXFREERESTORE*/
				)
			OR
			@operType NOT IN(
1001
, 1005
				)
			)
		BEGIN
			SET @o_errorCode = -2
			GOTO CX_EXIT
		END
-----------------------------------------------------------
--Check if supported agents
-----------------------------------------------------------
		IF NOT EXISTS(SELECT 1
				FROM GxGlobalParam
WHERE name = 'DisableCloudAgentFilter'
				AND modified = 0
				AND value = 'true')
		BEGIN
			IF @appType NOT IN(
33
,81
,106
,13
,29
				)
			BEGIN
				SET @o_errorCode = -3
				GOTO CX_EXIT
			END
		END
	END
-----------------------------------------------------------
--Skip auto recall for VSA V1 due to synthfull jobs requiring
--separate recall logic which needs manually running workflow
--Workflow already fails for VSA V1 with message to run it manually
-----------------------------------------------------------
	IF @bkpJobId = 0
	BEGIN
		SELECT @bkpJobId = jobId
		FROM archFile
		WHERE id = @i_archFileId
		AND commCellId = @i_commCellId
	END
IF @appType = 106
		AND NOT EXISTS(SELECT 1
		FROM JMJobDataLink
		WHERE (parentJobId = @bkpJobId
		OR childJobId = @bkpJobId)
		and commCellId = @i_commCellId)
	BEGIN
		SET @o_errorCode = -8
		GOTO CX_EXIT
	END
-----------------------------------------------------------
--Check if job is already processed by another workflow
-----------------------------------------------------------
DECLARE @defaultCommCellId INT = 2
	IF EXISTS(SELECT 1
			FROM JMJobOptions
WHERE attributeId = 101
			AND jobId = @i_jobId
			AND commCellId = @defaultCommCellId)
	BEGIN
		SET @o_errorCode = -4
		GOTO CX_EXIT
	END
-----------------------------------------------------------
--Check if supported cloud storages
-----------------------------------------------------------
	IF OBJECT_ID('tempdb.dbo.#tempDeviceTypes') IS NOT NULL DROP TABLE #tempDeviceTypes
	CREATE TABLE #tempDeviceTypes (DeviceTypeId INT PRIMARY KEY)
	INSERT INTO #tempDeviceTypes
SELECT 2 /*Amazon S3*/
    UNION
SELECT 53 /*Amazon Glacier*/
    UNION
SELECT 3 /*Microsoft Azure Storage*/
    UNION
SELECT 23 /*Alibaba Cloud Object Storage Service*/
	UNION
SELECT 21 /*Oracle Cloud Infrastructure Object Storage Classic*/
	UNION
SELECT 22 /*Oracle Cloud Infrastructure Archive Storage Classic*/
	UNION
SELECT 25 /*Oracle Cloud Infrastructure Object Storage (S3 Compatibility)*/
	UNION
SELECT 26 /*Oracle Cloud Infrastructure Object Storage*/
	UNION
SELECT 28 /*Oracle Cloud Infrastructure Archive Storage*/
	UNION
SELECT 40 /*S3 Compatible Storage*/
	IF OBJECT_ID('tempdb.dbo.#RecallLibraryList') IS NOT NULL DROP TABLE #RecallLibraryList
	CREATE TABLE #RecallLibraryList(LibraryId INT PRIMARY KEY)
	INSERT INTO #RecallLibraryList(LibraryId)
	SELECT DISTINCT MP.LibraryId
	FROM MMMountPath MP
	JOIN MMMountPathToStorageDevice  MSD ON MSD.MountPathId = MP.MountPathId
	JOIN MMDevice D ON D.DeviceId = MSD.DeviceId
	WHERE (EXISTS(SELECT 1
		FROM MMVolume V
		WHERE V.VolumeId = @i_volumeId
		AND MP.MediaSideId = V.MediaSideId)
	OR EXISTS(SELECT 1
		FROM MMDrivePool DPL
		JOIN MMDataPath DP ON DP.DrivePoolId = DPL.DrivePoolId
		WHERE DPL.MasterPoolId = MP.MasterPoolId AND DP.CopyId = @i_copyId))
	AND (D.DeviceTypeId IN (SELECT DeviceTypeId FROM #tempDeviceTypes)
OR (D.DeviceTypeId >= 200
AND D.DeviceTypeId <= 299))
	DECLARE @considerLifecyclePolicy INT = 0
-----------------------------------------------------------
--Check if there is data on archive tier
-----------------------------------------------------------
	IF EXISTS(SELECT 1
				FROM GxGlobalParam
WHERE name = 'EnableCloudLifecycleRecall'
				AND modified = 0
				AND value = 'true')
	BEGIN
		SET @considerLifecyclePolicy = 1
	END
	IF OBJECT_ID('tempdb.dbo.#ArchiveLibraryList') IS NOT NULL DROP TABLE #ArchiveLibraryList
	CREATE TABLE #ArchiveLibraryList(LibraryId INT)
	IF OBJECT_ID('tempdb.dbo.#GetCloudArchOutput') IS NOT NULL DROP TABLE #GetCloudArchOutput
	CREATE TABLE #GetCloudArchOutput(ArchStorageExists INT, CombinedTier INT)
	IF @considerLifecyclePolicy = 0
	BEGIN
		DECLARE @i_libraryId INT
		DECLARE @o_archStorageExists INT
		DECLARE @o_combinedTier INT
		DECLARE LIB_CUR CURSOR
		FOR SELECT LibraryId
		FROM #RecallLibraryList
		OPEN LIB_CUR
		FETCH NEXT FROM LIB_CUR
		INTO @i_libraryId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			DELETE FROM #GetCloudArchOutput
			INSERT INTO #GetCloudArchOutput(ArchStorageExists, CombinedTier)
			EXEC MMS2GetCloudLibArchiveMountPath @i_libraryId
			SELECT @o_archStorageExists = ArchStorageExists
			FROM #GetCloudArchOutput
			IF @o_archStorageExists = 1
			BEGIN
				INSERT INTO #ArchiveLibraryList
				SELECT @i_libraryId
			END
			FETCH NEXT FROM LIB_CUR
			INTO @i_libraryId
		END
		CLOSE LIB_CUR
		DEALLOCATE LIB_CUR
		DELETE R
		FROM #RecallLibraryList R
		LEFT JOIN #ArchiveLibraryList A ON A.LibraryId = R.LibraryId
		WHERE A.LibraryId IS NULL
	END
	IF NOT EXISTS(SELECT 1
		FROM #RecallLibraryList)
	BEGIN
		SET @o_errorCode = -6
		GOTO CX_EXIT
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_errorCode = -7
	SET @o_errorMessage = 'Error: PROC(' + ERROR_PROCEDURE() + '), LINE(' + CAST(ERROR_LINE() AS NVARCHAR(10)) +
		'), ERROR(' + CAST(ERROR_NUMBER() AS NVARCHAR(10)) + '), INFO: ' + ERROR_MESSAGE() + '.'
	;THROW @o_errorCode, @o_errorMessage, 1
END CATCH
CX_EXIT:
	IF @o_errorCode = -1
		SET @o_errorMessage = 'Error: Auto recall of archived files on cloud storage is disabled.'
	ELSE IF @o_errorCode = -2
		SET @o_errorMessage = 'Error: JobType is not supported for Auto recall of archived files.'
	ELSE IF @o_errorCode = -3
		SET @o_errorMessage = 'Error: Auto recall of archived files is not supported for the Agent.'
	ELSE IF @o_errorCode = -4
		SET @o_errorMessage = 'Error: Job has already been processed for Auto recall of archived files.'
	ELSE IF @o_errorCode = -5
SET @o_errorMessage = 'Error: Failed to get id for workflow [' + 'Cloud Storage Archive Recall' + '].'
	ELSE IF @o_errorCode = -6
		SET @o_errorMessage = 'Error: No archived files found for the AfId [' + ISNULL(TRY_CAST(@i_archFileId AS VARCHAR(MAX)), '0') + '].'
	ELSE IF @o_errorCode = -8
		SET @o_errorMessage = 'Error: Auto recall is not supported for VSA with V1 index.'
	IF OBJECT_ID('tempdb.dbo.#RunningCloudRecallJobs') IS NOT NULL DROP TABLE #RunningCloudRecallJobs
	IF object_id('tempdb.dbo.#tempDeviceTypes') is not null DROP TABLE #tempDeviceTypes
	IF OBJECT_ID('tempdb.dbo.#RecallLibraryList') IS NOT NULL DROP TABLE #RecallLibraryList
	IF OBJECT_ID('tempdb.dbo.#ArchiveLibraryList') IS NOT NULL DROP TABLE #ArchiveLibraryList
	IF OBJECT_ID('tempdb.dbo.#GetCloudArchOutput') IS NOT NULL DROP TABLE #GetCloudArchOutput
	SELECT @o_workflowId, @o_workflowUser, @o_isIndexRecall, @o_errorCode, @o_errorMessage
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ArchCheckCloudRecallRequired')
	delete from GxQscripts where name = 'ArchCheckCloudRecallRequired'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchCheckCloudRecallRequired')
	delete from GXDBVersions where aliasname = 'ArchCheckCloudRecallRequired'
GO

insert into GXDBVersions values(2, 'ArchCheckCloudRecallRequired',  '00000000000000000000', 'ArchCheckCloudRecallRequired', '00000000000000000000')
GO

