

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchBackupCopyFallenBehindAlert.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchBackupCopyFallenBehindAlert.sp,v $ $Id: ArchBackupCopyFallenBehindAlert.sp,v 1.1.2.3 2018/12/21 18:35:18 sudhanarayanan Exp $";
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE: "ArchBackupCopyFallenBehindAlert"     |
--  |                                   |
--  | Execute the System stored procedure to fetch the physical files   |
--  | .. for the (current) database.                    |
--  +-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ArchBackupCopyFallenBehindAlert')
BEGIN
	print '>>> Drop Stored Procedure: ArchBackupCopyFallenBehindAlert <<<'
	drop procedure ArchBackupCopyFallenBehindAlert
END
IF EXISTS (select * from GxQscripts where name='ArchBackupCopyFallenBehindAlert')
	delete from GxQscripts where name = 'ArchBackupCopyFallenBehindAlert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchBackupCopyFallenBehindAlert')
	delete from GXDBVersions where aliasname = 'ArchBackupCopyFallenBehindAlert'
GO
print '... Creating Procedure: ArchBackupCopyFallenBehindAlert'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure ArchBackupCopyFallenBehindAlert
  @i_dummy int
AS
  DECLARE @o_StoragePolicyId integer
  DECLARE @o_StoragePolicyName NVARCHAR(255)
  DECLARE @o_CopyId integer
  DECLARE @o_CopyName NVARCHAR(255)
  DECLARE @o_NoOfJobsToBeBackupCopied integer
DECLARE @unixTimeNow INTEGER = dbo.GetUnixTime(GETUTCDATE())
IF (OBJECT_ID('tempdb.dbo.#archGroupList') IS NOT NULL) DROP TABLE #archGroupList
create table #archGroupList(archGroupId integer, hoursInterval integer)
insert into #archGroupList
select EntityId, 0 from MMEntityProp WITH(READUNCOMMITTED) where propertyName = 'BackupCopyAlertEnabled' and entityType = 1 and intVal = 1
update tmp
set tmp.hoursInterval = PROP.intVal
from #archGroupList tmp
inner join MMEntityProp PROP WITH(READUNCOMMITTED) on PROP.EntityId = tmp.archGroupId and PROP.EntityType = 1 and PROP.propertyName = 'BackupCopyAlertInHours' and PROP.intVal > 0
update tmp
set tmp.hoursInterval =  (PROP.intVal * 24)
from #archGroupList tmp
inner join MMEntityProp PROP WITH(READUNCOMMITTED) on PROP.EntityId = tmp.archGroupId and PROP.EntityType = 1 and PROP.propertyName = 'BackupCopyAlertInDays' and PROP.intVal > 0
and tmp.hoursInterval = 0
select AG.id, AG.name, AGC.id, AGC.name, COUNT(JMS.jobId) from JMJobSnapshotStats JMS WITH(READUNCOMMITTED)
inner join JMBkpStats JM WITH(READUNCOMMITTED) on JMS.jobId = JM.jobId and JMS.commcellId = JM.commCellId and JMS.materializationStatus in (101,102,103) and (JMS.disabled & 1) = 0
inner join #archGroupList TMP on TMP.archGroupId = JMS.archGrpId and ( (@unixTimeNow - JM.servStartDate)/(60*60) ) >= TMP.hoursInterval
inner join archGroup AG WITH(READUNCOMMITTED) on TMP.archGroupId = AG.id
inner join archGroupCopy AGC WITH(READUNCOMMITTED) on AG.id = AGC.archGroupId and AG.defaultCopy = AGC.id
GROUP BY AG.id, AG.name, AGC.id, AGC.name
IF (OBJECT_ID('tempdb.dbo.#archGroupList') IS NOT NULL) DROP TABLE #archGroupList
GO

IF EXISTS (select * from GxQscripts where name = 'ArchBackupCopyFallenBehindAlert')
	delete from GxQscripts where name = 'ArchBackupCopyFallenBehindAlert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchBackupCopyFallenBehindAlert')
	delete from GXDBVersions where aliasname = 'ArchBackupCopyFallenBehindAlert'
GO

insert into GXDBVersions values(2, 'ArchBackupCopyFallenBehindAlert',  '00010001000200030000', 'ArchBackupCopyFallenBehindAlert', '00010001000200030000')
GO

