

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchAllowSynthFullToRun.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchAllowSynthFullToRun.sp,v $ $Id: ArchAllowSynthFullToRun.sp,v 1.1.2.1 2020/09/28 19:46:32 cliu Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ArchAllowSynthFullToRun')
BEGIN
	print '>>> Drop Stored Procedure: ArchAllowSynthFullToRun <<<'
	drop procedure ArchAllowSynthFullToRun
END
IF EXISTS (select * from GxQscripts where name='ArchAllowSynthFullToRun')
	delete from GxQscripts where name = 'ArchAllowSynthFullToRun'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchAllowSynthFullToRun')
	delete from GXDBVersions where aliasname = 'ArchAllowSynthFullToRun'
GO
print '... Creating Procedure: ArchAllowSynthFullToRun'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure ArchAllowSynthFullToRun
  @i_jobId integer,
  @i_commCellId integer
AS
  DECLARE @retVal integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
  SET @retVal = 1
  DECLARE @SYNTHFULLJOB INT = 7
  DECLARE @allowSynthFullToRun INT = 1
  SELECT @allowSynthFullToRun = value
  FROM	MMConfigs WITH (READUNCOMMITTED)
  WHERE	Name = 'MMCONFIG_RESOURCEMANAGER_ALLOW_SYNTHFULL_WHEN_DDB_PARTITION_OFFLINE'
  DECLARE @isPowerVMFeatureEnabled INT = 0
  DECLARE @HOST_STATUS_POWER_MANAGED_VM	INT = 7
  SET @isPowerVMFeatureEnabled = ISNULL ((SELECT value FROM MMConfigs WHERE name LIKE 'MMCONFIG_CLOUD_VM_MANAGEMENT_ENABLED_FLAG'), 0)
  DECLARE @jobType INT
  DECLARE @appId 	INT = 0
  DECLARE @archCopyId INT = 0
  DECLARE @dedupeFlags INT = 0
  DECLARE @sidbStoreId INT = 0
  SET @jobType = dbo.GetJobTypeForJobID(@i_jobId)
  IF @jobType = @SYNTHFULLJOB AND @allowSynthFullToRun = 0
  BEGIN
	-- Synthetic full job should have only one copy Id
	SELECT	TOP 1 @archCopyId = archGrpCopyId, @appId = appId
	FROM	JMJobDataStats WITH (READUNCOMMITTED)
	WHERE	jobId = @i_jobId AND commCellId = @i_commCellId
  	SELECT @dedupeFlags = dedupeFlags
	FROM	ArchGroupCopy WITH (READUNCOMMITTED)
	WHERE	id = @archCopyId
	SELECT @SIDBStoreId = SIDBStoreId
	FROM 	archSubclientCopyDDBMap WITH (readuncommitted)
	WHERE	appId = @appId
	AND		copyId = @archCopyId
	-- Don't alow synthtic full job run in resiliency mode with the option set to false
IF (@dedupeFlags & 8 > 0)
	BEGIN
		-- If any of the partitions are offline, then return false
		IF EXISTS (SELECT idxss.subStoreId
					FROM	MMHost host WITH (READUNCOMMITTED), IdxCache idxc WITH (READUNCOMMITTED),
							IdxAccessPath idxa WITH (READUNCOMMITTED), IdxSIDBSubStore idxss WITH (READUNCOMMITTED)
					WHERE	idxss.SIDBStoreId = @SIDBStoreId
					AND 		idxss.ClientId = host.ClientId
					AND		idxss.IdxCacheId = idxc.IdxCacheId
					AND		idxss.IdxAccessPathId = idxa.IdxAccessPathId
					-- not corrupted
					AND	(
(idxss.Status = 1)
					-- ddb move is not running ( all the comments here say inverse of what it checks)
OR (idxss.Flags & 1024 = 1024)
					-- Media Agent online
OR ((host.mmhostsoftstate = 0 AND ( host.OfflineReason <> @HOST_STATUS_POWER_MANAGED_VM OR @isPowerVMFeatureEnabled = 0)) OR host.mmhostenabled = 0  OR ((host.Attribute & 16) > 0))
					-- Index Cache online
						OR (idxc.Enabled = 0 OR idxc.SoftState = 0)
					-- Access Path online
						OR (idxa.Enabled = 0 OR idxa.SoftState = 0)
						)
					)
		BEGIN
			SET @retVal = 0
		END
	END
  END
FINISH:
  IF OBJECT_ID('tempdb.dbo.#tmpResutSetForArchAllowSynthFullToRun') IS NOT NULL
  BEGIN
	INSERT INTO #tmpResutSetForArchAllowSynthFullToRun
	SELECT @retVal
  END
  ELSE
	SELECT @retVal
  RETURN @retVal
GO

IF EXISTS (select * from GxQscripts where name = 'ArchAllowSynthFullToRun')
	delete from GxQscripts where name = 'ArchAllowSynthFullToRun'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchAllowSynthFullToRun')
	delete from GXDBVersions where aliasname = 'ArchAllowSynthFullToRun'
GO

insert into GXDBVersions values(2, 'ArchAllowSynthFullToRun',  '00010001000200010000', 'ArchAllowSynthFullToRun', '00010001000200010000')
GO

