

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ArchAgeJobs.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  ArchAgeJobs.sp                             */
/*                                                                            */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ArchAgeJobs.sp,v $ $Id: ArchAgeJobs.sp,v 1.1.2.9 2020/08/24 15:17:57 sjohnson Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ArchAgeJobs')
BEGIN
	print '>>> Drop Stored Procedure: ArchAgeJobs <<<'
	drop procedure ArchAgeJobs
END
IF EXISTS (select * from GxQscripts where name='ArchAgeJobs')
	delete from GxQscripts where name = 'ArchAgeJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchAgeJobs')
	delete from GXDBVersions where aliasname = 'ArchAgeJobs'
GO
print '... Creating Procedure: ArchAgeJobs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ArchAgeJobs
  @i_inputXml xml OUTPUT
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @l_appId 				INTEGER
DECLARE @skippedCode		INTEGER = 0
DECLARE @errorString		NVARCHAR(MAX) = ''
SET @l_appId = ISNULL(( SELECT ref.value('@appId', 'int')
                                    FROM   @i_inputXml . nodes('MediaManager_ArchAgeJobsReq') R ( ref )
                                ), 0)
DECLARE @jobsToRetain INT = 0
DECLARE @minJobTimeToRetain INT =0
DECLARE @retStatus INT = 0
SELECT @jobsToRetain = attrVal
FROM App_SubClientProp WITH (NOLOCK)
WHERE ComponentNameId = @l_appId
AND attrname = N'Virtual Server Number Of Snaps To Retain'
AND cs_attrName = CHECKSUM(N'Virtual Server Number Of Snaps To Retain') AND modified = 0
IF(ISNULL(@jobsToRetain, 0) <= 0)
	GOTO EXIT_PROC
DECLARE @isIndexingV2 INT = 0
SET @isIndexingV2 = dbo.IsIndexingV2Enabled(0, 0, @l_appId)
IF(@isIndexingV2 = 0)
BEGIN
	SELECT @minJobTimeToRetain = MIN(T.jobTimes)
	FROM
	(SELECT DISTINCT TOP (@jobsToRetain) JBKP.servStartDate "jobTimes"
	FROM JMBkpStats JBKP WITH (NOLOCK)
	INNER JOIN ArchGroup AG WITH (NOLOCK) ON JBKP.dataArchGrpId = AG.id
	INNER JOIN JMJobDataStats JDS WITH (NOLOCK)
	ON JBKP.jobId = JDS.jobID AND JBKP.commcellId = JDS.commcellId AND AG.defaultSnapCopy = JDS.archGrpCopyId
WHERE JBKP.appId = @l_appId AND JDS.status = 100 AND JDS.disabled & 256 = 0
	ORDER BY JBKP.servStartDate DESC) T
END
ELSE
BEGIN
	--For both V2 and V2.1 fetch minJobTimeToRetain based on child jobs
	SELECT @minJobTimeToRetain = MIN(T.jobTimes)
	FROM
	(SELECT DISTINCT TOP (@jobsToRetain) JBKP.servStartDate "jobTimes"
	FROM JMBkpStats JBKP WITH (NOLOCK)
	INNER JOIN ArchGroup AG WITH (NOLOCK) ON JBKP.dataArchGrpId = AG.id
INNER JOIN JMJobDataLink JDL WITH(NOLOCK) ON JBKP.jobId = JDL.parentJobID AND JBKP.commcellId = JDL.commcellId AND JDL.linkType = 7
	INNER JOIN JMJobDataStats JDS WITH (NOLOCK)
	ON JDL.childJobId = JDS.jobId AND JDL.commcellId = JDS.commcellId AND AG.defaultSnapCopy = JDS.archGrpCopyId
WHERE JBKP.appId = @l_appId AND JDS.status = 100 AND JDS.disabled & 256 = 0
	ORDER BY JBKP.servStartDate DESC) T
END
--Find current running replication job for the subclient and retain the latest valid snap job before the replication job. Assumption is replication job will be using that snap job
DECLARE @l_probableJobInUse int = 0
DECLARE @l_latestReplicationJobStartTime int = 0
SELECT @l_latestReplicationJobStartTime = MAX(jobStartTime) FROM JMJobInfo WITH(NOLOCK)
WHERE opType = 105 /* --enum CVOpType{ SITE_REPLICATION = 105 */ AND CAST(dbo.GetJobOption(jobid, 140007) AS INT) = @l_appId
IF @l_latestReplicationJobStartTime > 0
BEGIN
	SELECT TOP 1 @l_probableJobInUse = JBKP.jobId
	FROM JMBkpStats JBKP WITH(NOLOCK) WHERE JBKP.appId = @l_appId AND JBKP.status IN (1, 3, 14)
	AND JBKP.servEndDate < @l_latestReplicationJobStartTime AND JBKP.commcellId = 2 AND JBKP.opType = 59
	ORDER BY servStartDate desc
END
IF OBJECT_ID('tempdb..#JobsToPruneForVSALiveSync') IS NOT NULL
	DROP TABLE #JobsToPruneForVSALiveSync
CREATE TABLE #JobsToPruneForVSALiveSync (JobId INT, commCellId INT, fileType INT, archGrpId INT, archGrpCopyId INT, ignoreCheckFlags INT)
--This would fetch parent jobs if they are data bearing entities for both V1 and V2
INSERT INTO #JobsToPruneForVSALiveSync
SELECT JDS.JobId, JDS.commCellId, JDS.dataType, AG.id, JDS.archGrpCopyId, 128
FROM JMBkpStats JBKP WITH (NOLOCK)
INNER JOIN ArchGroup AG WITH (NOLOCK) ON JBKP.dataArchGrpId = AG.id
INNER JOIN JMJobDataStats JDS WITH (NOLOCK)
ON JBKP.jobId = JDS.jobID AND JBKP.commcellId = JDS.commcellId AND JDS.archGrpCopyId = AG.defaultSnapCopy
WHERE JDS.disabled & 256 = 0 AND JBKP.appId = @l_appId AND JBKP.servStartDate < @minJobTimeToRetain AND JBKP.jobId <> @l_probableJobInUse
--This would fetch child jobs for V2 (Query would handle both V2 and V2.1)
IF(@isIndexingV2 = 1)
BEGIN
	INSERT INTO #JobsToPruneForVSALiveSync
	SELECT JDS.jobId, JDS.commcellId, JDS.dataType, JDS.archGrpId, JDS.archGrpCopyId, 128
	FROM JMBkpStats JBKP WITH (NOLOCK)
	INNER JOIN ArchGroup AG WITH (NOLOCK) ON JBKP.dataArchGrpId = AG.id
INNER JOIN JMJobDataLink JDL WITH(NOLOCK) ON JBKP.JobId = JDL.parentJobId AND JBKP.commCellId = JDL.commCellId AND JDL.linkType = 7
	INNER JOIN JMJobDataStats JDS WITH(NOLOCK) ON JDL.childJobId = JDS.jobId AND JDL.commcellId = JDS.commcellId AND AG.defaultSnapCopy = JDS.archGrpCopyId
WHERE JDS.disabled & 256 = 0 AND JBKP.appId = @l_appId AND JBKP.servStartDate < @minJobTimeToRetain AND JBKP.jobId <> @l_probableJobInUse
END
DECLARE @jobsToPruneXML xml
SET @jobsToPruneXML = CAST(('<GalaxyOperations_PruneJobs>' +
                        CAST (
                        (SELECT JobId, commCellId, fileType, archGrpId, archGrpCopyId, ignoreCheckFlags FROM #JobsToPruneForVSALiveSync "JobInfo" FOR XML AUTO) AS NVARCHAR(MAX)
                        ) +
                        '</GalaxyOperations_PruneJobs>') AS XML)
IF OBJECT_ID('tempdb.dbo.#tmpRetVal') IS NOT NULL
	DROP TABLE #tmpRetVal
CREATE TABLE #tmpRetVal(retVal INT, errorString VARCHAR(1024), skippedCode INT, prunedJobIdList VARCHAR(MAX))
EXEC deleteMultipleBackupByJobCopy 1, @jobsToPruneXML
SELECT TOP 1 @retStatus = retVal, @skippedCode = skippedCode, @errorString = errorString
FROM #tmpRetVal
IF(@retStatus = 0)
BEGIN
	PRINT 'LOG_LOW:ArchAgeJobsReq - ' + CAST(@i_inputXml AS VARCHAR(MAX)) + ' Aged jobs - ' + CAST(@jobsToPruneXML AS VARCHAR(MAX))
	IF (@skippedCode > 0)
	BEGIN
		PRINT 'Skipped Reasons: ' + @errorString
	END
END
ELSE
BEGIN
	PRINT 'ArchAgeJobsReq - ' + CAST(@i_inputXml AS VARCHAR(MAX)) + '. Failed for - ' + CAST(@jobsToPruneXML AS VARCHAR(MAX)) + '. RetCode - ' + CAST(@retStatus AS varchar(10))
	PRINT 'Error: ' + @errorString
END
EXIT_PROC:
	SELECT @i_inputXml = CAST(('<MediaManager_ArchAgeJobsResp retStatus = "' + CAST(@retStatus AS VARCHAR(10)) + '"/>') AS XML)
GO

IF EXISTS (select * from GxQscripts where name = 'ArchAgeJobs')
	delete from GxQscripts where name = 'ArchAgeJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ArchAgeJobs')
	delete from GXDBVersions where aliasname = 'ArchAgeJobs'
GO

insert into GXDBVersions values(2, 'ArchAgeJobs',  '00010001000200090000', 'ArchAgeJobs', '00010001000200090000')
GO

