

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/App_UpdateClientAccessControl.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/App_UpdateClientAccessControl.sp,v $ $Id: App_UpdateClientAccessControl.sp,v 1.1.2.5 2020/07/20 20:44:06 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  App_UpdateClientAccessControl()
--  |
--  | Description:  Update client permissions
--  |
--  |       Input:  PrivilegedClientId, AccessedClientId
--	|
--  |      Output:  xxx
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
------------------------------------------------------------------------------
set nocount on
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='App_UpdateClientAccessControl')
BEGIN
	print '>>> Drop Stored Procedure: App_UpdateClientAccessControl <<<'
	drop procedure App_UpdateClientAccessControl
END
IF EXISTS (select * from GxQscripts where name='App_UpdateClientAccessControl')
	delete from GxQscripts where name = 'App_UpdateClientAccessControl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='App_UpdateClientAccessControl')
	delete from GXDBVersions where aliasname = 'App_UpdateClientAccessControl'
GO
print '... Creating Procedure: App_UpdateClientAccessControl'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure App_UpdateClientAccessControl
  @PrivilegedClientId INT,
  @AccessedClientId INT
AS
Declare @rcnt int = 0
CREATE TABLE #tempAccessControlTable (
    id int primary key
)
Insert into #tempAccessControlTable (id)
select id from App_ClientAccessControl with (NOLOCK) where PrivilegedClientId = @PrivilegedClientId and AccessedClientId = @AccessedClientId
set @rcnt = @@ROWCOUNT
if (@rcnt = 0)
begin
    insert into App_ClientAccessControl (PrivilegedClientId, AccessedClientId, CreationTime, insertedBy) values (@PrivilegedClientId, @AccessedClientId, CURRENT_TIMESTAMP, 0) -- 0 means inserted by JM
end
else
begin
    UPDATE a
        set CreationTime = CURRENT_TIMESTAMP,insertedBy = 0,remoteProcessName = '', accessType = 1
        FROM App_ClientAccessControl a
        INNER JOIN #tempAccessControlTable t on
        t.id = a.id
end
GO

IF EXISTS (select * from GxQscripts where name = 'App_UpdateClientAccessControl')
	delete from GxQscripts where name = 'App_UpdateClientAccessControl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='App_UpdateClientAccessControl')
	delete from GXDBVersions where aliasname = 'App_UpdateClientAccessControl'
GO

insert into GXDBVersions values(2, 'App_UpdateClientAccessControl',  '00010001000200050000', 'App_UpdateClientAccessControl', '00010001000200050000')
GO

