

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/App_SetMongoDbSCPriority.sp] ---------- 

-- This will generate the revision for the stored procedure. Don't remove this line!!!
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/App_SetMongoDbSCPriority.sp,v $ $Id: App_SetMongoDbSCPriority.sp,v 1.1.2.5 2019/05/13 21:31:19 skummali Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='App_SetMongoDbSCPriority')
BEGIN
	print '>>> Drop Stored Procedure: App_SetMongoDbSCPriority <<<'
	drop procedure App_SetMongoDbSCPriority
END
IF EXISTS (select * from GxQscripts where name='App_SetMongoDbSCPriority')
	delete from GxQscripts where name = 'App_SetMongoDbSCPriority'
GO

IF EXISTS (select * from GXDBVersions where aliasname='App_SetMongoDbSCPriority')
	delete from GXDBVersions where aliasname = 'App_SetMongoDbSCPriority'
GO
print '... Creating Procedure: App_SetMongoDbSCPriority'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure App_SetMongoDbSCPriority
-- Input variables of the stored procedure
  @in_subclientId int,
  @in_instanceId int,
  @in_opType int,
  @in_nodePriorityList XML
AS
-- OpType Reference
-- 1 - Update
-- 2 - Sync when nodes are refreshed
IF object_id('temp.dbo.#Ranked_Nodes') IS NOT null DROP TABLE #Ranked_Nodes
IF @in_opType = 1 AND @in_subclientId <> 0 AND @in_instanceId <> 0
BEGIN
	SELECT IDENTITY(int, 1,1)as id,
		   mongo.repset.value('(client/@clientId)[1]', 'INT') as nodeClientId,
		   mongo.repset.value('@portNumber', 'INT') as portNumber,
		   mongo.repset.value('@repsetName', 'NVARCHAR(225)') as repsetname
	INTO #Ranked_Nodes
	FROM @in_nodePriorityList.nodes('/App_DataAccessNodes/mongoDataAccessNodes/repsetClient') mongo(repset)
	DELETE APP_MongoDbSCPriority
	WHERE subclientId =  @in_subclientId
	INSERT INTO APP_MongoDbSCPriority
	SELECT
	assoc.id, @in_subclientId, RANK() OVER(PARTITION BY rn.repsetname ORDER BY rn.id ASC)
	FROM #Ranked_Nodes rn
		JOIN APP_MongoDbAssociation assoc ON rn.nodeClientId = assoc.clientId AND rn.portNumber = assoc.portNumber
	WHERE
		assoc.instanceId = @in_instanceId  AND assoc.modified = 0
END
ELSE IF @in_opType = 2 AND @in_instanceId <> 0
BEGIN
	WITH
		NewNodes AS	(SELECT assoc.id as mdbNode FROM
					APP_MongoDbAssociation assoc LEFT JOIN
					APP_MongoDbSCPriority prio ON prio.mdbNode = assoc.id
					WHERE assoc.instanceId = @in_instanceId
						AND prio.id IS NULL
						AND assoc.role IN (1,2)), -- Only PRIMARY and SECONDARY new nodes
		SCPriority AS (SELECT app.id as scId ,MAX(ISNULL(prio.priority,0))+1 as priority FROM
					APP_MongoDbAssociation assoc JOIN
					APP_Application app on assoc.instanceId = app.instance LEFT JOIN
					APP_MongoDbSCPriority prio ON prio.mdbNode = assoc.id AND app.id = prio.subclientId
					WHERE assoc.instanceId = @in_instanceId
					GROUP BY app.id
					)
	INSERT INTO APP_MongoDbSCPriority
	SELECT mdbNode, scId, priority
	FROM NewNodes nn,SCPriority scp
END
ELSE
BEGIN
	DECLARE @errorMessage VARCHAR(300) = 'Invaid Inputs!  subclientId:' + CONVERT(VARCHAR(15), @in_subclientId) + ', instanceId:'+ CONVERT(VARCHAR(15), @in_instanceId) + ', opType:' + CONVERT(VARCHAR(15), @in_opType)
	RAISERROR(@errorMessage, 16, 1)
END
IF object_id('temp.dbo.#Ranked_Nodes') IS NOT null DROP TABLE #Ranked_Nodes
GO

IF EXISTS (select * from GxQscripts where name = 'App_SetMongoDbSCPriority')
	delete from GxQscripts where name = 'App_SetMongoDbSCPriority'
GO

IF EXISTS (select * from GXDBVersions where aliasname='App_SetMongoDbSCPriority')
	delete from GXDBVersions where aliasname = 'App_SetMongoDbSCPriority'
GO

insert into GXDBVersions values(2, 'App_SetMongoDbSCPriority',  '00010001000200050000', 'App_SetMongoDbSCPriority', '00010001000200050000')
GO

