

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/App_SetCurrencyInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APP_SetCurrencyInfo.sp,v $ $Id: APP_SetCurrencyInfo.sp,v 1.3.2.2 2018/03/27 08:48:13 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  APP_SetCurrencyInfo()
--  |
--  | Description: sets currency preference.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APP_SetCurrencyInfo')
BEGIN
	print '>>> Drop Stored Procedure: APP_SetCurrencyInfo <<<'
	drop procedure APP_SetCurrencyInfo
END
IF EXISTS (select * from GxQscripts where name='APP_SetCurrencyInfo')
	delete from GxQscripts where name = 'APP_SetCurrencyInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APP_SetCurrencyInfo')
	delete from GXDBVersions where aliasname = 'APP_SetCurrencyInfo'
GO
print '... Creating Procedure: APP_SetCurrencyInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APP_SetCurrencyInfo
  @i_xmlText XML
AS
  DECLARE @errorCode int 
  DECLARE @errorString varchar(4000)
  DECLARE @r_ReturnResult xml
SET NOCOUNT ON
SET @errorCode = 0
SET @errorString = 'ERROR: GENERAL ERROR!'
BEGIN TRY
DECLARE @currency  nvarchar(100)
SET @currency = ( SELECT @i_xmlText.value('/EVGui_SetPreferredCurrency[1]/currencyInfo[1]/@currentPreference','nvarchar(100)') )
update GXGlobalParam
set value = @currency
where name ='CurrentCurrencyPreference'
SET @errorString = 'NO_ERROR'
GOTO SCRIPT_EXIT
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = @@ERROR
	SET @errorString = 'Failed to set currency preference. ERROR_NUMBER: '+ cast(ERROR_NUMBER() as varchar(10))+' ERROR_LINE: '+cast(ERROR_LINE() as varchar(10))+' ERROR_MESSAGE: '+ISNULL(ERROR_MESSAGE(), 'UNKNOWN')
	GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
	IF @errorCode <> 0
	BEGIN
		RAISERROR ('%s' , 16, 1, @errorString)
		SET @r_ReturnResult = ( SELECT  1               as TAG,
			NULL           as Parent,
			@errorCode       as [EVGui_GenericResp!1!errorCode],
			@errorString as [EVGui_GenericResp!1!errorMessage]
			FOR XML EXPLICIT
		);
	END
	ELSE
	BEGIN
	SET @r_ReturnResult = ( SELECT  1               as TAG,
			NULL           as Parent,
			@errorCode       as [EVGui_GenericResp!1!errorCode],
			'' as [EVGui_GenericResp!1!errorMessage]
			FOR XML EXPLICIT
		);
	END
SET NOCOUNT OFF
SELECT @r_ReturnResult;
GO

IF EXISTS (select * from GxQscripts where name = 'App_SetCurrencyInfo')
	delete from GxQscripts where name = 'App_SetCurrencyInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='App_SetCurrencyInfo')
	delete from GXDBVersions where aliasname = 'App_SetCurrencyInfo'
GO

insert into GXDBVersions values(2, 'App_SetCurrencyInfo',  '00010003000200020000', 'App_SetCurrencyInfo', '00010003000200020000')
GO

