

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/App_RegisterDevice.sp] ---------- 

-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "App_GetAuditedSessions"
--	|	This Procedure is used to modify/add/delete users
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: App_RegisterDevice <<<'

IF EXISTS (select * from sysobjects where name='App_RegisterDevice')
	drop procedure App_RegisterDevice
IF EXISTS (select * from GxQscripts where name='App_RegisterDevice')
	delete from GxQscripts where name = 'App_RegisterDevice'
GO

IF EXISTS (select * from GXDBVersions where aliasname='App_RegisterDevice')
	delete from GXDBVersions where aliasname = 'App_RegisterDevice'
GO
print '... Creating Procedure: App_RegisterDevice'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure App_RegisterDevice
  @userId integer,
  @deviceId nvarchar(128),
  @appId nvarchar(2048),
  @osId integer,
  @devicename nvarchar(256),
  @hostname nvarchar(256),
  @timeSkew bigint,
  @password nvarchar(256)
AS
	declare @now bigint = dbo.GetUnixTime(GETUTCDATE())
	declare @deviceClientId int = 0
	declare @lastError int = 0
	declare @localErrorMsg nvarchar(1024)= ''
	declare @oldAppKey nvarchar(1024) = ''
	---------------------------------------------------
	-- Audit Parameters
	---------------------------------------------------
	DECLARE @opMsgId            INTEGER
	DECLARE @opEvMsgId          INTEGER
	DECLARE @opId               INTEGER
	DECLARE @paramMsgId         INTEGER
	DECLARE @paramData          NVARCHAR(1024)
	DECLARE @dataIsEvent        INTEGER = 0
	----------------------------------------------------
BEGIN TRAN
	BEGIN TRY
	-- Check if there already exists a client for this device
	SELECT @deviceClientId = id from APP_Client where GUID = @deviceId
	IF (@deviceClientId = 0)
			BEGIN
				insert into App_Client(name, simOperatingSystemId, net_hostname, client_password, refTime, modified, offlineEntity, offlineTimeStamp, csHostName, clientDescription, jobResultDir,
							clientSkewTime, cvdPort, evmgrcPort, status, releaseId, spaceCheckFlags, ccpId, ccpTime, origCCId, GUID, specialClientFlags, displayName)
							Values(@devicename, @osId, @hostname, @password, @now, 0, 0, 0, '', '', '', @timeSkew, 0, 0, 0, 0, 0, 0, 0, 0, @deviceId, 0, @deviceName)
				SET @deviceClientId = SCOPE_IDENTITY()
				---------------------------------------------------------------------------------
												--Audit trail
				---------------------------------------------------------------------------------
SET @opMsgId = (584 | (CAST(POWER(2, 24) AS BIGINT) * 84))
				EXEC EvGuiAuditSetOperation @opMsgId, @userId, @opEvMsgId OUTPUT, @opId OUTPUT
SET @paramMsgId  = (1599 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				 SET @paramData = @devicename
				 EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
				 EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
SET @paramMsgId  = (1600 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				 SET @paramData = IIF(@osId = 215,'iOS','Android')
				 EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
				 EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
SET @paramMsgId  = (1597 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				 SET @paramData = @hostname
				 EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
				 EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
SET @paramMsgId  = (1598 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				 SET @paramData = CONVERT(NVARCHAR(1024), @deviceId)
				 EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
				 EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
				 --------------------------------------------------------------------------------
			END
		-- Add owner if not exists already
		if NOT EXISTS(select 1 from UMOWNERS where entityId = @deviceClientId and userOrGroupId = @userId and isUser = 1)	-- add user in owners if not already an owner.
		BEGIN
			-- Add owner
			insert into UMOWNERS(entityType, entityId, userOrGroupId, isUser, authorId, flags) values(3, @deviceClientId, @userId, 1, @userId, 1)
			---------------------------------------------------------------------------------
												--Audit trail
			---------------------------------------------------------------------------------
SET @opMsgId = (584 | (CAST(POWER(2, 24) AS BIGINT) * 84))
			EXEC EvGuiAuditSetOperation @opMsgId, @userId, @opEvMsgId OUTPUT, @opId OUTPUT
SET @paramMsgId  = (583 | (CAST(POWER(2, 24) AS BIGINT) * 84))
			SET @paramData = CONVERT(NVARCHAR(1024), @userId)
			EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
			---------------------------------------------------------------------------------
		END
		-- Add properties if not already present
		IF(@appId IS NOT NULL AND @appId <> '')
		BEGIN
			IF NOT EXISTS(SELECT 1 FROM APP_CLIENTPROP WHERE ComponentNameId = @deviceClientId AND attrname = 'ApplicationId' AND Modified = 0)
			BEGIN
				INSERT INTO APP_CLIENTPROP(componentNameId, attrName, attrVal, attrType, created, modified, ccpid) Values(@deviceClientId, 'ApplicationId', @appId, 10, @now, 0, 0)
				---------------------------------------------------------------------------------
												--Audit trail
				---------------------------------------------------------------------------------
SET @opMsgId = (582 | (CAST(POWER(2, 24) AS BIGINT) * 84))
				EXEC EvGuiAuditSetOperation @opMsgId, @userId, @opEvMsgId OUTPUT, @opId OUTPUT
SET @paramMsgId  = (1596 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				SET @paramData = @appId
				EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
				---------------------------------------------------------------------------------
			END
			-- Update property in case it has changed recently.
			ELSE
			BEGIN
				SELECT @oldAppKey = attrName from APP_CLIENTPROP WHERE COMPONENTNAMEID = @deviceClientId AND attrName = 'ApplicationId'
				UPDATE APP_CLIENTPROP SET attrVal = @appId WHERE COMPONENTNAMEID = @deviceClientId AND attrName = 'ApplicationId'
				---------------------------------------------------------------------------------
												--Audit trail
				---------------------------------------------------------------------------------
SET @opMsgId = (585 | (CAST(POWER(2, 24) AS BIGINT) * 84))
				EXEC EvGuiAuditSetOperation @opMsgId, @userId, @opEvMsgId OUTPUT, @opId OUTPUT
SET @paramMsgId  = (1602 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				SET @paramData = @appId
				EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
				SET @paramData = @oldAppKey
				EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
				---------------------------------------------------------------------------------
			END
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		Set @lastError      = ERROR_NUMBER()
		SET @localErrorMsg  = ERROR_MESSAGE()
	END   CATCH
	IF @lastError  = 0
		COMMIT TRAN
	ELSE
		ROLLBACK TRAN
	-- return clientId
	select @deviceClientId
GO

IF EXISTS (select * from GxQscripts where name = 'App_RegisterDevice')
	delete from GxQscripts where name = 'App_RegisterDevice'
GO

IF EXISTS (select * from GXDBVersions where aliasname='App_RegisterDevice')
	delete from GXDBVersions where aliasname = 'App_RegisterDevice'
GO

insert into GXDBVersions values(2, 'App_RegisterDevice',  '00000000000000000000', 'App_RegisterDevice', '00000000000000000000')
GO

