

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/App_IsClientExcludedFromSLA.sp] ---------- 

-------------------------------------------------------------------
------ SP : to check if a client is excluded from sla
------ input: clientId
-------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: App_IsClientExcludedFromSLA <<<'

IF EXISTS (select * from sysobjects where name='App_IsClientExcludedFromSLA')
	drop procedure App_IsClientExcludedFromSLA
IF EXISTS (select * from GxQscripts where name='App_IsClientExcludedFromSLA')
	delete from GxQscripts where name = 'App_IsClientExcludedFromSLA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='App_IsClientExcludedFromSLA')
	delete from GXDBVersions where aliasname = 'App_IsClientExcludedFromSLA'
GO
print '... Creating Procedure: App_IsClientExcludedFromSLA'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure App_IsClientExcludedFromSLA
  @clientId INT
AS
  DECLARE @isExcluded INT
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @isExcluded = ISNULL((SELECT attrVal FROM App_ClientProp WHERE componentNameId = @clientId AND modified = 0 AND attrName='Exclude from SLA'),0)
--if not excluded, check from clientgroup level
IF @isExcluded <> 1
BEGIN
	SET @isExcluded=(SELECT count(1) FROM APP_ClientGroupAssoc Assoc
					 INNER JOIN App_ComponentProp Prop
					 ON Assoc.ClientId = @clientId AND Assoc.clientGroupId = Prop.componentId
AND Prop.propertyTypeId = 3301 AND Prop.componentType = 8
					 AND Prop.modified = 0 AND Prop.longVal = 1)
END
SELECT @isExcluded
GO

IF EXISTS (select * from GxQscripts where name = 'App_IsClientExcludedFromSLA')
	delete from GxQscripts where name = 'App_IsClientExcludedFromSLA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='App_IsClientExcludedFromSLA')
	delete from GXDBVersions where aliasname = 'App_IsClientExcludedFromSLA'
GO

insert into GXDBVersions values(2, 'App_IsClientExcludedFromSLA',  '00000000000000000000', 'App_IsClientExcludedFromSLA', '00000000000000000000')
GO

