

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/App_GetOrganizationForClient.sp] ---------- 

-- ALLOW_COMMENTS_BELOW_HERE:
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- ----------------------------------------------------------------------
--
--        Gets the organization to which the client belongs
--
-- ----------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='App_GetOrganizationForClient')
BEGIN
	print '>>> Drop Stored Procedure: App_GetOrganizationForClient <<<'
	drop procedure App_GetOrganizationForClient
END
IF EXISTS (select * from GxQscripts where name='App_GetOrganizationForClient')
	delete from GxQscripts where name = 'App_GetOrganizationForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='App_GetOrganizationForClient')
	delete from GXDBVersions where aliasname = 'App_GetOrganizationForClient'
GO
print '... Creating Procedure: App_GetOrganizationForClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure App_GetOrganizationForClient
  @clientId INT
AS
  DECLARE @organizationName NVARCHAR(510)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
    IF object_id('tempdb.dbo.#tmpOwnerList') IS NOT NULL
		DROP TABLE #tmpOwnerList
    CREATE TABLE #tmpOwnerList(userId INT, userGroupId INT,organizationName NVARCHAR(510))
	CREATE NONCLUSTERED INDEX #tmpOwnerList_userId_Index ON #tmpOwnerList ([userId])
	CREATE NONCLUSTERED INDEX #tmpOwnerList_userGroupId_Index ON #tmpOwnerList ([userGroupId])
	INSERT INTO #tmpOwnerList (userId,userGroupId)
	SELECT userId, userGroupId FROM sec_getClientOwnersWithParam(@clientId,0,0)
	UPDATE tmp SET organizationName = prov.domainName
	FROM #tmpOwnerList tmp
	INNER JOIN umusers ON tmp.userId = umusers.id AND tmp.userId<>0
INNER JOIN UMDSProviders prov on prov.id=umusers.umDSproviderId and prov.enabled=1 and prov.serviceType= 5
    UPDATE tmp SET  organizationName = prov.domainName
	FROM #tmpOwnerList tmp
	INNER JOIN umgroups ON tmp.userGroupId = umgroups.id AND tmp.userGroupId<>0
INNER JOIN UMDSProviders prov on prov.id=umgroups.umDSproviderId and prov.enabled=1 and prov.serviceType= 5
	SELECT DISTINCT organizationName FROM #tmpOwnerList WHERE organizationName IS NOT NULL
	UNION
	SELECT domainName FROM umdsproviders WHERE id IN
		( SELECT CAST(attrval AS INT) FROM App_ClientProp WHERE modified = 0 AND componentNameId = @clientId AND attrName = 'Installation company ID') AND id<>0
	DROP TABLE #tmpOwnerList
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'App_GetOrganizationForClient')
	delete from GxQscripts where name = 'App_GetOrganizationForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='App_GetOrganizationForClient')
	delete from GXDBVersions where aliasname = 'App_GetOrganizationForClient'
GO

insert into GXDBVersions values(2, 'App_GetOrganizationForClient',  '00000000000000000000', 'App_GetOrganizationForClient', '00000000000000000000')
GO

