

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/App_GetDomainBasedAccess.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/App_GetDomainBasedAccess.sp,v $ $Id: App_GetDomainBasedAccess.sp,v 1.1.2.1 2019/10/24 02:25:24 jiechen Exp $";
--  +==============================================================================================================+
--  | Name:  App_GetDomainBasedAccess
--  | Description: Takes remoteClientId and clientId returns whether remoteClientId is infrastructure machine and is
--	| in the same domain as the client
--  +==============================================================================================================+
set nocount on
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='App_GetDomainBasedAccess')
BEGIN
	print '>>> Drop Stored Procedure: App_GetDomainBasedAccess <<<'
	drop procedure App_GetDomainBasedAccess
END
IF EXISTS (select * from GxQscripts where name='App_GetDomainBasedAccess')
	delete from GxQscripts where name = 'App_GetDomainBasedAccess'
GO

IF EXISTS (select * from GXDBVersions where aliasname='App_GetDomainBasedAccess')
	delete from GXDBVersions where aliasname = 'App_GetDomainBasedAccess'
GO
print '... Creating Procedure: App_GetDomainBasedAccess'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure App_GetDomainBasedAccess
  @i_xml xml
AS
  DECLARE @o_xml xml
DECLARE @companyId_MA int
DECLARE @companyId_Client int
DECLARE @errorCode int = 0
DECLARE @errorMessage varchar(max)
DECLARE @remoteClientId INT = ISNULL((SELECT ref.value('@remoteClientId', 'INT') FROM @i_xml.nodes ('App_GetDomainBasedAccessRequest') R(ref)), 1) -- 1 for NO_CLIENT
DECLARE @clientId INT = ISNULL((SELECT ref.value('@clientId', 'INT')  FROM @i_xml.nodes ('App_GetDomainBasedAccessRequest') R(ref)), 1)
---------------------------------------------------------------------------
--return companyId for remoteClient if it is MA, null if it is not MA------
---------------------------------------------------------------------------
select @companyId_MA = companyId
from UMSecurityAssociations with (nolock)
where entityType1 = 11
and isCreator = 1
and entityId1 = @remoteClientId
IF @companyId_MA IS NULL
BEGIN
set @errorCode = 1
	set @errorMessage = 'Remote client is not MA'
	goto proc_exit
END
------------------------------------------------
-----find companyId for client------------------
------------------------------------------------
IF object_id('tempdb.dbo.#domainInfoForClient') IS NOT NULL
	drop table #domainInfoForClient
create table #domainInfoForClient(
	ownerCompanyId    INT,
	ownerUserID       INT,
domainName        NVARCHAR(255),
userGroupName     NVARCHAR(255),
	errorCode         INT ,
	errorString       VARCHAR(MAX)
)
insert into #domainInfoForClient
exec AppGetCustomDomainInfo @clientId
select @companyId_client = ownerCompanyId from #domainInfoForClient
if @companyId_client = @companyId_MA
BEGIN
set @errorCode = 0
	set @errorMessage = 'MA and client have same companyId [' + cast(@companyId_client as varchar(10)) + '] '
END
ELSE
BEGIN
set @errorCode = 2
	set @errorMessage = 'MA and client have different companyId ['
					+ cast(@companyId_MA as varchar(10)) + ' and ['
					+ cast(@companyId_client as varchar(10)) + ']. '
END
PROC_EXIT:
SET @o_xml =
    (select @remoteClientId  as '@PrivilegedClientId',
       @clientId as '@AccessedClientId',
       @errorCode as '@errorCode',
       @errorMessage as '@errorMessage'
       FOR XML PATH('App_GetDomainBasedAccessResponse'), type)
SELECT @o_xml AS [o_xml]
GO

IF EXISTS (select * from GxQscripts where name = 'App_GetDomainBasedAccess')
	delete from GxQscripts where name = 'App_GetDomainBasedAccess'
GO

IF EXISTS (select * from GXDBVersions where aliasname='App_GetDomainBasedAccess')
	delete from GXDBVersions where aliasname = 'App_GetDomainBasedAccess'
GO

insert into GXDBVersions values(2, 'App_GetDomainBasedAccess',  '00010001000200010000', 'App_GetDomainBasedAccess', '00010001000200010000')
GO

