

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/App_GetDeniedClientForCompany.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/App_GetDeniedClientForCompany.sp,v $ $Id: App_GetDeniedClientForCompany.sp,v 1.1.2.1 2020/05/27 17:40:28 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='App_GetDeniedClientForCompany')
BEGIN
	print '>>> Drop Stored Procedure: App_GetDeniedClientForCompany <<<'
	drop procedure App_GetDeniedClientForCompany
END
IF EXISTS (select * from GxQscripts where name='App_GetDeniedClientForCompany')
	delete from GxQscripts where name = 'App_GetDeniedClientForCompany'
GO

IF EXISTS (select * from GXDBVersions where aliasname='App_GetDeniedClientForCompany')
	delete from GXDBVersions where aliasname = 'App_GetDeniedClientForCompany'
GO
print '... Creating Procedure: App_GetDeniedClientForCompany'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure App_GetDeniedClientForCompany
  @i_companyId INTEGER
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF object_id('tempdb.dbo.#App_GetDeniedClientForCompanyOutputTbl') IS NULL
BEGIN
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/SPBodies/App_GetDeniedClientForCompany.spb,v $ $Id: App_GetDeniedClientForCompany.spb,v 1.1.2.1 2020/05/27 17:36:43 jiechen Exp $";
-- Query to get black list clients for given company Id.
-- Gets the clients on which this company user / group has roles in Security table
-- MINUS
-- Clients that belong to this company (or child companies) or parent companies / MSP that has been shared with this company.
;WITH CTEChildCompanies(companyId)              -- Child companies of given company Id.
AS
(
   SELECT id AS companyId
   FROM UMDSProviders (NOLOCK)
   WHERE
		  id = @i_companyId
   UNION ALL
   SELECT P.id AS companyId
   FROM UMDSProviders P (NOLOCK)
		  INNER JOIN CTEChildCompanies CC
				 ON P.ownerCompany = CC.companyId
AND P.serviceType = 5
),
CTEParentCompanies(companyId)                          -- Parent companies of given company Id.
AS
(
   SELECT ownerCompany AS companyId
   FROM UMDSProviders (NOLOCK)
   WHERE
		  id = @i_companyId
   UNION ALL
   SELECT P.ownerCompany AS companyId
   FROM UMDSProviders P (NOLOCK)
		  INNER JOIN CTEParentCompanies CC
				 ON P.id = CC.companyId
AND P.serviceType = 5
)
-- Clients on which this company user / group has been given explicit roles.
SELECT entityId1
FROM UMSecurityAssociations Sec
WHERE
entityType1 = 3
	  AND companyId = @i_companyId
UNION
SELECT entityId
FROM UMOwners O
WHERE
entityType = 3
	  AND companyId = @i_companyId
EXCEPT
(
  -- These are the valid clients for this company. They belong to this company or child companies
  -- or parent company or MSP and shared with this company.
  SELECT CP.componentNameId
  FROM App_ClientProp CP(NOLOCK)
         INNER JOIN CTEChildCompanies CCT
               ON CP.attrName = 'Installation Company Id'
               AND CP.attrVal = CAST(CCT.companyId AS VARCHAR(10))
               AND CP.modified = 0
  UNION
  SELECT CP.componentNameId
  FROM App_ClientProp CP(NOLOCK)
         INNER JOIN CTEParentCompanies CPT
               ON CP.attrName = 'Installation Company Id'
               AND CP.attrVal = CAST(CPT.companyId AS VARCHAR(10))
               AND CP.modified = 0
  UNION
  SELECT C.id           -- If property is not present, then assume it as 0(MSP).
  FROM APP_Client C (NOLOCK)
    LEFT OUTER JOIN APP_ClientProp CP (NOLOCK)
        ON C.id = CP.componentNameId
        AND CP.attrName = 'Installation Company Id'
        AND CP.modified = 0
  WHERE
    CP.componentNameId IS NULL
)
END
ELSE
BEGIN
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/SPBodies/App_GetDeniedClientForCompany.spb,v $ $Id: App_GetDeniedClientForCompany.spb,v 1.1.2.1 2020/05/27 17:36:43 jiechen Exp $";
-- Query to get black list clients for given company Id.
-- Gets the clients on which this company user / group has roles in Security table
-- MINUS
-- Clients that belong to this company (or child companies) or parent companies / MSP that has been shared with this company.
;WITH CTEChildCompanies(companyId)              -- Child companies of given company Id.
AS
(
   SELECT id AS companyId
   FROM UMDSProviders (NOLOCK)
   WHERE
		  id = @i_companyId
   UNION ALL
   SELECT P.id AS companyId
   FROM UMDSProviders P (NOLOCK)
		  INNER JOIN CTEChildCompanies CC
				 ON P.ownerCompany = CC.companyId
AND P.serviceType = 5
),
CTEParentCompanies(companyId)                          -- Parent companies of given company Id.
AS
(
   SELECT ownerCompany AS companyId
   FROM UMDSProviders (NOLOCK)
   WHERE
		  id = @i_companyId
   UNION ALL
   SELECT P.ownerCompany AS companyId
   FROM UMDSProviders P (NOLOCK)
		  INNER JOIN CTEParentCompanies CC
				 ON P.id = CC.companyId
AND P.serviceType = 5
)
INSERT INTO #App_GetDeniedClientForCompanyOutputTbl
-- Clients on which this company user / group has been given explicit roles.
SELECT entityId1
FROM UMSecurityAssociations Sec
WHERE
entityType1 = 3
	  AND companyId = @i_companyId
UNION
SELECT entityId
FROM UMOwners O
WHERE
entityType = 3
	  AND companyId = @i_companyId
EXCEPT
(
  -- These are the valid clients for this company. They belong to this company or child companies
  -- or parent company or MSP and shared with this company.
  SELECT CP.componentNameId
  FROM App_ClientProp CP(NOLOCK)
         INNER JOIN CTEChildCompanies CCT
               ON CP.attrName = 'Installation Company Id'
               AND CP.attrVal = CAST(CCT.companyId AS VARCHAR(10))
               AND CP.modified = 0
  UNION
  SELECT CP.componentNameId
  FROM App_ClientProp CP(NOLOCK)
         INNER JOIN CTEParentCompanies CPT
               ON CP.attrName = 'Installation Company Id'
               AND CP.attrVal = CAST(CPT.companyId AS VARCHAR(10))
               AND CP.modified = 0
  UNION
  SELECT C.id           -- If property is not present, then assume it as 0(MSP).
  FROM APP_Client C (NOLOCK)
    LEFT OUTER JOIN APP_ClientProp CP (NOLOCK)
        ON C.id = CP.componentNameId
        AND CP.attrName = 'Installation Company Id'
        AND CP.modified = 0
  WHERE
    CP.componentNameId IS NULL
)
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'App_GetDeniedClientForCompany')
	delete from GxQscripts where name = 'App_GetDeniedClientForCompany'
GO

IF EXISTS (select * from GXDBVersions where aliasname='App_GetDeniedClientForCompany')
	delete from GXDBVersions where aliasname = 'App_GetDeniedClientForCompany'
GO

insert into GXDBVersions values(2, 'App_GetDeniedClientForCompany',  '00010001000200010000', 'App_GetDeniedClientForCompany', '00010001000200010000')
GO

