

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/App_GetClientAccessControlV2.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/App_GetClientAccessControlV2.sp,v $ $Id: App_GetClientAccessControlV2.sp,v 1.1.2.6.8.1 2021/02/26 00:45:08 anarde Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "App_GetClientAccessControlV2"
--  |			Input: <App_GetClientAccessControlRequest remoteClientId = "100" clientId = "200" isRefreshMod = "0"/>
-- 	+---------------------------------------------------------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='App_GetClientAccessControlV2')
BEGIN
	print '>>> Drop Stored Procedure: App_GetClientAccessControlV2 <<<'
	drop procedure App_GetClientAccessControlV2
END
IF EXISTS (select * from GxQscripts where name='App_GetClientAccessControlV2')
	delete from GxQscripts where name = 'App_GetClientAccessControlV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='App_GetClientAccessControlV2')
	delete from GXDBVersions where aliasname = 'App_GetClientAccessControlV2'
GO
print '... Creating Procedure: App_GetClientAccessControlV2'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure App_GetClientAccessControlV2
  @i_xml XML
AS
  DECLARE @o_xml XML
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
/*
This sp takes an input xml and depend on @isRefreshMode = 0 or 1 get or refresh acccess
1. for getting access, (request, target) client ids should be included in the input xml, sp checks client accesses and update App_clientAccessContrl table based on preset rules. It will return an output xml with errorCode/errorMessage, and accessType
2. for refresh it randomly select expired entrys in App_ClientAccessControl table, either update the creation time if entry is still valid or delete entry if entry is not valid anymore. It will return an outputxml with errorCode 0 and number of rows in errorMessage
we follow below rules:
1. client can access its MA
2. pseudo client's proxies can access itself
----removed-->3. pseudo client's proxies can access each other<--- removed because these are not related to password access
----removed-->4. pseudo client's proxies can access its MAs<--- removed because these are not related to password access
5. if pseudo client is VSA client, its proxies can access its children VMs
6. if proxy is a linux cluster client (VM), its physical client (PM) should have access to its pseudo client
7. for VSA, proxy of admin client (associated with admin Instance) is allowed to access tenant client (associated with tenant instance)
8. for content indexing, search engine node is allowed to access associated client
*/
DECLARE @isRefreshMode INT = ISNULL((SELECT ref.value('@isRefreshMode', 'INT')  FROM @i_xml.nodes ('App_GetClientAccessControlRequest') R(ref)), 0)
DECLARE @reqRemoteClientId INT = ISNULL((SELECT ref.value('@remoteClientId',   'INT')          FROM @i_xml.nodes ('App_GetClientAccessControlRequest') R(ref)), 1) -- 1 for NO_CLIENT
DECLARE @reqClientId INT = ISNULL((SELECT ref.value('@clientId', 'INT')  FROM @i_xml.nodes ('App_GetClientAccessControlRequest') R(ref)), 1)
DECLARE @remoteProcessName NVARCHAR(max) = ISNULL((SELECT ref.value('@remoteProcessName', 'NVARCHAR(MAX)')  FROM @i_xml.nodes ('App_GetClientAccessControlRequest') R(ref)), '')
DECLARE @errorMessage NVARCHAR(MAX) = ''
DECLARE @errorCode INT = 0
DECLARE @currTimeStamp DATETIME = CURRENT_TIMESTAMP
DECLARE @accessType INT = 0
DECLARE @refreshInfo XML
DECLARE @accessInfo XML
DECLARE @error XML
DECLARE @rowsDeleted int =0
DECLARE @rowsUpdated int =0
DECLARE @rowsInserted int =0
/*
we follow below rules:
1. client can access its MA
2. pseudo client's proxies can access itself
----removed-->3. pseudo client's proxies can access each other<--- removed because these are not related to password access
----removed-->4. pseudo client's proxies can access its MAs<--- removed because these are not related to password access
5. IF pseudo client is VSA client, its proxies can access its children VMs
6. IF proxy is a linux cluster client (VM), its physical client (PM) should have access to its pseudo client
7. for VSA, proxy of admin client (associated WITH admin Instance) is allowed to access tenant client (associated WITH tenant instance)
*/
BEGIN TRY
IF EXISTS (SELECT 1 FROM gxglobalparam WHERE name = 'bEnableAppMgrSecurityCheck' AND value = '0')
BEGIN
	SET @error =
		(SELECT
			@errorCode AS '@errorCode',
			'regkey [bEnableAppMgrSecurityCheck] set to 0, AppMgrSecurityCheck disabled' AS '@errorMessage'
			FOR XML PATH('error'), type)
	IF @isRefreshMode = 0
	BEGIN
SET @accessType = 1
		SET @accessInfo =
			(SELECT
				@reqRemoteClientId  AS '@requestClientId',
				@reqClientId AS '@targetClientId',
				@accessType AS '@accessType'
				FOR XML PATH('accessInfo'), type)
	END
	GOTO PROC_EXIT
END
--check input, return IF input is invalid: we should not get an invalid request IF sp is called FROM cpp code but add this check for completeness
IF @isRefreshMode = 0
BEGIN
	IF (@reqRemoteClientId = 1 or @reqClientId = 1)
	BEGIN
SET @errorCode = 1
		SET @error =
			(SELECT
				@errorCode AS '@errorCode',
				'invalid input' AS '@errorMessage'
				FOR XML PATH('error'), type)
		SET @accessInfo =
			(SELECT @reqRemoteClientId  AS '@requestClientId',
			   @reqClientId AS '@targetClientId',
			   @accessType AS '@accessType'
			   FOR XML PATH('accessInfo'), type)
		GOTO PROC_EXIT
	END
	IF NOT EXISTS (SELECT 1 FROM app_client WHERE id = @reqRemoteClientId)
	BEGIN
SET @errorCode = 10
		SET @error =
				(SELECT
					@errorCode AS '@errorCode',
					'remote client id not found in app_client table' AS '@errorMessage'
					FOR XML PATH('error'), type)
		SET @accessInfo =
			(SELECT
				@reqRemoteClientId  AS '@requestClientId',
				@reqClientId AS '@targetClientId',
				@accessType AS '@accessType'
				FOR XML PATH('accessInfo'), type)
		GOTO PROC_EXIT
	END
END
SET @error =
	(SELECT
		@errorCode AS '@errorCode'
		FOR XML PATH('error'), type)
IF @isRefreshMode = 0
BEGIN
	SET @accessInfo =
			(
				SELECT top 1
				PrivilegedClientId AS '@requestClientId',
				AccessedClientId AS '@targetClientId',
				CreationTime AS '@CreationTime',
				accessType AS '@accessType',
				insertedBy AS '@insertedBy'
				FROM App_ClientAccessControl WITH (NOLOCK)
				WHERE
				(
					@reqRemoteClientId = PrivilegedClientId AND
					@reqClientId = AccessedClientId AND
accessType = 1
				)
				FOR XML PATH('accessInfo'), type
			)
	IF @accessInfo IS NOT NULL
		GOTO PROC_EXIT
END
IF OBJECT_ID('tempdb.dbo.#App_GetClientAccessControlV2_InputTable') IS NOT NULL
	DROP TABLE #App_GetClientAccessControlV2_InputTable
CREATE TABLE #App_GetClientAccessControlV2_InputTable (
	PrivilegedClientId	INT,
	AccessedClientId	INT,
	remoteProcessName nvarchar(max)
)
CREATE CLUSTERED INDEX #App_GetClientAccessControlV2_InputTable_PrivilegedClientId_AccessedClientId_idx
	ON #App_GetClientAccessControlV2_InputTable(PrivilegedClientId, AccessedClientId)
IF @isRefreshMode = 1
--refresh 10 percent expired access every hour to distribute the "refresh" load to 24 hours.
--10 percent was chosen because every day, we would have 100 percent expired accesses being refreshed so we need 100 percent / 24 hours ~ 5 percent/hour.
--With 10 percent we would have better coverage.
--inerstedBy <> 0 because configured accesses should not be refreshed (deleted)
	INSERT INTO #App_GetClientAccessControlV2_InputTable
		SELECT TOP 10 PERCENT privilegedClientId, accessedClientId, remoteProcessName
		FROM app_clientaccesscontrol
WHERE DATEDIFF(day, creationTime, @currTimeStamp) >= 30
AND InsertedBy <> 0
		ORDER BY NEWID()
ELSE
	INSERT INTO #App_GetClientAccessControlV2_InputTable
		VALUES (@reqRemoteClientId, @reqClientId, @remoteProcessName)
IF OBJECT_ID('tempdb.dbo.#temp_update_CAC') IS NOT NULL
	DROP TABLE #temp_update_CAC
CREATE TABLE #temp_update_CAC (
	id INT PRIMARY KEY,
	InsertedBy INTEGER NOT NULL DEFAULT 0,
	remoteProcessName NVARCHAR(MAX) NOT NULL DEFAULT ''
)
IF OBJECT_ID('tempdb.dbo.#temp_insert_CAC') IS NOT NULL DROP TABLE #temp_insert_CAC
CREATE TABLE #temp_insert_CAC (
	PrivilegedClientId INT,
	AccessedClientId  INT,
	CreationTime DATETIME NOT NULL,
	InsertedBy INTEGER NOT NULL DEFAULT 0,
	remoteProcessName NVARCHAR(MAX) NOT NULL DEFAULT ''
)
CREATE INDEX #temp_insert_CAC_PrivilegedClientId_AccessedClientId_idx
	ON #temp_insert_CAC(PrivilegedClientId, AccessedClientId)
IF @isRefreshMode = 0
BEGIN
	--return no access immediately IF client is in requestClient's deny list
	IF EXISTS (SELECT 1 FROM gxglobalparam WHERE name = 'bEnableAppMgrTenantCheck' AND value = '1' )
	BEGIN
		-- get company id for @requestClient, AND get denied client for this company
			DECLARE @companyId int = 0;
		SELECT @companyId = CAST(attrval AS int ) FROM app_clientProp WHERE componentNameId = @reqRemoteClientId AND attrName = 'Installation Company ID' AND modified = 0
			IF @companyId <> 0
			BEGIN
				IF OBJECT_ID('tempdb.dbo.#App_GetDeniedClientForCompanyOutputTbl') IS NOT NULL
					DROP TABLE #App_GetDeniedClientForCompanyOutputTbl
				CREATE TABLE #App_GetDeniedClientForCompanyOutputTbl( clientId integer)
				EXEC App_GetDeniedClientForCompany @companyId
				IF EXISTS (SELECT 1 FROM #App_GetDeniedClientForCompanyOutputTbl WHERE clientId = @reqClientId)
				BEGIN
					INSERT INTO #temp_update_CAC (id,InsertedBy)
						SELECT DISTINCT
							CAC.id,
-2
						FROM App_ClientAccessControl CAC WITH (NOLOCK)
					JOIN #App_GetDeniedClientForCompanyOutputTbl DC ON CAC.PrivilegedClientId = @reqRemoteClientId AND CAC.AccessedClientId = DC.clientId
						LEFT JOIN #temp_update_CAC TCAC ON CAC.id = TCAC.id WHERE TCAC.id IS NULL
					;WITH DeniedClientList (clientid, accessedClientId)
					AS (SELECT DISTINCT @reqRemoteClientId, clientId FROM #App_GetDeniedClientForCompanyOutputTbl
						EXCEPT
						SELECT privilegedClientId, AccessedClientId FROM App_ClientAccessControl CAC WITH (NOLOCK)
						EXCEPT
						SELECT privilegedClientId, AccessedClientId FROM #temp_insert_CAC
						)
					INSERT INTO #temp_insert_CAC (PrivilegedClientId,AccessedClientId,CreationTime,InsertedBy)
					SELECT
						clientid,
						accessedclientId,
						@currTimeStamp,
-2
						FROM DeniedClientList
					GOTO PROC_UPDATE
				END
			END
	END -- regkey check
END -- not refresh mode
--check for MA
IF OBJECT_ID('tempdb.dbo.#tmpMATable') IS NOT NULL
	DROP TABLE #tmpMATable
CREATE TABLE #tmpMATable(
	clientId INTEGER,
	maClientId INTEGER
)
CREATE CLUSTERED INDEX #tmpMATable_idx
	ON #tmpMATable(clientId, maClientId)
IF OBJECT_ID('TempDb..#AccessExclude') IS NOT NULL
	DROP TABLE #AccessExclude
CREATE TABLE #AccessExclude (
	privilegedClientId		INT,
	AccessedClientId		INT,
	PRIMARY KEY (privilegedClientId, AccessedClientId)
)
INSERT INTO #AccessExclude
	SELECT
		privilegedClientId,
		AccessedClientId
	FROM App_ClientAccessControl CAC WITH(NOLOCK)
	UNION
	SELECT
		privilegedClientId,
		AccessedClientId
	FROM #temp_insert_CAC
IF OBJECT_ID('tempdb..#inputClientList') IS NOT NULL
	DROP TABLE #inputClientList
CREATE TABLE #inputClientList
(
	clientId INT PRIMARY KEY
)
INSERT INTO #inputClientList
	SELECT DISTINCT privilegedClientId FROM #App_GetClientAccessControlV2_InputTable
--Code Below Here is From AppGetClientMediaAgentMap.spb
BEGIN
	IF OBJECT_ID('tempdb.dbo.#ClientMediaAgentMap') IS NOT NULL
		DROP TABLE #ClientMediaAgentMap
	CREATE TABLE #ClientMediaAgentMap
	(
		clientId INT,
		mediaAgentId INT,
		PRIMARY KEY(clientId,mediaAgentId)
	);
	IF OBJECT_ID('tempdb..#lt_Clients') IS NOT NULL DROP TABLE #lt_Clients
	CREATE TABLE #lt_Clients
	(
		clientId	INT
		PRIMARY KEY(clientId)
	)
	IF OBJECT_ID('tempdb.dbo.#tempArchGrp') IS NOT NULL
		DROP TABLE #tempArchGrp
	CREATE TABLE #tempArchGrp
	(
		clientId	INT,
		archGroupId	INT,
		primaryCopyId smallint,
		primarySnapCopyId smallint
	)
	CREATE CLUSTERED INDEX  tempArchGrp_idx1 ON #tempArchGrp(primaryCopyId)
	CREATE NONCLUSTERED INDEX  tempArchGrp_idx2 ON #tempArchGrp(primarySnapCopyId, clientId)
DECLARE @cs_assocPlan INT = checksum('Associated Plan')
	-- Get all index servers
	IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
	CREATE TABLE #getIndexServers
						(     serverURL NVARCHAR(512),
								clientId INT,
								clientName NVARCHAR(256),
								cloudId INT,
								hostName NVARCHAR(256),
								basePort INT,
								engineName  NVARCHAR(256),
								serverType INT,
								indexServerClientId INT,
								internalCloudName NVARCHAR(256)
						)
	EXEC DM2GetIndexServers
	-- Get Source Clients
		INSERT 	INTO #lt_Clients
		SELECT	CN.id
		FROM	App_Client CN WITH(READUNCOMMITTED)
				,#inputClientList CL
		WHERE	CN.id > 1
				AND CL.clientId = CN.id
	--
	--Find destination clients
	--
	IF @@ROWCOUNT > 0
	BEGIN
		-- Get all the storage policies
		INSERT INTO #tempArchGrp
		SELECT 	distinct APP.clientId, AG.id, AG.defaultCopy, AG.defaultSnapCopy
		FROM	#lt_Clients CN
				INNER JOIN App_Application APP WITH(READUNCOMMITTED)
				ON CN.clientId = APP.clientId
				INNER JOIN 	archGroup AAG WITH(READUNCOMMITTED)
				ON APP.dataArchGrpId = AAG.id,
				archGroup AG
		WHERE 	AG.id in (AAG.id, AAG.incrSP)
				AND AG.id > 1
		UNION
		SELECT 	distinct APP.clientId, AG.id, AG.defaultCopy, AG.defaultSnapCopy
		FROM	#lt_Clients CN
				INNER JOIN App_Application APP WITH(READUNCOMMITTED)
				ON CN.clientId = APP.clientId
				INNER JOIN 	archGroup AAG WITH(READUNCOMMITTED)
				ON APP.logArchGrpId = AAG.id,
				archGroup AG
		WHERE 	AG.id in (AAG.id, AAG.incrSP)
				AND AG.id > 1
		--Get client to infrastructure map
		INSERT INTO #ClientMediaAgentMap
		-- MediaAgents
		SELECT 	TA.clientId, DPool.clientId
		FROM 	#tempArchGrp TA,
				MMDataPath DPath WITH(READUNCOMMITTED),
				MMDrivePool DPool WITH(READUNCOMMITTED)
		WHERE	TA.primarySnapCopyId = DPath.copyId
				AND DPath.copyId > 0
				AND DPath.DrivePoolId = DPool.DrivePoolId
		UNION
		SELECT 	TA.clientId, DPool.clientId
		FROM 	#tempArchGrp TA,
				MMDataPath DPath WITH(READUNCOMMITTED),
				MMDrivePool DPool WITH(READUNCOMMITTED)
		WHERE	TA.primaryCopyId = DPath.copyId
				AND DPath.copyId > 0
				AND DPath.DrivePoolId = DPool.DrivePoolId
		UNION
		-- DDB Engines
		SELECT 	TA.clientId, SS.clientId
		FROM 	#tempArchGrp TA,
				archCopySIDBStore CPS WITH(READUNCOMMITTED),
				IdxSIDBStore S WITH(READUNCOMMITTED),
				IdxSIDBSubStore SS WITH(READUNCOMMITTED)
		WHERE	TA.primaryCopyId = CPS.copyId
				AND CPS.SIDBStoreId = S.SIDBStoreId
				AND S.sealedTime = 0 --ActiveStores
				AND S.SIDBStoreId = SS.SIDBStoreId
		UNION
		-- IndexServers: Exchange
		SELECT 	CN.clientId, S.clientId
		FROM 	#lt_Clients CN,
				APP_IDAName IDN WITH(READUNCOMMITTED),
				App_IdaProp IP WITH(READUNCOMMITTED), #getIndexServers S
		WHERE  	CN.clientId = IDN.clientId
				AND IP.componentNameId = IDN.ID
				AND IP.attrName = 'OnePass Index Server'
				AND IP.modified = 0
				AND S.indexServerClientId = CAST (IP.AttrVal AS INT)
		UNION
		-- IndexServers: Edge
		SELECT  CN.clientId, S.clientId
		FROM  	#lt_Clients CN,
				App_EdgeDriveAssociation EDGE WITH(READUNCOMMITTED), #getIndexServers S
		WHERE  	CN.clientId = EDGE.clientId
AND S.indexServerClientId = EDGE.entityId AND EDGE.entityType = 3
		UNION
		-- IndexServers: Edge Laptop clients
		SELECT	CN.clientId, EDW.webserverId
		FROM 	#lt_Clients CN
				INNER JOIN App_Client CL  WITH(READUNCOMMITTED) ON CN.clientId = CL.id
				INNER JOIN App_SyncCloudConfig SC  WITH(READUNCOMMITTED) ON CL.id = SC.clientId
				INNER JOIN App_SyncCloudFolder SF  WITH(READUNCOMMITTED) ON SC.syncWebFolderId = SF.syncWebFolderId
				INNER JOIN APP_Application APP  WITH(READUNCOMMITTED) ON APP.id = SC.subclientId
				INNER JOIN AppEdgeDriveWebserverAssociation EDW  WITH(READUNCOMMITTED) ON EDW.edgeClientId = APP.clientId
WHERE 	CL.status & 0x1000 > 0
AND SF.flag &  0x10 > 0
AND APP.subclientStatus & 0x20000 > 0
		UNION
		-- IndexServers: FileSystem
		SELECT  CN.clientId, S.clientId
		FROM  	#lt_Clients CN,
				App_Application APP WITH(READUNCOMMITTED),
				App_IndexDBInfo idx WITH(READUNCOMMITTED), #getIndexServers S
		WHERE	CN.clientId = APP.clientId
				AND idx.backupSetId = APP.backupSet
				AND S.indexServerClientId = idx.currentIdxServer
		UNION
		-- IndexServers: Plan VSA
		SELECT  T.clientId, S.clientId
		FROM  	(
					SELECT 	CN.clientId, CAST(CP.attrVal AS INT) PlanId
					FROM 	#lt_Clients CN,
							App_clientProp CP WITH(READUNCOMMITTED)
					WHERE 	CN.clientId = CP.componentNameId
AND CP.attrName = 'Associated Plan'
							AND CP.modified = 0
					UNION
					SELECT 	CN.clientId, CAST(SCP.attrVal AS INT) PlanId
					FROM 	#lt_Clients CN,
							App_Application SC WITH(READUNCOMMITTED),
							App_SubclientProp SCP WITH(READUNCOMMITTED)
					WHERE 	CN.clientId = SC.clientId
							AND SCP.componentNameId = SC.id
							AND SCP.cs_attrName = @cs_assocPlan
AND SCP.attrName = 'Associated Plan'
							AND SCP.modified = 0
				) AS T,
				App_PlanProp PROP WITH(READUNCOMMITTED), #getIndexServers S
		WHERE	PROP.componentNameId = T.PlanId
				AND PROP.attrName = 'Analytics Index Server Id'
				AND PROP.modified = 0
				AND S.indexServerClientId = CAST (PROP.AttrVal AS INT)
		UNION
		-- Remote SoftwareCache: Client Level
		SELECT  CN.clientId, UA.clientId
		FROM  	#lt_Clients CN,
				App_clientProp CP WITH(READUNCOMMITTED),
				PatchUpdateAgentInfo UA WITH(READUNCOMMITTED)
		WHERE 	CN.clientId = CP.componentNameId
				AND CP.attrName = N'UPDATE CACHE AGENT ID'
				AND CP.modified = 0
				AND CAST(CP.attrVal AS INT) = UA.id
		UNION
		-- Remote SoftwareCache: ClientGroup Level
		SELECT  CN.clientId, UA.clientId
		FROM  	#lt_Clients CN,
				App_ClientGroupAssoc CGA WITH(READUNCOMMITTED),
				APP_ComponentProp CP WITH(READUNCOMMITTED),
				PatchUpdateAgentInfo UA WITH(READUNCOMMITTED)
		WHERE 	CN.clientId = CGA.clientId
				AND CGA.clientGroupId = CP.componentId
AND CP.componentType = 8
AND CP.propertyTypeId = 1300
				AND CP.modified = 0
				AND CP.longVal = UA.id
		--
		--Remove entries if source and dest are same
		--
		DELETE 	#ClientMediaAgentMap
		WHERE	clientId = mediaAgentId
		-- Remove entries for invalid MAs.
		-- Example: On deleting a DDB MA without deleting relevant partition info (feature introduced in SP19), a MA entry with clientid=1 (NOCLIENT) is used as a placeholder.
		-- Such MA ids are invalid for general processing
		DELETE 	#ClientMediaAgentMap
		WHERE	mediaAgentId < 2
	END
	IF OBJECT_ID('tempdb..#lt_Clients') IS NOT NULL 			DROP TABLE #lt_Clients
	IF OBJECT_ID('tempdb.dbo.#tempArchGrp') IS NOT NULL 		DROP TABLE #tempArchGrp
	IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
END
IF OBJECT_ID('tempdb..#inputClientList') IS NOT NULL
	DROP TABLE #inputClientList
INSERT INTO #tmpMATable
	SELECT DISTINCT clientId, mediaAgentId maClientId
		FROM #ClientMediaAgentMap
IF OBJECT_ID('tempdb.dbo.#ClientMediaAgentMap') IS NOT NULL
    DROP TABLE #ClientMediaAgentMap
INSERT INTO #temp_update_CAC (id,InsertedBy)
	SELECT DISTINCT
		CAC.id,
1
	FROM App_ClientAccessControl CAC WITH (NOLOCK)
	JOIN #tmpMATable MA ON CAC.PrivilegedClientId = MA.clientId AND CAC.AccessedClientId = MA.maClientId
	LEFT JOIN #temp_update_CAC TCAC ON CAC.id = TCAC.id WHERE TCAC.id IS NULL
--rows need to be inserted into CAC would go into #temp_insert_CAC AND would be inserted in the end of this sp
INSERT INTO #temp_insert_CAC (PrivilegedClientId,AccessedClientId,CreationTime,InsertedBy)
	OUTPUT INSERTED.PrivilegedClientId, INSERTED.AccessedClientId INTO #AccessExclude
	SELECT DISTINCT
		m.clientId,
		m.maClientId,
		@currTimeStamp,
1
	FROM #tmpMATable m
		LEFT OUTER JOIN #AccessExclude e ON
			e.privilegedClientId = m.clientId
			AND e.AccessedClientId = m.maClientId
	WHERE
		e.privilegedClientId IS NULL
--check proxy:
--we need to 1. find proxy for targetClient, 2. proxy of targetClient's parent because both of these proxies would have access to child
--Proxy-->(VSA client)-->VM client
IF OBJECT_ID('tempdb.dbo.#tmpParentChildTable') IS NOT NULL DROP TABLE #tmpParentChildTable
CREATE TABLE #tmpParentChildTable(
	parentClientId	INTEGER,
	childClientId INTEGER,
	type 	INTEGER
)
INSERT INTO #tmpParentChildTable
SELECT  AA.clientId vsa,
		CP.componentNameId vm,
5 type
	FROM APP_Application AA
	JOIN APP_ClientProp CP
		ON CP.attrVal = CAST(AA.id AS nvarchar(12))
	JOIN #App_GetClientAccessControlV2_InputTable I
		ON CP.componentNameId = I.AccessedClientId --child VM client Id
		WHERE CP.attrName = 'Last Backup Subclient'
		AND CP.modified = 0
--Proxy->(admin instance)->tenant instance
INSERT INTO #tmpParentChildTable
SELECT 	app2.clientId, ---admin Client
		app.clientId, --tenant client
7
	FROM app_application app (NOLOCK)
	INNER JOIN  APP_InstanceProp p1 (NOLOCK)
		ON app.instance = p1.componentNameId
		AND p1.attrName ='Amazon Enable Admin Account'
		AND p1.attrVal= N'1'
		AND p1.modified = 0
AND app.appTypeId = 106
	INNER JOIN #App_GetClientAccessControlV2_InputTable I
		ON app.clientId = I.AccessedClientId
	INNER JOIN APP_InstanceProp p2 (NOLOCK)
		ON p1.componentNameId = p2.componentNameId
		AND p2.attrName = 'Amazon Admin Instance Id'
		AND p2.modified = 0
	INNER JOIN app_application app2 (NOLOCK)
		ON p2.attrval = CAST(app2.instance AS NVARCHAR(12))
AND app2.appTypeId = 106
IF OBJECT_ID('tempdb.dbo.#tmpProxyClientInput') IS NOT NULL
	DROP TABLE #tmpProxyClientInput
CREATE TABLE #tmpProxyClientInput (
	clientId        INTEGER,
	instance        INTEGER DEFAULT 0,
	appTypeId       INTEGER DEFAULT 0,
	subclientId     INTEGER DEFAULT 0,
)
INSERT INTO #tmpProxyClientInput (clientId)
	SELECT AccessedClientId
		FROM #App_GetClientAccessControlV2_InputTable
	UNION
	SELECT parentClientId
		FROM #tmpParentChildTable
IF OBJECT_ID('tempdb.dbo.#tmpProxyClientOutput') IS NOT NULL
	DROP TABLE #tmpProxyClientOutput
CREATE TABLE #tmpProxyClientOutput(
	ClientId		INTEGER,
	instanceId		INTEGER,
	proxyClientId	INTEGER,
	ClientAppType	INTEGER,
	isIndexServer		INTEGER DEFAULT 0,  --0 meaning proxyclient, 1 meaning INDEX server
	iscloudindexServer 	INTEGER DEFAULT 0,    -- 1 meaning cloud INDEX server
	cloudindexServer 	INTEGER DEFAULT 0,
	isproxyclientGroup 	INTEGER DEFAULT 0 , -- 1 meaning client Group
	clientGroup		 	INTEGER DEFAULT 0,
	subclientId		 	INTEGER DEFAULT 0
)
CREATE CLUSTERED INDEX #tmpProxyClientOutput_proxyClientId_ClientId_idx
	ON #tmpProxyClientOutput(proxyClientId,ClientId)
EXEC AppGetPRoxyClientInfo '#tmpProxyClientInput', '#tmpProxyClientOutput', 1
--check proxy: check IF remoteClient is one of the proxies found for client
INSERT INTO #temp_update_CAC (id,InsertedBy)
	SELECT DISTINCT
		CAC.id,
2
	FROM App_ClientAccessControl CAC WITH (NOLOCK)
	JOIN #tmpProxyClientOutput P ON CAC.PrivilegedClientId = P.proxyclientId AND CAC.AccessedClientId = P.clientid
	LEFT JOIN #temp_update_CAC TCAC ON CAC.id = TCAC.id WHERE TCAC.id IS NULL
INSERT INTO #temp_insert_CAC (PrivilegedClientId,AccessedClientId,CreationTime,InsertedBy)
	OUTPUT INSERTED.PrivilegedClientId, INSERTED.AccessedClientId INTO #AccessExclude
	SELECT DISTINCT
		p.proxyClientId,
		p.clientId,
		@currTimeStamp,
2
	FROM #tmpProxyClientOutput p
		LEFT OUTER JOIN #AccessExclude e ON
			e.privilegedClientId = p.proxyClientId
			AND e.AccessedClientId = p.clientId
	WHERE
		e.privilegedClientId IS NULL
--for VM client, VSA clients' proxy can access its children vm clients
IF OBJECT_ID('tempdb.dbo.#tmpProxyAccessVM') IS NOT NULL DROP TABLE #tmpProxyAccessVM
CREATE TABLE #tmpProxyAccessVM(
				VMClientId integer,
				proxyClientId integer,
			PRIMARY KEY (proxyClientId, VMClientId)
				)
INSERT INTO #tmpProxyAccessVM (VMClientId, proxyClientId)
	SELECT DISTINCT PC.childClientId VMClientId, P.proxyClientId
	FROM #tmpProxyClientOutput P
		JOIN #tmpParentChildTable PC ON
			P.clientId = PC.parentClientId
AND PC.type = 5
INSERT INTO #temp_update_CAC (id,InsertedBy)
SELECT
	CAC.id,
5
FROM App_ClientAccessControl CAC WITH (NOLOCK)
	JOIN #tmpProxyAccessVM VM ON
		CAC.PrivilegedClientId = VM.proxyClientId
		AND CAC.AccessedClientId = VM.VMClientId
	LEFT JOIN #temp_update_CAC TCAC ON
		CAC.id = TCAC.id
WHERE TCAC.id IS NULL
INSERT INTO #temp_insert_CAC (PrivilegedClientId,AccessedClientId,CreationTime,InsertedBy)
	OUTPUT INSERTED.PrivilegedClientId, INSERTED.AccessedClientId INTO #AccessExclude
	SELECT
		v.proxyClientId,
		v.VMClientId,
		@currTimeStamp,
5
	FROM #tmpProxyAccessVM v
		LEFT OUTER JOIN #AccessExclude e ON
			e.privilegedClientId = v.proxyClientId
			AND e.AccessedClientId = v.VMClientId
	WHERE
		e.privilegedClientId IS NULL
--for linux cluster clients(VM), there is a control client(PM) for it. IF VM is a proxy, its PM should have access to its pseudoclient.
IF OBJECT_ID('tempdb.dbo.#tmpPMAccessPseudo') IS NOT NULL DROP TABLE #tmpPMAccessPseudo
CREATE TABLE #tmpPMAccessPseudo(
				PMClientId integer, -- physical machine (control client)
				VMClientId	integer, -- virtual machine (proxy)
				PseudoClientId integer
				)
CREATE CLUSTERED INDEX #tmpPMAccessPseudo_PMClientId_PseudoClientId ON #tmpPMAccessPseudo (PMClientId,PseudoClientId)
INSERT INTO #tmpPMAccessPseudo (PMClientId, VMClientId, PseudoClientId)
	SELECT DISTINCT
		PM2VM.PMClientId PMClientId,
		PM2VM.VMClientId VMClientId,
		VM2Pseudo.clientId
	FROM APP_VMToPMMap PM2VM
		JOIN #tmpProxyClientOutput VM2Pseudo ON
			PM2VM.VMClientId = VM2Pseudo.proxyClientId
INSERT INTO #temp_update_CAC (id,InsertedBy)
	SELECT
		CAC.id,
6
	FROM App_ClientAccessControl CAC WITH (NOLOCK)
		JOIN #tmpPMAccessPseudo P ON
			CAC.PrivilegedClientId = P.PMClientId
			AND CAC.AccessedClientId = P.PseudoClientId
		LEFT JOIN #temp_update_CAC TCAC ON
			CAC.id = TCAC.id
	WHERE TCAC.id IS NULL
INSERT INTO #temp_insert_CAC (PrivilegedClientId,AccessedClientId,CreationTime,InsertedBy)
	OUTPUT INSERTED.PrivilegedClientId, INSERTED.AccessedClientId INTO #AccessExclude
	SELECT DISTINCT
		p.PMClientId,
		p.PseudoClientId,
		@currTimeStamp,
6
	FROM #tmpPMAccessPseudo p
		LEFT OUTER JOIN #AccessExclude e ON
			e.privilegedClientId = p.PMClientId
			AND e.AccessedClientId = p.PseudoClientId
	WHERE
		e.privilegedClientId IS NULL
--For VSA, proxy of admin client (associated WITH admin Instance) is allowed to access tenant client (associated WITH tenant instance)
IF OBJECT_ID('tempdb.dbo.#tmpProxyAccessTenant') IS NOT NULL DROP TABLE #tmpProxyAccessTenant
CREATE TABLE #tmpProxyAccessTenant(
							proxyClient			integer,
							adminClient			integer,
							tenantClient		integer)
CREATE CLUSTERED INDEX #tmpProxyAccessTenant_proxyClient_tenantClient_idx ON #tmpProxyAccessTenant(proxyClient,tenantClient)
INSERT INTO #tmpProxyAccessTenant
	SELECT DISTINCT proxy.proxyClientId,
		proxy.clientid adminClientid,
		PC.childClientId tenantClient
	FROM #tmpParentChildTable PC
		INNER JOIN #tmpProxyClientOutput proxy ON
			PC.parentClientId = proxy.ClientId
AND PC.type = 7
INSERT INTO #temp_update_CAC (id,InsertedBy)
	SELECT DISTINCT
		CAC.id,
7
	FROM App_ClientAccessControl CAC WITH (NOLOCK)
		JOIN #tmpProxyAccessTenant VSA ON
			CAC.PrivilegedClientId = VSA.proxyClient
			AND CAC.AccessedClientId = VSA.tenantClient
		LEFT JOIN #temp_update_CAC TCAC ON
			CAC.id = TCAC.id
	WHERE
		TCAC.id IS NULL
INSERT INTO #temp_insert_CAC (PrivilegedClientId,AccessedClientId,CreationTime,InsertedBy)
	OUTPUT INSERTED.PrivilegedClientId, INSERTED.AccessedClientId INTO #AccessExclude
	SELECT
		t.proxyClient,
		t.tenantClient,
		@currTimeStamp,
7
	FROM #tmpProxyAccessTenant t
		LEFT OUTER JOIN #AccessExclude e ON
			e.privilegedClientId = t.proxyClient
			AND e.AccessedClientId = t.tenantClient
	WHERE
		e.privilegedClientId IS NULL
--for content indexing, search engine node accesses client
--search engine is associated with client through storage policy
IF OBJECT_ID('tempdb.dbo.#tmpSearchEngineAccessClient') IS NOT NULL DROP TABLE #tmpSearchEngineAccessClient
CREATE TABLE #tmpSearchEngineAccessClient(
		searchEngineClient			integer,
		client		integer)
CREATE CLUSTERED INDEX #tmpSearchEngineAccessClient_searchEngineClient_client_idx ON #tmpSearchEngineAccessClient(searchEngineClient,client)
INSERT INTO #tmpSearchEngineAccessClient
	SELECT DISTINCT CP2.longval,
		A.clientId AS ClientId
	FROM APP_Application A
		JOIN archContentIndexingRules R ON
			A.dataArchGrpID = R.archGroupId
		JOIN APP_ComponentProp CP ON
			R.cloudId = CP.id AND CP.componentType = 1
		JOIN APP_ComponentProp CP2 ON
			CP.id = CP2.componentId AND CP2.propertyTypeId = 1008
	WHERE A.clientId = @reqClientId
		AND CP2.longval = @reqRemoteClientId
INSERT INTO #temp_update_CAC (id,InsertedBy)
	SELECT DISTINCT
		CAC.id,
8
	FROM App_ClientAccessControl CAC WITH (NOLOCK)
		JOIN #tmpSearchEngineAccessClient SE ON
			CAC.PrivilegedClientId = SE.searchEngineClient
			AND CAC.AccessedClientId = SE.client
		LEFT JOIN #temp_update_CAC TCAC ON
			CAC.id = TCAC.id
	WHERE
		TCAC.id IS NULL
INSERT INTO #temp_insert_CAC (PrivilegedClientId,AccessedClientId,CreationTime,InsertedBy)
	OUTPUT INSERTED.PrivilegedClientId, INSERTED.AccessedClientId INTO #AccessExclude
	SELECT
		t.searchEngineClient,
		t.client,
		@currTimeStamp,
8
	FROM #tmpSearchEngineAccessClient t
		LEFT OUTER JOIN #AccessExclude e ON
			e.privilegedClientId = t.searchEngineClient
			AND e.AccessedClientId = t.client
	WHERE
		e.privilegedClientId IS NULL
--we may already have (@reqRemoteClientId, @reqClientId) unauthorized before: WITH insertedBy =-1 AND creationTime > 7 days old
--AND it is still not authorized.
IF @isRefreshMode = 0
BEGIN
	INSERT INTO #temp_update_CAC (id,InsertedBy, remoteProcessName)
		SELECT DISTINCT
			CAC.id,
-1,
			@remoteProcessName
		FROM App_ClientAccessControl CAC WITH (NOLOCK)
			LEFT JOIN #temp_update_CAC TCAC ON
				CAC.id = TCAC.id
			JOIN #App_GetClientAccessControlV2_InputTable I ON
				CAC.PrivilegedClientId = I.PrivilegedClientId
				AND CAC.AccessedClientId = I.AccessedClientId
		WHERE
			TCAC.id IS NULL
	IF NOT EXISTS (SELECT 1 FROM  #AccessExclude WHERE privilegedClientId = @reqRemoteClientId AND AccessedClientId = @reqClientId)
	BEGIN
		INSERT INTO #temp_insert_CAC (PrivilegedClientId,AccessedClientId,CreationTime,InsertedBy,remoteProcessName)
		OUTPUT INSERTED.PrivilegedClientId, INSERTED.AccessedClientId INTO #AccessExclude
			VALUES(
				@reqRemoteClientId,
				@reqClientId,
				@currTimeStamp,
-1,
				@remoteProcessName
			)
	END
END
PROC_UPDATE:
UPDATE CAC set
	CAC.CreationTime = @currTimeStamp,
	CAC.insertedBy = tCAC.InsertedBy,
	CAC.remoteProcessName = tCAC.remoteProcessName,
	CAC.accessType =(
		CASE
WHEN tCAC.insertedBy = -1
THEN 2
WHEN tCAC.insertedBy = -2
THEN 0
			ELSE
1
		END
		)
FROM App_ClientAccessControl CAC
	INNER JOIN #temp_update_CAC tCAC ON
		tCAC.id = CAC.id
INSERT INTO App_ClientAccessControl (PrivilegedClientId, AccessedClientId, CreationTime, insertedBy, remoteProcessName, accessType)
	SELECT
		tCAC.PrivilegedClientId,
		tCAC.AccessedClientId,
		tCAC.CreationTime,
		tCAC.insertedBy,
		tCAC.remoteProcessName,
		(
		CASE
WHEN tCAC.insertedBy = -1
THEN 2
WHEN tCAC.insertedBy = -2
THEN 0
			ELSE
1
		END
		)
	FROM #temp_insert_CAC tCAC
		LEFT JOIN App_ClientAccessControl app ON
			app.PrivilegedClientId = tCAC.PrivilegedClientId
			AND app.AccessedClientId = tCAC.AccessedClientId
	WHERE
		app.PrivilegedClientId IS NULL
		AND app.AccessedClientId IS NULL
IF @isRefreshMode = 0
SET @accessInfo =
	(SELECT top 1
		PrivilegedClientId AS '@requestClientId',
		AccessedClientId AS '@targetClientId',
		CreationTime AS '@CreationTime',
		AccessType AS '@accessType'
	FROM App_ClientAccessControl WITH (NOLOCK)
	WHERE
		PrivilegedClientId = @reqRemoteClientId
		AND AccessedClientId = @reqClientId
	FOR XML PATH('accessInfo'), type)
ELSE IF @isRefreshMode = 1
BEGIN
	DELETE App_ClientAccessControl
		WHERE id in (
			SELECT
				id
			FROM App_ClientAccessControl CAC
				JOIN #App_GetClientAccessControlV2_InputTable I ON
					CAC.privilegedClientId = I.privilegedClientId
					AND CAC.accessedClientId = I.accessedClientId
			EXCEPT
			SELECT
				id
			FROM #temp_update_CAC
		)
	SET @rowsDeleted = @@ROWCOUNT
	SELECT @rowsUpdated = COUNT(*) FROM #temp_update_CAC
	SELECT @rowsInserted = COUNT(*) FROM #temp_insert_CAC
SET @refreshInfo =
	(SELECT
		@rowsDeleted AS '@deleted',
		@rowsUpdated AS '@updated',
		@rowsInserted AS '@inserted'
	FOR XML PATH('refreshInfo'), type)
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
SET @errorCode = 1
SET @errorMessage = ERROR_MESSAGE()
SET @error =
	(SELECT
		@errorCode AS '@errorCode'
		FOR XML PATH('error'), type)
END CATCH
PROC_EXIT:
set @o_xml =
	(SELECT
		@isRefreshMode as '@isRefreshMode',
		@accessInfo,
		@refreshInfo,
		@error
		FOR XML PATH('App_GetClientAccessControlResponse'), type)
SELECT @o_xml AS [o_xml]
GO

IF EXISTS (select * from GxQscripts where name = 'App_GetClientAccessControlV2')
	delete from GxQscripts where name = 'App_GetClientAccessControlV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='App_GetClientAccessControlV2')
	delete from GXDBVersions where aliasname = 'App_GetClientAccessControlV2'
GO

insert into GXDBVersions values(2, 'App_GetClientAccessControlV2',  'v1.1.2.6.8.1', 'App_GetClientAccessControlV2', 'v1.1.2.6.8.1')
GO

