

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/App_GetClientAccessControl.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/App_GetClientAccessControl.sp,v $ $Id: App_GetClientAccessControl.sp,v 1.1.2.23 2020/10/09 16:29:11 anarde Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "App_GetClientAccessControl"
--  |    		input: <App_GetClientAccessControlRequest  clientId = "5831"  remoteClientId = "13"/>
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='App_GetClientAccessControl')
BEGIN
	print '>>> Drop Stored Procedure: App_GetClientAccessControl <<<'
	drop procedure App_GetClientAccessControl
END
IF EXISTS (select * from GxQscripts where name='App_GetClientAccessControl')
	delete from GxQscripts where name = 'App_GetClientAccessControl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='App_GetClientAccessControl')
	delete from GXDBVersions where aliasname = 'App_GetClientAccessControl'
GO
print '... Creating Procedure: App_GetClientAccessControl'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure App_GetClientAccessControl
  @i_xml XML
AS
  DECLARE @o_xml XML
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
DECLARE @reqRemoteClientId INT = ISNULL((SELECT ref.value('@remoteClientId',   'INT')          FROM @i_xml.nodes ('App_GetClientAccessControlRequest') R(ref)), 1) -- 1 for NO_CLIENT
DECLARE @reqClientId INT = ISNULL((SELECT ref.value('@clientId', 'INT')  FROM @i_xml.nodes ('App_GetClientAccessControlRequest') R(ref)), 1)
DECLARE @remoteProcessName NVARCHAR(max) = ISNULL((SELECT ref.value('@remoteProcessName', 'NVARCHAR(MAX)')  FROM @i_xml.nodes ('App_GetClientAccessControlRequest') R(ref)), '')
DECLARE @error_message nvarchar(max) = 'AppMgrSecurityCheck: '
DECLARE @errorCode int = 0
declare @currTimeStamp datetime = CURRENT_TIMESTAMP
/*
we follow below rules:
1. client can access its MA
2. pseudo client's proxies can access itself
3. pseudo client's proxies can access each other
4. pseudo client's proxies can access its MAs
5. if pseudo client is VSA client, its proxies can access its children VMs
6. if proxy is a linux cluster client (VM), its physical client (PM) should have access to its pseudo client
7. for VSA, proxy of admin client (associated with admin Instance) is allowed to access tenant client (associated with tenant instance)
*/
BEGIN TRY
IF EXISTS (SELECT 1 FROM gxglobalparam WHERE name = 'bEnableAppMgrSecurityCheck' and value = '0')
begin
SET @errorCode = 0
SET @o_xml =
	(select @reqRemoteClientId  as '@PrivilegedClientId',
	   @reqClientId as '@AccessedClientId',
	   @currTimeStamp as '@CreationTime',
	   @errorCode as '@errorCode',
	   @error_message + 'regkey [bEnableAppMgrSecurityCheck] is set to 0, disable AppMgr Security Check' as '@errorMessage'
	   FOR XML PATH('App_GetClientAccessControlResponse'), type)
SELECT @o_xml AS [o_xml]
return
end
--check input, return if input is invalid: we should not get an invalid request if sp is called from cpp code but add this check for completeness
if @reqRemoteClientId = 1 or @reqClientId = 1
begin
SET @errorCode = 1
SET @o_xml =
	(select @reqRemoteClientId  as '@PrivilegedClientId',
	   @reqClientId as '@AccessedClientId',
	   @currTimeStamp as '@CreationTime',
	   @errorCode as '@errorCode',
	   @error_message + 'invalid input' as '@errorMessage'
	   FOR XML PATH('App_GetClientAccessControlResponse'), type)
SELECT @o_xml AS [o_xml]
return
end
if not exists (select 1 from app_client where id = @reqRemoteClientId)
begin
SET @errorCode = 10
SET @o_xml =
	(select @reqRemoteClientId  as '@PrivilegedClientId',
	   @reqClientId as '@AccessedClientId',
	   @currTimeStamp as '@CreationTime',
	   @errorCode as '@errorCode',
	   @error_message + 'invalid remote client id: not found in app_client table' as '@errorMessage'
	   FOR XML PATH('App_GetClientAccessControlResponse'), type)
SELECT @o_xml AS [o_xml]
return
end
--check if already in access control table and has access and inserted within 7 days
SET @o_xml =
		(
			select top 1
			PrivilegedClientId as '@PrivilegedClientId',
			AccessedClientId as '@AccessedClientId',
			CreationTime as '@CreationTime',
			0 as '@errorCode',
			@error_message + 'source [' + cast(InsertedBy as varchar(5)) + ']' as '@errorMessage'
			from App_ClientAccessControl with (NOLOCK)
			where
			(
(@reqRemoteClientId = PrivilegedClientId and @reqClientId = AccessedClientId and InsertedBy > -1)
					or
(@reqRemoteClientId = AccessedClientId and @reqClientId = PrivilegedClientId and InsertedBy = 3) -- APPMGR_ACCESS_TYPE_PROXY_PROXY is for proxys access each other, so we reverse caller and callee and check it
			)
			and
DATEDIFF(DAY, CreationTime, @currTimeStamp) <= 30
			FOR XML PATH('App_GetClientAccessControlResponse'), type
		)
if @o_xml is not null
begin
SELECT @o_xml AS [o_xml]
return
end
IF object_id('tempdb.dbo.#temp_update_CAC') IS NOT NULL drop table #temp_update_CAC
create table #temp_update_CAC (id int primary key,
			InsertedBy integer NOT NULL DEFAULT 0,
			remoteProcessName nvarchar(max) NOT NULL DEFAULT ''
			)
IF object_id('tempdb.dbo.#temp_insert_CAC') IS NOT NULL drop table #temp_insert_CAC
create table #temp_insert_CAC (
		PrivilegedClientId int,
		AccessedClientId  int,
		CreationTime datetime NOT NULL,
		InsertedBy integer NOT NULL DEFAULT 0,
		remoteProcessName nvarchar(max) NOT NULL DEFAULT ''
)
create index #temp_insert_CAC_PrivilegedClientId_AccessedClientId_idx on #temp_insert_CAC(PrivilegedClientId,AccessedClientId)
--return no access immediately if client is in requestClient's deny list
IF EXISTS (SELECT 1 FROM gxglobalparam WHERE name = 'bEnableAppMgrTenantCheck' AND value = '1' )
BEGIN
	-- get company id for @requestClient, and get denied client for this company
	DECLARE @companyId int = 0;
	SELECT @companyId = cast(attrval as int ) from app_clientProp where componentNameId = @reqRemoteClientId and attrName = 'Installation Company ID' and modified = 0
	IF @companyId <> 0
	BEGIN
		IF object_id('tempdb.dbo.#App_GetDeniedClientForCompanyOutputTbl') IS NOT NULL
			DROP TABLE #App_GetDeniedClientForCompanyOutputTbl
		CREATE TABLE #App_GetDeniedClientForCompanyOutputTbl( clientId integer)
		EXEC App_GetDeniedClientForCompany @companyId
		IF EXISTS (SELECT 1 FROM #App_GetDeniedClientForCompanyOutputTbl WHERE clientId = @reqClientId)
		BEGIN
			insert into #temp_update_CAC (id,InsertedBy)
select distinct CAC.id,-2
				from App_ClientAccessControl CAC with (NOLOCK)
				join #App_GetDeniedClientForCompanyOutputTbl DC on CAC.PrivilegedClientId = @reqRemoteClientId and CAC.AccessedClientId = DC.clientId
				left join #temp_update_CAC TCAC on CAC.id = TCAC.id where TCAC.id is null
			;with cte (clientid, accessedClientId)
			as (select distinct @reqRemoteClientId, clientId from #App_GetDeniedClientForCompanyOutputTbl
				except
				select privilegedClientId, AccessedClientId from App_ClientAccessControl CAC with (NOLOCK)
				except
				select privilegedClientId, AccessedClientId from #temp_insert_CAC
				)
			insert into #temp_insert_CAC (PrivilegedClientId,AccessedClientId,CreationTime,InsertedBy)
select clientid, accessedclientId, @currTimeStamp, -2 from cte
			GOTO EXIT_PROC
		END
	END
END
--check for MA
IF object_id('tempdb.dbo.#tmpMATable') IS NOT NULL drop table #tmpMATable
create table #tmpMATable( clientId integer, maClientId integer, maClientName nvarchar(255), maClientHostName nvarchar(255), maClientGUID nvarchar(255))
create index #tmpMATable_idx on #tmpMATable(clientId)
INSERT INTO #tmpMATable exec AppGetMediaAgentsForClient 0
insert into #temp_update_CAC (id,InsertedBy)
select distinct CAC.id,1
	from App_ClientAccessControl CAC with (NOLOCK)
	join #tmpMATable MA on CAC.PrivilegedClientId = MA.clientId and CAC.AccessedClientId = MA.maClientId
	left join #temp_update_CAC TCAC on CAC.id = TCAC.id where TCAC.id is null
--rows need to be inserted into CAC would go into #temp_insert_CAC and would be inserted in the end of this sp
;with cte (clientid, accessedClientId)
as (select distinct clientId, maClientId from #tmpMATable
	except
	select privilegedClientId, AccessedClientId from App_ClientAccessControl CAC with (NOLOCK)
	except
	select privilegedClientId, AccessedClientId from #temp_insert_CAC
	)
insert into #temp_insert_CAC (PrivilegedClientId,AccessedClientId,CreationTime,InsertedBy)
select clientid, accessedclientId, @currTimeStamp, 1 from cte
--check proxy: call AppGetPRoxyClientInfo sp to find all proxies
IF object_id('tempdb.dbo.#tmpProxyClientOutput') IS NOT NULL drop table #tmpProxyClientOutput
create table #tmpProxyClientOutput(ClientId		integer,
						instanceId			integer,
						proxyClientId			integer,
						ClientAppType				integer,
						isIndexServer				integer DEFAULT 0,  --0 meaning proxyclient, 1 meaning index server
						iscloudindexServer 	integer DEFAULT 0,    -- 1 meaning cloud index server
						cloudindexServer 	integer DEFAULT 0,
						isproxyclientGroup 	integer DEFAULT 0 , -- 1 meaning client Group
						clientGroup		 	integer DEFAULT 0,
						subclientId		 	integer DEFAULT 0
						)
create index #tmpProxyClientOutput_proxyClientId_ClientId_idx on #tmpProxyClientOutput(proxyClientId,ClientId)
EXEC AppGetPRoxyClientInfo '', '#tmpProxyClientOutput', 1 -- get all proxy clients if no input table if given
--check proxy: check if remoteClient is one of the proxies found for client
insert into #temp_update_CAC (id,InsertedBy)
select distinct CAC.id,2
	from App_ClientAccessControl CAC with (NOLOCK)
	join #tmpProxyClientOutput P on CAC.PrivilegedClientId = P.proxyclientId and CAC.AccessedClientId = P.clientid
	left join #temp_update_CAC TCAC on CAC.id = TCAC.id where TCAC.id is null
;with cte (clientid, accessedClientId)
as (select distinct proxyClientId, clientId from #tmpProxyClientOutput
	except
	select privilegedClientId, AccessedClientId from App_ClientAccessControl CAC with (NOLOCK)
	except
	select privilegedClientId, AccessedClientId from #temp_insert_CAC
	)
insert into #temp_insert_CAC (PrivilegedClientId,AccessedClientId,CreationTime,InsertedBy)
select clientid, accessedClientId, @currTimeStamp, 2 from cte
--check proxy: proxy client of same pseudo client/instance/apptype can access each other
IF object_id('tempdb.dbo.#tmpProxyClientPairs') IS NOT NULL drop table #tmpProxyClientPairs
create table #tmpProxyClientPairs(
						proxyClientId1		integer,
						proxyClientId2		integer
						)
insert into #tmpProxyClientPairs select distinct t1.proxyclientid proxy1, t2.proxyclientid proxy2 --distinct needed so we don't insert duplicates to app_clientaccesscontrol table below
from #tmpProxyClientOutput t1 join #tmpProxyClientOutput t2 on
t1.clientid = t2.clientid and t1.instanceId = t2.instanceId and t1.ClientAppType = t2.ClientAppType
where t1.proxyClientId < t2.proxyClientId
insert into #temp_update_CAC (id,InsertedBy)
select distinct UCAC.id,3
	from (
		select id from app_clientaccesscontrol CAC with (NOLOCK)
		join #tmpProxyClientPairs PP on CAC.PrivilegedClientId = PP.proxyClientId1 and CAC.AccessedClientId = PP.proxyClientId2
		union
		select id from app_clientaccesscontrol CAC with (NOLOCK)
		join #tmpProxyClientPairs PP on CAC.PrivilegedClientId = PP.proxyClientId2 and CAC.AccessedClientId = PP.proxyClientId1
	) UCAC
	left join #temp_update_CAC TCAC on UCAC.id = TCAC.id where TCAC.id is null
;with cte (clientid, accessedClientId)
as (select distinct proxyClientId1, proxyClientId2 from #tmpProxyClientPairs
	except
	select privilegedClientId, AccessedClientId from App_ClientAccessControl CAC with (NOLOCK)
	except
	select privilegedClientId, AccessedClientId from #temp_insert_CAC
	)
insert into #temp_insert_CAC (PrivilegedClientId,AccessedClientId,CreationTime,InsertedBy)
select clientid, accessedClientId, @currTimeStamp, 3 from cte
--for pseudoclient, its proxy should be able to access its MA
IF object_id('tempdb.dbo.#tmpProxyAccessMA') IS NOT NULL drop table #tmpProxyAccessMA
create table #tmpProxyAccessMA(
						proxyClientId	integer,
						maClientId	integer
						)
insert into #tmpProxyAccessMA select distinct proxyClientid, maClientid
from #tmpProxyClientOutput P join #tmpMATable MA on P.clientid = MA.clientId
insert into #temp_update_CAC (id,InsertedBy)
select distinct CAC.id,4
	from App_ClientAccessControl CAC with (NOLOCK)
	join #tmpProxyAccessMA PM on CAC.PrivilegedClientId = PM.proxyClientId and CAC.AccessedClientId = PM.maClientId
	left join #temp_update_CAC TCAC on CAC.id = TCAC.id where TCAC.id is null
;with cte (clientid, accessedClientId)
as (select distinct proxyClientId, maClientId from #tmpProxyAccessMA
	except
	select privilegedClientId, AccessedClientId from App_ClientAccessControl CAC with (NOLOCK)
	except
	select privilegedClientId, AccessedClientId from #temp_insert_CAC
	)
insert into #temp_insert_CAC (PrivilegedClientId,AccessedClientId,CreationTime,InsertedBy)
select clientid, accessedClientId, @currTimeStamp, 4 from cte
--for VM client, VSA clients' proxy can access its children vm clients
IF object_id('tempdb.dbo.#tmpProxyAccessVM') IS NOT NULL drop table #tmpProxyAccessVM
create table #tmpProxyAccessVM(
				VMClientId integer,
				VSAClientId	integer,
				proxyClientId integer
				)
insert into #tmpProxyAccessVM (VMClientId, VSAClientId, proxyClientId)
select distinct CP.componentNameId VMClientId, P.ClientId VSAClientId, P.proxyClientId
from #tmpProxyClientOutput P
join APP_Application AA with (nolock) on P.clientId = AA.clientId
join APP_ClientProp CP with (nolock) on  AA.id = CAST(CP.attrVal as INT)
where CP.attrName = 'Last Backup Subclient'
insert into #temp_update_CAC (id,InsertedBy)
select CAC.id,5
	from App_ClientAccessControl CAC with (NOLOCK)
	join #tmpProxyAccessVM VM on CAC.PrivilegedClientId = VM.proxyClientId and CAC.AccessedClientId = VM.VMClientId
	left join #temp_update_CAC TCAC on CAC.id = TCAC.id where TCAC.id is null
;with cte (clientid, accessedClientId)
as (select  distinct proxyClientId, VMClientId from #tmpProxyAccessVM
	except
	select privilegedClientId, AccessedClientId from App_ClientAccessControl CAC with (NOLOCK)
	except
	select privilegedClientId, AccessedClientId from #temp_insert_CAC
	)
insert into #temp_insert_CAC (PrivilegedClientId,AccessedClientId,CreationTime,InsertedBy)
select clientid, accessedClientId, @currTimeStamp, 5 from cte
--for linux cluster clients(VM), there is a control client(PM) for it. If VM is a proxy, its PM should have access to its pseudoclient.
IF object_id('tempdb.dbo.#tmpPMAccessPseudo') IS NOT NULL drop table #tmpPMAccessPseudo
create table #tmpPMAccessPseudo(
				PMClientId integer, -- physical machine (control client)
				VMClientId	integer, -- virtual machine (proxy)
				PseudoClientId integer
				)
create clustered index #tmpPMAccessPseudo_PMClientId_PseudoClientId on #tmpPMAccessPseudo (PMClientId,PseudoClientId)
insert into #tmpPMAccessPseudo (PMClientId, VMClientId, PseudoClientId)
select distinct PM2VM.PMClientId PMClientId, PM2VM.VMClientId VMClientId, VM2Pseudo.clientId
from APP_VMToPMMap PM2VM
join #tmpProxyClientOutput VM2Pseudo on PM2VM.VMClientId = VM2Pseudo.proxyClientId
insert into #temp_update_CAC (id,InsertedBy)
select CAC.id,6
	from App_ClientAccessControl CAC with (NOLOCK)
	join #tmpPMAccessPseudo P on CAC.PrivilegedClientId = P.PMClientId and CAC.AccessedClientId = P.PseudoClientId
	left join #temp_update_CAC TCAC on CAC.id = TCAC.id where TCAC.id is null
;with cteRowsToAdd (clientid, accessedClientId)
as (select distinct PMClientId, PseudoClientId from #tmpPMAccessPseudo
	except
	select privilegedClientId, AccessedClientId from App_ClientAccessControl CAC with (NOLOCK)
	except
	select privilegedClientId, AccessedClientId from #temp_insert_CAC
	)
insert into #temp_insert_CAC (PrivilegedClientId,AccessedClientId,CreationTime,InsertedBy)
select clientid, accessedClientId, @currTimeStamp,6 from cteRowsToAdd
--For VSA, proxy of admin client (associated with admin Instance) is allowed to access tenant client (associated with tenant instance)
IF object_id('tempdb.dbo.#tmpProxyAccessTenant') IS NOT NULL drop table #tmpProxyAccessTenant
create table #tmpProxyAccessTenant(
							proxyClient			integer,
							adminClient			integer,
							adminInstance		integer,
							tenantClient		integer,
							tenantInstance		integer)
create clustered index #tmpProxyAccessTenant_proxyClient_tenantClient_idx on #tmpProxyAccessTenant(proxyClient,tenantClient)
insert into #tmpProxyAccessTenant
	select distinct proxy.proxyClientId,
		app2.clientid adminClientid,
		cast(p2.attrval as int) adminInstance,
		app.clientid tenantClient,
		app.instance tenantInstance
	from app_application app (NOLOCK)
	inner join  APP_InstanceProp p1 (NOLOCK)
		on app.instance = p1.componentNameId
		and p1.attrName ='Amazon Enable Admin Account'
		and p1.attrVal= N'1'
		and p1.modified = 0
and app.appTypeId = 106
	inner join APP_InstanceProp p2 (NOLOCK)
		on p1.componentNameId = p2.componentNameId
		and p2.attrName = 'Amazon Admin Instance Id'
		and p2.modified = 0
	inner join app_application app2 (NOLOCK)
		on p2.attrval = cast(app2.instance as NVARCHAR(12))
and app2.appTypeId = 106
	inner join #tmpProxyClientOutput proxy
		on app2.clientid = proxy.ClientId
insert into #temp_update_CAC (id,InsertedBy)
select distinct CAC.id, 7
	from App_ClientAccessControl CAC with (NOLOCK)
	join #tmpProxyAccessTenant VSA on CAC.PrivilegedClientId = VSA.proxyClient and CAC.AccessedClientId = VSA.tenantClient
	left join #temp_update_CAC TCAC on CAC.id = TCAC.id where TCAC.id is null
;with cteRowsToInsert (clientid, accessedClientId)
as (select  distinct proxyClient, tenantClient from #tmpProxyAccessTenant
	except
	select privilegedClientId, AccessedClientId from App_ClientAccessControl CAC with (NOLOCK)
	except
	select privilegedClientId, AccessedClientId from #temp_insert_CAC
	)
insert into #temp_insert_CAC (PrivilegedClientId,AccessedClientId,CreationTime,InsertedBy)
select clientid, accessedClientId, @currTimeStamp, 7 from cteRowsToInsert
--we may already have (@reqRemoteClientId, @reqClientId) unauthorized before: with insertedBy =-1 and creationTime > 7 days old
--and it is still not authorized.
insert into #temp_update_CAC (id,InsertedBy, remoteProcessName)
select distinct CAC.id,-1, @remoteProcessName
	from App_ClientAccessControl CAC with (NOLOCK)
	left join #temp_update_CAC TCAC on CAC.id = TCAC.id
	where TCAC.id is null and CAC.PrivilegedClientId = @reqRemoteClientId and CAC.AccessedClientId = @reqClientId
;with cte (clientid, accessedClientId)
as (select  @reqRemoteClientId, @reqClientId
	except
	select privilegedClientId, AccessedClientId from App_ClientAccessControl CAC with (NOLOCK)
	except
	select privilegedClientId, AccessedClientId from #temp_insert_CAC
	)
insert into #temp_insert_CAC (PrivilegedClientId,AccessedClientId,CreationTime,InsertedBy, remoteProcessName)
select clientid, accessedClientId, @currTimeStamp, -1, @remoteProcessName from cte
EXIT_PROC:
UPDATE a set
	a.CreationTime = @currTimeStamp,
	a.insertedBy = t.InsertedBy,
	a.remoteProcessName = t.remoteProcessName,
	a.accessType =
	(
		CASE
WHEN t.insertedBy = -1
THEN 2
WHEN t.insertedBy = -2
THEN 0
			ELSE
1
		END
		)
	FROM App_ClientAccessControl a INNER JOIN #temp_update_CAC t on t.id = a.id
insert into App_ClientAccessControl (PrivilegedClientId, AccessedClientId, CreationTime, insertedBy, remoteProcessName, accessType)
	select tCAC.PrivilegedClientId,tCAC.AccessedClientId,tCAC.CreationTime,tCAC.insertedBy, tCAC.remoteProcessName,
	(
		CASE
WHEN tCAC.insertedBy = -1
THEN 2
WHEN tCAC.insertedBy = -2
THEN 0
			ELSE
1
		END
	)
	from #temp_insert_CAC tCAC
	left join App_ClientAccessControl app on (app.PrivilegedClientId = tCAC.PrivilegedClientId and app.AccessedClientId = tCAC.AccessedClientId)
	where app.PrivilegedClientId is null and app.AccessedClientId is null
SET @o_xml =
	(select top 1 PrivilegedClientId as '@PrivilegedClientId',
	   AccessedClientId as '@AccessedClientId',
	   CreationTime as '@CreationTime',
	   (CASE WHEN insertedby <= -1 THEN 1 ELSE 0 END) as '@errorCode',
	   @error_message + 'source [' + cast(InsertedBy as varchar(5)) + ']' as '@errorMessage'
	   from App_ClientAccessControl with (NOLOCK)
	   where (PrivilegedClientId = @reqRemoteClientId and AccessedClientId = @reqClientId)
or  (PrivilegedClientId = @reqClientId and AccessedClientId = @reqRemoteClientId and InsertedBy = 3)
	   FOR XML PATH('App_GetClientAccessControlResponse'), type)
END TRY
BEGIN CATCH
SET @error_message = 'AppMgrSecurityCheck: Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +'] Error Code [' + Convert(varchar(5), ERROR_NUMBER()) + ']. ' +ERROR_MESSAGE()
SET @o_xml =
	(select @reqRemoteClientId as '@PrivilegedClientId',
	@reqClientId as '@AccessedClientId',
	@currTimeStamp as '@CreationTime',
	0 as '@errorCode',
	@error_message as '@errorMessage'
	FOR XML PATH('App_GetClientAccessControlResponse'), type)
END CATCH
SELECT @o_xml AS [o_xml]
GO

IF EXISTS (select * from GxQscripts where name = 'App_GetClientAccessControl')
	delete from GxQscripts where name = 'App_GetClientAccessControl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='App_GetClientAccessControl')
	delete from GXDBVersions where aliasname = 'App_GetClientAccessControl'
GO

insert into GXDBVersions values(2, 'App_GetClientAccessControl',  '00010001000200230000', 'App_GetClientAccessControl', '00010001000200230000')
GO

