

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/App_GetAuditedSessions.sp] ---------- 

-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "App_GetAuditedSessions"
--	|	This Procedure is used to modify/add/delete users
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: App_GetAuditedSessions <<<'

IF EXISTS (select * from sysobjects where name='App_GetAuditedSessions')
	drop procedure App_GetAuditedSessions
IF EXISTS (select * from GxQscripts where name='App_GetAuditedSessions')
	delete from GxQscripts where name = 'App_GetAuditedSessions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='App_GetAuditedSessions')
	delete from GXDBVersions where aliasname = 'App_GetAuditedSessions'
GO
print '... Creating Procedure: App_GetAuditedSessions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure App_GetAuditedSessions
  @userId INT=0,
  @pageSize INT=50,
  @onlyActive int=1,
  @lastTimeStamp bigint = 2147483647,
  @sortCol nvarchar(20) = 'createdTime'
AS
		if(@userId > 0)
	BEGIN
		if(@onlyActive = 0)
		BEGIN
			IF(@sortCol = 'logoutTime')
			BEGIN
			Select userId , name , sessionId , createdTime,  logoutTime , consoleType , host , browserSessionId , lastAccessedTime, location from
					(select ROW_NUMBER() over (order by logoutTime desc) As RowNum,
					ua.userId as userId,
					uu.name as name,
					ua.sessionId as sessionID,
					ua.createdTime as createdTime,
					ua.logoutTime as logoutTime,
					ua.consoleType as consoleType,
					ua.host as host,
					ua.browserSessionId,
					ua.logoutTime as lastAccessedTime,
					ua.location as location
				from UMSessionAudit ua WITH(NOLOCK)
				JOIN UMUSERS UU with (NOLOCK) on ua.userId = uu.id
				where ua.userId = @userId and logoutTime > 0 and logoutTime < @lastTimeStamp) as withRowNos
				where RowNum >=1 and RowNum <= @pageSize
			END
			ELSE		-- Logged out sessions with so
			BEGIN
				Select userId , name , sessionId , createdTime,  logoutTime , consoleType , host , browserSessionId , lastAccessedTime, location from
					(select ROW_NUMBER() over (order by logoutTime desc) As RowNum,
					ua.userId as userId,
					uu.name as name,
					ua.sessionId as sessionID,
					ua.createdTime as createdTime,
					ua.logoutTime as logoutTime,
					ua.consoleType as consoleType,
					ua.host as host,
					ua.browserSessionId,
					ua.logoutTime as lastAccessedTime,
					ua.location as location
				from UMSessionAudit ua WITH(NOLOCK)
				JOIN UMUSERS UU with (NOLOCK) on ua.userId = uu.id
				where ua.userId = @userId and logoutTime > 0 and createdTime < @lastTimeStamp) as withRowNos
				where RowNum >=1 and RowNum <= @pageSize
			END
		END
		ELSE IF(@onlyActive = 1)
		BEGIN
					Select userId , name , sessionId , createdTime,  logoutTime , consoleType , host , browserSessionId , lastAccessedTime, location from
					(select ROW_NUMBER() over (order by logoutTime desc) As RowNum,
					T.* from (Select
							ua.userId as userId,
							UU.name as name,
							ua.sessionId as sessionID,
							ua.createdTime as createdTime,
							0 as logoutTime,
							ua.consoleType as consoleType,
							ua.host as host,
							ua.browserSessionId,
							0 as lastAccessedTime,
							ua.location as location
					from UMSessionAudit ua WITH(NOLOCK)
					JOIN UMUSERS UU with (NOLOCK) on ua.userId = uu.id
					where (ua.consoleType = 5 AND ua.logoutTime = 0 AND ua.userId = @userId and ua.createdTime < @lastTimeStamp)
					union
						-- Current session which don't belong to java gui.
						Select ua.userId, uu.name as name, ua.sessionId, ua.createdTime, ua.logoutTime, ua.consoleType, ua.host , ua.browserSessionId, q.lastAccessedTime as lastAccessedTime, q.location as location
						from UMSessionAudit ua WITH(NOLOCK), UMQSDKSessions q WITH(NOLOCK), UMUSERS uu WITH(NOLOCK)
						where ua.consoleType = q.ConsoleType and ua.logoutTime = 0 and ua.userId = q.userid and ua.sessionId = CONVERT(nvarchar(40), q.GUID) and q.userId = @userId  and ua.userId = uu.id and q.created < @lastTimeStamp ) as T) as withRows
						where RowNum >=1 and RowNum <= @pageSize
		END
	END
	ELSE
	BEGIN
		if(@onlyActive = 0)
		BEGIN
			IF(@sortCol = 'logoutTime')
			BEGIN
			Select userId , name , sessionId , createdTime,  logoutTime , consoleType , host , browserSessionId , lastAccessedTime, location from
					(select ROW_NUMBER() over (order by logoutTime desc) As RowNum,
					ua.userId as userId,
					uu.name as name,
					ua.sessionId as sessionID,
					ua.createdTime as createdTime,
					ua.logoutTime as logoutTime,
					ua.consoleType as consoleType,
					ua.host as host,
					ua.browserSessionId,
					ua.logoutTime as lastAccessedTime,
					ua.location as location
				from UMSessionAudit ua WITH(NOLOCK)
				JOIN UMUSERS UU with (NOLOCK) on ua.userId = uu.id
				where logoutTime > 0 and logoutTime < @lastTimeStamp) as withRowNos
				where RowNum >=1 and RowNum <= @pageSize
			END
			ELSE		-- Logged out sessions with so
			BEGIN
				Select userId , name , sessionId , createdTime,  logoutTime , consoleType , host , browserSessionId , lastAccessedTime, location from
					(select ROW_NUMBER() over (order by logoutTime desc) As RowNum,
					ua.userId as userId,
					uu.name as name,
					ua.sessionId as sessionID,
					ua.createdTime as createdTime,
					ua.logoutTime as logoutTime,
					ua.consoleType as consoleType,
					ua.host as host,
					ua.browserSessionId,
					ua.logoutTime as lastAccessedTime,
					ua.location as location
				from UMSessionAudit ua WITH(NOLOCK)
				JOIN UMUSERS UU with (NOLOCK) on ua.userId = uu.id
				where logoutTime > 0 and createdTime < @lastTimeStamp) as withRowNos
				where RowNum >=1 and RowNum <= @pageSize
			END
		END
		ELSE IF(@onlyActive = 1)
		BEGIN
					Select userId , name , sessionId , createdTime,  logoutTime , consoleType , host , browserSessionId , lastAccessedTime, location from
					(select ROW_NUMBER() over (order by logoutTime desc) As RowNum,
					T.* from (Select
							ua.userId as userId,
							UU.name as name,
							ua.sessionId as sessionID,
							ua.createdTime as createdTime,
							0 as logoutTime,
							ua.consoleType as consoleType,
							ua.host as host,
							ua.browserSessionId,
							0 as lastAccessedTime,
							ua.location as location
					from UMSessionAudit ua WITH(NOLOCK)
					JOIN UMUSERS UU with (NOLOCK) on ua.userId = uu.id
					where (ua.consoleType = 5 AND ua.logoutTime = 0 AND ua.createdTime < @lastTimeStamp)
					union
						-- Current session which don't belong to java gui.
						Select ua.userId, uu.name as name, ua.sessionId, ua.createdTime, ua.logoutTime, ua.consoleType, ua.host , ua.browserSessionId, q.lastAccessedTime as lastAccessedTime, q.location as location
						from UMSessionAudit ua WITH(NOLOCK), UMQSDKSessions q WITH(NOLOCK), UMUSERS uu WITH(NOLOCK)
						where ua.consoleType = q.ConsoleType and ua.logoutTime = 0 and ua.userId = q.userid and ua.sessionId = CONVERT(nvarchar(40), q.GUID) and ua.userId = uu.id  and q.created < @lastTimeStamp) as T) as withRows
						where RowNum >=1 and RowNum <= @pageSize
		END
	END
GO

IF EXISTS (select * from GxQscripts where name = 'App_GetAuditedSessions')
	delete from GxQscripts where name = 'App_GetAuditedSessions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='App_GetAuditedSessions')
	delete from GXDBVersions where aliasname = 'App_GetAuditedSessions'
GO

insert into GXDBVersions values(2, 'App_GetAuditedSessions',  '00000000000000000000', 'App_GetAuditedSessions', '00000000000000000000')
GO

