

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppWorkQueueUpdateRequest.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppWorkQueueUpdateRequest.sp,v $ $Id: AppWorkQueueUpdateRequest.sp,v 1.4.80.3 2020/03/12 20:07:05 mnatarajan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppWorkQueueUpdateRequest')
BEGIN
	print '>>> Drop Stored Procedure: AppWorkQueueUpdateRequest <<<'
	drop procedure AppWorkQueueUpdateRequest
END
IF EXISTS (select * from GxQscripts where name='AppWorkQueueUpdateRequest')
	delete from GxQscripts where name = 'AppWorkQueueUpdateRequest'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppWorkQueueUpdateRequest')
	delete from GXDBVersions where aliasname = 'AppWorkQueueUpdateRequest'
GO
print '... Creating Procedure: AppWorkQueueUpdateRequest'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppWorkQueueUpdateRequest
-- Input arguments
  @i_lXml XML
AS
SET NOCOUNT ON
-- Removing primary key and creating clustered index on WorkqueueId. Sometimes in corner case cpp sends same workqueue multiple times and its passed to SP which throws primary key violation
-- So SP throws error to workqueue module in cpp which appends wqs passed here to its original list and it sends same workqueues in previous iteration in next iteration also. This results in cascading effect where
-- workqueues are not cleaned up from DB and are stuck in processing state.
 IF object_id('tempdb.dbo.#workQueueRequestVector') IS NOT NULL
        DROP TABLE #workQueueRequestVector
CREATE TABLE #workQueueRequestVector (workQueueId BIGINT , flag INT)
CREATE CLUSTERED INDEX workQueueRequestVector_workQueueId_Index ON #workQueueRequestVector (workQueueId)
DECLARE @isIDSet INT = 0
SET @isIDSet = @i_lXml.exist('/App_WorkQueueRequestStatusList')
IF @isIDSet > 0
BEGIN
	INSERT  INTO #workQueueRequestVector
		    SELECT  DISTINCT ref.value('@nWorkQueueID', 'BIGINT') AS workQueueId, ref.value('@nFlag', 'int') AS flag
			FROM    @i_lXml.nodes('App_WorkQueueRequestStatusList/lRequestList') R ( ref )
	-- First clear all request that marked as processed and no new requests merged to it (lastUpdateTime=0 for new one)
	DELETE APP_WorkQueueRequest
	WHERE workQueueId IN (SELECT workQueueId FROM #workQueueRequestVector WHERE flag = 8)
	AND lastUpdateTime <> 0
	-- reset count for successfully processed requests that were merged with new one ((lastUpdateTime=0 )
	UPDATE APP_WorkQueueRequest
	SET retryCount = 0
	WHERE workQueueId IN (SELECT workQueueId FROM #workQueueRequestVector WHERE flag = 8)
	AND lastUpdateTime = 0
	-- reset 'in process' and 'force to execute' flags for all request in input list
	UPDATE APP_WorkQueueRequest
	SET flag &= ~6
	WHERE workQueueId IN (SELECT workQueueId FROM #workQueueRequestVector)
	-- increase count for failed requests
	UPDATE APP_WorkQueueRequest
	SET retryCount += 1
	WHERE workQueueId IN (SELECT workQueueId FROM #workQueueRequestVector WHERE flag = 0)
END
ELSE -- workQueue id is not specified. Reset status for all workQueueID
BEGIN
	UPDATE APP_WorkQueueRequest	SET flag &= ~6 -- reset flag = 2 - in process and flag = 4 - force to execute
END
 IF object_id('tempdb.dbo.#workQueueRequestVector') IS NOT NULL
        DROP TABLE #workQueueRequestVector
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppWorkQueueUpdateRequest')
	delete from GxQscripts where name = 'AppWorkQueueUpdateRequest'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppWorkQueueUpdateRequest')
	delete from GXDBVersions where aliasname = 'AppWorkQueueUpdateRequest'
GO

insert into GXDBVersions values(2, 'AppWorkQueueUpdateRequest',  '00010004008000030000', 'AppWorkQueueUpdateRequest', '00010004008000030000')
GO

