

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppWorkQueueSubmitRequestXMLOUTPUT.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppWorkQueueSubmitRequestXMLOUTPUT.sp,v $ $Id: AppWorkQueueSubmitRequestXMLOUTPUT.sp,v 1.1.2.3 2020/06/23 08:15:21 shussain Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppWorkQueueSubmitRequestXMLOUTPUT')
BEGIN
	print '>>> Drop Stored Procedure: AppWorkQueueSubmitRequestXMLOUTPUT <<<'
	drop procedure AppWorkQueueSubmitRequestXMLOUTPUT
END
IF EXISTS (select * from GxQscripts where name='AppWorkQueueSubmitRequestXMLOUTPUT')
	delete from GxQscripts where name = 'AppWorkQueueSubmitRequestXMLOUTPUT'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppWorkQueueSubmitRequestXMLOUTPUT')
	delete from GXDBVersions where aliasname = 'AppWorkQueueSubmitRequestXMLOUTPUT'
GO
print '... Creating Procedure: AppWorkQueueSubmitRequestXMLOUTPUT'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppWorkQueueSubmitRequestXMLOUTPUT
-- Input arguments
  @i_xmlText XML,
  @o_output XML OUTPUT
AS
BEGIN
	DECLARE @o_errorCode	INT = 0
	DECLARE @o_errorCodeStr NVARCHAR(1024) = ''
	DECLARE @i_workToken INT = ISNULL(( SELECT ref.value('@workToken', 'INT')
                FROM @i_xmlText.nodes ('App_SubmitWorkQueueReq') R(ref)),0)
	DECLARE @i_allClients INT = ISNULL(( SELECT ref.value('@allClients', 'INT')
                FROM @i_xmlText.nodes ('App_SubmitWorkQueueReq') R(ref)),0)
	DECLARE @i_flag INT = ISNULL(( SELECT ref.value('@flag', 'INT')
                FROM @i_xmlText.nodes ('App_SubmitWorkQueueReq') R(ref)),0)
	DECLARE @i_clientName VARCHAR(MAX) = ISNULL(( SELECT ref.value('@clientName', 'VARCHAR(MAX)')
                FROM @i_xmlText.nodes ('App_SubmitWorkQueueReq/client') R(ref)), '')
	DECLARE @i_clientId INT = ISNULL(( SELECT ref.value('@clientId', 'INT')
                FROM @i_xmlText.nodes ('App_SubmitWorkQueueReq/client') R(ref)), ISNULL((SELECT id FROM APP_Client WHERE name = @i_clientName),0))
	DECLARE @i_clientGroupName VARCHAR(MAX) = ISNULL(( SELECT ref.value('@clientGroupName', 'VARCHAR(MAX)')
                FROM @i_xmlText.nodes ('App_SubmitWorkQueueReq/clientGroup') R(ref)), '')
	DECLARE @i_clientGroupId INT = ISNULL(( SELECT ref.value('@clientGroupId', 'INT')
                FROM @i_xmlText.nodes ('App_SubmitWorkQueueReq/clientGroup') R(ref)), ISNULL((SELECT id FROM APP_ClientGroup WHERE name = @i_clientGroupName),0))
	DECLARE @i_workTokenParams VARCHAR(MAX) = ISNULL(( SELECT ref.value('@workTokenParams', 'VARCHAR(MAX)')
                FROM @i_xmlText.nodes ('App_SubmitWorkQueueReq') R(ref)),0)
	DECLARE @entityListXml XML = @i_xmlText.query('App_SubmitWorkQueueReq/entityList')
	IF @i_clientId <> 0 OR @i_clientGroupId <> 0 OR (@entityListXml IS NOT NULL)
	BEGIN
		IF @i_workToken = 10
		BEGIN
			SET @i_workTokenParams = (SELECT id FROM APP_Client WHERE name = @i_workTokenParams)
		END
SET @o_errorCode = 0
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE	@currentTime	 INTEGER
SET	@currentTime = dbo.GetUnixTime(GetUTCDate())
IF OBJECT_ID('tempdb.dbo.#WQ_ClientIdList') IS NOT NULL
BEGIN
	DROP TABLE #WQ_ClientIdList
END
CREATE TABLE #WQ_ClientIdList (clientID INT)
CREATE CLUSTERED INDEX WQ_ClientIdList_clientID_Idx ON #WQ_ClientIdList(clientID)
BEGIN TRY
	-- execute script for all clients
	IF @i_allClients <> 0
	BEGIN
		INSERT INTO #WQ_ClientIdList SELECT id FROM APP_Client WITH(NOLOCK)
	END
	ELSE
	BEGIN
		-- execute script for client group
		IF @i_clientGroupId<>0
		BEGIN
			IF NOT EXISTS( SELECT clientId FROM APP_ClientGroupAssoc WITH(NOLOCK) WHERE clientGroupId=@i_clientGroupId)
			BEGIN
				SET @o_errorCode = 1
				SET @o_errorCodeStr = N'invalid client group argument'
			END
			ELSE
			BEGIN
				INSERT INTO #WQ_ClientIdList
				SELECT clientId FROM APP_ClientGroupAssoc WITH(NOLOCK)
				WHERE clientGroupId = @i_clientGroupId
			END
		END
		ELSE
		BEGIN
			-- execute script for client
			IF @i_clientId > 0
			BEGIN
				IF NOT EXISTS( SELECT 1 FROM APP_Client WITH(NOLOCK) WHERE id = @i_clientId)
				BEGIN
					set @o_errorCode = 2
					set @o_errorCodeStr = N'invalid client ID'
				END
				ELSE
				BEGIN
					INSERT INTO #WQ_ClientIdList VALUES(@i_clientId)
				END
			END
		END
	END
	INSERT INTO #WQ_ClientIdList
	SELECT ref.value('@clientId', 'INT')
    FROM @entityListXml.nodes ('entityList') R(ref)
	WHERE ref.value('@clientId', 'INT')>0
	UNION
	SELECT App_ClientGroupAssoc.clientId
    FROM @entityListXml.nodes ('entityList') R(ref)
	INNER JOIN App_ClientGroupAssoc ON ref.value('@clientGroupId', 'INT') = App_ClientGroupAssoc.clientGroupId
	AND ISNULL(ref.value('@clientId', 'INT'),0) = 0
	WHERE ref.value('@clientGroupId', 'INT')>0
	DECLARE @csActivePhysicalNode INT = 0
	SELECT @csActivePhysicalNode = CAST(attrVal AS INT) FROM App_ClientProp (NOLOCK) WHERE componentnameID =2 -- CS Client
	AND attrname='CS Active Physical Node' AND modified = 0
	-- If its registry work token and CS is cluster CS with entry in APP_VMToPMMap then insert for all passive nodes if not already there.
	-- 6: WORK_TOKEN_REGISTRY
	IF (@i_workToken = 6 AND EXISTS(SELECT clientID FROM #WQ_ClientIdList WHERE clientID = 2)
		AND EXISTS( SELECT 1 FROM APP_VMToPMMap WITH(NOLOCK) WHERE VMClientId=2) --If its for cluster CS
		AND EXISTS( SELECT 1 FROM APP_VMToPMMap (NOLOCK) LEFT JOIN App_WorkQueueRequest (NOLOCK) ON
			App_WorkQueueRequest.clientID = APP_VMToPMMap.PMClientID
			AND App_WorkQueueRequest.workToken = @i_workToken
			WHERE APP_VMToPMMap.VMClientID = 2 -- CS
			AND APP_VMToPMMap.PMClientID != @csActivePhysicalNode -- No need to insert for active physical node.
			AND App_WorkQueueRequest.clientID IS NULL )
		)
	BEGIN
		INSERT INTO #WQ_ClientIdList
		SELECT PMClientId FROM APP_VMToPMMap WITH(NOLOCK)
		LEFT JOIN App_WorkQueueRequest (NOLOCK) ON App_WorkQueueRequest.clientID = APP_VMToPMMap.PMClientID
		AND App_WorkQueueRequest.workToken = @i_workToken
		WHERE APP_VMToPMMap.VMClientID = 2 -- CS
		AND APP_VMToPMMap.PMClientID != @csActivePhysicalNode -- No need to insert for active physical node.
		AND App_WorkQueueRequest.clientID IS NULL
	END
	-- check if any VM in request then submit request to all Physical nodes
   -- exclude name change work token, which has its own implementation to send request to cluster passive nodes
	IF @i_workToken <> 34 AND EXISTS( SELECT VMClientId FROM APP_VMToPMMap WITH(NOLOCK) WHERE VMClientId IN (SELECT clientID FROM #WQ_ClientIdList WHERE clientID <> 2)) --dont include cluster CS
	BEGIN
		INSERT INTO #WQ_ClientIdList
		SELECT PMClientId FROM APP_VMToPMMap WITH(NOLOCK)
		WHERE VMClientId IN (SELECT clientID FROM #WQ_ClientIdList WHERE clientID <> 2)
		DELETE #WQ_ClientIdList WHERE clientID IN (SELECT VMClientId FROM APP_VMToPMMap WITH(NOLOCK) WHERE VMClientId <> 2)
	END
	-- check if any edge client is present, if yes submit request to all associated laptops
	IF @i_workToken = 4 -- WORK_TOKEN_OSC
	   AND EXISTS(SELECT 1 FROM App_Client APP WITH(NOLOCK)
				  INNER JOIN #WQ_ClientIdList C ON C.clientID = APP.id
WHERE APP.status & 0x10000000 <> 0)
	BEGIN
		INSERT #WQ_ClientIdList
		SELECT SC.clientId
		FROM App_SyncCloudConfig SC WITH (NOLOCK)
		INNER JOIN APP_Application APP WITH (NOLOCK) ON SC.subclientId = APP.id
INNER JOIN APP_Client CL WITH(NOLOCK) ON CL.id = APP.clientId AND CL.status & 0x10000000 <> 0
		INNER JOIN #WQ_ClientIdList	CT ON CL.id = CT.clientID
		WHERE SC.flag & 0x1 = 0 -- Skip paused
		-- Remove all edge clients
		DELETE FROM #WQ_ClientIdList
WHERE clientID IN (SELECT id FROM APP_Client WITH (NOLOCK) WHERE status & 0x10000000 <> 0)
	END
	-- check if any user centric client is present, if yes submit request to the physical clients
	IF EXISTS(SELECT 1 FROM #WQ_ClientIdList C
				  INNER JOIN APP_ClientProp CP WITH (NOLOCK) ON C.clientID = CP.componentNameId AND CP.attrName = 'User Centric Client' AND CP.modified = 0
				  WHERE CP.attrVal = '1'
				  )
	BEGIN
		INSERT #WQ_ClientIdList
		SELECT CAST(CP2.attrVal AS INT)
		FROM #WQ_ClientIdList C
		INNER JOIN APP_ClientProp CP WITH (NOLOCK) ON CP.componentNameId = C.clientID AND CP.attrName = 'User Centric Client' AND CP.modified = 0 AND CP.attrVal = '1'
		INNER JOIN APP_ClientProp CP2 WITH (NOLOCK) ON CP2.componentNameId = C.clientID AND CP2.attrName = 'Physical Client Id' AND CP2.modified = 0
		-- Remove all user centric clients
		DELETE FROM #WQ_ClientIdList
		WHERE clientID IN (SELECT componentNameId FROM APP_ClientProp WITH (NOLOCK) WHERE attrName = 'User Centric Client' AND modified = 0 AND attrVal = '1')
	END
	CREATE TABLE #tempClientList ( clientId int primary key )
	INSERT #tempClientList
	select id from  App_Client APP WITH(NOLOCK)
	INNER JOIN #WQ_ClientIdList C ON C.clientID = APP.id
WHERE (APP.status & 0x0040 <> 0)
	UNION
	select componentNameId from APP_ClientProp APP WITH(NOLOCK)
	INNER JOIN #WQ_ClientIdList C on C.clientID = APP.componentNameId
	WHERE (APP.attrName = 'Distributed iDA Client' and APP.attrVal = '1')
	UNION
	select id from  App_Client APP WITH(NOLOCK)
	INNER JOIN #WQ_ClientIdList C ON C.clientID = APP.id
WHERE (APP.status & 0x2000000 <> 0)
	-- check if any RAC client/MongoDB/SAP HANA client is present, if yes submit request to all associated Physicals
	IF (@i_workToken = 3 -- WORK_TOKEN_JM_END_JOB
		OR
		@i_workToken = 4 -- WORK_TOKEN_OSC
		OR
		@i_workToken = 40 -- WORK_TOKEN_JM_JOB_STATUS_CHANGE
		OR
		@i_workToken = 61 -- WORK_TOKEN_BACKUP_ACTIVITY_CHANGED
		)
	   AND EXISTS(SELECT clientId FROM #tempClientList)
	BEGIN
		INSERT #WQ_ClientIdList
		select distinct Inst.ClientId from
		APP_Application SC WITH (NOLOCK)
		INNER JOIN APP_OracleRacInstance Inst WITH (NOLOCK) ON Inst.instaceId = SC.instance
		INNER JOIN #WQ_ClientIdList	CT ON CT.clientId = SC.clientId
where SC.appTypeId = 80 and (SC.subclientStatus & 0x0040  = 0x0040) --CV_APPTYPE_ORACLE_RAC
		UNION
		select distinct Inst.ClientId from
		APP_Application SC WITH (NOLOCK)
		INNER JOIN APP_MongoDbAssociation Inst WITH (NOLOCK) ON Inst.instanceId = SC.instance
		INNER JOIN #WQ_ClientIdList	CT ON CT.clientId = SC.clientId
		INNER JOIN App_ClientProp AP ON (AP.componentNameId = SC.clientId and AP.attrName = 'Distributed iDA Client' and AP.attrVal = '1')
		where SC.appTypeId = 64
		UNION
		select distinct EP.Id from
		APP_Application SC WITH (NOLOCK)
		INNER JOIN APP_InstanceProp IP WITH (NOLOCK) ON SC.instance = IP.componentNameId
			AND IP.attrName = 'Database Clients'
			AND IP.modified = 0
		cross apply dbo.SplitIDString(replace(ip.attrVal,'+',',')) T
		INNER JOIN #WQ_ClientIdList CT on CT.clientId = SC.clientId
		INNER JOIN APP_Client EP
			on ep.id = t._ID
where SC.appTypeId = 135 and (SC.subclientStatus & 0x1000 = 0x1000)
		-- check if any VM in request then submit request to all Physical nodes
		-- exclude name change work token, which has its own implementation to send request to cluster passive nodes
		CREATE TABLE #tempVMtoPMMap (VMClientId INT,PMClientId INT)
		INSERT INTO #tempVMtoPMMap
			SELECT MAP.VMClientId,MAP.PMClientId FROM APP_VMToPMMap MAP
			INNER JOIN #WQ_ClientIdList WQCList
			ON MAP.VMClientId = WQCList.clientID
			WHERE WQClist.clientID NOT IN (SELECT clientid FROM APP_COMMCELL) --dont include cluster CS
		IF @i_workToken <> 34 AND EXISTS (SELECT VMClientId FROM #tempVMtoPMMap)
		BEGIN
			INSERT INTO #WQ_ClientIdList SELECT PMClientId FROM #tempVMtoPMMap
			DELETE #WQ_ClientIdList WHERE clientID IN (SELECT VMClientId FROM #tempVMtoPMMap)
		END
		DROP TABLE #tempVMtoPMMap
		-- Do not push to pseudo RAC
		DELETE FROM #WQ_ClientIdList
		WHERE clientID IN (SELECT clientId FROM #tempClientList)
	END
	DROP TABLE #tempClientList
	IF @i_workToken <> 36		/*WORK_TOKEN_IDA_PROP_MODIFIED*/
	BEGIN						-- Skip the below code for this token. This token is applicable only for FS clients.
	-- check if any SQl AlwaysON pseudo clients client is present, if yes submit request to all associated Physicals
	IF EXISTS(SELECT 1 FROM App_Client APP WITH(NOLOCK)
				  INNER JOIN #WQ_ClientIdList C ON C.clientID = APP.id
WHERE APP.status & 0x20000000 <> 0)
	BEGIN
		IF object_id('tempdb.dbo.#xmlOption_InfoTable') is not null
			DROP TABLE #xmlOption_InfoTable
		CREATE TABLE #xmlOption_InfoTable
					(instanceId INT, xmlValue XML)
		CREATE CLUSTERED INDEX xmlOption_InfoTable_instanceId_Index1 ON #xmlOption_InfoTable (instanceId)
		INSERT INTO #xmlOption_InfoTable
		SELECT DISTINCT instance, IP.attrVal
		FROM #WQ_ClientIdList CL
		JOIN APP_Application APP (NOLOCK) ON APP.clientId = CL.clientID
		JOIN APP_InstanceProp IP (NOLOCK) ON IP.componentNameId = APP.instance
AND APP.appTypeId = 81
		AND IP.attrName = 'Availability Replicas'
		AND IP.modified = 0
		INSERT INTO #WQ_ClientIdList
		SELECT pc.value('@clientId', 'INT')
		FROM #xmlOption_InfoTable T
		CROSS APPLY T.xmlValue.nodes('/App_SQLAvailabilityReplicas/SQLAvailabilityReplicasList/replicaClient') P(pc)
		IF object_id('tempdb.dbo.#xmlOption_InfoTable') is not null
			DROP TABLE #xmlOption_InfoTable
		-- Do not push to SQl AlwaysON pseudo clients
		DELETE FROM #WQ_ClientIdList
WHERE clientID IN (SELECT id FROM APP_Client WITH (NOLOCK) WHERE status & 0x20000000 <> 0)
		-- check if any VM in request then submit request to all Physical nodes
		-- exclude name change work token, which has its own implementation to send request to cluster passive nodes
		IF @i_workToken <> 34 AND EXISTS( SELECT VMClientId FROM APP_VMToPMMap WITH(NOLOCK) WHERE VMClientId IN (SELECT clientID FROM #WQ_ClientIdList WHERE clientID <> 2)) --dont include cluster CS
		BEGIN
			INSERT INTO #WQ_ClientIdList
			SELECT PMClientId FROM APP_VMToPMMap WITH(NOLOCK)
			WHERE VMClientId IN (SELECT clientID FROM #WQ_ClientIdList WHERE clientID <> 2)
			DELETE #WQ_ClientIdList WHERE clientID IN (SELECT VMClientId FROM APP_VMToPMMap WITH(NOLOCK) WHERE VMClientId <> 2)
		END
	END
	-- Check if any SQL Cloud pseudo clients present, if yes submit request to all associated proxies.
	IF EXISTS(SELECT 1 FROM App_Client APP WITH(NOLOCK)
				  INNER JOIN #WQ_ClientIdList C ON C.clientID = APP.id
				  WHERE (APP.specialClientFlags & 2) = 2 AND @i_workToken <> 59)--WORK_TOKEN_PULL_SERVICECOMMCELL_WEB_PACKAGE
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#tt_Proxies') IS NOT NULL
			DROP TABLE #tt_Proxies
		CREATE TABLE #tt_Proxies (instanceId INT, clientId INT, proxies XML)
		INSERT #tt_Proxies
		SELECT AP.instance,
			AP.clientId,
			ID.attrVal
			FROM APP_IDAProp ID
				JOIN APP_IDAName INA
					ON INA.id = ID.componentNameId
						AND INA.appTypeId = 81
						AND ID.attrName = N'Cloud Proxy Servers'
						AND ID.modified = 0
				JOIN APP_Application AP
					ON AP.clientId = INA.clientId
						AND AP.appTypeId = 81
				JOIN #WQ_ClientIdList CD
					ON CD.clientID = AP.clientId
		IF OBJECT_ID('tempdb.dbo.#tt_ProxiesPerCloudInstance') IS NOT NULL DROP TABLE #tt_ProxiesPerCloudInstance
		CREATE TABLE #tt_ProxiesPerCloudInstance(instance INT, clientId INT, proxy INT, PRIMARY KEY(instance, clientId, proxy))
		-- Store AG instance.
		INSERT INTO #tt_ProxiesPerCloudInstance
			SELECT DISTINCT
				S.instanceId,
				S.clientId,
				REP.C.value('(client/@clientId)[1]', 'INT') AS proxy
			FROM #tt_Proxies AS S
				CROSS  APPLY S.proxies.nodes('App_MemberServers/memberServers') as REP(C)
		INSERT INTO #WQ_ClientIdList
			SELECT DISTINCT PC.proxy
			FROM #tt_ProxiesPerCloudInstance PC
				JOIN #WQ_ClientIdList WC ON PC.clientId = WC.clientID
		-- Do not push to SQL pseudo clients
		DELETE CL
			FROM #WQ_ClientIdList CL JOIN
				(SELECT DISTINCT AC.id FROM APP_Client AC WITH (NOLOCK)
					JOIN APP_Application AP WITH (NOLOCK)
						ON AC.id = AP.clientId
							AND AP.appTypeId = 81
						WHERE (AC.specialClientFlags & 2) = 2) CLN
			ON CL.clientID = CLN.id
		-- check if any VM in request then submit request to all Physical nodes
		-- exclude name change work token, which has its own implementation to send request to cluster passive nodes
		IF @i_workToken <> 34 AND EXISTS( SELECT VMClientId FROM APP_VMToPMMap WITH(NOLOCK) WHERE VMClientId IN (SELECT clientID FROM #WQ_ClientIdList WHERE clientID <> 2)) --dont include cluster CS
		BEGIN
			INSERT INTO #WQ_ClientIdList
			SELECT PMClientId FROM APP_VMToPMMap WITH(NOLOCK)
			WHERE VMClientId IN (SELECT clientID FROM #WQ_ClientIdList WHERE clientID <> 2)
			DELETE #WQ_ClientIdList WHERE clientID IN (SELECT VMClientId FROM APP_VMToPMMap WITH(NOLOCK) WHERE VMClientId <> 2)
		END
	END
	END
	IF (@i_workToken = 34) -- WORK_TOKEN_NAME_CHANGE
	BEGIN
		-- Delete all the existing name change work tokens for the client and apply only the latest changes.
		DELETE APP_WorkQueueRequest where workToken = 34 and clientId IN (SELECT DISTINCT clientID FROM #WQ_ClientIdList)
	END
	INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
		SELECT DISTINCT clientID, @i_workToken, @i_workTokenParams, @currentTime, 0, 0, @i_flag, -1
		FROM #WQ_ClientIdList Q
		INNER JOIN APP_Client C ON C.id	 = Q.clientID	--MAKE SURE IT IS A VALID CLIENT OR INSERT WILL GIVE CONSTRAIN ERROR
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	set @o_errorCode = 3
	set @o_errorCodeStr = N'Failed to submit workQueue request. Error code [' + CAST(ERROR_NUMBER() AS NVARCHAR(10)) + ']. ' + ERROR_MESSAGE()
END CATCH
	END
	SET @o_output = ( SELECT @o_errorCode '@errorCode', @o_errorCodeStr '@errorMessage'
	FOR XML PATH('App_GenericResp'))
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppWorkQueueSubmitRequestXMLOUTPUT')
	delete from GxQscripts where name = 'AppWorkQueueSubmitRequestXMLOUTPUT'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppWorkQueueSubmitRequestXMLOUTPUT')
	delete from GXDBVersions where aliasname = 'AppWorkQueueSubmitRequestXMLOUTPUT'
GO

insert into GXDBVersions values(2, 'AppWorkQueueSubmitRequestXMLOUTPUT',  '00010001000200030000', 'AppWorkQueueSubmitRequestXMLOUTPUT', '00010001000200030000')
GO

